/*
 * Decompiled with CFR 0.152.
 */
package skyrimcharacterhelper;

import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.jdesktop.application.Application;
import org.jdesktop.application.SingleFrameApplication;
import skyrimcharacterhelper.SkyrimCharacterHelperAboutDialog;
import skyrimcharacterhelper.SkyrimCharacterHelperClipboardImage;
import skyrimcharacterhelper.SkyrimCharacterHelperGuiConnector;
import skyrimcharacterhelper.SkyrimCharacterHelperLaunchThread;
import skyrimcharacterhelper.SkyrimCharacterHelperPlayer;
import skyrimcharacterhelper.SkyrimCharacterHelperPlayerManager;
import skyrimcharacterhelper.SkyrimCharacterHelperProgressNotifier;
import skyrimcharacterhelper.SkyrimCharacterHelperSaveFileFilter;
import skyrimcharacterhelper.SkyrimCharacterHelperSaveGame;
import skyrimcharacterhelper.SkyrimCharacterHelperThreadNotifier;
import skyrimcharacterhelper.SkyrimCharacterHelperView;

public class SkyrimCharacterHelperApp
extends SingleFrameApplication
implements SkyrimCharacterHelperGuiConnector,
SkyrimCharacterHelperThreadNotifier,
WindowListener {
    private SkyrimCharacterHelperView m_tView;
    private ResourceBundle m_tLocalizedMessages;
    private Properties m_tProperties = new Properties();
    private String m_sSeparator = System.getProperty("file.separator");
    private SwingWorkerDirectoryScan m_tWorkerDirectoryScan = null;
    private SwingWorkerSaveGameDelete m_tWorkerDeleteSaveGames;
    private SwingWorkerSaveGameCopy m_tWorkerCopySaveGames = null;
    private SwingWorkerSaveGameLoader m_tWorkerLoaderSaveGamesActive = null;
    private SwingWorkerSaveGameLoader m_tWorkerLoaderSaveGamesBackup = null;
    private boolean m_bInitializing = true;
    private boolean m_bPrepareForLaunching = false;
    private boolean m_bScanAll = true;
    private int m_iSaveGameChanges = 0;
    private String m_sLaunchPlayer;
    private SkyrimCharacterHelperPlayerManager m_tPlayerManagerActiveSaveGames;
    private SkyrimCharacterHelperPlayerManager m_tPlayerManagerBackupSaveGames;
    private SkyrimCharacterHelperLaunchThread m_tLaunchThread = null;

    public SkyrimCharacterHelperApp() {
        this.m_tLocalizedMessages = ResourceBundle.getBundle("skyrimcharacterhelper/resources/SkyrimCharacterHelperMessages");
        this.m_tPlayerManagerActiveSaveGames = new SkyrimCharacterHelperPlayerManager();
        this.m_tPlayerManagerBackupSaveGames = new SkyrimCharacterHelperPlayerManager();
    }

    @Override
    protected void startup() {
        String lc_sActivePath = "";
        String lc_sBackupPath = "";
        String lc_sWorkModeString = null;
        String lc_sConfirmationModeString = null;
        String lc_sOverwriteModeString = null;
        String lc_sMinimizeString = null;
        String lc_sImageModeString = null;
        String lc_sLaunchBinary = null;
        String lc_sAutoSaveString = null;
        String lc_sQuickSaveString = null;
        String lc_sPrefixString = null;
        String lc_sLaunchParameters = null;
        String lc_sInitModeString = null;
        boolean lc_bFreshStart = true;
        if (null != this.m_tProperties) {
            try {
                if (this.loadProperties()) {
                    lc_sActivePath = this.checkPath(this.getPropertyString("ACTIVE_PATH"));
                    lc_sBackupPath = this.checkPath(this.getPropertyString("DESTINATION_PATH"));
                    lc_sLaunchBinary = this.checkExecutable(this.getPropertyString("LAUNCH_BINARY"));
                    lc_sWorkModeString = this.getPropertyString("WORK_MODE");
                    lc_sConfirmationModeString = this.getPropertyString("CONFIRMATION_MODE");
                    lc_sOverwriteModeString = this.getPropertyString("OVERWRITE_MODE");
                    lc_sInitModeString = this.getPropertyString("INIT_MODE");
                    lc_sMinimizeString = this.getPropertyString("MINIMIZE_MODE");
                    lc_sImageModeString = this.getPropertyString("IMAGE_MODE");
                    lc_sAutoSaveString = this.getPropertyString("AUTOSAVE_MODE");
                    lc_sQuickSaveString = this.getPropertyString("QUICKSAVE_MODE");
                    lc_sPrefixString = this.getPropertyString("PREFIX");
                    lc_sLaunchParameters = this.getPropertyString("LAUNCH_PARAMETERS");
                    lc_bFreshStart = false;
                }
                this.m_tProperties.put("ACTIVE_PATH", lc_sActivePath);
                this.m_tProperties.put("DESTINATION_PATH", lc_sBackupPath);
            }
            catch (Exception lc_tException) {
                // empty catch block
            }
            if (this.checkString(lc_sInitModeString)) {
                boolean bl = this.m_bScanAll = 0 == Integer.valueOf(lc_sInitModeString);
            }
            if (!this.checkString(lc_sLaunchBinary)) {
                lc_sLaunchBinary = this.getSkyrimInstallationDirectory();
            }
            this.m_tProperties.put("LAUNCH_BINARY", lc_sLaunchBinary);
            if (null != lc_sActivePath && null != lc_sBackupPath && lc_sActivePath.equals(lc_sBackupPath)) {
                this.m_tProperties.put("DESTINATION_PATH", "");
                lc_sBackupPath = null;
            }
            if (null != (this.m_tView = new SkyrimCharacterHelperView(this, this, this.getLocalizedComboBoxOptionsWorkMode(), this.getLocalizedYesNoOptions(), this.getLocalizedComboBoxOptionsLaunchMode(), this.getLocalizedComboBoxOptionsImageMode(), this.getLocalizedComboBoxOptionsInitMode(), this.getMonitoringDisplays(), this.getLocalizedTableHeaders(), this.getPropertyString("HEADER_ACTIVE"), this.getPropertyString("HEADER_BACKUP"), this.getPropertyString("SORT_ORDER_ACTIVE"), this.getPropertyString("SORT_ORDER_BACKUP")))) {
                this.show(this.m_tView);
                if (lc_bFreshStart) {
                    this.m_tView.setUILockMode(true, false);
                    JOptionPane.showMessageDialog(this.m_tView, this.getLocalizedString("dialogTextFreshStart"), this.getLocalizedString("dialogTitleInformation"), 1);
                    this.m_tView.setUILockMode(false, false);
                }
                if (!this.checkString(lc_sActivePath)) {
                    lc_sActivePath = this.tryGuessSkyrimSaveGameFolder();
                }
                if (!this.checkString(lc_sPrefixString)) {
                    lc_sPrefixString = this.tryGuessPrefix(lc_sActivePath, true);
                }
                this.m_tView.setFileMode(null != lc_sWorkModeString ? Integer.valueOf(lc_sWorkModeString) : 0);
                this.m_tView.setConfirmationMode(null != lc_sConfirmationModeString ? Integer.valueOf(lc_sConfirmationModeString) : 0);
                this.m_tView.setOverwriteMode(null != lc_sOverwriteModeString ? Integer.valueOf(lc_sOverwriteModeString) : 0);
                this.m_tView.setMinimizeMode(null != lc_sMinimizeString ? Integer.valueOf(lc_sMinimizeString) : 0);
                this.m_tView.setAutoSaveMode(null != lc_sAutoSaveString ? Integer.valueOf(lc_sAutoSaveString) : 0);
                this.m_tView.setQuickSaveMode(null != lc_sQuickSaveString ? Integer.valueOf(lc_sQuickSaveString) : 0);
                this.m_tView.setImageMode(null != lc_sImageModeString ? Integer.valueOf(lc_sImageModeString) : 0);
                this.m_tView.setInitMode(null != lc_sInitModeString ? Integer.valueOf(lc_sInitModeString) : 0);
                this.m_tView.setActivePath(lc_sActivePath);
                this.m_tView.setBackupPath(lc_sBackupPath);
                this.m_tView.setPrefix(lc_sPrefixString);
                this.m_tView.setLaunchBinary(lc_sLaunchBinary);
                this.m_tView.setLaunchOptions(lc_sLaunchParameters);
                this.m_tView.setOnSkyrim(false);
                if (this.checkString(lc_sActivePath)) {
                    this.scanActiveSaveGamesDirectory(lc_sActivePath, this.getLocalizedString("messageScanningActiveSaveGames"), true, false);
                } else if (this.checkString(lc_sBackupPath) && this.m_bScanAll) {
                    this.scanBackupSaveGamesDirectory(lc_sBackupPath, false);
                } else {
                    this.m_bInitializing = false;
                    this.m_tView.updateUIElements();
                }
            }
        }
    }

    @Override
    protected void configureWindow(Window root) {
    }

    public static SkyrimCharacterHelperApp getApplication() {
        return Application.getInstance(SkyrimCharacterHelperApp.class);
    }

    public static void main(String[] args) {
        SkyrimCharacterHelperApp.launch(SkyrimCharacterHelperApp.class, args);
    }

    @Override
    public void windowClosing(WindowEvent pa_tEvent) {
        this.handleProgramExit();
    }

    @Override
    public void windowClosed(WindowEvent pa_tEvent) {
        System.exit(0);
    }

    @Override
    public void windowOpened(WindowEvent pa_tEvent) {
    }

    @Override
    public void windowIconified(WindowEvent pa_tEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent pa_tEvent) {
    }

    @Override
    public void windowActivated(WindowEvent pa_tEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent pa_tEvent) {
    }

    @Override
    public void handleButtonExit() {
        this.handleProgramExit();
    }

    @Override
    public void handleButtonProcessCancel() {
        int lc_iAmount = 0;
        String lc_sMessage = this.getLocalizedString("messageInterrupted");
        String lc_sMessageKey = null;
        boolean lc_bMode = false;
        this.m_bInitializing = false;
        this.m_bPrepareForLaunching = false;
        if (null != this.m_tWorkerDirectoryScan) {
            this.m_tWorkerDirectoryScan.cancel(true);
        }
        try {
            if (null != this.m_tWorkerCopySaveGames) {
                lc_iAmount = this.m_tWorkerCopySaveGames.getProcessedAmount();
                lc_bMode = this.m_tWorkerCopySaveGames.getMode();
                lc_sMessageKey = true == lc_bMode ? "messageBackupDone" : "messageRestoreDone";
                this.m_tWorkerCopySaveGames.cancel(true);
            }
        }
        catch (Exception lc_tException) {
            // empty catch block
        }
        try {
            if (null != this.m_tWorkerDeleteSaveGames) {
                lc_iAmount = this.m_tWorkerDeleteSaveGames.getProcessedAmount();
                lc_sMessageKey = "messageDeleteDone";
                this.m_tWorkerDeleteSaveGames.cancel(true);
            }
        }
        catch (Exception lc_tException) {
            // empty catch block
        }
        try {
            if (null != this.m_tLaunchThread) {
                this.m_tView.setLaunched(false);
                this.m_tView.setOnSkyrim(false);
                this.m_tLaunchThread.terminate();
                this.m_tLaunchThread = null;
                this.m_tView.setMessage(this.insertNumberString(this.getLocalizedString("mdssageLaunchAborted"), this.m_iSaveGameChanges));
            }
        }
        catch (Exception lc_tException) {
            // empty catch block
        }
        try {
            if (null != this.m_tWorkerLoaderSaveGamesActive) {
                this.m_tWorkerLoaderSaveGamesActive.cancel(true);
            }
            if (null != this.m_tWorkerLoaderSaveGamesBackup) {
                this.m_tWorkerLoaderSaveGamesBackup.cancel(true);
            }
        }
        catch (Exception lc_tException) {
            // empty catch block
        }
        if (0 < lc_iAmount && null != lc_sMessageKey) {
            lc_sMessage = lc_sMessage + " " + this.insertNumberString(this.getLocalizedString(lc_sMessageKey), lc_iAmount);
            this.m_tView.setMessage(lc_sMessage);
        }
        this.m_tView.setUILockMode(false, false);
        this.m_tView.resetProgress();
    }

    @Override
    public void handleButtonAbout() {
        SkyrimCharacterHelperAboutDialog lc_tAboutDialog = null;
        lc_tAboutDialog = new SkyrimCharacterHelperAboutDialog((Frame)this.m_tView, true);
        if (null != lc_tAboutDialog) {
            this.m_tView.setUILockMode(true, true);
            lc_tAboutDialog.setVisible(true);
            this.m_tView.setUILockMode(false, false);
        }
    }

    @Override
    public void handleButtonSelectActivePath() {
        this.performSelectPath(true);
    }

    @Override
    public void handleButtonSelectBackupPath() {
        this.performSelectPath(false);
    }

    @Override
    public void handleListSelectionActivePlayers() {
        this.performCharacterListSelection(true);
    }

    @Override
    public void handleListSelectionBackupPlayers() {
        this.performCharacterListSelection(false);
    }

    @Override
    public void handleListSelectionActiveSaveGames() {
        this.performSaveGameListSelection(true);
    }

    @Override
    public void handleListSelectionBackupSaveGames() {
        this.performSaveGameListSelection(false);
    }

    @Override
    public void handleButtonSelectActiveRescan(String pa_sMessage, boolean pa_bShowMessage) {
        this.scanActiveSaveGamesDirectory(this.checkPath(this.getPropertyString("ACTIVE_PATH")), pa_sMessage, pa_bShowMessage, true);
    }

    @Override
    public void handleButtonSelectBackupRescan() {
        this.scanBackupSaveGamesDirectory(this.checkPath(this.getPropertyString("DESTINATION_PATH")), true);
    }

    @Override
    public void handleButtonActiveClipboard() {
        this.copyImageToClipboard(this.m_tView.getActiveSaveGameScreenshot());
        this.m_tView.setMessage(this.getLocalizedString("messageClipboardDone"));
    }

    @Override
    public void handleButtonBackupClipboard() {
        this.copyImageToClipboard(this.m_tView.getBackupSaveGameScreenshot());
        this.m_tView.setMessage(this.getLocalizedString("messageClipboardDone"));
    }

    @Override
    public void handleButtonActiveDeletePlayer() {
        this.performDeletePlayers(true);
    }

    @Override
    public void handleButtonBackupDeletePlayer() {
        this.performDeletePlayers(false);
    }

    @Override
    public void handleButtonActiveClearPlayers() {
        this.performClearPlayers(true);
    }

    @Override
    public void handleButtonBackupClearPlayers() {
        this.performClearPlayers(false);
    }

    @Override
    public void handleButtonActiveDeleteSaveGame() {
        this.performDeleteSaveGames(true);
    }

    @Override
    public void handleButtonBackupDeleteSaveGame() {
        this.performDeleteSaveGames(false);
    }

    @Override
    public void handleButtonActiveBackupSaveGame() {
        this.performCopySaveGames(true);
    }

    @Override
    public void handleButtonBackupSaveGameRestore() {
        this.performCopySaveGames(false);
    }

    @Override
    public void handleButtonActiveBackupPlayer() {
        this.performCopyPlayers(true);
    }

    @Override
    public void handleButtonBackupPlayerRestore() {
        this.performCopyPlayers(false);
    }

    @Override
    public void handleButtonBackupLaunchPlayer() {
        boolean lc_bContinue = true;
        int lc_iCount = 0;
        SkyrimCharacterHelperPlayer lc_tSelectedBackupPlayer = this.m_tView.getFirstSelectedBackupPlayer();
        SkyrimCharacterHelperPlayer lc_tSelectedDestinationPlayer = null;
        List<SkyrimCharacterHelperSaveGame> lc_tSaveGames = null;
        String lc_sSelectedDestinationPlayerName = null;
        if (null != lc_tSelectedBackupPlayer) {
            if (0 == this.m_tView.getConfirmationMode()) {
                boolean bl = lc_bContinue = 0 == JOptionPane.showOptionDialog(this.m_tView, this.insertString(this.getLocalizedString("dialogTextBackupPlayerMoveForLaunch"), lc_tSelectedBackupPlayer.getName()), this.getLocalizedString("dialogTitleWarning"), 0, 2, null, this.getLocalizedOkCancelOptions(), this.getLocalizedString("dialogOptionOk"));
            }
            if (lc_bContinue && null != (lc_tSaveGames = this.getSaveGamesListFromPlayers(false, true))) {
                if (0 == this.m_tView.getOverwriteMode() && 0 < (lc_iCount = this.getAmountOfFileCollisions(lc_tSaveGames, false))) {
                    boolean bl = lc_bContinue = 0 == JOptionPane.showOptionDialog(this.m_tView, this.insertNumberString(this.getLocalizedString("dialogTextOverwriteSaveGame"), lc_iCount), this.getLocalizedString("dialogTitleWarning"), 0, 2, null, this.getLocalizedOkCancelOptions(), this.getLocalizedString("dialogOptionOk"));
                }
                if (lc_bContinue) {
                    this.m_bPrepareForLaunching = true;
                    this.m_sLaunchPlayer = lc_tSelectedBackupPlayer.getName();
                    this.m_tWorkerCopySaveGames = new SwingWorkerSaveGameCopy();
                    if (null != this.m_tWorkerCopySaveGames) {
                        lc_tSelectedDestinationPlayer = this.m_tView.getFirstSelectedActivePlayer();
                        lc_sSelectedDestinationPlayerName = null != lc_tSelectedDestinationPlayer ? lc_tSelectedDestinationPlayer.getName() : null;
                        this.m_tView.setMessage(this.getLocalizedString("messageRestoring"));
                        this.m_tView.setUILockMode(true, false);
                        this.m_tWorkerCopySaveGames.init(3, 1, lc_tSaveGames, false, this.m_tView.hasListMultiSelectionActivePlayers(), lc_sSelectedDestinationPlayerName);
                        this.m_tWorkerCopySaveGames.execute();
                    }
                }
            }
        }
    }

    @Override
    public void handleButtonActiveLaunchPlayer() {
        boolean lc_bContinue = true;
        boolean lc_bJustOnePlayer = this.m_tView.hasOneActivePlayer();
        int lc_iCount = 0;
        SkyrimCharacterHelperPlayer lc_tSelectedActivePlayer = this.m_tView.getFirstSelectedActivePlayer();
        SkyrimCharacterHelperPlayer lc_tSelectedDestinationPlayer = null;
        List<SkyrimCharacterHelperSaveGame> lc_tSaveGames = null;
        String lc_sSelectedDestinationPlayerName = null;
        if (null != lc_tSelectedActivePlayer) {
            if (!lc_bJustOnePlayer && 0 == this.m_tView.getConfirmationMode()) {
                boolean bl = lc_bContinue = 0 == JOptionPane.showOptionDialog(this.m_tView, this.insertString(this.getLocalizedString("dialogTextActivePlayerMoveForLaunch"), lc_tSelectedActivePlayer.getName()), this.getLocalizedString("dialogTitleWarning"), 0, 2, null, this.getLocalizedOkCancelOptions(), this.getLocalizedString("dialogOptionOk"));
            }
            if (lc_bContinue) {
                lc_tSaveGames = this.getSaveGamesExceptSelectedPlayer(true);
                if (null != lc_tSaveGames) {
                    if (0 == this.m_tView.getOverwriteMode() && 0 < (lc_iCount = this.getAmountOfFileCollisions(lc_tSaveGames, true))) {
                        boolean bl = lc_bContinue = 0 == JOptionPane.showOptionDialog(this.m_tView, this.insertNumberString(this.getLocalizedString("dialogTextOverwriteSaveGame"), lc_iCount), this.getLocalizedString("dialogTitleWarning"), 0, 2, null, this.getLocalizedOkCancelOptions(), this.getLocalizedString("dialogOptionOk"));
                    }
                    if (lc_bContinue) {
                        this.m_bPrepareForLaunching = true;
                        this.m_sLaunchPlayer = lc_tSelectedActivePlayer.getName();
                        if (!lc_bJustOnePlayer) {
                            this.m_tWorkerCopySaveGames = new SwingWorkerSaveGameCopy();
                            if (null != this.m_tWorkerCopySaveGames) {
                                lc_tSelectedDestinationPlayer = this.m_tView.getFirstSelectedBackupPlayer();
                                lc_sSelectedDestinationPlayerName = null != lc_tSelectedDestinationPlayer ? lc_tSelectedDestinationPlayer.getName() : null;
                                this.m_tView.setMessage(this.getLocalizedString("messageBackingUp"));
                                this.m_tView.setUILockMode(true, false);
                                this.m_tWorkerCopySaveGames.init(4, 1, lc_tSaveGames, true, this.m_tView.hasListMultiSelectionBackupPlayers(), lc_sSelectedDestinationPlayerName);
                                this.m_tWorkerCopySaveGames.execute();
                            }
                        } else {
                            this.m_bPrepareForLaunching = false;
                            this.m_tView.setMessage(this.getLocalizedString("messageLaunchSingle"));
                            this.launchSkyrim();
                        }
                    }
                } else {
                    this.m_bPrepareForLaunching = false;
                    this.m_tView.setMessage(this.getLocalizedString("messageLaunchSingle"));
                    this.launchSkyrim();
                }
            }
        }
    }

    @Override
    public void handleButtonChooseBinary() {
        String lc_sFile = this.getPropertyString("LAUNCH_BINARY");
        String lc_sNewFile = null;
        if (null != this.m_tProperties && null != (lc_sNewFile = this.handleFileRequesterFile(lc_sFile, this.getLocalizedString("dialogTitleFileRequesterLaunchBinary"))) && this.checkString(lc_sNewFile)) {
            if (null != this.checkExecutable(lc_sNewFile)) {
                this.m_tProperties.put("LAUNCH_BINARY", lc_sNewFile);
                this.m_tView.setLaunchBinary(lc_sNewFile);
            } else {
                this.m_tView.setMessage(this.getLocalizedString("messageNotExecutable"));
            }
        }
    }

    @Override
    public void handleButtonRestoreLaunchPath() {
        String lc_sLaunchBinary = this.getSkyrimInstallationDirectory();
        this.m_tProperties.put("LAUNCH_BINARY", lc_sLaunchBinary);
        this.m_tView.setLaunchBinary(lc_sLaunchBinary);
        this.m_tView.setMessage(this.getLocalizedString("messageLaunchRestored"));
    }

    @Override
    public void handleButtonLaunchSolo() {
        this.m_tView.setMessage(this.getLocalizedString("messageLaunchSingle"));
        this.launchSkyrim();
    }

    private String checkPath(String pa_sPath) {
        File lc_tFile = null;
        String lc_sResult = null;
        try {
            if (null != pa_sPath && null != (lc_tFile = new File(pa_sPath)) && lc_tFile.exists() && lc_tFile.isDirectory() && lc_tFile.canRead() && lc_tFile.canWrite()) {
                lc_sResult = pa_sPath;
            }
        }
        catch (Exception lc_tException) {
            // empty catch block
        }
        return lc_sResult;
    }

    private String checkExecutable(String pa_sPath) {
        File lc_tFile = null;
        String lc_sResult = null;
        try {
            if (null != pa_sPath && null != (lc_tFile = new File(pa_sPath)) && lc_tFile.exists() && lc_tFile.isFile() && lc_tFile.canExecute()) {
                lc_sResult = pa_sPath;
            }
        }
        catch (Exception lc_tException) {
            // empty catch block
        }
        return lc_sResult;
    }

    private String getSkyrimInstallationDirectory() {
        String lc_sSkyrimPath;
        String lc_sSkyrimBinaryNormal = null;
        String lc_sSkyrimDirectory32Bit = this.getRegistryValue("\"HKLM\\Software\\Bethesda Softworks\\Skyrim\"");
        String lc_sSkyrimDirectory64Bit = this.getRegistryValue("\"HKLM\\Software\\Wow6432Node\\Bethesda Softworks\\Skyrim\"");
        String string = lc_sSkyrimPath = null != lc_sSkyrimDirectory32Bit ? lc_sSkyrimDirectory32Bit : lc_sSkyrimDirectory64Bit;
        if (null != lc_sSkyrimPath) {
            lc_sSkyrimBinaryNormal = this.checkSkyrimFile(lc_sSkyrimPath, "SkyrimLauncher.exe", true);
        }
        return lc_sSkyrimBinaryNormal;
    }

    private String checkSkyrimFile(String pa_sPath, String pa_sFile, boolean pa_bCheckExecute) {
        File lc_tFile = null;
        String lc_sResult = null;
        StringBuffer lc_tNewPath = new StringBuffer();
        boolean lc_bOk = false;
        if (null != lc_tNewPath && null != pa_sFile && null != pa_sPath) {
            lc_tNewPath.append(pa_sPath);
            if (!pa_sPath.endsWith(this.m_sSeparator)) {
                lc_tNewPath.append(this.m_sSeparator);
            }
            lc_tNewPath.append(pa_sFile);
            lc_tFile = new File(lc_tNewPath.toString());
            if (null != lc_tFile && lc_tFile.exists()) {
                lc_bOk = lc_tFile.isFile();
                boolean bl = pa_bCheckExecute ? lc_tFile.canExecute() : lc_tFile.canRead();
                if (lc_bOk &= bl) {
                    lc_sResult = lc_tNewPath.toString();
                }
            }
        }
        return true == lc_bOk ? lc_sResult : null;
    }

    private boolean checkString(String pa_sValue) {
        return null != pa_sValue && 0 < pa_sValue.length();
    }

    private String getRegistryValue(String pa_sEntry) {
        InputStreamReader lc_tInputStreamReader = null;
        ProcessBuilder lc_tProcessBuilder = null;
        Process lc_tRegistryQuery = null;
        StringBuffer lc_sRegReply = new StringBuffer();
        String lc_sResult = null;
        int lc_iChar = 0;
        int lc_iPos = -1;
        lc_tProcessBuilder = new ProcessBuilder("reg", "query", pa_sEntry, "/v", "\"Installed Path\"");
        if (null != lc_tProcessBuilder) {
            try {
                if (null != lc_sRegReply && null != (lc_tRegistryQuery = lc_tProcessBuilder.start()) && null != (lc_tInputStreamReader = new InputStreamReader(lc_tRegistryQuery.getInputStream()))) {
                    while (-1 != (lc_iChar = lc_tInputStreamReader.read())) {
                        if (lc_iChar < 32) continue;
                        lc_sRegReply.append(Character.toChars(lc_iChar));
                    }
                    lc_tInputStreamReader.close();
                    lc_iPos = lc_sRegReply.indexOf("REG_SZ");
                    if (-1 != lc_iPos) {
                        lc_sResult = lc_sRegReply.substring(lc_iPos + "REG_SZ".length());
                    }
                }
            }
            catch (IOException lc_tException) {
                // empty catch block
            }
        }
        return null != lc_sResult ? lc_sResult.trim() : null;
    }

    private void launchSkyrim() {
        String lc_sLaunchBinary = this.getPropertyString("LAUNCH_BINARY");
        if (null == this.m_tLaunchThread) {
            this.m_tLaunchThread = new SkyrimCharacterHelperLaunchThread(this, lc_sLaunchBinary, this.m_tView.getPrefix(), this.m_tView.getActivePath(), this.m_tView.getLaunchOptions(), 0 == this.m_tView.getAutoSaveMode(), 0 == this.m_tView.getQuickSaveMode());
            if (null != this.m_tLaunchThread) {
                this.m_iSaveGameChanges = 0;
                this.m_tLaunchThread.start();
                this.m_tView.setLaunched(true);
                this.m_tView.setOnSkyrim(true);
                this.m_tView.setUILockMode(true, false);
            }
            if (0 == this.m_tView.getMinimizeMode()) {
                this.m_tView.setState(1);
            }
        }
    }

    private String tryGuessPrefix(String pa_sSkyrimSaveGameFolder, boolean pa_bUseSkyrimLocale) {
        String lc_sResult = null;
        String lc_sSkyrimDirectory32Bit = this.getRegistryValue("\"HKLM\\Software\\Bethesda Softworks\\Skyrim\"");
        String lc_sSkyrimDirectory64Bit = this.getRegistryValue("\"HKLM\\Software\\Wow6432Node\\Bethesda Softworks\\Skyrim\"");
        String lc_sSkyrimPath = null != lc_sSkyrimDirectory32Bit ? lc_sSkyrimDirectory32Bit : lc_sSkyrimDirectory64Bit;
        String lc_sDefaultIniPath = null;
        String lc_sLocaleIniValue = null;
        String lc_sLocaleIniFile = null;
        String lc_sSaveValue = null;
        Locale lc_tDefaultLocale = Locale.getDefault();
        StringBuffer lc_tResult = null;
        if (pa_bUseSkyrimLocale && null != (lc_sDefaultIniPath = this.checkSkyrimFile(lc_sSkyrimPath, "Skyrim_default.ini", false)) && null != (lc_sLocaleIniValue = this.searchInFile("sLanguage", "=", lc_sDefaultIniPath, false)) && null != (lc_sLocaleIniFile = lc_sSkyrimPath + "Data\\Interface\\" + "Translate_" + lc_sLocaleIniValue + ".txt") && null != (lc_sSaveValue = this.searchInFile("$SAVE", "\t", lc_sLocaleIniFile, true)) && 1 < lc_sSaveValue.length() && null != (lc_tResult = new StringBuffer())) {
            lc_tResult.append(lc_sSaveValue.charAt(0));
            lc_tResult.append(lc_sSaveValue.substring(1).toLowerCase());
            lc_sResult = lc_tResult.toString();
        }
        if (!this.checkString(lc_sResult)) {
            lc_sResult = this.tryFindPrefixBySaveGame(pa_sSkyrimSaveGameFolder);
        }
        if (!(this.checkString(lc_sResult) && pa_bUseSkyrimLocale || null == lc_tDefaultLocale)) {
            if (lc_tDefaultLocale == Locale.GERMAN) {
                return "Speichern";
            }
            if (lc_tDefaultLocale == Locale.CANADA || lc_tDefaultLocale == Locale.ENGLISH) {
                return "Save";
            }
        }
        return lc_sResult;
    }

    private String tryFindPrefixBySaveGame(String pa_sSkyrimSaveGameFolder) {
        File lc_tDirectory = new File(pa_sSkyrimSaveGameFolder);
        File[] lc_tFiles = null;
        String lc_sPrefix = null;
        String lc_sSaveGameName = null;
        int lc_iEnd = -1;
        if (null != lc_tDirectory && lc_tDirectory.exists() && lc_tDirectory.isDirectory() && null != (lc_tFiles = lc_tDirectory.listFiles())) {
            for (File lc_tFile : lc_tFiles) {
                if (null == lc_tFile || null == (lc_sSaveGameName = lc_tFile.getName()) || !lc_sSaveGameName.toLowerCase().endsWith(".ess") || -1 == (lc_iEnd = lc_sSaveGameName.indexOf(" "))) continue;
                try {
                    lc_sPrefix = lc_sSaveGameName.substring(0, lc_iEnd);
                    if (!this.checkString(lc_sPrefix)) continue;
                    break;
                }
                catch (Exception lc_tException) {
                    lc_sPrefix = null;
                }
            }
        }
        return lc_sPrefix;
    }

    private String searchInFile(String pa_sKey, String pa_sSeparator, String pa_sFilePath, boolean pa_bLittleEndian) {
        FileInputStream lc_InputStream;
        InputStreamReader lc_tInputStreamReader;
        BufferedReader lc_tInputStringReader;
        String lc_sResult;
        block17: {
            File lc_tFile = null;
            lc_sResult = null;
            String lc_sLine = null;
            String lc_sWorkLine = null;
            lc_tInputStringReader = null;
            lc_tInputStreamReader = null;
            lc_InputStream = null;
            int lc_iPos = -1;
            int lc_iStartPos = -1;
            boolean lc_bDone = false;
            if (null != pa_sKey && null != pa_sFilePath && null != (lc_tFile = new File(pa_sFilePath)) && lc_tFile.exists() && lc_tFile.isFile() && lc_tFile.canRead()) {
                try {
                    lc_InputStream = new FileInputStream(lc_tFile);
                    if (null == lc_InputStream) break block17;
                    try {
                        lc_tInputStreamReader = new InputStreamReader((InputStream)lc_InputStream, true == pa_bLittleEndian ? "UTF-16LE" : "UTF-8");
                        if (null == lc_tInputStreamReader || null == (lc_tInputStringReader = new BufferedReader(lc_tInputStreamReader))) break block17;
                        try {
                            while (!lc_bDone && null != (lc_sLine = lc_tInputStringReader.readLine())) {
                                lc_sWorkLine = lc_sLine.trim();
                                if (null == lc_sWorkLine || -1 == (lc_iPos = lc_sWorkLine.indexOf(pa_sKey)) || -1 == (lc_iStartPos = lc_sWorkLine.indexOf(pa_sSeparator, lc_iPos + pa_sKey.length()))) continue;
                                lc_sResult = lc_sWorkLine.substring(lc_iStartPos + 1);
                                lc_bDone = true;
                            }
                        }
                        catch (IOException lc_tException) {
                        }
                    }
                    catch (UnsupportedEncodingException lc_tException) {}
                }
                catch (FileNotFoundException lc_tException) {
                    // empty catch block
                }
            }
        }
        if (null != lc_tInputStringReader) {
            try {
                lc_tInputStringReader.close();
                lc_tInputStringReader = null;
            }
            catch (Exception lc_tException) {
                // empty catch block
            }
        }
        if (null != lc_tInputStreamReader) {
            try {
                lc_tInputStreamReader.close();
                lc_tInputStreamReader = null;
            }
            catch (Exception lc_tException) {
                // empty catch block
            }
        }
        if (null != lc_InputStream) {
            try {
                lc_InputStream.close();
                lc_InputStream = null;
            }
            catch (Exception lc_tException) {
                // empty catch block
            }
        }
        return lc_sResult;
    }

    private void scanActiveSaveGamesDirectory(String pa_sPath, String pa_sMessage, boolean pa_bShowMessage, boolean pa_bIsRescan) {
        String lc_sPath = this.getPropertyString("ACTIVE_PATH");
        this.m_tView.setActivePath(pa_sPath);
        this.m_tView.storePlayerSelection(true);
        this.m_tView.storeSaveGameSelection(true);
        this.m_tView.setActiveScanned(false);
        if (null == pa_sMessage) {
            pa_sMessage = this.getLocalizedString("messageScanningActiveSaveGames");
        }
        if (null != lc_sPath && null != this.m_tPlayerManagerActiveSaveGames && null != (this.m_tWorkerDirectoryScan = new SwingWorkerDirectoryScan())) {
            this.m_tPlayerManagerActiveSaveGames.clear();
            this.m_tView.resetAmountActive();
            this.m_tView.setActiveSaveGameScreenshot(null);
            this.m_tView.setActivePlayerRace(null);
            this.m_tView.clearActiveSaveGameTable();
            this.m_tView.clearActivePlayerList();
            this.m_tView.setUILockMode(true, false);
            this.m_tWorkerDirectoryScan.init(lc_sPath, pa_bIsRescan, true, pa_sMessage, pa_bShowMessage);
            this.m_tWorkerDirectoryScan.execute();
        }
    }

    private void scanBackupSaveGamesDirectory(String pa_sPath, boolean pa_bIsRescan) {
        String lc_sPath = this.getPropertyString("DESTINATION_PATH");
        this.m_tView.setBackupPath(pa_sPath);
        this.m_tView.storePlayerSelection(false);
        this.m_tView.storeSaveGameSelection(false);
        this.m_tView.setBackupScanned(false);
        if (null != lc_sPath && null != this.m_tPlayerManagerBackupSaveGames) {
            this.m_tWorkerDirectoryScan = new SwingWorkerDirectoryScan();
            if (null != this.m_tWorkerDirectoryScan) {
                this.m_tPlayerManagerBackupSaveGames.clear();
                this.m_tView.resetAmountBackup();
                this.m_tView.setBackupSaveGameScreenshot(null);
                this.m_tView.setBackupPlayerRace(null);
                this.m_tView.clearBackupSaveGameTable();
                this.m_tView.clearBackupPlayerList();
                this.m_tView.setUILockMode(true, false);
                this.m_tWorkerDirectoryScan.init(lc_sPath, pa_bIsRescan, false, this.getLocalizedString("messageScanningBackupSaveGames"), true);
                this.m_tWorkerDirectoryScan.execute();
            }
        } else {
            this.m_bInitializing = false;
        }
    }

    protected synchronized void handleNonScanWorkerThreadFinished(int pa_iThreadModeId, int pa_iNumberOfFiles, boolean pa_bMode) {
        boolean lc_bFugly;
        String lc_sMessageKey = null;
        boolean lc_bReloadScreenhotTest = false;
        boolean lc_bReloadScreenhotMode = false;
        boolean lc_bScrollToSelection = false;
        boolean lc_bWasMoving = false;
        switch (pa_iThreadModeId) {
            case 0: {
                lc_sMessageKey = "messageDeleteDone";
                lc_bReloadScreenhotTest = true;
                lc_bScrollToSelection = true;
                lc_bReloadScreenhotMode = pa_bMode;
                break;
            }
            case 2: {
                lc_sMessageKey = "messageRestoreDone";
                lc_bScrollToSelection = lc_bWasMoving = null != this.m_tWorkerCopySaveGames ? this.m_tWorkerCopySaveGames.getWorkMode() == 1 : false;
                lc_bReloadScreenhotTest = true;
                lc_bReloadScreenhotMode = true;
                this.m_tView.restoreSaveGameSelection(true, true);
                break;
            }
            case 1: {
                lc_sMessageKey = "messageBackupDone";
                lc_bScrollToSelection = lc_bWasMoving = null != this.m_tWorkerCopySaveGames ? this.m_tWorkerCopySaveGames.getWorkMode() == 1 : false;
                lc_bReloadScreenhotTest = true;
                lc_bReloadScreenhotMode = false;
                this.m_tView.restoreSaveGameSelection(false, true);
                break;
            }
            case 4: {
                lc_sMessageKey = "messageLaunchActive";
                break;
            }
            case 3: {
                lc_sMessageKey = "messageLaunchBackup";
                break;
            }
            default: {
                lc_sMessageKey = null;
            }
        }
        if (null != this.m_tWorkerCopySaveGames) {
            this.m_tWorkerCopySaveGames = null;
        }
        if (null != this.m_tWorkerDeleteSaveGames) {
            this.m_tWorkerDeleteSaveGames = null;
        }
        this.m_tView.setUILockMode(false, false);
        this.m_tView.setMessage(null != lc_sMessageKey ? this.insertNumberString(this.getLocalizedString(lc_sMessageKey), pa_iNumberOfFiles) : "");
        this.m_tView.setAmountActive(this.m_tPlayerManagerActiveSaveGames, this.m_tPlayerManagerActiveSaveGames.getSaveGameAmountForList(this.m_tView.getSelectedActivePlayers()));
        this.m_tView.setAmountBackup(this.m_tPlayerManagerBackupSaveGames, this.m_tPlayerManagerBackupSaveGames.getSaveGameAmountForList(this.m_tView.getSelectedBackupPlayers()));
        this.m_tView.resetProgress();
        if (pa_iThreadModeId == 4) {
            this.m_bPrepareForLaunching = false;
            this.m_sLaunchPlayer = null;
            this.launchSkyrim();
        }
        if (pa_iThreadModeId == 3 && null != this.m_tPlayerManagerActiveSaveGames) {
            this.m_tView.selectActivePlayer(this.m_tPlayerManagerActiveSaveGames.getPlayer(this.m_sLaunchPlayer));
            this.handleButtonActiveLaunchPlayer();
        }
        if (lc_bScrollToSelection) {
            lc_bFugly = pa_bMode;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SkyrimCharacterHelperApp.this.m_tView.ensureSaveGameSelectionIsVisible(lc_bFugly);
                }
            });
        }
        if (lc_bReloadScreenhotTest) {
            lc_bFugly = lc_bReloadScreenhotMode;
            final boolean lc_bFugly2 = lc_bWasMoving;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SkyrimCharacterHelperApp.this.performSaveGameListSelection(lc_bFugly);
                    if (lc_bFugly2) {
                        SkyrimCharacterHelperApp.this.performSaveGameListSelection(!lc_bFugly);
                    }
                }
            });
        }
    }

    private synchronized void handleSaveGameWorkerThreadFinished(boolean pa_bMode, boolean pa_bWasCancelled) {
        boolean lc_bHasMultiSelection;
        SkyrimCharacterHelperSaveGame lc_tSaveGame = null;
        BufferedImage lc_tImage = null;
        boolean bl = lc_bHasMultiSelection = true == pa_bMode ? this.m_tView.hasListMultiSelectionActiveSaveGames() : this.m_tView.hasListMultiSelectionBackupSaveGames();
        if (!lc_bHasMultiSelection && (null != this.m_tWorkerLoaderSaveGamesActive && pa_bMode || null != this.m_tWorkerLoaderSaveGamesBackup && !pa_bMode) && null != (lc_tSaveGame = true == pa_bMode ? this.m_tWorkerLoaderSaveGamesActive.getSaveGame() : this.m_tWorkerLoaderSaveGamesBackup.getSaveGame()) && null != lc_tSaveGame.getScreenshot()) {
            lc_tImage = lc_tSaveGame.getScreenshot().getImage();
        }
        if (pa_bMode) {
            this.m_tView.setActiveSaveGameScreenshot(lc_tImage);
        } else {
            this.m_tView.setBackupSaveGameScreenshot(lc_tImage);
        }
        this.m_tView.setUILockMode(false, false);
        this.m_tView.setStringCurrentProgress(null);
        this.m_tView.resetProgress();
        this.m_tView.setMessage(this.getLocalizedString("messageReady"));
        if (pa_bMode) {
            this.m_tWorkerLoaderSaveGamesActive = null;
        } else {
            this.m_tWorkerLoaderSaveGamesBackup = null;
        }
    }

    private synchronized void handleScanWorkerThreadFinished(boolean pa_bMode, boolean pa_bWasCancelled) {
        boolean lc_bRescan;
        boolean bl = lc_bRescan = null != this.m_tWorkerDirectoryScan ? this.m_tWorkerDirectoryScan.isRescan() : false;
        if (!pa_bMode) {
            this.m_tView.setBackupScanned(!pa_bWasCancelled);
            if (!pa_bWasCancelled) {
                this.m_tView.setAmountBackup(this.m_tPlayerManagerBackupSaveGames, this.m_tPlayerManagerBackupSaveGames.getSaveGameAmountForList(this.m_tView.getSelectedBackupPlayers()));
            } else {
                this.m_tView.resetAmountBackup();
                this.m_tPlayerManagerBackupSaveGames.clear();
            }
        } else {
            this.m_tView.setActiveScanned(!pa_bWasCancelled);
            if (!pa_bWasCancelled) {
                this.m_tView.setAmountActive(this.m_tPlayerManagerActiveSaveGames, this.m_tPlayerManagerActiveSaveGames.getSaveGameAmountForList(this.m_tView.getSelectedActivePlayers()));
            } else {
                this.m_tView.resetAmountActive();
                this.m_tPlayerManagerActiveSaveGames.clear();
            }
        }
        this.m_tView.setMessage("");
        this.m_tView.resetProgress();
        this.m_tView.setUILockMode(false, false);
        if (null != this.m_tWorkerDirectoryScan) {
            this.m_tWorkerDirectoryScan = null;
        }
        if (!pa_bWasCancelled) {
            if (pa_bMode) {
                this.m_tView.initPlayerList(this.m_tPlayerManagerActiveSaveGames, true);
                if (this.m_bInitializing && this.m_bScanAll) {
                    this.scanBackupSaveGamesDirectory(this.checkPath(this.getPropertyString("DESTINATION_PATH")), false);
                }
            } else {
                if (this.m_bInitializing) {
                    this.m_tView.setMessage(this.getLocalizedString("messageReady"));
                }
                this.m_bInitializing = false;
                this.m_tView.initPlayerList(this.m_tPlayerManagerBackupSaveGames, false);
            }
        }
        if (lc_bRescan) {
            final boolean lc_bFugly = pa_bMode;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SkyrimCharacterHelperApp.this.performSaveGameListSelection(lc_bFugly);
                }
            });
        }
    }

    private void copyImageToClipboard(BufferedImage pa_tImage) {
        SkyrimCharacterHelperClipboardImage lc_tClipBoardImage = new SkyrimCharacterHelperClipboardImage(pa_tImage);
        if (null != lc_tClipBoardImage) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(lc_tClipBoardImage, null);
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private boolean loadProperties() {
        File lc_tPropertiesFile = new File("settings.prs");
        FileInputStream lc_tInputStream = null;
        boolean lc_bResult = false;
        if (null != lc_tPropertiesFile && null != this.m_tProperties && lc_tPropertiesFile.exists() && lc_tPropertiesFile.isFile()) {
            try {
                lc_tInputStream = new FileInputStream(lc_tPropertiesFile);
                if (null != lc_tInputStream) {
                    this.m_tProperties.load(lc_tInputStream);
                    lc_tInputStream.close();
                    lc_bResult = true;
                }
            }
            catch (IOException lc_tException) {
                // empty catch block
            }
        }
        return lc_bResult;
    }

    private void saveProperties(String pa_sAnnotation) {
        File lc_tPropertiesFile = new File("settings.prs");
        FileOutputStream lc_tOutputStream = null;
        if (null != lc_tPropertiesFile && null != this.m_tProperties) {
            this.m_tProperties.put("MINIMIZE_MODE", Integer.toString(this.m_tView.getMinimizeMode()));
            this.m_tProperties.put("WORK_MODE", Integer.toString(this.m_tView.getFileMode()));
            this.m_tProperties.put("CONFIRMATION_MODE", Integer.toString(this.m_tView.getConfirmationMode()));
            this.m_tProperties.put("OVERWRITE_MODE", Integer.toString(this.m_tView.getOverwriteMode()));
            this.m_tProperties.put("IMAGE_MODE", Integer.toString(this.m_tView.getImageMode()));
            this.m_tProperties.put("AUTOSAVE_MODE", Integer.toString(this.m_tView.getAutoSaveMode()));
            this.m_tProperties.put("QUICKSAVE_MODE", Integer.toString(this.m_tView.getQuickSaveMode()));
            this.m_tProperties.put("INIT_MODE", Integer.toString(this.m_tView.getInitMode()));
            this.m_tProperties.put("HEADER_ACTIVE", this.m_tView.getHeaderArrangement(true));
            this.m_tProperties.put("HEADER_BACKUP", this.m_tView.getHeaderArrangement(false));
            this.m_tProperties.put("SORT_ORDER_ACTIVE", this.m_tView.getSortOrder(true));
            this.m_tProperties.put("SORT_ORDER_BACKUP", this.m_tView.getSortOrder(false));
            this.m_tProperties.put("PREFIX", this.m_tView.getPrefix());
            this.m_tProperties.put("LAUNCH_PARAMETERS", this.m_tView.getLaunchOptions());
            try {
                if (!lc_tPropertiesFile.exists()) {
                    lc_tPropertiesFile.createNewFile();
                }
                if (lc_tPropertiesFile.exists() && lc_tPropertiesFile.isFile() && null != (lc_tOutputStream = new FileOutputStream(lc_tPropertiesFile))) {
                    this.m_tProperties.store(lc_tOutputStream, pa_sAnnotation);
                    lc_tOutputStream.close();
                }
            }
            catch (IOException lc_tException) {
                // empty catch block
            }
        }
    }

    private String getLocalizedString(String pa_sKey) {
        return null != this.m_tLocalizedMessages ? this.m_tLocalizedMessages.getString(pa_sKey) : "";
    }

    private String[] getMonitoringDisplays() {
        String[] lc_tResult = new String[2];
        if (null != lc_tResult) {
            lc_tResult[0] = this.getLocalizedString("jLabel.text.notMonitoring");
            lc_tResult[1] = this.getLocalizedString("jLabel.text.monitoring");
        }
        return lc_tResult;
    }

    private String[] getLocalizedOkCancelOptions() {
        String[] lc_tResult = new String[2];
        if (null != lc_tResult) {
            lc_tResult[0] = this.getLocalizedString("dialogOptionOk");
            lc_tResult[1] = this.getLocalizedString("dialogOptionCancel");
        }
        return lc_tResult;
    }

    private String[] getLocalizedComboBoxOptionsWorkMode() {
        String[] lc_tResult = new String[2];
        if (null != lc_tResult) {
            lc_tResult[0] = this.getLocalizedString("comboBoxOptionCopy");
            lc_tResult[1] = this.getLocalizedString("comboBoxOptionMove");
        }
        return lc_tResult;
    }

    private String[] getLocalizedComboBoxOptionsImageMode() {
        String[] lc_tResult = new String[2];
        if (null != lc_tResult) {
            lc_tResult[0] = this.getLocalizedString("comboBoxOptionShow");
            lc_tResult[1] = this.getLocalizedString("comboBoxOptionHide");
        }
        return lc_tResult;
    }

    private String[] getLocalizedComboBoxOptionsInitMode() {
        String[] lc_tResult = new String[2];
        if (null != lc_tResult) {
            lc_tResult[0] = this.getLocalizedString("comboBoxOptionScanAll");
            lc_tResult[1] = this.getLocalizedString("comboBoxOptionScanSkyrimOnly");
        }
        return lc_tResult;
    }

    private String[] getLocalizedComboBoxOptionsLaunchMode() {
        String[] lc_tResult = new String[2];
        if (null != lc_tResult) {
            lc_tResult[0] = this.getLocalizedString("comboBoxOptionLaunchMinimized");
            lc_tResult[1] = this.getLocalizedString("comboBoxOptionLaunchNormal");
        }
        return lc_tResult;
    }

    private String[] getLocalizedYesNoOptions() {
        String[] lc_tResult = new String[2];
        if (null != lc_tResult) {
            lc_tResult[0] = this.getLocalizedString("comboBoxOptionYes");
            lc_tResult[1] = this.getLocalizedString("comboBoxOptionNo");
        }
        return lc_tResult;
    }

    private String[] getLocalizedTableHeaders() {
        String[] lc_tResult = new String[4];
        if (null != lc_tResult) {
            lc_tResult[0] = this.getLocalizedString("tableHeader.level");
            lc_tResult[1] = this.getLocalizedString("tableHeader.location");
            lc_tResult[2] = this.getLocalizedString("tableHeader.filetime");
            lc_tResult[3] = this.getLocalizedString("tableHeader.filename");
        }
        return lc_tResult;
    }

    private String getPropertyString(String pa_sKey) {
        Object lc_tObject = null;
        if (null != this.m_tProperties && null != (lc_tObject = this.m_tProperties.get(pa_sKey))) {
            return lc_tObject.toString();
        }
        return null;
    }

    private void handleProgramExit() {
        this.handleButtonProcessCancel();
        if (null != this.m_tProperties) {
            this.saveProperties("Last modified on:");
        }
        if (null != this.m_tPlayerManagerActiveSaveGames) {
            this.m_tPlayerManagerActiveSaveGames.clear();
        }
        if (null != this.m_tPlayerManagerBackupSaveGames) {
            this.m_tPlayerManagerBackupSaveGames.clear();
        }
        if (null != this.m_tLaunchThread) {
            this.m_tLaunchThread.terminate();
        }
        if (null != this.m_tWorkerDirectoryScan && !this.m_tWorkerDirectoryScan.isDone()) {
            this.m_tWorkerDirectoryScan.cancel(true);
        }
        if (null != this.m_tWorkerDeleteSaveGames && !this.m_tWorkerDeleteSaveGames.isDone()) {
            this.m_tWorkerDeleteSaveGames.cancel(true);
        }
        if (null != this.m_tWorkerCopySaveGames && !this.m_tWorkerCopySaveGames.isDone()) {
            this.m_tWorkerCopySaveGames.cancel(true);
        }
        if (null != this.m_tWorkerLoaderSaveGamesActive && !this.m_tWorkerLoaderSaveGamesActive.isDone()) {
            this.m_tWorkerLoaderSaveGamesActive.cancel(true);
        }
        if (null != this.m_tWorkerLoaderSaveGamesBackup && !this.m_tWorkerLoaderSaveGamesBackup.isDone()) {
            this.m_tWorkerLoaderSaveGamesBackup.cancel(true);
        }
        this.m_tPlayerManagerActiveSaveGames = null;
        this.m_tPlayerManagerBackupSaveGames = null;
        this.m_tLaunchThread = null;
        this.m_tWorkerDirectoryScan = null;
        this.m_tWorkerDeleteSaveGames = null;
        this.m_tWorkerCopySaveGames = null;
        this.m_tWorkerLoaderSaveGamesActive = null;
        this.m_tWorkerLoaderSaveGamesBackup = null;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    SkyrimCharacterHelperApp.this.m_tView.dispose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private String handleFileRequester(String pa_sPath, String pa_sTitle, int pa_iFileSelectionMode, boolean pa_bCheckRead, boolean pa_bCheckExecute) {
        JFileChooser lc_tFileChooser = new JFileChooser();
        File lc_tFile = null;
        String lc_sResult = null;
        if (null != lc_tFileChooser && null != this.m_tProperties) {
            if (null != pa_sPath) {
                lc_tFileChooser.setCurrentDirectory(new File(pa_sPath));
            }
            lc_tFileChooser.setFileSelectionMode(pa_iFileSelectionMode);
            lc_tFileChooser.setAcceptAllFileFilterUsed(true);
            lc_tFileChooser.setMultiSelectionEnabled(false);
            lc_tFileChooser.setDialogTitle(pa_sTitle);
            lc_tFileChooser.setApproveButtonText(this.getLocalizedString("fileChooserOk"));
            if (0 == lc_tFileChooser.showOpenDialog(this.m_tView) && null != (lc_tFile = lc_tFileChooser.getSelectedFile())) {
                if (pa_bCheckRead && lc_tFile.canRead() || pa_bCheckExecute && lc_tFile.canExecute()) {
                    try {
                        lc_sResult = lc_tFile.getCanonicalPath();
                    }
                    catch (IOException lc_tException) {}
                } else {
                    JOptionPane.showMessageDialog(this.m_tView, this.getLocalizedString(true == pa_bCheckRead ? "dialogTextNotReadable" : "dialogTextNotExecutableError"), this.getLocalizedString("dialogTitleError"), 0);
                }
            }
        }
        return lc_sResult;
    }

    private String handleFileRequesterDirectory(String pa_sPath, String pa_sTitle) {
        return this.handleFileRequester(pa_sPath, pa_sTitle, 1, true, false);
    }

    private String handleFileRequesterFile(String pa_sPath, String pa_sTitle) {
        return this.handleFileRequester(pa_sPath, pa_sTitle, 0, false, true);
    }

    private List<SkyrimCharacterHelperSaveGame> getSaveGamesListFromPlayers(boolean pa_bMode, boolean pa_bUseSelectedPlayers) {
        ArrayList<SkyrimCharacterHelperSaveGame> lc_tResult = new ArrayList<SkyrimCharacterHelperSaveGame>();
        List<SkyrimCharacterHelperSaveGame> lc_tPlayerSaveGames = null;
        List<SkyrimCharacterHelperPlayer> lc_tSelectedPlayers = pa_bMode ? (pa_bUseSelectedPlayers ? this.m_tView.getSelectedActivePlayers() : this.m_tView.getActivePlayers()) : (true == pa_bUseSelectedPlayers ? this.m_tView.getSelectedBackupPlayers() : this.m_tView.getBackupPlayers());
        int lc_iCount = 0;
        if (null != lc_tSelectedPlayers && null != lc_tResult) {
            for (SkyrimCharacterHelperPlayer lc_tPlayer : lc_tSelectedPlayers) {
                if (null == lc_tPlayer || null == (lc_tPlayerSaveGames = lc_tPlayer.getSaveGamesList())) continue;
                for (SkyrimCharacterHelperSaveGame lc_tSaveGame : lc_tPlayerSaveGames) {
                    if (null == lc_tSaveGame) continue;
                    lc_tResult.add(lc_tSaveGame);
                    ++lc_iCount;
                }
            }
        }
        return 0 < lc_iCount ? lc_tResult : null;
    }

    private List<SkyrimCharacterHelperSaveGame> getSaveGamesExceptSelectedPlayer(boolean pa_bMode) {
        ArrayList<SkyrimCharacterHelperSaveGame> lc_tResult = new ArrayList<SkyrimCharacterHelperSaveGame>();
        List<SkyrimCharacterHelperSaveGame> lc_tPlayerSaveGames = null;
        List<SkyrimCharacterHelperPlayer> lc_tConcernedPlayers = true == pa_bMode ? this.m_tView.getActivePlayers() : this.m_tView.getBackupPlayers();
        SkyrimCharacterHelperPlayer lc_tSelectedPlayer = true == pa_bMode ? this.m_tView.getFirstSelectedActivePlayer() : this.m_tView.getFirstSelectedBackupPlayer();
        int lc_iCount = 0;
        if (null != lc_tConcernedPlayers && null != lc_tSelectedPlayer && null != lc_tResult) {
            for (SkyrimCharacterHelperPlayer lc_tPlayer : lc_tConcernedPlayers) {
                if (null == lc_tPlayer || lc_tPlayer.equals(lc_tSelectedPlayer) || null == (lc_tPlayerSaveGames = lc_tPlayer.getSaveGamesList())) continue;
                for (SkyrimCharacterHelperSaveGame lc_tSaveGame : lc_tPlayerSaveGames) {
                    if (null == lc_tSaveGame) continue;
                    lc_tResult.add(lc_tSaveGame);
                    ++lc_iCount;
                }
            }
        }
        return 0 < lc_iCount ? lc_tResult : null;
    }

    private List<SkyrimCharacterHelperSaveGame> getSaveGamesExceptSelectedSavegame(boolean pa_bMode) {
        ArrayList<SkyrimCharacterHelperSaveGame> lc_tResult = new ArrayList<SkyrimCharacterHelperSaveGame>();
        List<SkyrimCharacterHelperSaveGame> lc_tPlayerSaveGames = null;
        List<SkyrimCharacterHelperPlayer> lc_tConcernedPlayers = true == pa_bMode ? this.m_tView.getActivePlayers() : this.m_tView.getBackupPlayers();
        SkyrimCharacterHelperPlayer lc_tSelectedPlayer = true == pa_bMode ? this.m_tView.getFirstSelectedActivePlayer() : this.m_tView.getFirstSelectedBackupPlayer();
        SkyrimCharacterHelperSaveGame lc_tSelectedSaveGame = true == pa_bMode ? this.m_tView.getFirstSelectedActiveSaveGame() : this.m_tView.getFirstSelectedBackupSaveGame();
        int lc_iCount = 0;
        if (null != lc_tConcernedPlayers && null != lc_tSelectedPlayer && null != lc_tResult) {
            for (SkyrimCharacterHelperPlayer lc_tPlayer : lc_tConcernedPlayers) {
                if (null == lc_tPlayer || lc_tPlayer.equals(lc_tSelectedPlayer) || null == (lc_tPlayerSaveGames = lc_tPlayer.getSaveGamesList())) continue;
                for (SkyrimCharacterHelperSaveGame lc_tSaveGame : lc_tPlayerSaveGames) {
                    if (null == lc_tSaveGame) continue;
                    lc_tResult.add(lc_tSaveGame);
                    ++lc_iCount;
                }
            }
            if (null != lc_tSelectedSaveGame && null != (lc_tPlayerSaveGames = lc_tSelectedPlayer.getSaveGamesList())) {
                for (SkyrimCharacterHelperSaveGame lc_tSaveGame : lc_tPlayerSaveGames) {
                    if (null == lc_tSaveGame || lc_tSelectedSaveGame.equals(lc_tSaveGame)) continue;
                    lc_tResult.add(lc_tSaveGame);
                    ++lc_iCount;
                }
            }
        }
        return 0 < lc_iCount ? lc_tResult : null;
    }

    private int getAmountOfFileCollisions(List<SkyrimCharacterHelperSaveGame> pa_tSaveGames, boolean pa_bMode) {
        SkyrimCharacterHelperPlayerManager lc_tDestinationPlayerManager;
        int lc_iCollisions = 0;
        SkyrimCharacterHelperPlayerManager skyrimCharacterHelperPlayerManager = lc_tDestinationPlayerManager = true == pa_bMode ? this.m_tPlayerManagerBackupSaveGames : this.m_tPlayerManagerActiveSaveGames;
        if (null != pa_tSaveGames && null != lc_tDestinationPlayerManager) {
            for (SkyrimCharacterHelperSaveGame lc_tSaveGame : pa_tSaveGames) {
                if (null == lc_tSaveGame || !lc_tDestinationPlayerManager.hasSaveGame(lc_tSaveGame)) continue;
                ++lc_iCollisions;
            }
        }
        return lc_iCollisions;
    }

    private String replaceString(String pa_sSource, String pa_sReplace, String pa_sReplaceWith) {
        StringBuffer lc_sResult = null;
        try {
            if (null != pa_sSource && null != pa_sReplace && null != pa_sReplaceWith && null != (lc_sResult = new StringBuffer())) {
                if (-1 != pa_sSource.indexOf(pa_sReplace)) {
                    lc_sResult.append(pa_sSource.substring(0, pa_sSource.indexOf(pa_sReplace)));
                    lc_sResult.append(pa_sReplaceWith);
                    lc_sResult.append(pa_sSource.substring(pa_sSource.indexOf(pa_sReplace) + pa_sReplace.length()));
                } else {
                    lc_sResult.append(pa_sSource);
                }
            }
        }
        catch (Exception lc_tException) {
            // empty catch block
        }
        return null != lc_sResult ? lc_sResult.toString() : "";
    }

    private String insertNumberString(String pa_sSource, int pa_iNumber) {
        return this.replaceString(pa_sSource, "%d", Integer.toString(pa_iNumber));
    }

    private String insertString(String pa_sSource, String pa_sToInsert) {
        return this.replaceString(pa_sSource, "%s", pa_sToInsert);
    }

    private synchronized void performSaveGameListSelection(boolean pa_bMode) {
        SkyrimCharacterHelperSaveGame lc_tSelectedSaveGame;
        BufferedImage lc_tImage = null;
        String lc_sFileName = null;
        boolean lc_bHasMultiSelection = true == pa_bMode ? this.m_tView.hasListMultiSelectionActiveSaveGames() : this.m_tView.hasListMultiSelectionBackupSaveGames();
        SkyrimCharacterHelperSaveGame skyrimCharacterHelperSaveGame = lc_tSelectedSaveGame = true == pa_bMode ? this.m_tView.getFirstSelectedActiveSaveGame() : this.m_tView.getFirstSelectedBackupSaveGame();
        if (this.m_tView.getImageMode() == 0) {
            if (pa_bMode) {
                this.m_tView.setActiveSaveGameScreenshot(null);
            } else {
                this.m_tView.setBackupSaveGameScreenshot(null);
            }
            if (null != lc_tSelectedSaveGame && !lc_bHasMultiSelection && null != lc_tSelectedSaveGame.getScreenshot() && null != lc_tSelectedSaveGame.getScreenshot().getImage()) {
                lc_tImage = lc_tSelectedSaveGame.getScreenshot().getImage();
            }
            if (null == lc_tImage && !lc_bHasMultiSelection && null != lc_tSelectedSaveGame && null != (lc_sFileName = lc_tSelectedSaveGame.getFilePath())) {
                if (pa_bMode) {
                    if (null == this.m_tWorkerLoaderSaveGamesActive && null != (this.m_tWorkerLoaderSaveGamesActive = new SwingWorkerSaveGameLoader(this.m_tWorkerLoaderSaveGamesBackup))) {
                        this.m_tView.setUILockMode(true, true);
                        this.m_tWorkerLoaderSaveGamesActive.init(lc_sFileName, lc_tSelectedSaveGame, pa_bMode, this.insertString(this.getLocalizedString("messageReadingSaveGame"), lc_sFileName));
                        this.m_tWorkerLoaderSaveGamesActive.execute();
                    }
                } else if (null == this.m_tWorkerLoaderSaveGamesBackup && null != (this.m_tWorkerLoaderSaveGamesBackup = new SwingWorkerSaveGameLoader(this.m_tWorkerLoaderSaveGamesActive))) {
                    this.m_tView.setUILockMode(true, true);
                    this.m_tWorkerLoaderSaveGamesBackup.init(lc_sFileName, lc_tSelectedSaveGame, pa_bMode, this.insertString(this.getLocalizedString("messageReadingSaveGame"), lc_sFileName));
                    this.m_tWorkerLoaderSaveGamesBackup.execute();
                }
            }
            if (null != lc_tImage) {
                if (pa_bMode) {
                    this.m_tView.setActiveSaveGameScreenshot(lc_tImage);
                } else {
                    this.m_tView.setBackupSaveGameScreenshot(lc_tImage);
                }
            }
        }
        this.m_tView.updateUIElements();
    }

    private void performCharacterListSelection(boolean pa_bMode) {
        boolean lc_bHasMultiSelection;
        SkyrimCharacterHelperPlayer lc_tSelectedCharacter = null;
        boolean bl = lc_bHasMultiSelection = true == pa_bMode ? this.m_tView.hasListMultiSelectionActivePlayers() : this.m_tView.hasListMultiSelectionBackupPlayers();
        if (pa_bMode) {
            this.m_tView.setActiveSaveGameScreenshot(null);
            this.m_tView.setAmountActive(this.m_tPlayerManagerActiveSaveGames, -1);
            this.m_tView.setActivePlayerRace(null);
            this.m_tView.clearActiveSaveGameTable();
        } else {
            this.m_tView.setBackupSaveGameScreenshot(null);
            this.m_tView.setAmountBackup(this.m_tPlayerManagerBackupSaveGames, -1);
            this.m_tView.setBackupPlayerRace(null);
            this.m_tView.clearBackupSaveGameTable();
        }
        if (!lc_bHasMultiSelection) {
            lc_tSelectedCharacter = true == pa_bMode ? this.m_tView.getFirstSelectedActivePlayer() : this.m_tView.getFirstSelectedBackupPlayer();
            if (null != lc_tSelectedCharacter) {
                if (pa_bMode) {
                    this.m_tView.initSaveGameList(lc_tSelectedCharacter.getSaveGames(), true, false);
                    this.m_tView.setAmountActive(this.m_tPlayerManagerActiveSaveGames, lc_tSelectedCharacter.getSaveGameAmount());
                    this.m_tView.setActivePlayerRace(lc_tSelectedCharacter.getRace());
                } else {
                    this.m_tView.initSaveGameList(lc_tSelectedCharacter.getSaveGames(), false, false);
                    this.m_tView.setAmountBackup(this.m_tPlayerManagerBackupSaveGames, lc_tSelectedCharacter.getSaveGameAmount());
                    this.m_tView.setBackupPlayerRace(lc_tSelectedCharacter.getRace());
                }
            }
        } else if (pa_bMode) {
            this.m_tView.setAmountActive(this.m_tPlayerManagerActiveSaveGames, this.m_tPlayerManagerActiveSaveGames.getSaveGameAmountForList(this.m_tView.getSelectedActivePlayers()));
        } else {
            this.m_tView.setAmountBackup(this.m_tPlayerManagerBackupSaveGames, this.m_tPlayerManagerBackupSaveGames.getSaveGameAmountForList(this.m_tView.getSelectedBackupPlayers()));
        }
    }

    private void performSelectPath(boolean pa_bMode) {
        String lc_sPath = this.getPropertyString(true == pa_bMode ? "ACTIVE_PATH" : "DESTINATION_PATH");
        String lc_sOldValue = true == pa_bMode ? this.m_tView.getActivePath() : this.m_tView.getBackupPath();
        String lc_sDirectory = null;
        if (null != this.m_tProperties && null != (lc_sDirectory = this.handleFileRequesterDirectory(lc_sPath, this.getLocalizedString(true == pa_bMode ? "dialogTitleFileRequesterSaveGamesDir" : "dialogTitleFileRequesterBackupDir")))) {
            if (pa_bMode) {
                this.m_tView.setActivePath(lc_sDirectory);
            } else {
                this.m_tView.setBackupPath(lc_sDirectory);
            }
            if (!lc_sDirectory.equals(lc_sOldValue)) {
                if (this.m_tView.hasEqualDirectories()) {
                    if (pa_bMode) {
                        this.m_tView.setActivePath(lc_sOldValue);
                    } else {
                        this.m_tView.setBackupPath(lc_sOldValue);
                    }
                    this.m_tView.setMessage(this.getLocalizedString("messageEqualDirs"));
                } else {
                    this.m_tView.removeSaveGameSelections(pa_bMode);
                    if (pa_bMode) {
                        this.m_tView.setActivePath(lc_sDirectory);
                    } else {
                        this.m_tView.setBackupPath(lc_sDirectory);
                    }
                    this.m_tProperties.put(true == pa_bMode ? "ACTIVE_PATH" : "DESTINATION_PATH", lc_sDirectory);
                    if (pa_bMode) {
                        this.scanActiveSaveGamesDirectory(lc_sDirectory, this.getLocalizedString("messageScanningActiveSaveGames"), true, false);
                    } else {
                        this.scanBackupSaveGamesDirectory(lc_sDirectory, false);
                    }
                }
            }
        }
        this.m_tView.updateUIElements();
    }

    private void performDeletePlayers(boolean pa_bMode) {
        List<SkyrimCharacterHelperPlayer> lc_tPlayers;
        boolean lc_bContinue = true;
        SkyrimCharacterHelperPlayerManager lc_tManager = true == pa_bMode ? this.m_tPlayerManagerActiveSaveGames : this.m_tPlayerManagerBackupSaveGames;
        List<SkyrimCharacterHelperPlayer> list = lc_tPlayers = true == pa_bMode ? this.m_tView.getSelectedActivePlayers() : this.m_tView.getSelectedBackupPlayers();
        if (null != lc_tManager && null != lc_tPlayers) {
            if (0 == this.m_tView.getConfirmationMode()) {
                boolean bl = lc_bContinue = 0 == JOptionPane.showOptionDialog(this.m_tView, 1 == lc_tPlayers.size() ? this.getLocalizedString("dialogTextDeletePlayer") : this.getLocalizedString("dialogTextDeletePlayers"), this.getLocalizedString("dialogTitleWarning"), 0, 2, null, this.getLocalizedOkCancelOptions(), this.getLocalizedString("dialogOptionOk"));
            }
            if (lc_bContinue && null != (this.m_tWorkerDeleteSaveGames = new SwingWorkerSaveGameDelete())) {
                this.m_tView.setMessage(this.getLocalizedString("messageDeletePlayers"));
                this.m_tView.setUILockMode(true, false);
                this.m_tWorkerDeleteSaveGames.init(0, this.getSaveGamesListFromPlayers(pa_bMode, true), pa_bMode);
                this.m_tWorkerDeleteSaveGames.execute();
            }
        }
    }

    private void performDeleteSaveGames(boolean pa_bMode) {
        List<SkyrimCharacterHelperSaveGame> lc_tSaveGames;
        boolean lc_bContinue = true;
        SkyrimCharacterHelperPlayerManager lc_tManager = true == pa_bMode ? this.m_tPlayerManagerActiveSaveGames : this.m_tPlayerManagerBackupSaveGames;
        List<SkyrimCharacterHelperSaveGame> list = lc_tSaveGames = true == pa_bMode ? this.m_tView.getSelectedActiveSaveGames() : this.m_tView.getSelectedBackupSaveGames();
        if (null != lc_tManager && null != lc_tSaveGames) {
            if (0 == this.m_tView.getConfirmationMode()) {
                boolean bl = lc_bContinue = 0 == JOptionPane.showOptionDialog(this.m_tView, 1 == lc_tSaveGames.size() ? this.getLocalizedString("dialogTextDeleteSaveGame") : this.getLocalizedString("dialogTextDeleteSaveGames"), this.getLocalizedString("dialogTitleWarning"), 0, 2, null, this.getLocalizedOkCancelOptions(), this.getLocalizedString("dialogOptionOk"));
            }
            if (lc_bContinue && null != lc_tManager && null != (this.m_tWorkerDeleteSaveGames = new SwingWorkerSaveGameDelete())) {
                this.m_tView.setMessage(this.getLocalizedString("messageDeleteSaveGames"));
                this.m_tView.setUILockMode(true, false);
                this.m_tWorkerDeleteSaveGames.init(0, lc_tSaveGames, pa_bMode);
                this.m_tWorkerDeleteSaveGames.execute();
            }
        }
    }

    private void performClearPlayers(boolean pa_bMode) {
        boolean lc_bContinue = true;
        if (0 == this.m_tView.getConfirmationMode()) {
            boolean bl = lc_bContinue = 0 == JOptionPane.showOptionDialog(this.m_tView, this.getLocalizedString("dialogTextClearPlayers"), this.getLocalizedString("dialogTitleWarning"), 0, 2, null, this.getLocalizedOkCancelOptions(), this.getLocalizedString("dialogOptionOk"));
        }
        if (lc_bContinue && null != (this.m_tWorkerDeleteSaveGames = new SwingWorkerSaveGameDelete())) {
            this.m_tView.setMessage(this.getLocalizedString("messageDeleteAllPlayers"));
            this.m_tView.setUILockMode(true, false);
            this.m_tWorkerDeleteSaveGames.init(0, this.getSaveGamesListFromPlayers(pa_bMode, false), pa_bMode);
            this.m_tWorkerDeleteSaveGames.execute();
        }
    }

    private void performCopySaveGames(boolean pa_bMode) {
        String lc_sSelectedDestinationPlayerName = null;
        boolean lc_bContinue = true;
        int lc_iCount = 0;
        SkyrimCharacterHelperPlayerManager lc_tManager = true == pa_bMode ? this.m_tPlayerManagerActiveSaveGames : this.m_tPlayerManagerBackupSaveGames;
        SkyrimCharacterHelperPlayer lc_tSelectedDestinationPlayer = null;
        List<SkyrimCharacterHelperSaveGame> lc_tSaveGames = null;
        this.m_tView.storeSaveGameSelection(pa_bMode);
        this.m_tView.storeSaveGameSelection(!pa_bMode);
        if (null != lc_tManager && null != (lc_tSaveGames = true == pa_bMode ? this.m_tView.getSelectedActiveSaveGames() : this.m_tView.getSelectedBackupSaveGames())) {
            if (0 == this.m_tView.getConfirmationMode() && 1 == this.m_tView.getFileMode()) {
                boolean bl = lc_bContinue = 0 == JOptionPane.showOptionDialog(this.m_tView, this.getLocalizedString("dialogTextDeleteAfterCopy"), this.getLocalizedString("dialogTitleWarning"), 0, 2, null, this.getLocalizedOkCancelOptions(), this.getLocalizedString("dialogOptionOk"));
            }
            if (lc_bContinue) {
                if (0 == this.m_tView.getOverwriteMode() && 0 < (lc_iCount = this.getAmountOfFileCollisions(lc_tSaveGames, pa_bMode))) {
                    boolean bl = lc_bContinue = 0 == JOptionPane.showOptionDialog(this.m_tView, this.insertNumberString(this.getLocalizedString("dialogTextOverwriteSaveGame"), lc_iCount), this.getLocalizedString("dialogTitleWarning"), 0, 2, null, this.getLocalizedOkCancelOptions(), this.getLocalizedString("dialogOptionOk"));
                }
                if (lc_bContinue && null != (this.m_tWorkerCopySaveGames = new SwingWorkerSaveGameCopy())) {
                    lc_tSelectedDestinationPlayer = true == pa_bMode ? this.m_tView.getFirstSelectedBackupPlayer() : this.m_tView.getFirstSelectedActivePlayer();
                    lc_sSelectedDestinationPlayerName = null != lc_tSelectedDestinationPlayer ? lc_tSelectedDestinationPlayer.getName() : null;
                    this.m_tView.setMessage(this.getLocalizedString(true == pa_bMode ? "messageBackingUp" : "messageRestoring"));
                    this.m_tView.setUILockMode(true, false);
                    this.m_tWorkerCopySaveGames.init(true == pa_bMode ? 1 : 2, this.m_tView.getFileMode(), lc_tSaveGames, pa_bMode, true == pa_bMode ? this.m_tView.hasListMultiSelectionBackupPlayers() : this.m_tView.hasListMultiSelectionActivePlayers(), lc_sSelectedDestinationPlayerName);
                    this.m_tWorkerCopySaveGames.execute();
                }
            }
        }
    }

    private void performCopyPlayers(boolean pa_bMode) {
        String lc_sSelectedDestinationPlayerName = null;
        boolean lc_bContinue = true;
        int lc_iCount = 0;
        SkyrimCharacterHelperPlayer lc_tSelectedDestinationPlayer = null;
        List<SkyrimCharacterHelperSaveGame> lc_tSaveGames = null;
        this.m_tView.storeSaveGameSelection(pa_bMode);
        this.m_tView.storeSaveGameSelection(!pa_bMode);
        if (0 == this.m_tView.getConfirmationMode() && 1 == this.m_tView.getFileMode()) {
            boolean bl = lc_bContinue = 0 == JOptionPane.showOptionDialog(this.m_tView, this.getLocalizedString("dialogTextDeleteAfterCopy"), this.getLocalizedString("dialogTitleWarning"), 0, 2, null, this.getLocalizedOkCancelOptions(), this.getLocalizedString("dialogOptionOk"));
        }
        if (lc_bContinue && null != (lc_tSaveGames = this.getSaveGamesListFromPlayers(pa_bMode, true))) {
            if (0 == this.m_tView.getOverwriteMode() && 0 < (lc_iCount = this.getAmountOfFileCollisions(lc_tSaveGames, pa_bMode))) {
                boolean bl = lc_bContinue = 0 == JOptionPane.showOptionDialog(this.m_tView, this.insertNumberString(this.getLocalizedString("dialogTextOverwriteSaveGame"), lc_iCount), this.getLocalizedString("dialogTitleWarning"), 0, 2, null, this.getLocalizedOkCancelOptions(), this.getLocalizedString("dialogOptionOk"));
            }
            if (lc_bContinue && null != (this.m_tWorkerCopySaveGames = new SwingWorkerSaveGameCopy())) {
                lc_tSelectedDestinationPlayer = true == pa_bMode ? this.m_tView.getFirstSelectedBackupPlayer() : this.m_tView.getFirstSelectedActivePlayer();
                lc_sSelectedDestinationPlayerName = null != lc_tSelectedDestinationPlayer ? lc_tSelectedDestinationPlayer.getName() : null;
                this.m_tView.setMessage(this.getLocalizedString(true == pa_bMode ? "messageBackingUp" : "messageRestoring"));
                this.m_tView.setUILockMode(true, false);
                this.m_tWorkerCopySaveGames.init(true == pa_bMode ? 1 : 2, this.m_tView.getFileMode(), lc_tSaveGames, pa_bMode, true == pa_bMode ? this.m_tView.hasListMultiSelectionBackupPlayers() : this.m_tView.hasListMultiSelectionActivePlayers(), lc_sSelectedDestinationPlayerName);
                this.m_tWorkerCopySaveGames.execute();
            }
        }
    }

    @Override
    public void notifySkyrimTerminated(int pa_iExitValue) {
        this.m_tLaunchThread = null;
        this.m_tView.setOnSkyrim(false);
        this.m_tView.setLaunched(false);
        this.m_tView.setUILockMode(false, false);
        if (1 == this.m_tView.getState()) {
            this.m_tView.setState(this.m_tView.getExtendedState() & 0xFFFFFFFE);
        }
        this.m_tView.toFront();
        this.m_tView.setMessage(this.insertNumberString(this.getLocalizedString("messageLaunchDone"), this.m_iSaveGameChanges));
    }

    @Override
    public synchronized void notifySkyrimSavegameDeleted(String pa_sFileName) {
        SkyrimCharacterHelperSaveGame lc_tSaveGame = null;
        SkyrimCharacterHelperPlayer lc_tSourceFirstSelection = this.m_tView.getFirstSelectedActivePlayer();
        String lc_sCharacter = null;
        boolean lc_bSourceHasSingleSelection = null != this.m_tView.getSelectedActivePlayers() && false == this.m_tView.hasListMultiSelectionActivePlayers();
        boolean lc_bSourceHasPlayer = false;
        boolean lc_bEmpty = false;
        boolean lc_bWasDisplayed = false;
        if (null != this.m_tPlayerManagerActiveSaveGames && null != pa_sFileName && null != (lc_sCharacter = this.m_tPlayerManagerActiveSaveGames.hasSaveGame(pa_sFileName))) {
            this.m_tView.storePlayerSelection(true);
            lc_bSourceHasPlayer = this.m_tPlayerManagerActiveSaveGames.hasPlayer(lc_sCharacter);
            ++this.m_iSaveGameChanges;
            lc_tSaveGame = this.m_tPlayerManagerActiveSaveGames.removeSaveGame(pa_sFileName);
            boolean bl = lc_bEmpty = 0 == this.m_tPlayerManagerActiveSaveGames.getSaveGameAmount(lc_sCharacter);
            if (null != lc_tSourceFirstSelection && lc_bSourceHasSingleSelection && lc_bSourceHasPlayer && lc_sCharacter.equals(lc_tSourceFirstSelection.getName())) {
                this.m_tView.removeActiveSaveGame(lc_tSaveGame, false == lc_bEmpty);
                lc_bWasDisplayed = true;
            }
            if (lc_bEmpty) {
                this.m_tPlayerManagerActiveSaveGames.removePlayer(lc_sCharacter);
                if (lc_bWasDisplayed) {
                    this.m_tView.setActiveSaveGameScreenshot(null);
                    this.m_tView.setActivePlayerRace(null);
                    this.m_tView.removeActivePlayer(lc_tSourceFirstSelection, true, false);
                }
            }
            this.m_tView.setAmountActive(this.m_tPlayerManagerActiveSaveGames, this.m_tPlayerManagerActiveSaveGames.getSaveGameAmountForList(this.m_tView.getSelectedActivePlayers()));
        }
    }

    @Override
    public synchronized void notifySkyrimSavegameModified(String pa_sFileName) {
        SkyrimCharacterHelperSaveGame lc_tSaveGame = null;
        String lc_sFullPath = null;
        String lc_sCharacter = null;
        List<SkyrimCharacterHelperPlayer> lc_tSourcePlayerOldSelection = this.m_tView.getSelectedActivePlayers();
        SkyrimCharacterHelperPlayer lc_tSourceFirstSelection = this.m_tView.getFirstSelectedActivePlayer();
        boolean lc_bSourceHasSingleSelection = null != this.m_tView.getSelectedActivePlayers() && false == this.m_tView.hasListMultiSelectionActivePlayers();
        boolean lc_bSourceHasPlayer = false;
        if (null != this.m_tPlayerManagerActiveSaveGames && null != pa_sFileName && null != (lc_tSaveGame = new SkyrimCharacterHelperSaveGame()) && null != (lc_sFullPath = this.getPropertyString("ACTIVE_PATH"))) {
            if (!lc_sFullPath.endsWith(this.m_sSeparator)) {
                lc_sFullPath = lc_sFullPath + this.m_sSeparator;
            }
            if (lc_tSaveGame.read(lc_sFullPath = lc_sFullPath + pa_sFileName, null, true)) {
                lc_sCharacter = lc_tSaveGame.getPlayerName();
                lc_bSourceHasPlayer = this.m_tPlayerManagerActiveSaveGames.hasPlayer(lc_sCharacter);
                this.m_tPlayerManagerActiveSaveGames.add(lc_tSaveGame);
                ++this.m_iSaveGameChanges;
                if (null != lc_tSourceFirstSelection && lc_bSourceHasSingleSelection && lc_bSourceHasPlayer && lc_sCharacter.equals(lc_tSourceFirstSelection.getName())) {
                    this.m_tView.addActiveSaveGame(lc_tSaveGame, true);
                }
                if (!lc_bSourceHasPlayer) {
                    this.m_tView.addActivePlayer(this.m_tPlayerManagerActiveSaveGames.getPlayer(lc_sCharacter));
                    this.m_tView.reselectPlayers(lc_tSourcePlayerOldSelection, true);
                }
                this.m_tView.setAmountActive(this.m_tPlayerManagerActiveSaveGames, this.m_tPlayerManagerActiveSaveGames.getSaveGameAmountForList(this.m_tView.getSelectedActivePlayers()));
            }
        }
    }

    private String tryGuessSkyrimSaveGameFolder() {
        String lc_sHomeDirectory = System.getenv("USERPROFILE");
        String lc_sOsName = System.getProperty("os.name");
        String lc_sOsVersion = System.getProperty("os.version");
        String lc_sPath = null;
        boolean lc_bWinXp = false;
        boolean lc_bWin2K = false;
        boolean lc_bWin7 = false;
        if (null != lc_sOsName && null != lc_sOsVersion && null != this.m_tProperties && lc_sOsName.toUpperCase().startsWith("WINDOWS".toUpperCase())) {
            lc_bWinXp = lc_sOsVersion.startsWith("5.1");
            lc_bWin2K = lc_sOsVersion.startsWith("6.0");
            lc_bWin7 = lc_sOsVersion.startsWith("6.1");
            if (lc_bWinXp) {
                lc_sHomeDirectory = lc_sHomeDirectory + "\\My Documents\\My Games";
            }
            if (lc_bWin2K) {
                lc_sHomeDirectory = lc_sHomeDirectory + "\\My Documents\\Saved Games";
            }
            if (lc_bWin7) {
                lc_sHomeDirectory = lc_sHomeDirectory + "\\Documents\\My Games";
            }
            if (null != (lc_sPath = this.checkPath(lc_sHomeDirectory = lc_sHomeDirectory + "\\Skyrim\\Saves")) && 0 == JOptionPane.showOptionDialog(this.m_tView, this.insertString(this.getLocalizedString("dialogTextFreshSaveGame"), lc_sPath), this.getLocalizedString("dialogTitleInformation"), 0, 1, null, this.getLocalizedYesNoOptions(), this.getLocalizedString("dialogOptionYes"))) {
                this.m_tProperties.put("ACTIVE_PATH", lc_sPath);
                return lc_sPath;
            }
        }
        return null;
    }

    @Override
    public void handleComboBoxImageMode() {
        int lc_iMode = this.m_tView.getImageMode();
        if (0 == lc_iMode) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (null == SkyrimCharacterHelperApp.this.m_tView.getActiveSaveGameScreenshot()) {
                        SkyrimCharacterHelperApp.this.performSaveGameListSelection(true);
                    }
                    if (null == SkyrimCharacterHelperApp.this.m_tView.getBackupSaveGameScreenshot()) {
                        SkyrimCharacterHelperApp.this.performSaveGameListSelection(false);
                    }
                }
            });
        }
    }

    @Override
    public void handleButtonActiveLaunchSaveGame() {
        boolean lc_bContinue = true;
        boolean lc_bJustOneSaveGame = this.m_tView.hasOneActiveSaveGame();
        int lc_iCount = 0;
        SkyrimCharacterHelperPlayer lc_tSelectedActivePlayer = this.m_tView.getFirstSelectedActivePlayer();
        SkyrimCharacterHelperPlayer lc_tSelectedDestinationPlayer = null;
        List<SkyrimCharacterHelperSaveGame> lc_tSaveGames = null;
        String lc_sSelectedDestinationPlayerName = null;
        if (null != lc_tSelectedActivePlayer) {
            if (!lc_bJustOneSaveGame && 0 == this.m_tView.getConfirmationMode()) {
                boolean bl = lc_bContinue = 0 == JOptionPane.showOptionDialog(this.m_tView, this.getLocalizedString("dialogTextActiveSavegameMoveForLaunch"), this.getLocalizedString("dialogTitleWarning"), 0, 2, null, this.getLocalizedOkCancelOptions(), this.getLocalizedString("dialogOptionOk"));
            }
            if (lc_bContinue) {
                lc_tSaveGames = this.getSaveGamesExceptSelectedSavegame(true);
                if (lc_bJustOneSaveGame || null != lc_tSaveGames) {
                    if (!lc_bJustOneSaveGame && 0 == this.m_tView.getOverwriteMode() && 0 < (lc_iCount = this.getAmountOfFileCollisions(lc_tSaveGames, true))) {
                        boolean bl = lc_bContinue = 0 == JOptionPane.showOptionDialog(this.m_tView, this.insertNumberString(this.getLocalizedString("dialogTextOverwriteSaveGame"), lc_iCount), this.getLocalizedString("dialogTitleWarning"), 0, 2, null, this.getLocalizedOkCancelOptions(), this.getLocalizedString("dialogOptionOk"));
                    }
                    if (lc_bContinue) {
                        this.m_bPrepareForLaunching = true;
                        this.m_sLaunchPlayer = lc_tSelectedActivePlayer.getName();
                        if (!lc_bJustOneSaveGame) {
                            this.m_tWorkerCopySaveGames = new SwingWorkerSaveGameCopy();
                            if (null != this.m_tWorkerCopySaveGames) {
                                lc_tSelectedDestinationPlayer = this.m_tView.getFirstSelectedBackupPlayer();
                                lc_sSelectedDestinationPlayerName = null != lc_tSelectedDestinationPlayer ? lc_tSelectedDestinationPlayer.getName() : null;
                                this.m_tView.setMessage(this.getLocalizedString("messageBackingUp"));
                                this.m_tView.setUILockMode(true, false);
                                this.m_tWorkerCopySaveGames.init(4, 1, lc_tSaveGames, true, this.m_tView.hasListMultiSelectionBackupPlayers(), lc_sSelectedDestinationPlayerName);
                                this.m_tWorkerCopySaveGames.execute();
                            }
                        } else {
                            this.m_bPrepareForLaunching = false;
                            this.m_tView.setMessage(this.getLocalizedString("messageLaunchSingle"));
                            this.launchSkyrim();
                        }
                    }
                }
            }
        }
    }

    @Override
    public void handleButtonBackupLaunchSaveGame() {
        boolean lc_bContinue = true;
        int lc_iCount = 0;
        SkyrimCharacterHelperPlayer lc_tSelectedBackupPlayer = this.m_tView.getFirstSelectedBackupPlayer();
        SkyrimCharacterHelperSaveGame lc_tSelectedBackupSavegame = this.m_tView.getFirstSelectedBackupSaveGame();
        SkyrimCharacterHelperPlayer lc_tSelectedDestinationPlayer = null;
        ArrayList<SkyrimCharacterHelperSaveGame> lc_tSaveGames = new ArrayList<SkyrimCharacterHelperSaveGame>();
        String lc_sSelectedDestinationPlayerName = null;
        if (null != lc_tSelectedBackupPlayer && null != lc_tSelectedBackupSavegame && null != lc_tSaveGames) {
            lc_tSaveGames.add(lc_tSelectedBackupSavegame);
            if (0 == this.m_tView.getConfirmationMode()) {
                boolean bl = lc_bContinue = 0 == JOptionPane.showOptionDialog(this.m_tView, this.getLocalizedString("dialogTextBackupSavegameMoveForLaunch"), this.getLocalizedString("dialogTitleWarning"), 0, 2, null, this.getLocalizedOkCancelOptions(), this.getLocalizedString("dialogOptionOk"));
            }
            if (lc_bContinue) {
                if (0 == this.m_tView.getOverwriteMode() && 0 < (lc_iCount = this.getAmountOfFileCollisions(lc_tSaveGames, false))) {
                    boolean bl = lc_bContinue = 0 == JOptionPane.showOptionDialog(this.m_tView, this.insertNumberString(this.getLocalizedString("dialogTextOverwriteSaveGame"), lc_iCount), this.getLocalizedString("dialogTitleWarning"), 0, 2, null, this.getLocalizedOkCancelOptions(), this.getLocalizedString("dialogOptionOk"));
                }
                if (lc_bContinue) {
                    this.m_bPrepareForLaunching = true;
                    this.m_sLaunchPlayer = lc_tSelectedBackupPlayer.getName();
                    this.m_tWorkerCopySaveGames = new SwingWorkerSaveGameCopy();
                    if (null != this.m_tWorkerCopySaveGames) {
                        lc_tSelectedDestinationPlayer = this.m_tView.getFirstSelectedActivePlayer();
                        lc_sSelectedDestinationPlayerName = null != lc_tSelectedDestinationPlayer ? lc_tSelectedDestinationPlayer.getName() : null;
                        this.m_tView.setMessage(this.getLocalizedString("messageRestoring"));
                        this.m_tView.setUILockMode(true, false);
                        this.m_tWorkerCopySaveGames.init(3, 1, lc_tSaveGames, false, this.m_tView.hasListMultiSelectionActivePlayers(), lc_sSelectedDestinationPlayerName);
                        this.m_tWorkerCopySaveGames.execute();
                    }
                }
            }
        }
    }

    class SwingWorkerDirectoryScan
    extends SwingWorker
    implements SkyrimCharacterHelperProgressNotifier {
        private File m_tDirectory = null;
        private boolean m_bMode = false;
        private boolean m_bShowMessage = true;
        private boolean m_bIsRescan = false;
        private String m_sMessageString = null;
        private SkyrimCharacterHelperPlayerManager m_tCharacterManager = null;

        public void init(String pa_sDirectory, boolean pa_bIsRescan, boolean pa_bMode, String pa_sMessageString, boolean pa_bShowMessage) {
            this.m_tDirectory = new File(pa_sDirectory);
            this.m_tCharacterManager = true == pa_bMode ? SkyrimCharacterHelperApp.this.m_tPlayerManagerActiveSaveGames : SkyrimCharacterHelperApp.this.m_tPlayerManagerBackupSaveGames;
            this.m_bMode = pa_bMode;
            this.m_sMessageString = pa_sMessageString;
            this.m_bShowMessage = pa_bShowMessage;
            this.m_bIsRescan = pa_bIsRescan;
        }

        public boolean getMode() {
            return this.m_bMode;
        }

        public Object doInBackground() {
            int lc_iCount = 0;
            File[] lc_tSaveFiles = null;
            String lc_sFileName = null;
            SkyrimCharacterHelperSaveGame lc_tSaveGame = null;
            if (null != this.m_tDirectory && null != (lc_tSaveFiles = this.m_tDirectory.listFiles(new SkyrimCharacterHelperSaveFileFilter())) && 0 < lc_tSaveFiles.length) {
                SkyrimCharacterHelperApp.this.m_tView.initTotalProgress(lc_tSaveFiles.length);
                SkyrimCharacterHelperApp.this.m_tView.initCurrentProgress(100);
                if (this.m_bShowMessage) {
                    SkyrimCharacterHelperApp.this.m_tView.setMessage(SkyrimCharacterHelperApp.this.insertNumberString(this.m_sMessageString, lc_tSaveFiles.length));
                }
                for (File lc_tCurrentFile : lc_tSaveFiles) {
                    if (this.isCancelled()) break;
                    try {
                        lc_sFileName = lc_tCurrentFile.getCanonicalPath();
                        if (null != lc_sFileName) {
                            SkyrimCharacterHelperApp.this.m_tView.setStringCurrentProgress(lc_sFileName);
                            lc_tSaveGame = new SkyrimCharacterHelperSaveGame();
                            if (null != lc_tSaveGame && lc_tSaveGame.read(lc_sFileName, this, false)) {
                                this.m_tCharacterManager.add(lc_tSaveGame);
                            }
                        }
                    }
                    catch (IOException lc_tException) {
                        // empty catch block
                    }
                    if (this.isCancelled()) continue;
                    SkyrimCharacterHelperApp.this.m_tView.setTotalProgress(++lc_iCount);
                }
                SkyrimCharacterHelperApp.this.m_tView.setStringCurrentProgress(null);
            }
            return null;
        }

        public final boolean isRescan() {
            return this.m_bIsRescan;
        }

        @Override
        public void notifyProgress(int pa_iValue) {
            if (!this.isCancelled()) {
                SkyrimCharacterHelperApp.this.m_tView.setCurrentProgress(pa_iValue);
            }
        }

        @Override
        protected void done() {
            SkyrimCharacterHelperApp.this.handleScanWorkerThreadFinished(this.m_bMode, this.isCancelled());
        }
    }

    class SwingWorkerSaveGameCopy
    extends SwingWorker {
        private int m_iThreadModeId = 0;
        private int m_iWorkMode = 0;
        private int m_iAmountProcessedFiles = 0;
        private boolean m_bMode = false;
        private boolean m_bDestinationMultiSelection = false;
        private String m_sDestinationSelection = null;
        private List<SkyrimCharacterHelperSaveGame> m_tSaveGames = null;
        private SkyrimCharacterHelperPlayerManager m_tCharacterManagerSource = null;
        private SkyrimCharacterHelperPlayerManager m_tCharacterManagerDestination = null;

        public void init(int pa_iModeId, int pa_iWorkMode, List<SkyrimCharacterHelperSaveGame> pa_tSaveGames, boolean pa_bMode, boolean pa_bDestinationMultiSelection, String pa_sDestinationSelection) {
            this.m_tCharacterManagerSource = true == pa_bMode ? SkyrimCharacterHelperApp.this.m_tPlayerManagerActiveSaveGames : SkyrimCharacterHelperApp.this.m_tPlayerManagerBackupSaveGames;
            this.m_tCharacterManagerDestination = true == pa_bMode ? SkyrimCharacterHelperApp.this.m_tPlayerManagerBackupSaveGames : SkyrimCharacterHelperApp.this.m_tPlayerManagerActiveSaveGames;
            this.m_bDestinationMultiSelection = pa_bDestinationMultiSelection;
            this.m_sDestinationSelection = pa_sDestinationSelection;
            this.m_tSaveGames = pa_tSaveGames;
            this.m_bMode = pa_bMode;
            this.m_iThreadModeId = pa_iModeId;
            this.m_iWorkMode = pa_iWorkMode;
        }

        public Object doInBackground() {
            List<SkyrimCharacterHelperPlayer> lc_tDestinationPlayerOldSelection;
            int lc_iCountTotal = 0;
            int lc_iAmountSaveGames = 0;
            boolean lc_bDestinationHasPlayer = false;
            boolean lc_bReselect = false;
            boolean lc_bEmpty = false;
            String lc_sSourcePlayerName = null;
            String lc_sSourceFileName = null;
            String lc_sDestinationFile = null;
            String lc_sDestinationDir = true == this.m_bMode ? SkyrimCharacterHelperApp.this.m_tView.getBackupPath() : SkyrimCharacterHelperApp.this.m_tView.getActivePath();
            SkyrimCharacterHelperPlayer lc_tSourcePlayer = null;
            SkyrimCharacterHelperSaveGame lc_tNewSaveGame = null;
            List<SkyrimCharacterHelperPlayer> list = lc_tDestinationPlayerOldSelection = true == this.m_bMode ? SkyrimCharacterHelperApp.this.m_tView.getSelectedBackupPlayers() : SkyrimCharacterHelperApp.this.m_tView.getSelectedActivePlayers();
            if (null != this.m_tCharacterManagerSource && null != this.m_tCharacterManagerDestination && null != this.m_tSaveGames && 0 < (lc_iAmountSaveGames = this.m_tSaveGames.size())) {
                SkyrimCharacterHelperApp.this.m_tView.initTotalProgress(lc_iAmountSaveGames);
                for (SkyrimCharacterHelperSaveGame lc_tSaveGame : this.m_tSaveGames) {
                    if (this.isCancelled()) break;
                    if (null != lc_tSaveGame) {
                        lc_sSourcePlayerName = lc_tSaveGame.getPlayerName();
                        lc_bDestinationHasPlayer = this.m_tCharacterManagerDestination.hasPlayer(lc_sSourcePlayerName);
                        lc_sSourceFileName = lc_tSaveGame.getFilePath();
                        if (null != lc_sSourceFileName) {
                            if (this.isCancelled()) break;
                            lc_sDestinationFile = lc_sDestinationDir + SkyrimCharacterHelperApp.this.m_sSeparator + lc_tSaveGame.getFileName();
                            if (this.copyFile(lc_sSourceFileName, lc_sDestinationFile, lc_tSaveGame)) {
                                lc_tNewSaveGame = new SkyrimCharacterHelperSaveGame(lc_tSaveGame, lc_sDestinationFile);
                                this.m_tCharacterManagerDestination.add(lc_tNewSaveGame);
                                ++lc_iCountTotal;
                                if (!this.m_bDestinationMultiSelection && null != lc_sSourcePlayerName && null != this.m_sDestinationSelection && lc_sSourcePlayerName.equals(this.m_sDestinationSelection)) {
                                    if (this.m_bMode) {
                                        SkyrimCharacterHelperApp.this.m_tView.addBackupSaveGame(lc_tNewSaveGame, false);
                                    } else {
                                        SkyrimCharacterHelperApp.this.m_tView.addActiveSaveGame(lc_tNewSaveGame, false);
                                    }
                                }
                                if (!lc_bDestinationHasPlayer) {
                                    if (this.m_bMode) {
                                        SkyrimCharacterHelperApp.this.m_tView.addBackupPlayer(this.m_tCharacterManagerDestination.getPlayer(lc_sSourcePlayerName));
                                    } else {
                                        SkyrimCharacterHelperApp.this.m_tView.addActivePlayer(this.m_tCharacterManagerDestination.getPlayer(lc_sSourcePlayerName));
                                    }
                                    SkyrimCharacterHelperApp.this.m_tView.reselectPlayers(lc_tDestinationPlayerOldSelection, !this.m_bMode);
                                }
                                if (1 == this.m_iWorkMode) {
                                    this.m_tCharacterManagerSource.removeSaveGame(lc_tSaveGame);
                                    this.deleteFile(lc_tSaveGame.getFilePath());
                                    lc_bReselect = lc_iCountTotal == lc_iAmountSaveGames;
                                    boolean bl = lc_bEmpty = 0 == this.m_tCharacterManagerSource.getSaveGameAmount(lc_sSourcePlayerName);
                                    if (this.m_bMode) {
                                        SkyrimCharacterHelperApp.this.m_tView.removeActiveSaveGame(lc_tSaveGame, !lc_bEmpty & lc_bReselect);
                                    } else {
                                        SkyrimCharacterHelperApp.this.m_tView.removeBackupSaveGame(lc_tSaveGame, !lc_bEmpty & lc_bReselect);
                                    }
                                    lc_tSourcePlayer = this.m_tCharacterManagerSource.getPlayer(lc_sSourcePlayerName);
                                    if (null != lc_tSourcePlayer && 0 == lc_tSourcePlayer.getSaveGameAmount()) {
                                        this.m_tCharacterManagerSource.removePlayer(lc_sSourcePlayerName);
                                        if (this.m_bMode) {
                                            SkyrimCharacterHelperApp.this.m_tView.removeActivePlayer(lc_tSourcePlayer, true, false);
                                        } else {
                                            SkyrimCharacterHelperApp.this.m_tView.removeBackupPlayer(lc_tSourcePlayer, true, this.m_iThreadModeId == 3);
                                        }
                                    }
                                }
                                SkyrimCharacterHelperApp.this.m_tView.setAmountActive(SkyrimCharacterHelperApp.this.m_tPlayerManagerActiveSaveGames, SkyrimCharacterHelperApp.this.m_tPlayerManagerActiveSaveGames.getSaveGameAmountForList(SkyrimCharacterHelperApp.this.m_tView.getSelectedActivePlayers()));
                                SkyrimCharacterHelperApp.this.m_tView.setAmountBackup(SkyrimCharacterHelperApp.this.m_tPlayerManagerBackupSaveGames, SkyrimCharacterHelperApp.this.m_tPlayerManagerBackupSaveGames.getSaveGameAmountForList(SkyrimCharacterHelperApp.this.m_tView.getSelectedBackupPlayers()));
                            }
                        }
                    }
                    if (this.isCancelled()) continue;
                    SkyrimCharacterHelperApp.this.m_tView.setTotalProgress(lc_iCountTotal);
                }
            }
            return null;
        }

        private synchronized boolean copyFile(String pa_sSourceFileName, String pa_sDestinationFileName, SkyrimCharacterHelperSaveGame pa_tSaveGame) {
            File lc_tDestinationFile;
            boolean lc_bResult;
            block15: {
                int lc_iCountCurrent = 0;
                int lc_iFileSize = 0;
                int lc_iBytesRead = 0;
                int lc_iBytesReadTotal = 0;
                int lc_iRatio = 0;
                lc_bResult = false;
                File lc_tSourceFile = null;
                lc_tDestinationFile = null;
                FileInputStream lc_tInputStream = null;
                FileOutputStream lc_tOutputStream = null;
                byte[] lc_tBuffer = new byte[0x100000];
                if (null != pa_sSourceFileName && null != pa_sDestinationFileName && null != pa_tSaveGame && null != lc_tBuffer && null != (lc_tSourceFile = new File(pa_sSourceFileName))) {
                    lc_iFileSize = (int)lc_tSourceFile.length();
                    lc_iRatio = lc_iFileSize / 0x100000;
                    lc_iBytesRead = 0;
                    lc_iBytesReadTotal = 0;
                    lc_iCountCurrent = 0;
                    SkyrimCharacterHelperApp.this.m_tView.initCurrentProgress(lc_iRatio);
                    SkyrimCharacterHelperApp.this.m_tView.setStringCurrentProgress(pa_sSourceFileName);
                    try {
                        lc_tInputStream = new FileInputStream(lc_tSourceFile);
                        if (null == lc_tInputStream) break block15;
                        lc_tOutputStream = new FileOutputStream(pa_sDestinationFileName);
                        if (null != lc_tOutputStream) {
                            try {
                                while ((lc_iBytesRead = lc_tInputStream.read(lc_tBuffer)) > 0) {
                                    lc_tOutputStream.write(lc_tBuffer, 0, lc_iBytesRead);
                                    if ((lc_iBytesReadTotal += lc_iBytesRead) >= lc_iRatio) {
                                        lc_iBytesReadTotal = 0;
                                    }
                                    if (this.isCancelled()) continue;
                                    SkyrimCharacterHelperApp.this.m_tView.setCurrentProgress(++lc_iCountCurrent);
                                }
                            }
                            catch (Exception lc_tException) {
                                // empty catch block
                            }
                            ++this.m_iAmountProcessedFiles;
                            lc_bResult = true;
                            if (null != lc_tOutputStream) {
                                try {
                                    lc_tOutputStream.close();
                                }
                                catch (Exception lc_tException) {
                                    // empty catch block
                                }
                            }
                        }
                        if (null != lc_tInputStream) {
                            try {
                                lc_tInputStream.close();
                            }
                            catch (Exception lc_tException) {}
                        }
                    }
                    catch (Exception lc_tException) {
                        // empty catch block
                    }
                }
            }
            if (lc_bResult && null != (lc_tDestinationFile = new File(pa_sDestinationFileName))) {
                lc_tDestinationFile.setLastModified(pa_tSaveGame.getFileDate());
            }
            SkyrimCharacterHelperApp.this.m_tView.setStringCurrentProgress(null);
            return lc_bResult;
        }

        private synchronized void deleteFile(String pa_sFilePath) {
            File lc_tFile = null;
            if (null != pa_sFilePath && null != (lc_tFile = new File(pa_sFilePath))) {
                lc_tFile.delete();
            }
        }

        @Override
        protected void done() {
            SkyrimCharacterHelperApp.this.handleNonScanWorkerThreadFinished(this.m_iThreadModeId, this.m_iAmountProcessedFiles, this.m_bMode);
        }

        public final int getProcessedAmount() {
            return this.m_iAmountProcessedFiles;
        }

        public final boolean getMode() {
            return this.m_bMode;
        }

        public final int getWorkMode() {
            return this.m_iWorkMode;
        }
    }

    class SwingWorkerSaveGameDelete
    extends SwingWorker {
        private int m_iModeId = 0;
        private int m_iAmountProcessedFiles = 0;
        private boolean m_bMode = false;
        private List<SkyrimCharacterHelperSaveGame> m_tSaveGames;
        private SkyrimCharacterHelperPlayerManager m_tCharacterManagerSource;
        private SkyrimCharacterHelperPlayerManager m_tCharacterManagerDestination;

        public SwingWorkerSaveGameDelete() {
            SkyrimCharacterHelperApp.this.m_sLaunchPlayer = null;
            this.m_tSaveGames = null;
            this.m_tCharacterManagerSource = null;
            this.m_tCharacterManagerDestination = null;
        }

        public final void init(int pa_iModeId, List<SkyrimCharacterHelperSaveGame> pa_tSaveGames, boolean pa_bMode) {
            this.m_tCharacterManagerSource = true == pa_bMode ? SkyrimCharacterHelperApp.this.m_tPlayerManagerActiveSaveGames : SkyrimCharacterHelperApp.this.m_tPlayerManagerBackupSaveGames;
            this.m_tCharacterManagerDestination = true == pa_bMode ? SkyrimCharacterHelperApp.this.m_tPlayerManagerBackupSaveGames : SkyrimCharacterHelperApp.this.m_tPlayerManagerActiveSaveGames;
            this.m_tSaveGames = pa_tSaveGames;
            this.m_bMode = pa_bMode;
            this.m_iModeId = pa_iModeId;
        }

        public Object doInBackground() {
            int lc_iCountSaveGames = 0;
            int lc_iCountTotal = 0;
            int lc_iAmountSaveGames = 0;
            boolean lc_bReselect = false;
            boolean lc_bEmpty = false;
            String lc_sSourceFileName = null;
            String lc_sSourcePlayerName = null;
            SkyrimCharacterHelperPlayer lc_tSourcePlayer = null;
            if (null != this.m_tCharacterManagerSource && null != this.m_tCharacterManagerDestination && null != this.m_tSaveGames && 0 < (lc_iAmountSaveGames = this.m_tSaveGames.size())) {
                SkyrimCharacterHelperApp.this.m_tView.initTotalProgress(lc_iAmountSaveGames);
                if (!this.isCancelled()) {
                    for (SkyrimCharacterHelperSaveGame lc_tSaveGame : this.m_tSaveGames) {
                        if (this.isCancelled()) {
                            return null;
                        }
                        lc_sSourcePlayerName = lc_tSaveGame.getPlayerName();
                        if (null != lc_tSaveGame && null != (lc_sSourceFileName = lc_tSaveGame.getFilePath())) {
                            this.m_tCharacterManagerSource.removeSaveGame(lc_tSaveGame);
                            this.deleteFile(lc_tSaveGame.getFilePath());
                            ++this.m_iAmountProcessedFiles;
                            lc_bReselect = ++lc_iCountSaveGames == lc_iAmountSaveGames;
                            boolean bl = lc_bEmpty = 0 == this.m_tCharacterManagerSource.getSaveGameAmount(lc_sSourcePlayerName);
                            if (this.m_bMode) {
                                SkyrimCharacterHelperApp.this.m_tView.removeActiveSaveGame(lc_tSaveGame, false == lc_bEmpty && true == lc_bReselect);
                            } else {
                                SkyrimCharacterHelperApp.this.m_tView.removeBackupSaveGame(lc_tSaveGame, false == lc_bEmpty && true == lc_bReselect);
                            }
                        }
                        if (!this.isCancelled()) {
                            SkyrimCharacterHelperApp.this.m_tView.setTotalProgress(++lc_iCountTotal);
                        }
                        if (null != (lc_tSourcePlayer = this.m_tCharacterManagerSource.getPlayer(lc_sSourcePlayerName)) && 0 == lc_tSourcePlayer.getSaveGameAmount()) {
                            this.m_tCharacterManagerSource.removePlayer(lc_sSourcePlayerName);
                            if (this.m_bMode) {
                                SkyrimCharacterHelperApp.this.m_tView.removeActivePlayer(lc_tSourcePlayer, 0 < this.m_tCharacterManagerSource.getSaveGameAmount(), false);
                            } else {
                                SkyrimCharacterHelperApp.this.m_tView.removeBackupPlayer(lc_tSourcePlayer, 0 < this.m_tCharacterManagerSource.getSaveGameAmount(), false);
                            }
                        }
                        if (this.m_bMode) {
                            SkyrimCharacterHelperApp.this.m_tView.setAmountActive(SkyrimCharacterHelperApp.this.m_tPlayerManagerActiveSaveGames, SkyrimCharacterHelperApp.this.m_tPlayerManagerActiveSaveGames.getSaveGameAmountForList(SkyrimCharacterHelperApp.this.m_tView.getSelectedActivePlayers()));
                            continue;
                        }
                        SkyrimCharacterHelperApp.this.m_tView.setAmountBackup(SkyrimCharacterHelperApp.this.m_tPlayerManagerBackupSaveGames, SkyrimCharacterHelperApp.this.m_tPlayerManagerBackupSaveGames.getSaveGameAmountForList(SkyrimCharacterHelperApp.this.m_tView.getSelectedBackupPlayers()));
                    }
                }
            }
            return null;
        }

        private void deleteFile(String pa_sFilePath) {
            File lc_tFile = null;
            if (null != pa_sFilePath && null != (lc_tFile = new File(pa_sFilePath))) {
                lc_tFile.delete();
            }
        }

        @Override
        protected void done() {
            SkyrimCharacterHelperApp.this.handleNonScanWorkerThreadFinished(this.m_iModeId, this.m_iAmountProcessedFiles, this.m_bMode);
        }

        public int getProcessedAmount() {
            return this.m_iAmountProcessedFiles;
        }
    }

    class SwingWorkerSaveGameLoader
    extends SwingWorker
    implements SkyrimCharacterHelperProgressNotifier {
        private String m_sFilePath = null;
        private String m_sMessage = null;
        private boolean m_bMode = false;
        private SkyrimCharacterHelperPlayerManager m_tCharacterManager = null;
        private SkyrimCharacterHelperSaveGame m_tSaveGame = null;
        private SwingWorkerSaveGameLoader m_tWorkerToWaitFor;

        public SwingWorkerSaveGameLoader(SwingWorkerSaveGameLoader pa_tWorkerToWaitFor) {
            this.m_tWorkerToWaitFor = pa_tWorkerToWaitFor;
        }

        public SkyrimCharacterHelperSaveGame getSaveGame() {
            return this.m_tSaveGame;
        }

        public void init(String pa_sFilePath, SkyrimCharacterHelperSaveGame pa_tSaveGame, boolean pa_bMode, String pa_sMessage) {
            this.m_sFilePath = pa_sFilePath;
            this.m_tSaveGame = pa_tSaveGame;
            this.m_sMessage = pa_sMessage;
            this.m_bMode = pa_bMode;
            this.m_tCharacterManager = true == pa_bMode ? SkyrimCharacterHelperApp.this.m_tPlayerManagerActiveSaveGames : SkyrimCharacterHelperApp.this.m_tPlayerManagerBackupSaveGames;
        }

        public boolean getMode() {
            return this.m_bMode;
        }

        public Object doInBackground() {
            if (null != this.m_tWorkerToWaitFor) {
                while (null != this.m_tWorkerToWaitFor && !this.m_tWorkerToWaitFor.isDone() && !this.m_tWorkerToWaitFor.isCancelled()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (null != this.m_sFilePath) {
                SkyrimCharacterHelperApp.this.m_tView.initCurrentProgress(100);
                SkyrimCharacterHelperApp.this.m_tView.setStringCurrentProgress(this.m_sFilePath);
                SkyrimCharacterHelperApp.this.m_tView.setMessage(this.m_sMessage);
                this.m_tSaveGame.read(this.m_sFilePath, this, true);
                this.m_tCharacterManager.add(this.m_tSaveGame);
                if (this.m_bMode) {
                    SkyrimCharacterHelperApp.this.m_tView.addActiveSaveGame(this.m_tSaveGame, false);
                } else {
                    SkyrimCharacterHelperApp.this.m_tView.addBackupSaveGame(this.m_tSaveGame, false);
                }
            }
            return null;
        }

        @Override
        public void notifyProgress(int pa_iValue) {
            if (!this.isCancelled()) {
                SkyrimCharacterHelperApp.this.m_tView.setCurrentProgress(pa_iValue);
            }
        }

        @Override
        protected void done() {
            SkyrimCharacterHelperApp.this.handleSaveGameWorkerThreadFinished(this.m_bMode, this.isCancelled());
        }
    }
}

