/*
 * Decompiled with CFR 0.152.
 */
package skyrimcharacterhelper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import skyrimcharacterhelper.SkyrimCharacterHelperDirectorySnifferThread;
import skyrimcharacterhelper.SkyrimCharacterHelperThreadNotifier;

public class SkyrimCharacterHelperLaunchThread
extends Thread {
    private SkyrimCharacterHelperThreadNotifier m_tNotifier;
    private SkyrimCharacterHelperDirectorySnifferThread m_tDirectorySniffer;
    private String m_sLaunchFile;
    private String m_sLaunchParameters;
    private String m_sSeparator;
    private boolean m_bRunning;
    private boolean m_bCopyAutoSaves;
    private boolean m_bCopyQuickSaves;
    private boolean m_bNotify;

    public SkyrimCharacterHelperLaunchThread(SkyrimCharacterHelperThreadNotifier pa_tNotifier, String pa_sLaunchFile, String pa_sPrefix, String pa_sDirectory, String pa_sParameters, boolean pa_bCopyAutoSaves, boolean pa_bCopyQuickSaves) {
        this.m_sLaunchFile = pa_sLaunchFile;
        this.m_tNotifier = pa_tNotifier;
        this.m_sLaunchParameters = pa_sParameters;
        this.m_bRunning = false;
        this.m_bNotify = true;
        this.m_bCopyAutoSaves = pa_bCopyAutoSaves;
        this.m_bCopyQuickSaves = pa_bCopyQuickSaves;
        this.m_sSeparator = System.getProperty("file.separator");
        this.m_tDirectorySniffer = new SkyrimCharacterHelperDirectorySnifferThread(pa_tNotifier, pa_sPrefix, pa_sDirectory, pa_bCopyAutoSaves, pa_bCopyQuickSaves);
    }

    public final boolean isRunning() {
        return this.m_bRunning;
    }

    public final void terminate() {
        if (null != this.m_tDirectorySniffer) {
            this.m_tDirectorySniffer.terminate();
        }
        this.m_bNotify = false;
        this.m_bRunning = false;
    }

    @Override
    public final void run() {
        int lc_iLaunchResult = -1;
        int lc_iProcessResult = -1;
        this.m_bRunning = true;
        lc_iLaunchResult = this.launch();
        if (0L == (long)lc_iLaunchResult && -1 != this.waitForSkyrimProcesses()) {
            if (null != this.m_tDirectorySniffer) {
                this.m_tDirectorySniffer.start();
            }
            try {
                while (this.m_bRunning) {
                    this.goToSleep(5000L);
                    lc_iProcessResult = this.checkForSkyrimProcesses();
                    this.m_bRunning = 0 < lc_iProcessResult;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (null != this.m_tDirectorySniffer) {
                this.m_tDirectorySniffer.terminate();
            }
        }
        if (this.m_bNotify && null != this.m_tNotifier) {
            this.m_tNotifier.notifySkyrimTerminated(lc_iLaunchResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int launch() {
        int lc_iExitValue;
        block12: {
            Process lc_tExecuteProcess = null;
            StreamGobbler lc_tErrorGobbler = null;
            StreamGobbler lc_tOutputGobbler = null;
            lc_iExitValue = 0;
            String lc_sLaunchTarget = this.m_sLaunchFile;
            if (null != this.m_sLaunchParameters && null != lc_sLaunchTarget && 0 < this.m_sLaunchParameters.length()) {
                if (!this.m_sLaunchParameters.startsWith(" ")) {
                    lc_sLaunchTarget = lc_sLaunchTarget + " ";
                }
                lc_sLaunchTarget = lc_sLaunchTarget + this.m_sLaunchParameters;
            }
            if (null != lc_sLaunchTarget) {
                try {
                    if (this.isProcessRunning(this.m_sLaunchFile) || null == (lc_tExecuteProcess = Runtime.getRuntime().exec(lc_sLaunchTarget))) break block12;
                    lc_tErrorGobbler = new StreamGobbler(lc_tExecuteProcess.getErrorStream());
                    lc_tOutputGobbler = new StreamGobbler(lc_tExecuteProcess.getInputStream());
                    if (null != lc_tErrorGobbler) {
                        lc_tErrorGobbler.start();
                    }
                    if (null != lc_tOutputGobbler) {
                        lc_tOutputGobbler.start();
                    }
                    Process process = lc_tExecuteProcess;
                    synchronized (process) {
                        try {
                            lc_iExitValue = lc_tExecuteProcess.waitFor();
                        }
                        catch (InterruptedException lc_tException) {
                            // empty catch block
                        }
                    }
                }
                catch (IOException lc_tException) {
                    // empty catch block
                }
            }
        }
        return lc_iExitValue;
    }

    private boolean isProcessRunning(String pa_sProcess) {
        String lc_sProcess = null;
        boolean lc_bResult = false;
        int lc_iPos = -1;
        List<String> lc_tProcesses = null;
        if (null != pa_sProcess) {
            lc_iPos = pa_sProcess.lastIndexOf(this.m_sSeparator);
            String string = lc_sProcess = -1 == lc_iPos ? pa_sProcess : pa_sProcess.substring(lc_iPos + this.m_sSeparator.length());
        }
        if (null != lc_sProcess && null != (lc_tProcesses = this.getProcesses()) && 0 < lc_tProcesses.size()) {
            lc_bResult = lc_tProcesses.contains(lc_sProcess.toLowerCase());
        }
        return lc_bResult;
    }

    private List<String> getProcesses() {
        ArrayList<String> lc_tProcesses = null;
        Process lc_tProcess = null;
        String lc_sLine = null;
        String lc_sWorkLine = null;
        BufferedReader lc_tInputReader = null;
        InputStreamReader lc_tInputStreamReader = null;
        int lc_iPos = -1;
        try {
            lc_tProcess = Runtime.getRuntime().exec("tasklist.exe /fo csv /nh");
            if (null != lc_tProcess && null != lc_tProcess.getInputStream() && null != (lc_tInputStreamReader = new InputStreamReader(lc_tProcess.getInputStream()))) {
                lc_tInputReader = new BufferedReader(lc_tInputStreamReader);
                if (null != lc_tInputReader) {
                    lc_tProcesses = new ArrayList<String>();
                    if (null != lc_tProcesses) {
                        while (null != (lc_sLine = lc_tInputReader.readLine())) {
                            if (lc_sLine.isEmpty() || null == (lc_sWorkLine = lc_sLine.substring(1).toLowerCase().trim()) || lc_sWorkLine.isEmpty() || -1 == (lc_iPos = lc_sWorkLine.indexOf("\""))) continue;
                            lc_tProcesses.add(lc_sWorkLine.substring(0, lc_iPos));
                        }
                    }
                    lc_tInputReader.close();
                }
                lc_tInputStreamReader.close();
            }
        }
        catch (Exception lc_tException) {
            // empty catch block
        }
        return lc_tProcesses;
    }

    private void goToSleep(long pa_lTime) {
        try {
            SkyrimCharacterHelperLaunchThread.sleep(pa_lTime);
        }
        catch (InterruptedException lc_tException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int checkForSkyrimProcesses() {
        List<String> lc_tProcesses = null;
        boolean lc_bProcessesFound = true;
        lc_tProcesses = this.getProcesses();
        if (null != lc_tProcesses) {
            if (0 < lc_tProcesses.size()) {
                lc_bProcessesFound = lc_tProcesses.contains("TESV.exe".toLowerCase());
                lc_bProcessesFound |= lc_tProcesses.contains("SkyrimLauncher.exe".toLowerCase());
                return true == (lc_bProcessesFound |= lc_tProcesses.contains("skse_loader.exe".toLowerCase())) ? 1 : 0;
            }
            return 0;
        }
        return -1;
    }

    private int waitForSkyrimProcesses() {
        long lc_lEndTime = System.currentTimeMillis() + 60000L;
        int lc_iProcessResult = -1;
        boolean lc_bDone = false;
        while (!lc_bDone && System.currentTimeMillis() < lc_lEndTime) {
            lc_iProcessResult = this.checkForSkyrimProcesses();
            lc_bDone = 1 == lc_iProcessResult || -1 == lc_iProcessResult;
            if (lc_bDone) continue;
            this.goToSleep(1000L);
        }
        return lc_iProcessResult;
    }

    class StreamGobbler
    extends Thread {
        InputStream m_tInputStream;

        StreamGobbler(InputStream pa_tInputStream) {
            this.m_tInputStream = pa_tInputStream;
        }

        @Override
        public void run() {
            InputStreamReader lc_tInputStreamReader = null != this.m_tInputStream ? new InputStreamReader(this.m_tInputStream) : null;
            BufferedReader lc_tBufferedReader = null != lc_tInputStreamReader ? new BufferedReader(lc_tInputStreamReader) : null;
            String lc_sLine = null;
            if (null != lc_tBufferedReader) {
                try {
                    while (null != (lc_sLine = lc_tBufferedReader.readLine())) {
                    }
                }
                catch (IOException lc_tException) {
                    // empty catch block
                }
            }
            try {
                if (null != lc_tBufferedReader) {
                    lc_tBufferedReader.close();
                }
                if (null != lc_tInputStreamReader) {
                    lc_tInputStreamReader.close();
                }
            }
            catch (IOException lc_tException) {
                // empty catch block
            }
        }
    }
}

