/*
 * Decompiled with CFR 0.152.
 */
package skyrimcharacterhelper;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import skyrimcharacterhelper.SkyrimCharacterHelperSaveGame;

public class SkyrimCharacterHelperPlayer
implements Comparable<SkyrimCharacterHelperPlayer> {
    private String m_sName = null;
    private String m_sRace;
    private ArrayList<SkyrimCharacterHelperSaveGame> m_tSaveGames;
    private static Collator m_tCollator;

    public SkyrimCharacterHelperPlayer() {
        this.m_sRace = null;
        this.m_tSaveGames = new ArrayList();
        m_tCollator = Collator.getInstance();
        m_tCollator.setStrength(2);
    }

    public void clear() {
        if (null != this.m_tSaveGames) {
            this.m_tSaveGames.clear();
        }
    }

    public SkyrimCharacterHelperPlayer(SkyrimCharacterHelperSaveGame pa_tSaveGame) {
        this.m_tSaveGames = new ArrayList();
        m_tCollator = Collator.getInstance();
        m_tCollator.setStrength(2);
        if (null != pa_tSaveGame) {
            this.m_sRace = pa_tSaveGame.getPlayerRace();
            this.m_sName = pa_tSaveGame.getPlayerName();
            this.addSaveGame(pa_tSaveGame);
        }
    }

    public final int getSaveGameAmount() {
        return null != this.m_tSaveGames ? this.m_tSaveGames.size() : 0;
    }

    public final String getRace() {
        return this.m_sRace;
    }

    public final String getName() {
        return this.m_sName;
    }

    public final void setName(String pa_sName) {
        this.m_sName = pa_sName;
    }

    public final boolean addSaveGame(SkyrimCharacterHelperSaveGame pa_tSaveGame) {
        int lc_iPos = -1;
        boolean lc_bFreshAdd = false;
        if (null != this.m_tSaveGames && null != pa_tSaveGame) {
            if (null == this.m_sRace) {
                this.m_sRace = pa_tSaveGame.getPlayerRace();
            }
            if (-1 != (lc_iPos = this.m_tSaveGames.indexOf(pa_tSaveGame))) {
                this.m_tSaveGames.set(lc_iPos, pa_tSaveGame);
            } else {
                this.m_tSaveGames.add(pa_tSaveGame);
                lc_bFreshAdd = true;
            }
        }
        return lc_bFreshAdd;
    }

    public final SkyrimCharacterHelperSaveGame[] getSaveGames() {
        SkyrimCharacterHelperSaveGame[] lc_tArray = null;
        if (null != this.m_tSaveGames) {
            Collections.sort(this.m_tSaveGames, new Comparator<SkyrimCharacterHelperSaveGame>(){

                @Override
                public int compare(SkyrimCharacterHelperSaveGame o1, SkyrimCharacterHelperSaveGame o2) {
                    return m_tCollator.compare(o1.getFileName(), o2.getFileName());
                }
            });
            lc_tArray = new SkyrimCharacterHelperSaveGame[this.m_tSaveGames.size()];
            if (null != lc_tArray) {
                return this.m_tSaveGames.toArray(lc_tArray);
            }
        }
        return null;
    }

    public final List<SkyrimCharacterHelperSaveGame> getSaveGamesList() {
        SkyrimCharacterHelperSaveGame[] lc_tSaveGames = null;
        ArrayList<SkyrimCharacterHelperSaveGame> lc_tList = null;
        lc_tSaveGames = this.getSaveGames();
        if (null != lc_tSaveGames && null != (lc_tList = new ArrayList<SkyrimCharacterHelperSaveGame>())) {
            lc_tList.addAll(Arrays.asList(lc_tSaveGames));
        }
        return lc_tList;
    }

    public final boolean removeSaveGame(SkyrimCharacterHelperSaveGame pa_tSaveGame) {
        if (null != pa_tSaveGame && null != this.m_tSaveGames && null != this.getName() && 0 == m_tCollator.compare(this.getName(), pa_tSaveGame.getPlayerName())) {
            return this.m_tSaveGames.remove(pa_tSaveGame);
        }
        return false;
    }

    public final SkyrimCharacterHelperSaveGame removeSaveGame(String pa_sFileName) {
        boolean lc_bFound = false;
        int lc_iLen = 0;
        SkyrimCharacterHelperSaveGame[] lc_tSaveGames = null;
        SkyrimCharacterHelperSaveGame lc_tSaveGame = null;
        if (null != this.m_tSaveGames && null != pa_sFileName && 0 < (lc_iLen = this.getSaveGameAmount()) && null != (lc_tSaveGames = this.getSaveGames())) {
            for (int lc_iI = 0; !lc_bFound && lc_iI < lc_iLen; ++lc_iI) {
                lc_tSaveGame = lc_tSaveGames[lc_iI];
                if (null == lc_tSaveGame) continue;
                lc_bFound = 0 == m_tCollator.compare(pa_sFileName, lc_tSaveGame.getFileName());
            }
        }
        if (lc_bFound && this.removeSaveGame(lc_tSaveGame)) {
            return lc_tSaveGame;
        }
        return null;
    }

    public final boolean hasSaveGame(SkyrimCharacterHelperSaveGame pa_tSaveGame) {
        return null != this.m_tSaveGames && null != pa_tSaveGame ? this.m_tSaveGames.contains(pa_tSaveGame) : false;
    }

    public final SkyrimCharacterHelperSaveGame hasSaveGame(String pa_sFileName) {
        SkyrimCharacterHelperSaveGame[] lc_tSaveGames = null;
        SkyrimCharacterHelperSaveGame lc_tSaveGame = null;
        int lc_iLen = 0;
        boolean lc_bFound = false;
        lc_tSaveGames = this.getSaveGames();
        if (null != lc_tSaveGames && 0 < (lc_iLen = lc_tSaveGames.length)) {
            for (int lc_iI = 0; !lc_bFound && lc_iI < lc_iLen; ++lc_iI) {
                lc_tSaveGame = lc_tSaveGames[lc_iI];
                if (null == lc_tSaveGame) continue;
                lc_bFound = 0 == m_tCollator.compare(pa_sFileName, lc_tSaveGame.getFileName());
            }
        }
        return true == lc_bFound ? lc_tSaveGame : null;
    }

    @Override
    public int compareTo(SkyrimCharacterHelperPlayer pa_tObject) {
        String lc_sName;
        String string = lc_sName = null != pa_tObject ? pa_tObject.getName() : null;
        if (null == lc_sName) {
            return null == this.getName() ? 0 : 1;
        }
        return null == this.getName() ? -1 : m_tCollator.compare(this.getName(), lc_sName);
    }

    public int hashCode() {
        int lc_iHash = 7;
        lc_iHash = 17 * lc_iHash + Objects.hashCode(this.m_sName);
        return lc_iHash;
    }

    public boolean equals(Object pa_tObject) {
        SkyrimCharacterHelperPlayer lc_tPlayer = null;
        if (this == pa_tObject) {
            return true;
        }
        if (null != pa_tObject && this.getClass() == pa_tObject.getClass() && null != (lc_tPlayer = (SkyrimCharacterHelperPlayer)pa_tObject)) {
            return 0 == m_tCollator.compare(this.getName(), lc_tPlayer.getName());
        }
        return false;
    }

    public String toString() {
        return this.m_sName;
    }
}

