/*
 * Decompiled with CFR 0.152.
 */
package skyrimcharacterhelper;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import skyrimcharacterhelper.SkyrimCharacterHelperApp;
import skyrimcharacterhelper.SkyrimCharacterHelperGuiConnector;
import skyrimcharacterhelper.SkyrimCharacterHelperListCellRenderer;
import skyrimcharacterhelper.SkyrimCharacterHelperListModel;
import skyrimcharacterhelper.SkyrimCharacterHelperPlayer;
import skyrimcharacterhelper.SkyrimCharacterHelperPlayerManager;
import skyrimcharacterhelper.SkyrimCharacterHelperSaveGame;
import skyrimcharacterhelper.SkyrimCharacterHelperScreenshotPanel;
import skyrimcharacterhelper.SkyrimCharacterHelperTableCellRenderer;
import skyrimcharacterhelper.SkyrimCharacterHelperTableModel;
import skyrimcharacterhelper.SkyrimCharacterHelperTextDocument;

public class SkyrimCharacterHelperView
extends JFrame
implements MouseListener,
DocumentListener {
    private SkyrimCharacterHelperGuiConnector m_tGuiConnector;
    private SkyrimCharacterHelperScreenshotPanel m_tActivePaintPanel;
    private SkyrimCharacterHelperScreenshotPanel m_tBackupPaintPanel;
    private Color m_tLabelOnSkyrimActiveBg;
    private Color m_tLabelOnSkyrimNormalBg;
    private Color m_tTextfieldActivePathNormalFg;
    private Color m_tTextfieldBackupPathNormalFg;
    private TableRowSorter<TableModel> m_tRowSorterActiveSaveGames;
    private TableRowSorter<TableModel> m_tRowSorterBackupSaveGames;
    private boolean m_bIsWindowsOs;
    private boolean m_bLocked;
    private boolean m_bLaunched;
    private boolean m_bActiveScanned;
    private boolean m_bBackupScanned;
    private String[] m_tTableColumnHeaders;
    private String[] m_tMonitoringDisplays;
    private ResourceBundle m_tResources = ResourceBundle.getBundle("skyrimcharacterhelper/resources/SkyrimCharacterHelperView");
    private List<SkyrimCharacterHelperSaveGame> m_tStoredActiveSaveGameSelection;
    private List<SkyrimCharacterHelperSaveGame> m_tStoredBackupSaveGameSelection;
    private List<SkyrimCharacterHelperPlayer> m_tStoredActivePlayerSelection;
    private List<SkyrimCharacterHelperPlayer> m_tStoredBackupPlayerSelection;
    private Box.Filler filler21;
    private Box.Filler filler31;
    private JButton jButtonAbout;
    private JButton jButtonActiveCharacterBackup;
    private JButton jButtonActiveCharacterClear;
    private JButton jButtonActiveCharacterDelete;
    private JButton jButtonActiveCharacterLaunch;
    private JButton jButtonActiveClipboard;
    private JButton jButtonActiveLaunchSavegame;
    private JButton jButtonActivePath;
    private JButton jButtonActiveRescan;
    private JButton jButtonActiveSaveGameBackup;
    private JButton jButtonActiveSaveGameDelete;
    private JButton jButtonBackupCharacterClear;
    private JButton jButtonBackupCharacterDelete;
    private JButton jButtonBackupCharacterLaunch;
    private JButton jButtonBackupCharacterRestore;
    private JButton jButtonBackupClipboard;
    private JButton jButtonBackupLaunchSavegame;
    private JButton jButtonBackupPath;
    private JButton jButtonBackupRescan;
    private JButton jButtonBackupSaveGameDelete;
    private JButton jButtonBackupSaveGameRestore;
    private JButton jButtonChooseBinary;
    private JButton jButtonLaunchSolo;
    private JButton jButtonProgressCancel;
    private JButton jButtonProgressExit;
    private JButton jButtonRestoreRegistryPath;
    private JComboBox jComboBoxAutoSaves;
    private JComboBox jComboBoxConfirmation;
    private JComboBox jComboBoxImageMode;
    private JComboBox jComboBoxInitMode;
    private JComboBox jComboBoxMinimize;
    private JComboBox jComboBoxMode;
    private JComboBox jComboBoxOverwrite;
    private JComboBox jComboBoxQuickSaves;
    private JLabel jLabelAutoSaves;
    private JLabel jLabelBinaryPath;
    private JLabel jLabelConfirm;
    private JLabel jLabelImageMode;
    private JLabel jLabelInitMode;
    private JLabel jLabelLaunchOptions;
    private JLabel jLabelLaunchTarget;
    private JLabel jLabelMode;
    private JLabel jLabelOnSkyrim;
    private JLabel jLabelOverwrite;
    private JLabel jLabelPrefix;
    private JLabel jLabelProgressAction;
    private JLabel jLabelProgressCurrent;
    private JLabel jLabelProgressTotal;
    private JLabel jLabelQuickSave;
    private JList jListActiveCharacters;
    private JList jListBackupCharacters;
    private JPanel jPanelActive;
    private JPanel jPanelActiveCharacterData;
    private JPanel jPanelBackup;
    private JPanel jPanelBackupCharacterData;
    private JPanel jPanelControl;
    private JPanel jPanelProgress;
    private JProgressBar jProgressBarCurrent;
    private JProgressBar jProgressBarTotal;
    private JScrollPane jScrollPaneActiveCharacters;
    private JScrollPane jScrollPaneActiveSaveFiles;
    private JScrollPane jScrollPaneBackupCharacters;
    private JScrollPane jScrollPaneBackupSaveFiles;
    private JTable jTableActiveSaveGames;
    private JTable jTableBackupSaveGames;
    private JTextField jTextFieldActivePath;
    private JTextField jTextFieldAmountActive;
    private JTextField jTextFieldAmountBackup;
    private JTextField jTextFieldBackupPath;
    private JTextField jTextFieldBinary;
    private JTextField jTextFieldLaunchOptions;
    private JTextField jTextFieldPrefix;
    private JTextField jTextFieldProgressAction;
    private JTextField jTextFieldRaceActivePlayer;
    private JTextField jTextFieldRaceBackupPlayer;

    public SkyrimCharacterHelperView(SkyrimCharacterHelperGuiConnector pa_tGuiConnector, WindowListener pa_tWindowListener, String[] pa_sComboBoxFileModeValues, String[] pa_sComboBoxYesNo, String[] pa_sComboBoxLaunchMode, String[] pa_sComboBoxImageMode, String[] pa_sComboBoxInitMode, String[] pa_sMonitoringDisplays, String[] pa_tTableHeaders, String pa_sHeaderArrangementActive, String pa_sHeaderArrangementBackup, String pa_sSortOrderActive, String pa_sSortOrderBackup) {
        this.m_tTableColumnHeaders = pa_tTableHeaders;
        this.m_tMonitoringDisplays = pa_sMonitoringDisplays;
        this.m_bIsWindowsOs = false;
        this.m_bLocked = false;
        this.m_bLaunched = false;
        this.m_bBackupScanned = false;
        this.m_bActiveScanned = false;
        this.m_tStoredActiveSaveGameSelection = null;
        this.m_tStoredBackupSaveGameSelection = null;
        this.m_tStoredActivePlayerSelection = null;
        this.m_tStoredBackupPlayerSelection = null;
        this.m_tRowSorterActiveSaveGames = null;
        this.m_tRowSorterBackupSaveGames = null;
        this.pimpMyUi();
        this.initComponents();
        this.pimpMyTables(pa_sHeaderArrangementActive, pa_sHeaderArrangementBackup, pa_sSortOrderActive, pa_sSortOrderBackup);
        this.pimpMyLists();
        this.pimpMyPaintPanels();
        this.pimpMyComboBoxes(pa_sComboBoxFileModeValues, pa_sComboBoxYesNo, pa_sComboBoxLaunchMode, pa_sComboBoxImageMode, pa_sComboBoxInitMode);
        this.pimpMyListeners();
        this.unpimpMyKeys();
        this.jTextFieldPrefix.setDocument(new SkyrimCharacterHelperTextDocument());
        this.jTextFieldPrefix.getDocument().addDocumentListener(this);
        this.m_tLabelOnSkyrimNormalBg = this.jLabelOnSkyrim.getBackground();
        this.m_tLabelOnSkyrimActiveBg = null != this.m_tResources ? new Color(Integer.valueOf(this.m_tResources.getString("jLabelOnSkyrim.bgColorActive"), 16)) : Color.red;
        this.m_tTextfieldActivePathNormalFg = this.jTextFieldActivePath.getForeground();
        this.m_tTextfieldBackupPathNormalFg = this.jTextFieldBackupPath.getForeground();
        this.m_tGuiConnector = pa_tGuiConnector;
        this.addWindowListener(pa_tWindowListener);
        this.m_bIsWindowsOs = this.checkForWindows();
    }

    private void pimpMyUi() {
        if (null != this.m_tResources) {
            try {
                UIManager.put("ProgressBar.background", new Color(Integer.valueOf(this.m_tResources.getString("jProgressBar.background"), 16)));
                UIManager.put("ProgressBar.foreground", new Color(Integer.valueOf(this.m_tResources.getString("jProgressBar.foreground"), 16)));
                UIManager.put("ProgressBar.selectionBackground", new Color(Integer.valueOf(this.m_tResources.getString("jProgressBar.selectionBackground"), 16)));
                UIManager.put("ProgressBar.selectionForeground", new Color(Integer.valueOf(this.m_tResources.getString("jProgressBar.selectionForeground"), 16)));
                UIManager.put("ComboBox.selectionBackground", new Color(Integer.valueOf(this.m_tResources.getString("jComboBox.dropDownList.selectionBackground"), 16)));
                UIManager.put("ComboBox.selectionForeground", new Color(Integer.valueOf(this.m_tResources.getString("jComboBox.dropDownList.selectionForeground"), 16)));
                UIManager.put("FileChooser.cancelButtonText", this.m_tResources.getString("jFileChooser.cancelText"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void unpimpMyKeys() {
        this.removeArrowKeysFromTable(this.jTableActiveSaveGames);
        this.removeArrowKeysFromTable(this.jTableBackupSaveGames);
        this.removeArrowKeysFromList(this.jListActiveCharacters);
        this.removeArrowKeysFromList(this.jListBackupCharacters);
    }

    private void pimpMyListeners() {
        this.jTableActiveSaveGames.addMouseListener(this);
        this.jTableBackupSaveGames.addMouseListener(this);
        this.jTableActiveSaveGames.getTableHeader().addMouseListener(this);
        this.jTableBackupSaveGames.getTableHeader().addMouseListener(this);
        this.jListActiveCharacters.addMouseListener(this);
        this.jListBackupCharacters.addMouseListener(this);
    }

    private void pimpMyPaintPanels() {
        this.m_tActivePaintPanel = new SkyrimCharacterHelperScreenshotPanel(this.jPanelActiveCharacterData, this.m_tResources);
        if (null != this.m_tActivePaintPanel) {
            this.jPanelActiveCharacterData.setLayout(new GridLayout(1, 1));
            this.jPanelActiveCharacterData.add(this.m_tActivePaintPanel);
        }
        if (null != (this.m_tBackupPaintPanel = new SkyrimCharacterHelperScreenshotPanel(this.jPanelBackupCharacterData, this.m_tResources))) {
            this.jPanelBackupCharacterData.setLayout(new GridLayout(1, 1));
            this.jPanelBackupCharacterData.add(this.m_tBackupPaintPanel);
        }
    }

    private void pimpMyLists() {
        this.jListActiveCharacters.setCellRenderer(new SkyrimCharacterHelperListCellRenderer());
        this.jListActiveCharacters.setModel(new SkyrimCharacterHelperListModel());
        this.jListBackupCharacters.setCellRenderer(new SkyrimCharacterHelperListCellRenderer());
        this.jListBackupCharacters.setModel(new SkyrimCharacterHelperListModel());
    }

    private void pimpMyComboBoxes(String[] pa_sComboBoxFileModeValues, String[] pa_sComboBoxYesNo, String[] pa_sComboBoxLaunchMode, String[] pa_sComboBoxImageMode, String[] pa_sComboBoxInitMode) {
        if (null != pa_sComboBoxLaunchMode) {
            for (String lc_sValue : pa_sComboBoxLaunchMode) {
                this.jComboBoxMinimize.addItem(lc_sValue);
            }
        }
        if (null != pa_sComboBoxFileModeValues) {
            for (String lc_sValue : pa_sComboBoxFileModeValues) {
                this.jComboBoxMode.addItem(lc_sValue);
            }
        }
        if (null != pa_sComboBoxImageMode) {
            for (String lc_sValue : pa_sComboBoxImageMode) {
                this.jComboBoxImageMode.addItem(lc_sValue);
            }
        }
        if (null != pa_sComboBoxInitMode) {
            for (String lc_sValue : pa_sComboBoxInitMode) {
                this.jComboBoxInitMode.addItem(lc_sValue);
            }
        }
        if (null != pa_sComboBoxYesNo) {
            for (String lc_sValue : pa_sComboBoxYesNo) {
                this.jComboBoxConfirmation.addItem(lc_sValue);
                this.jComboBoxOverwrite.addItem(lc_sValue);
                this.jComboBoxAutoSaves.addItem(lc_sValue);
                this.jComboBoxQuickSaves.addItem(lc_sValue);
            }
        }
        this.jComboBoxMode.setSelectedIndex(0);
        this.jComboBoxAutoSaves.setSelectedIndex(0);
        this.jComboBoxQuickSaves.setSelectedIndex(0);
        this.jComboBoxConfirmation.setSelectedIndex(0);
        this.jComboBoxOverwrite.setSelectedIndex(0);
        this.jComboBoxImageMode.setSelectedIndex(0);
        this.jComboBoxMinimize.setSelectedIndex(1);
        this.jComboBoxInitMode.setSelectedIndex(0);
    }

    private void pimpMyTables(String pa_sHeaderArrangementActive, String pa_sHeaderArrangementBackup, String pa_sSortOrderActive, String pa_sSortOrderBackup) {
        SkyrimCharacterHelperTableModel lc_tTableModel1 = null;
        SkyrimCharacterHelperTableModel lc_tTableModel2 = null;
        TableColumnModel lc_tColumnModel = null;
        TableColumn lc_tColumn = null;
        String lc_sHeaderArrangementActiveSaveGames = this.checkHeaderArrangement(pa_sHeaderArrangementActive);
        String lc_sHeaderArrangementBackupSaveGames = this.checkHeaderArrangement(pa_sHeaderArrangementBackup);
        String lc_sSortOrderActive = this.checkSortOrder(pa_sSortOrderActive);
        String lc_sSortOrderBackup = this.checkSortOrder(pa_sSortOrderBackup);
        int lc_iCount = 0;
        int lc_iNewColumn = 0;
        int[] lc_iHeaderActive = new int[4];
        int[] lc_iHeaderBackup = new int[4];
        lc_iHeaderActive[0] = Character.digit(lc_sHeaderArrangementActiveSaveGames.charAt(0), 10);
        lc_iHeaderActive[1] = Character.digit(lc_sHeaderArrangementActiveSaveGames.charAt(1), 10);
        lc_iHeaderActive[2] = Character.digit(lc_sHeaderArrangementActiveSaveGames.charAt(2), 10);
        lc_iHeaderActive[3] = Character.digit(lc_sHeaderArrangementActiveSaveGames.charAt(3), 10);
        lc_tTableModel1 = new SkyrimCharacterHelperTableModel(this.m_tTableColumnHeaders);
        if (null != lc_tTableModel1) {
            this.jTableActiveSaveGames.setModel(lc_tTableModel1);
            this.jTableActiveSaveGames.createDefaultColumnsFromModel();
            this.jTableActiveSaveGames.setAutoCreateRowSorter(false);
            this.jTableActiveSaveGames.setDefaultRenderer(SkyrimCharacterHelperSaveGame.class, new SkyrimCharacterHelperTableCellRenderer());
            this.m_tRowSorterActiveSaveGames = new TableRowSorter<TableModel>(this.jTableActiveSaveGames.getModel());
            if (null != this.m_tRowSorterActiveSaveGames) {
                lc_tColumnModel = this.jTableActiveSaveGames.getColumnModel();
                if (null != lc_tColumnModel) {
                    for (lc_iCount = 0; lc_iCount < 4; ++lc_iCount) {
                        lc_tColumn = lc_tColumnModel.getColumn(lc_iCount);
                        if (null == lc_tColumn) continue;
                        lc_iNewColumn = lc_iHeaderActive[lc_iCount];
                        lc_tColumn.setModelIndex(lc_iNewColumn);
                        lc_tColumn.setHeaderValue(this.m_tTableColumnHeaders[lc_iNewColumn]);
                        this.m_tRowSorterActiveSaveGames.setComparator(lc_iNewColumn, new SaveGameComparator(lc_iNewColumn));
                    }
                }
                this.m_tRowSorterActiveSaveGames.setSortsOnUpdates(true);
                this.jTableActiveSaveGames.getTableHeader().resizeAndRepaint();
                this.jTableActiveSaveGames.setRowSorter(this.m_tRowSorterActiveSaveGames);
                this.setSortOrder(this.m_tRowSorterActiveSaveGames, lc_sSortOrderActive, this.jTableActiveSaveGames);
            }
        }
        lc_iHeaderBackup[0] = Character.digit(lc_sHeaderArrangementBackupSaveGames.charAt(0), 10);
        lc_iHeaderBackup[1] = Character.digit(lc_sHeaderArrangementBackupSaveGames.charAt(1), 10);
        lc_iHeaderBackup[2] = Character.digit(lc_sHeaderArrangementBackupSaveGames.charAt(2), 10);
        lc_iHeaderBackup[3] = Character.digit(lc_sHeaderArrangementBackupSaveGames.charAt(3), 10);
        lc_tTableModel2 = new SkyrimCharacterHelperTableModel(this.m_tTableColumnHeaders);
        if (null != lc_tTableModel2) {
            this.jTableBackupSaveGames.setModel(lc_tTableModel2);
            this.jTableBackupSaveGames.createDefaultColumnsFromModel();
            this.jTableBackupSaveGames.setAutoCreateRowSorter(false);
            this.jTableBackupSaveGames.setDefaultRenderer(SkyrimCharacterHelperSaveGame.class, new SkyrimCharacterHelperTableCellRenderer());
            this.m_tRowSorterBackupSaveGames = new TableRowSorter<TableModel>(this.jTableBackupSaveGames.getModel());
            if (null != this.m_tRowSorterBackupSaveGames) {
                lc_tColumnModel = this.jTableBackupSaveGames.getColumnModel();
                if (null != lc_tColumnModel) {
                    for (lc_iCount = 0; lc_iCount < 4; ++lc_iCount) {
                        lc_tColumn = lc_tColumnModel.getColumn(lc_iCount);
                        if (null == lc_tColumn) continue;
                        lc_iNewColumn = lc_iHeaderBackup[lc_iCount];
                        lc_tColumn.setModelIndex(lc_iNewColumn);
                        lc_tColumn.setHeaderValue(this.m_tTableColumnHeaders[lc_iNewColumn]);
                        this.m_tRowSorterBackupSaveGames.setComparator(lc_iNewColumn, new SaveGameComparator(lc_iNewColumn));
                    }
                }
                this.m_tRowSorterBackupSaveGames.setSortsOnUpdates(true);
                this.jTableBackupSaveGames.getTableHeader().resizeAndRepaint();
                this.jTableBackupSaveGames.setRowSorter(this.m_tRowSorterBackupSaveGames);
                this.setSortOrder(this.m_tRowSorterBackupSaveGames, lc_sSortOrderBackup, this.jTableBackupSaveGames);
            }
        }
    }

    public final void setLaunched(boolean pa_bValue) {
        this.m_bLaunched = pa_bValue;
    }

    public final void setActiveScanned(boolean pa_bValue) {
        this.m_bActiveScanned = pa_bValue;
        this.jTextFieldActivePath.setForeground(true == pa_bValue ? this.m_tTextfieldActivePathNormalFg : Color.red);
    }

    public final void setBackupScanned(boolean pa_bValue) {
        this.m_bBackupScanned = pa_bValue;
        this.jTextFieldBackupPath.setForeground(true == pa_bValue ? this.m_tTextfieldBackupPathNormalFg : Color.red);
    }

    public final void setUILockMode(boolean pa_bLock, boolean pa_bAtomic) {
        this.m_bLocked = pa_bLock;
        this.jButtonProgressCancel.setEnabled(pa_bLock && !pa_bAtomic);
        this.jButtonProgressExit.setEnabled(!pa_bLock && false == this.m_bLaunched);
        this.updateUIElements();
    }

    public final void updateUIElements() {
        boolean lc_bHasOneActiveCharacter = 1 == this.getListSize(this.jListActiveCharacters);
        boolean lc_bHasOneActiveSavegame = 1 == this.getTableSize(this.jTableActiveSaveGames);
        boolean lc_bHasActiveCharacters = 0 < this.getListSize(this.jListActiveCharacters);
        boolean lc_bHasActiveSaveGames = 0 < this.getTableSize(this.jTableActiveSaveGames);
        boolean lc_bHasBackupCharacters = 0 < this.getListSize(this.jListBackupCharacters);
        boolean lc_bHasBackupSaveGames = 0 < this.getTableSize(this.jTableBackupSaveGames);
        boolean lc_bHasActiveImage = null != this.m_tActivePaintPanel.getImage();
        boolean lc_bHasBackupImage = null != this.m_tBackupPaintPanel.getImage();
        boolean lc_bHasActiveCharacterSelection = null != this.getSelectedActivePlayers();
        boolean lc_bHasActiveSaveGameSelection = null != this.getSelectedActiveSaveGames();
        boolean lc_bHasBackupCharacterSelection = null != this.getSelectedBackupPlayers();
        boolean lc_bHasBackupSaveGameSelection = null != this.getSelectedBackupSaveGames();
        boolean lc_b0 = false == this.m_bLocked && false == this.m_bLaunched;
        boolean lc_b1 = true == this.m_bIsWindowsOs;
        boolean lc_b2 = true == lc_b0 && true == lc_bHasActiveCharacters && true == lc_bHasActiveCharacterSelection;
        boolean lc_b3 = true == lc_b0 && true == lc_bHasActiveSaveGames && true == lc_bHasActiveSaveGameSelection;
        boolean lc_b4 = true == lc_b0 && true == lc_bHasBackupCharacters && true == lc_bHasBackupCharacterSelection;
        boolean lc_b5 = true == lc_b0 && true == lc_bHasBackupSaveGames && true == lc_bHasBackupSaveGameSelection;
        boolean lc_b6 = true == this.checkString(this.getActivePath());
        boolean lc_b7 = true == this.checkString(this.getBackupPath());
        boolean lc_b8 = true == this.checkString(this.getLaunchBinary());
        boolean lc_b9 = true == this.checkString(this.getPrefix());
        boolean lc_bLaunch = false;
        this.jComboBoxMode.setEnabled(lc_b0);
        this.jComboBoxConfirmation.setEnabled(lc_b0);
        this.jComboBoxOverwrite.setEnabled(lc_b0);
        this.jComboBoxMinimize.setEnabled(lc_b0);
        this.jComboBoxImageMode.setEnabled(lc_b0);
        this.jComboBoxAutoSaves.setEnabled(lc_b0 && lc_b8 && lc_b9);
        this.jComboBoxQuickSaves.setEnabled(lc_b0 && lc_b8 && lc_b9);
        this.jComboBoxInitMode.setEnabled(lc_b0);
        this.jListActiveCharacters.setEnabled(lc_b0 && this.m_bActiveScanned);
        this.jListBackupCharacters.setEnabled(lc_b0 && this.m_bBackupScanned);
        this.jTableActiveSaveGames.setEnabled(lc_b0 && this.m_bActiveScanned);
        this.jTableBackupSaveGames.setEnabled(lc_b0 && this.m_bBackupScanned);
        this.jTableActiveSaveGames.getTableHeader().setEnabled(lc_b0 && this.m_bActiveScanned);
        this.jTableBackupSaveGames.getTableHeader().setEnabled(lc_b0 && this.m_bBackupScanned);
        this.jTextFieldPrefix.setEnabled(lc_b0);
        this.jTextFieldLaunchOptions.setEnabled(lc_b0);
        this.jButtonAbout.setEnabled(lc_b0);
        this.jButtonChooseBinary.setEnabled(lc_b0);
        this.jButtonRestoreRegistryPath.setEnabled(lc_b0 && lc_b1);
        this.jButtonLaunchSolo.setEnabled(lc_b0 && lc_b1 && lc_b8 && lc_b9);
        this.jButtonActiveCharacterBackup.setEnabled(lc_b0 && lc_b2 && lc_b6 && lc_b7 && this.m_bActiveScanned && this.m_bBackupScanned);
        this.jButtonActiveCharacterDelete.setEnabled(lc_b0 && lc_b2 && this.m_bActiveScanned);
        this.jButtonActiveCharacterClear.setEnabled(lc_b0 && lc_bHasActiveCharacters && this.m_bActiveScanned);
        boolean bl = lc_bLaunch = lc_b0 && lc_b1 && lc_b2 && lc_b6 && lc_b8 && lc_b9 && !this.hasListMultiSelectionActivePlayers() && this.m_bActiveScanned;
        if (!lc_bHasOneActiveCharacter) {
            lc_bLaunch &= lc_b7 && this.m_bBackupScanned;
        }
        this.jButtonActiveCharacterLaunch.setEnabled(lc_bLaunch);
        this.jButtonActiveSaveGameBackup.setEnabled(lc_b0 && lc_b3 && lc_b6 && lc_b7 && this.m_bBackupScanned && this.m_bActiveScanned);
        this.jButtonActiveSaveGameDelete.setEnabled(lc_b0 && lc_b3 && this.m_bActiveScanned);
        this.jButtonActiveClipboard.setEnabled(lc_b0 && lc_bHasActiveImage && this.m_bActiveScanned);
        this.jButtonActiveLaunchSavegame.setEnabled(lc_b0 && lc_b3 && !this.hasListMultiSelectionActiveSaveGames() && this.m_bActiveScanned && (true == lc_bHasOneActiveSavegame || lc_b7 && this.m_bBackupScanned));
        this.jButtonActivePath.setEnabled(lc_b0);
        this.jButtonActiveRescan.setEnabled(lc_b0 && lc_b6);
        this.jButtonBackupCharacterRestore.setEnabled(lc_b0 && lc_b4 && lc_b6 && lc_b7 && this.m_bBackupScanned && this.m_bActiveScanned);
        this.jButtonBackupCharacterDelete.setEnabled(lc_b0 && lc_b4 && this.m_bBackupScanned);
        this.jButtonBackupCharacterClear.setEnabled(lc_b0 && lc_bHasBackupCharacters && this.m_bBackupScanned);
        this.jButtonBackupCharacterLaunch.setEnabled(lc_b0 && lc_b1 && lc_b4 && lc_b6 && lc_b7 && lc_b8 && lc_b9 && !this.hasListMultiSelectionBackupPlayers() && this.m_bBackupScanned && this.m_bActiveScanned);
        this.jButtonBackupSaveGameRestore.setEnabled(lc_b0 && lc_b5 && lc_b6 && lc_b7 && this.m_bBackupScanned && this.m_bActiveScanned);
        this.jButtonBackupSaveGameDelete.setEnabled(lc_b0 && lc_b5);
        this.jButtonBackupClipboard.setEnabled(lc_b0 && lc_bHasBackupImage);
        this.jButtonBackupLaunchSavegame.setEnabled(lc_b0 && lc_b5 && !this.hasListMultiSelectionBackupSaveGames() && this.m_bBackupScanned && this.m_bActiveScanned);
        this.jButtonBackupPath.setEnabled(lc_b0);
        this.jButtonBackupRescan.setEnabled(lc_b0 && lc_b7);
    }

    public final boolean hasEqualDirectories() {
        String lc_sSourceDir = this.getActivePath();
        String lc_sDestinationDir = this.getBackupPath();
        boolean lc_bEquals = false;
        if (this.checkString(lc_sSourceDir) && this.checkString(lc_sDestinationDir) && lc_sSourceDir.equals(lc_sDestinationDir)) {
            lc_bEquals = true;
        }
        return lc_bEquals;
    }

    public final synchronized void initPlayerList(SkyrimCharacterHelperPlayerManager pa_tManager, boolean pa_bMode) {
        SkyrimCharacterHelperPlayer lc_tFirstSelectedPlayer = null;
        Object[] lc_tData = null;
        List<SkyrimCharacterHelperPlayer> lc_tOldSelection = true == pa_bMode ? this.m_tStoredActivePlayerSelection : this.m_tStoredBackupPlayerSelection;
        JList lc_tList = true == pa_bMode ? this.jListActiveCharacters : this.jListBackupCharacters;
        SkyrimCharacterHelperListModel lc_tModel = null != lc_tList ? (SkyrimCharacterHelperListModel)lc_tList.getModel() : null;
        boolean lc_bMultiSelection = false;
        boolean lc_bUpdated = false;
        if (null != lc_tModel && null != lc_tList) {
            lc_tList.getSelectionModel().clearSelection();
            lc_tModel.clear();
            if (null != pa_tManager && null != (lc_tData = pa_tManager.getPlayers()) && 0 < lc_tData.length) {
                lc_tModel.addAll(lc_tData);
                if (null != lc_tOldSelection) {
                    this.reselectPlayers(lc_tOldSelection, pa_bMode);
                    lc_tFirstSelectedPlayer = true == pa_bMode ? this.getFirstSelectedActivePlayer() : this.getFirstSelectedBackupPlayer();
                    boolean bl = lc_bMultiSelection = 1 < lc_tOldSelection.size();
                    if (null != lc_tFirstSelectedPlayer && !lc_bMultiSelection) {
                        this.initSaveGameList(lc_tFirstSelectedPlayer.getSaveGames(), pa_bMode, true);
                        lc_bUpdated = true;
                    }
                }
            }
        }
        if (null != pa_tManager) {
            if (!lc_bMultiSelection) {
                if (null != lc_tFirstSelectedPlayer) {
                    if (pa_bMode) {
                        this.setActivePlayerRace(lc_tFirstSelectedPlayer.getRace());
                        this.setAmountActive(pa_tManager, lc_tFirstSelectedPlayer.getSaveGameAmount());
                    } else {
                        this.setBackupPlayerRace(lc_tFirstSelectedPlayer.getRace());
                        this.setAmountBackup(pa_tManager, lc_tFirstSelectedPlayer.getSaveGameAmount());
                    }
                }
            } else if (pa_bMode) {
                this.setActivePlayerRace(null);
                this.setAmountActive(pa_tManager, pa_tManager.getSaveGameAmountForList(this.getSelectedActivePlayers()));
            } else {
                this.setBackupPlayerRace(null);
                this.setAmountBackup(pa_tManager, pa_tManager.getSaveGameAmountForList(this.getSelectedBackupPlayers()));
            }
        }
        if (!lc_bUpdated) {
            this.updateUIElements();
        }
    }

    public final synchronized void initSaveGameList(SkyrimCharacterHelperSaveGame[] pa_tData, boolean pa_bMode, boolean pa_bUseStoredSelection) {
        final SkyrimCharacterHelperSaveGame[] lc_tFData = pa_tData;
        final boolean lc_bMode = pa_bMode;
        final boolean lc_bUseStoredSelection = pa_bUseStoredSelection;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                List<SkyrimCharacterHelperSaveGame> lc_tOldSelection;
                SkyrimCharacterHelperSaveGame lc_tSaveGame = null;
                SkyrimCharacterHelperSaveGame[] lc_tData = lc_tFData;
                BufferedImage lc_tImage = null;
                JTable lc_tTable = true == lc_bMode ? SkyrimCharacterHelperView.this.jTableActiveSaveGames : SkyrimCharacterHelperView.this.jTableBackupSaveGames;
                SkyrimCharacterHelperTableModel lc_tModel = (SkyrimCharacterHelperTableModel)lc_tTable.getModel();
                List<SkyrimCharacterHelperSaveGame> list = lc_bMode ? (lc_bUseStoredSelection ? SkyrimCharacterHelperView.this.m_tStoredActiveSaveGameSelection : SkyrimCharacterHelperView.this.getSelectedActiveSaveGames()) : (lc_tOldSelection = true == lc_bUseStoredSelection ? SkyrimCharacterHelperView.this.m_tStoredBackupSaveGameSelection : SkyrimCharacterHelperView.this.getSelectedBackupSaveGames());
                if (lc_bMode) {
                    SkyrimCharacterHelperView.this.setActiveSaveGameScreenshot(null);
                } else {
                    SkyrimCharacterHelperView.this.setBackupSaveGameScreenshot(null);
                }
                if (null != lc_tModel && null != lc_tTable && null != lc_tData) {
                    List lc_tSortKeys = SkyrimCharacterHelperView.this.disableTableRowSorter(true == lc_bMode ? SkyrimCharacterHelperView.this.jTableActiveSaveGames : SkyrimCharacterHelperView.this.jTableBackupSaveGames);
                    lc_tModel.clear();
                    lc_tTable.getSelectionModel().clearSelection();
                    if (0 < lc_tData.length) {
                        lc_tModel.addAll(lc_tData);
                        if (null != lc_tOldSelection) {
                            SkyrimCharacterHelperView.this.reselectSaveGames(lc_tOldSelection, lc_bMode, false);
                            SkyrimCharacterHelperSaveGame skyrimCharacterHelperSaveGame = lc_tSaveGame = true == lc_bMode ? SkyrimCharacterHelperView.this.getFirstSelectedActiveSaveGame() : SkyrimCharacterHelperView.this.getFirstSelectedBackupSaveGame();
                            if (null != lc_tSaveGame && 1 == lc_tTable.getSelectedRowCount() && null != lc_tSaveGame.getScreenshot()) {
                                lc_tImage = lc_tSaveGame.getScreenshot().getImage();
                            }
                        }
                    }
                    if (lc_bMode) {
                        SkyrimCharacterHelperView.this.setActiveSaveGameScreenshot(lc_tImage);
                    } else {
                        SkyrimCharacterHelperView.this.setBackupSaveGameScreenshot(lc_tImage);
                    }
                    SkyrimCharacterHelperView.this.enableTableRowSorter(true == lc_bMode ? SkyrimCharacterHelperView.this.jTableActiveSaveGames : SkyrimCharacterHelperView.this.jTableBackupSaveGames, lc_tSortKeys);
                    SkyrimCharacterHelperView.this.updateUIElements();
                }
            }
        });
    }

    private synchronized void reselectSaveGames(List<SkyrimCharacterHelperSaveGame> pa_tOldSelection, boolean pa_bMode, boolean pa_bNotify) {
        int lc_iLastIndex = -1;
        int lc_iModelIndex = -1;
        int lc_iViewIndex = -1;
        int lc_iNewSelectionSize = 0;
        SkyrimCharacterHelperSaveGame lc_tSaveGame = null;
        SkyrimCharacterHelperSaveGame lc_tSelectedSaveGame = null;
        BufferedImage lc_tImage = null;
        JTable lc_tTable = true == pa_bMode ? this.jTableActiveSaveGames : this.jTableBackupSaveGames;
        SkyrimCharacterHelperTableModel lc_tModel = (SkyrimCharacterHelperTableModel)lc_tTable.getModel();
        if (null != pa_tOldSelection && null != lc_tModel && null != lc_tTable && 0 < pa_tOldSelection.size()) {
            lc_tTable.getSelectionModel().clearSelection();
            for (SkyrimCharacterHelperSaveGame lc_tObject : pa_tOldSelection) {
                if (null == lc_tObject || !(lc_tObject instanceof SkyrimCharacterHelperSaveGame) || null == (lc_tSaveGame = lc_tObject) || -1 == (lc_iModelIndex = lc_tModel.indexOf(lc_tSaveGame)) || -1 == (lc_iViewIndex = lc_tTable.convertRowIndexToView(lc_iModelIndex))) continue;
                lc_iLastIndex = lc_iViewIndex;
                lc_tTable.addRowSelectionInterval(lc_iViewIndex, lc_iViewIndex);
                ++lc_iNewSelectionSize;
            }
            if (-1 != lc_iLastIndex) {
                lc_tTable.scrollRectToVisible(new Rectangle(lc_tTable.getCellRect(lc_iLastIndex, 0, true)));
            }
            if (1 == lc_iNewSelectionSize && null != (lc_tSelectedSaveGame = true == pa_bMode ? this.getFirstSelectedActiveSaveGame() : this.getFirstSelectedBackupSaveGame()) && null != lc_tSelectedSaveGame.getScreenshot()) {
                lc_tImage = lc_tSelectedSaveGame.getScreenshot().getImage();
            }
        }
        if (pa_bMode) {
            this.setActiveSaveGameScreenshot(lc_tImage);
        } else {
            this.setBackupSaveGameScreenshot(lc_tImage);
        }
    }

    public final synchronized void reselectPlayers(List<SkyrimCharacterHelperPlayer> pa_tOldSelection, boolean pa_bMode) {
        SkyrimCharacterHelperListModel lc_tModel;
        Object[] lc_tEntries = null;
        int lc_iIndex = 0;
        int lc_iLastIndex = 0;
        SkyrimCharacterHelperPlayer lc_tPlayer = null;
        JList lc_tList = false == pa_bMode ? this.jListBackupCharacters : this.jListActiveCharacters;
        ArrayList<Integer> lc_tPositionList = new ArrayList<Integer>();
        SkyrimCharacterHelperListModel skyrimCharacterHelperListModel = lc_tModel = null != lc_tList ? (SkyrimCharacterHelperListModel)lc_tList.getModel() : null;
        if (null != pa_tOldSelection && null != lc_tModel && null != lc_tList && null != lc_tPositionList && 0 < pa_tOldSelection.size() && null != (lc_tEntries = lc_tModel.elements()) && 0 < lc_tEntries.length) {
            lc_tList.getSelectionModel().clearSelection();
            for (Object lc_tObject : lc_tEntries) {
                if (lc_tObject instanceof SkyrimCharacterHelperPlayer && null != (lc_tPlayer = (SkyrimCharacterHelperPlayer)lc_tObject)) {
                    for (SkyrimCharacterHelperPlayer lc_tSelectionPlayer : pa_tOldSelection) {
                        if (null == lc_tSelectionPlayer || !lc_tSelectionPlayer.getName().equals(lc_tPlayer.getName())) continue;
                        lc_tPositionList.add(lc_iIndex);
                        lc_iLastIndex = lc_iIndex;
                    }
                }
                ++lc_iIndex;
            }
            if (0 < lc_tPositionList.size()) {
                this.setSelectedIndices(lc_tList, lc_tPositionList);
                lc_tList.ensureIndexIsVisible(lc_iLastIndex);
            }
        }
    }

    private void setSelectedIndices(JList pa_tList, List<Integer> pa_tPositionList) {
        int[] lc_tIncidices = null;
        int lc_iIndex = 0;
        if (null != pa_tList && null != pa_tPositionList && 0 < pa_tPositionList.size() && null != (lc_tIncidices = new int[pa_tPositionList.size()])) {
            for (Integer lc_tInteger : pa_tPositionList) {
                lc_tIncidices[lc_iIndex] = lc_tInteger;
                ++lc_iIndex;
            }
            pa_tList.setSelectedIndices(lc_tIncidices);
        }
    }

    public final void addActivePlayer(SkyrimCharacterHelperPlayer pa_tPlayer) {
        SkyrimCharacterHelperListModel lc_tModel = (SkyrimCharacterHelperListModel)this.jListActiveCharacters.getModel();
        if (null != lc_tModel && null != pa_tPlayer) {
            lc_tModel.add(pa_tPlayer);
        }
    }

    public final void addBackupPlayer(SkyrimCharacterHelperPlayer pa_tPlayer) {
        SkyrimCharacterHelperListModel lc_tModel = (SkyrimCharacterHelperListModel)this.jListBackupCharacters.getModel();
        if (null != lc_tModel && null != pa_tPlayer) {
            lc_tModel.add(pa_tPlayer);
        }
    }

    public final synchronized void addActiveSaveGame(SkyrimCharacterHelperSaveGame pa_tSaveGame, boolean pa_bSelect) {
        final SkyrimCharacterHelperSaveGame lc_tSaveGame = pa_tSaveGame;
        final boolean lc_bSelect = pa_bSelect;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SkyrimCharacterHelperTableModel lc_tModel = (SkyrimCharacterHelperTableModel)SkyrimCharacterHelperView.this.jTableActiveSaveGames.getModel();
                int lc_iModelIndex = -1;
                int lc_iViewIndex = -1;
                if (null != lc_tModel && null != lc_tSaveGame && -1 != (lc_iModelIndex = lc_tModel.add(lc_tSaveGame)) && lc_bSelect && -1 != (lc_iViewIndex = SkyrimCharacterHelperView.this.jTableActiveSaveGames.convertRowIndexToView(lc_iModelIndex))) {
                    SkyrimCharacterHelperView.this.jTableActiveSaveGames.getSelectionModel().clearSelection();
                    SkyrimCharacterHelperView.this.jTableActiveSaveGames.setRowSelectionInterval(lc_iViewIndex, lc_iViewIndex);
                    SkyrimCharacterHelperView.this.jTableActiveSaveGames.scrollRectToVisible(new Rectangle(SkyrimCharacterHelperView.this.jTableActiveSaveGames.getCellRect(lc_iViewIndex, 0, true)));
                    if (null != SkyrimCharacterHelperView.this.m_tGuiConnector) {
                        SkyrimCharacterHelperView.this.m_tGuiConnector.handleListSelectionActiveSaveGames();
                    }
                }
            }
        });
    }

    public final synchronized void addBackupSaveGame(SkyrimCharacterHelperSaveGame pa_tSaveGame, boolean pa_bSelect) {
        final SkyrimCharacterHelperSaveGame lc_tSaveGame = pa_tSaveGame;
        final boolean lc_bSelect = pa_bSelect;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SkyrimCharacterHelperTableModel lc_tModel = (SkyrimCharacterHelperTableModel)SkyrimCharacterHelperView.this.jTableBackupSaveGames.getModel();
                int lc_iModelIndex = -1;
                int lc_iViewIndex = -1;
                if (null != lc_tModel && null != lc_tSaveGame && -1 != (lc_iModelIndex = lc_tModel.add(lc_tSaveGame)) && lc_bSelect && -1 != (lc_iViewIndex = SkyrimCharacterHelperView.this.jTableBackupSaveGames.convertRowIndexToView(lc_iModelIndex))) {
                    SkyrimCharacterHelperView.this.jTableBackupSaveGames.getSelectionModel().clearSelection();
                    SkyrimCharacterHelperView.this.jTableBackupSaveGames.setRowSelectionInterval(lc_iViewIndex, lc_iViewIndex);
                    SkyrimCharacterHelperView.this.jTableBackupSaveGames.scrollRectToVisible(new Rectangle(SkyrimCharacterHelperView.this.jTableBackupSaveGames.getCellRect(lc_iViewIndex, 0, true)));
                    if (null != SkyrimCharacterHelperView.this.m_tGuiConnector) {
                        SkyrimCharacterHelperView.this.m_tGuiConnector.handleListSelectionBackupSaveGames();
                    }
                }
            }
        });
    }

    public final int getQuickSaveMode() {
        return this.jComboBoxQuickSaves.getSelectedIndex();
    }

    public final void setQuickSaveMode(int pa_iMode) {
        if (pa_iMode == 0 || pa_iMode == 1) {
            this.jComboBoxQuickSaves.setSelectedIndex(pa_iMode);
        }
    }

    public final int getAutoSaveMode() {
        return this.jComboBoxAutoSaves.getSelectedIndex();
    }

    public final void setAutoSaveMode(int pa_iMode) {
        if (pa_iMode == 0 || pa_iMode == 1) {
            this.jComboBoxAutoSaves.setSelectedIndex(pa_iMode);
        }
    }

    public final int getMinimizeMode() {
        return this.jComboBoxMinimize.getSelectedIndex();
    }

    public final void setMinimizeMode(int pa_iMode) {
        if (pa_iMode == 0 || pa_iMode == 1) {
            this.jComboBoxMinimize.setSelectedIndex(pa_iMode);
        }
    }

    public final int getInitMode() {
        return this.jComboBoxInitMode.getSelectedIndex();
    }

    public final void setInitMode(int pa_iMode) {
        if (pa_iMode == 0 || pa_iMode == 1) {
            this.jComboBoxInitMode.setSelectedIndex(pa_iMode);
        }
    }

    public final int getFileMode() {
        return this.jComboBoxMode.getSelectedIndex();
    }

    public final void setFileMode(int pa_iMode) {
        if (pa_iMode == 0 || pa_iMode == 1) {
            this.jComboBoxMode.setSelectedIndex(pa_iMode);
        }
    }

    public final int getOverwriteMode() {
        return this.jComboBoxOverwrite.getSelectedIndex();
    }

    public final void setOverwriteMode(int pa_iMode) {
        if (pa_iMode == 0 || pa_iMode == 1) {
            this.jComboBoxOverwrite.setSelectedIndex(pa_iMode);
        }
    }

    public final int getConfirmationMode() {
        return this.jComboBoxConfirmation.getSelectedIndex();
    }

    public final void setConfirmationMode(int pa_iMode) {
        if (pa_iMode == 0 || pa_iMode == 1) {
            this.jComboBoxConfirmation.setSelectedIndex(pa_iMode);
        }
    }

    public final int getImageMode() {
        return this.jComboBoxImageMode.getSelectedIndex();
    }

    public final void setImageMode(int pa_iMode) {
        if (pa_iMode == 0 || pa_iMode == 1) {
            this.jComboBoxImageMode.setSelectedIndex(pa_iMode);
            this.setImageModeDisplay(pa_iMode == 0);
        }
    }

    public final int getAmountActivePlayers() {
        return this.getListSize(this.jListActiveCharacters);
    }

    public final int getAmountActiveSaveGames() {
        return this.getTableSize(this.jTableActiveSaveGames);
    }

    public final int getAmountBackupPlayers() {
        return this.getListSize(this.jListBackupCharacters);
    }

    public final int getAmountBackupSaveGames() {
        return this.getTableSize(this.jTableBackupSaveGames);
    }

    public final void setAmountActive(SkyrimCharacterHelperPlayerManager pa_tManager, int pa_iValue) {
        String lc_sValue = "";
        if (0 < pa_iValue) {
            lc_sValue = lc_sValue + Integer.toString(pa_iValue) + "/";
        }
        if (null != pa_tManager && 0 < pa_tManager.getSaveGameAmount()) {
            lc_sValue = lc_sValue + Integer.toString(pa_tManager.getSaveGameAmount());
        }
        this.jTextFieldAmountActive.setText(lc_sValue);
        this.jTextFieldAmountActive.setCaretPosition(0);
    }

    public final void resetAmountBackup() {
        this.jTextFieldAmountBackup.setText("");
    }

    public final void resetAmountActive() {
        this.jTextFieldAmountActive.setText("");
    }

    public final void setAmountBackup(SkyrimCharacterHelperPlayerManager pa_tManager, int pa_iValue) {
        String lc_sValue = "";
        if (0 < pa_iValue) {
            lc_sValue = lc_sValue + Integer.toString(pa_iValue) + "/";
        }
        if (null != pa_tManager && 0 < pa_tManager.getSaveGameAmount()) {
            lc_sValue = lc_sValue + Integer.toString(pa_tManager.getSaveGameAmount());
        }
        this.jTextFieldAmountBackup.setText(lc_sValue);
        this.jTextFieldAmountBackup.setCaretPosition(0);
    }

    public final synchronized void removeActiveSaveGame(SkyrimCharacterHelperSaveGame pa_tSaveGame, boolean pa_bReselect) {
        final SkyrimCharacterHelperSaveGame lc_tSaveGame = pa_tSaveGame;
        final boolean lc_bReselect = pa_bReselect;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int lc_iNewSelectionPos = -1;
                lc_iNewSelectionPos = SkyrimCharacterHelperView.this.removeSaveGameListEntry(SkyrimCharacterHelperView.this.jTableActiveSaveGames, lc_tSaveGame);
                if (-1 != lc_iNewSelectionPos && lc_bReselect) {
                    SkyrimCharacterHelperView.this.jTableActiveSaveGames.getSelectionModel().clearSelection();
                    SkyrimCharacterHelperView.this.jTableActiveSaveGames.addRowSelectionInterval(lc_iNewSelectionPos, lc_iNewSelectionPos);
                }
            }
        });
    }

    public final synchronized void removeBackupSaveGame(SkyrimCharacterHelperSaveGame pa_tSaveGame, boolean pa_bReselect) {
        final SkyrimCharacterHelperSaveGame lc_tSaveGame = pa_tSaveGame;
        final boolean lc_bReselect = pa_bReselect;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int lc_iNewSelectionPos = -1;
                lc_iNewSelectionPos = SkyrimCharacterHelperView.this.removeSaveGameListEntry(SkyrimCharacterHelperView.this.jTableBackupSaveGames, lc_tSaveGame);
                if (-1 != lc_iNewSelectionPos && lc_bReselect) {
                    SkyrimCharacterHelperView.this.jTableBackupSaveGames.getSelectionModel().clearSelection();
                    SkyrimCharacterHelperView.this.jTableBackupSaveGames.addRowSelectionInterval(lc_iNewSelectionPos, lc_iNewSelectionPos);
                }
            }
        });
    }

    public final synchronized void removeActivePlayer(SkyrimCharacterHelperPlayer pa_tCharacter, boolean pa_bReselect, boolean pa_bUseStoredSelection) {
        int lc_iNewSelectionPos = -1;
        if (pa_bUseStoredSelection) {
            this.storeSaveGameSelection(true);
        }
        this.clearActiveSaveGameTable();
        this.setActiveSaveGameScreenshot(null);
        this.setActivePlayerRace(null);
        lc_iNewSelectionPos = this.removePlayerListEntry(this.jListActiveCharacters, pa_tCharacter);
        if (-1 != lc_iNewSelectionPos && pa_bReselect) {
            this.jListActiveCharacters.getSelectionModel().clearSelection();
            this.jListActiveCharacters.setSelectedIndex(lc_iNewSelectionPos);
            if (null != this.getFirstSelectedActivePlayer()) {
                this.initSaveGameList(this.getFirstSelectedActivePlayer().getSaveGames(), true, pa_bUseStoredSelection);
                if (!pa_bUseStoredSelection && null != this.m_tGuiConnector) {
                    this.m_tGuiConnector.handleListSelectionActivePlayers();
                }
            }
        }
    }

    public final synchronized void removeBackupPlayer(SkyrimCharacterHelperPlayer pa_tCharacter, boolean pa_bReselect, boolean pa_bUseStoredSelection) {
        int lc_iNewSelectionPos = -1;
        if (pa_bUseStoredSelection) {
            this.storeSaveGameSelection(false);
        }
        this.clearBackupSaveGameTable();
        this.setBackupSaveGameScreenshot(null);
        this.setBackupPlayerRace(null);
        lc_iNewSelectionPos = this.removePlayerListEntry(this.jListBackupCharacters, pa_tCharacter);
        if (-1 != lc_iNewSelectionPos && pa_bReselect) {
            this.jListBackupCharacters.getSelectionModel().clearSelection();
            this.jListBackupCharacters.setSelectedIndex(lc_iNewSelectionPos);
            if (null != this.getFirstSelectedBackupPlayer()) {
                this.initSaveGameList(this.getFirstSelectedBackupPlayer().getSaveGames(), false, pa_bUseStoredSelection);
                if (!pa_bUseStoredSelection && null != this.m_tGuiConnector) {
                    this.m_tGuiConnector.handleListSelectionBackupPlayers();
                }
            }
        }
    }

    public final void clearActivePlayerList() {
        this.clearList(this.jListActiveCharacters);
    }

    public final void clearBackupPlayerList() {
        this.clearList(this.jListBackupCharacters);
    }

    public final void clearActiveSaveGameTable() {
        this.clearTable(this.jTableActiveSaveGames);
    }

    public final void clearBackupSaveGameTable() {
        this.clearTable(this.jTableBackupSaveGames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized List<SkyrimCharacterHelperSaveGame> getSelectedSaveGames(JTable pa_tTable) {
        ArrayList<SkyrimCharacterHelperSaveGame> lc_tResult = null;
        int[] lc_tIndices = pa_tTable.getSelectedRows();
        int lc_iModelIndex = -1;
        Object lc_tObject = null;
        boolean lc_bOk = false;
        if (null != lc_tIndices && 0 < lc_tIndices.length && null != (lc_tResult = new ArrayList<SkyrimCharacterHelperSaveGame>())) {
            try {
                JTable jTable = pa_tTable;
                synchronized (jTable) {
                    for (int lc_iIndex : lc_tIndices) {
                        lc_iModelIndex = pa_tTable.convertRowIndexToModel(lc_iIndex);
                        if (0 > lc_iModelIndex || lc_iModelIndex >= pa_tTable.getRowCount() || null == (lc_tObject = pa_tTable.getValueAt(lc_iIndex, 0)) || !(lc_tObject instanceof SkyrimCharacterHelperSaveGame)) continue;
                        lc_tResult.add((SkyrimCharacterHelperSaveGame)lc_tObject);
                    }
                    lc_bOk = true;
                }
            }
            catch (Exception lc_tException) {
                // empty catch block
            }
        }
        return true == lc_bOk ? lc_tResult : null;
    }

    public final synchronized List<SkyrimCharacterHelperSaveGame> getSelectedActiveSaveGames() {
        return this.getSelectedSaveGames(this.jTableActiveSaveGames);
    }

    public final synchronized List<SkyrimCharacterHelperSaveGame> getSelectedBackupSaveGames() {
        return this.getSelectedSaveGames(this.jTableBackupSaveGames);
    }

    public final synchronized List<SkyrimCharacterHelperPlayer> getSelectedActivePlayers() {
        List<SkyrimCharacterHelperPlayer> lc_tList = this.jListActiveCharacters.getSelectedValuesList();
        if (null != lc_tList && !lc_tList.isEmpty()) {
            return lc_tList;
        }
        return null;
    }

    public final synchronized List<SkyrimCharacterHelperPlayer> getActivePlayers() {
        SkyrimCharacterHelperListModel lc_tModel = (SkyrimCharacterHelperListModel)this.jListActiveCharacters.getModel();
        return null != lc_tModel ? lc_tModel.getPlayerList() : null;
    }

    public final synchronized List<SkyrimCharacterHelperPlayer> getBackupPlayers() {
        SkyrimCharacterHelperListModel lc_tModel = (SkyrimCharacterHelperListModel)this.jListBackupCharacters.getModel();
        return null != lc_tModel ? lc_tModel.getPlayerList() : null;
    }

    public final synchronized List<SkyrimCharacterHelperPlayer> getSelectedBackupPlayers() {
        List<SkyrimCharacterHelperPlayer> lc_tList = this.jListBackupCharacters.getSelectedValuesList();
        if (null != lc_tList && !lc_tList.isEmpty()) {
            return lc_tList;
        }
        return null;
    }

    public final String getActivePath() {
        return this.jTextFieldActivePath.getText();
    }

    public final void setActivePath(String pa_sValue) {
        this.jTextFieldActivePath.setForeground(true == this.m_bActiveScanned ? this.m_tTextfieldActivePathNormalFg : Color.red);
        this.jTextFieldActivePath.setText(pa_sValue);
        this.jTextFieldActivePath.setCaretPosition(0);
    }

    public final String getBackupPath() {
        return this.jTextFieldBackupPath.getText();
    }

    public final void setBackupPath(String pa_sValue) {
        this.jTextFieldBackupPath.setForeground(true == this.m_bBackupScanned ? this.m_tTextfieldBackupPathNormalFg : Color.red);
        this.jTextFieldBackupPath.setText(pa_sValue);
        this.jTextFieldBackupPath.setCaretPosition(0);
    }

    public final synchronized void setMessage(String pa_sValue) {
        this.jTextFieldProgressAction.setText(pa_sValue);
        this.jTextFieldProgressAction.setCaretPosition(0);
    }

    public final String getLaunchOptions() {
        return this.jTextFieldLaunchOptions.getText();
    }

    public final void setLaunchOptions(String pa_sValue) {
        this.jTextFieldLaunchOptions.setText(pa_sValue);
        this.jTextFieldLaunchOptions.setCaretPosition(0);
    }

    public final void setLaunchBinary(String pa_sValue) {
        this.jTextFieldBinary.setText(pa_sValue);
        this.jTextFieldBinary.setCaretPosition(0);
    }

    public final String getLaunchBinary() {
        return this.jTextFieldBinary.getText();
    }

    public final BufferedImage getActiveSaveGameScreenshot() {
        return null != this.m_tActivePaintPanel ? this.m_tActivePaintPanel.getBufferedImage() : null;
    }

    public final synchronized void setActiveSaveGameScreenshot(BufferedImage pa_tImage) {
        if (null != this.m_tActivePaintPanel) {
            this.m_tActivePaintPanel.setImage(pa_tImage);
        }
    }

    public final BufferedImage getBackupSaveGameScreenshot() {
        return null != this.m_tBackupPaintPanel ? this.m_tBackupPaintPanel.getBufferedImage() : null;
    }

    public final synchronized void setBackupSaveGameScreenshot(BufferedImage pa_tImage) {
        if (null != this.m_tBackupPaintPanel) {
            this.m_tBackupPaintPanel.setImage(pa_tImage);
        }
    }

    public final synchronized void initCurrentProgress(int pa_iMaxValue) {
        final int lc_iFugly = pa_iMaxValue;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SkyrimCharacterHelperView.this.jProgressBarCurrent.setMinimum(0);
                SkyrimCharacterHelperView.this.jProgressBarCurrent.setMaximum(lc_iFugly);
                SkyrimCharacterHelperView.this.jProgressBarCurrent.setValue(0);
            }
        });
    }

    public final synchronized void initTotalProgress(int pa_iMaxValue) {
        final int lc_iFugly = pa_iMaxValue;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SkyrimCharacterHelperView.this.jProgressBarTotal.setMinimum(0);
                SkyrimCharacterHelperView.this.jProgressBarTotal.setMaximum(lc_iFugly);
                SkyrimCharacterHelperView.this.jProgressBarTotal.setValue(0);
            }
        });
    }

    public final synchronized void setStringCurrentProgress(String pa_sValue) {
        final String lc_sFugly = pa_sValue;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SkyrimCharacterHelperView.this.jProgressBarCurrent.setString(lc_sFugly);
            }
        });
    }

    public final synchronized void setCurrentProgress(int pa_iValue) {
        final int lc_iFugly = pa_iValue;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SkyrimCharacterHelperView.this.jProgressBarCurrent.setValue(lc_iFugly);
            }
        });
    }

    public final synchronized void setTotalProgress(int pa_iValue) {
        final int lc_iFugly = pa_iValue;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SkyrimCharacterHelperView.this.jProgressBarTotal.setValue(lc_iFugly);
            }
        });
    }

    public final synchronized void resetProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SkyrimCharacterHelperView.this.setCurrentProgress(0);
                SkyrimCharacterHelperView.this.setTotalProgress(0);
            }
        });
    }

    public final synchronized boolean hasListMultiSelectionActiveSaveGames() {
        return 1 < this.jTableActiveSaveGames.getSelectedRowCount();
    }

    public final synchronized boolean hasListMultiSelectionBackupSaveGames() {
        return 1 < this.jTableBackupSaveGames.getSelectedRowCount();
    }

    public final synchronized boolean hasListMultiSelectionActivePlayers() {
        return this.hasMultiSelection(this.jListActiveCharacters);
    }

    public final synchronized boolean hasListMultiSelectionBackupPlayers() {
        return this.hasMultiSelection(this.jListBackupCharacters);
    }

    public final synchronized SkyrimCharacterHelperSaveGame getFirstSelectedActiveSaveGame() {
        List<SkyrimCharacterHelperSaveGame> lc_tList = this.getSelectedActiveSaveGames();
        if (null != lc_tList && !lc_tList.isEmpty()) {
            return lc_tList.get(0);
        }
        return null;
    }

    public final synchronized SkyrimCharacterHelperSaveGame getFirstSelectedBackupSaveGame() {
        List<SkyrimCharacterHelperSaveGame> lc_tList = this.getSelectedBackupSaveGames();
        if (null != lc_tList && !lc_tList.isEmpty()) {
            return lc_tList.get(0);
        }
        return null;
    }

    public final synchronized SkyrimCharacterHelperPlayer getFirstSelectedActivePlayer() {
        List<SkyrimCharacterHelperPlayer> lc_tList = this.getSelectedActivePlayers();
        if (null != lc_tList && !lc_tList.isEmpty()) {
            return lc_tList.get(0);
        }
        return null;
    }

    public final synchronized SkyrimCharacterHelperPlayer getFirstSelectedBackupPlayer() {
        List<SkyrimCharacterHelperPlayer> lc_tList = this.getSelectedBackupPlayers();
        if (null != lc_tList && !lc_tList.isEmpty()) {
            return lc_tList.get(0);
        }
        return null;
    }

    private synchronized void clearList(JList pa_tList) {
        SkyrimCharacterHelperListModel lc_tModel = null != pa_tList ? (SkyrimCharacterHelperListModel)pa_tList.getModel() : null;
        pa_tList.getSelectionModel().clearSelection();
        if (null != lc_tModel && 0 < lc_tModel.size()) {
            lc_tModel.clear();
        }
    }

    private synchronized void clearTable(JTable pa_tTable) {
        final JTable lc_tTable = pa_tTable;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SkyrimCharacterHelperTableModel lc_tModel = null != lc_tTable ? (SkyrimCharacterHelperTableModel)lc_tTable.getModel() : null;
                lc_tTable.getSelectionModel().clearSelection();
                if (null != lc_tModel && 0 < lc_tModel.size()) {
                    lc_tModel.clear();
                }
            }
        });
    }

    private boolean checkString(String pa_sValue) {
        return null != pa_sValue && 0 < pa_sValue.length();
    }

    private boolean hasMultiSelection(JList pa_tList) {
        int[] lc_iIndices = null;
        if (null != pa_tList && null != (lc_iIndices = pa_tList.getSelectedIndices())) {
            return 1 < lc_iIndices.length;
        }
        return false;
    }

    private int getListSize(JList pa_tList) {
        SkyrimCharacterHelperListModel lc_tModel;
        SkyrimCharacterHelperListModel skyrimCharacterHelperListModel = lc_tModel = null != pa_tList ? (SkyrimCharacterHelperListModel)pa_tList.getModel() : null;
        if (null != lc_tModel) {
            return lc_tModel.getSize();
        }
        return 0;
    }

    private int getTableSize(JTable pa_tTable) {
        AbstractTableModel lc_tModel;
        AbstractTableModel abstractTableModel = lc_tModel = null != pa_tTable ? (AbstractTableModel)pa_tTable.getModel() : null;
        if (null != lc_tModel) {
            return lc_tModel.getRowCount();
        }
        return 0;
    }

    private synchronized int removePlayerListEntry(JList pa_tList, SkyrimCharacterHelperPlayer pa_tCharacter) {
        SkyrimCharacterHelperListModel lc_tModel;
        int lc_iPos = null != pa_tList ? pa_tList.getSelectedIndex() : -1;
        int lc_iSize = 0;
        SkyrimCharacterHelperListModel skyrimCharacterHelperListModel = lc_tModel = null != pa_tList ? (SkyrimCharacterHelperListModel)pa_tList.getModel() : null;
        if (null != pa_tCharacter && null != pa_tList && null != lc_tModel) {
            lc_tModel.removeElement(pa_tCharacter);
            lc_iSize = lc_tModel.size();
        }
        if (0 == lc_iSize) {
            lc_iPos = -1;
        } else if (lc_iPos >= lc_iSize) {
            lc_iPos = lc_iSize - 1;
        }
        return lc_iPos;
    }

    private synchronized int removeSaveGameListEntry(JTable pa_tTable, SkyrimCharacterHelperSaveGame pa_tSaveGame) {
        SkyrimCharacterHelperTableModel lc_tModel;
        int lc_iModelIndex = -1;
        int lc_iViewIndex = -1;
        int lc_iSize = 0;
        SkyrimCharacterHelperTableModel skyrimCharacterHelperTableModel = lc_tModel = null != pa_tTable ? (SkyrimCharacterHelperTableModel)pa_tTable.getModel() : null;
        if (null != pa_tTable && null != pa_tSaveGame && null != lc_tModel && -1 != (lc_iModelIndex = lc_tModel.indexOf(pa_tSaveGame))) {
            lc_iViewIndex = pa_tTable.convertRowIndexToView(lc_iModelIndex);
            if (-1 != lc_iViewIndex && pa_tTable.isRowSelected(lc_iViewIndex)) {
                pa_tTable.getSelectionModel().removeSelectionInterval(lc_iViewIndex, lc_iViewIndex);
            }
            lc_tModel.removeElement(pa_tSaveGame);
            lc_iSize = lc_tModel.size();
        }
        if (0 == lc_iSize) {
            lc_iViewIndex = -1;
        } else if (lc_iViewIndex >= lc_iSize) {
            lc_iViewIndex = lc_iSize - 1;
        }
        return lc_iViewIndex;
    }

    private void initComponents() {
        this.jPanelProgress = new JPanel();
        this.jLabelProgressTotal = new JLabel();
        this.jLabelProgressCurrent = new JLabel();
        this.jProgressBarCurrent = new JProgressBar();
        this.jProgressBarTotal = new JProgressBar();
        this.jTextFieldProgressAction = new JTextField();
        this.jLabelProgressAction = new JLabel();
        this.jPanelControl = new JPanel();
        this.jComboBoxMode = new JComboBox();
        this.jButtonProgressExit = new JButton();
        this.jButtonProgressCancel = new JButton();
        this.jLabelConfirm = new JLabel();
        this.jComboBoxConfirmation = new JComboBox();
        this.jLabelMode = new JLabel();
        this.jLabelOverwrite = new JLabel();
        this.jComboBoxOverwrite = new JComboBox();
        this.jButtonAbout = new JButton();
        this.jLabelBinaryPath = new JLabel();
        this.jTextFieldBinary = new JTextField();
        this.jButtonChooseBinary = new JButton();
        this.jButtonRestoreRegistryPath = new JButton();
        this.jComboBoxMinimize = new JComboBox();
        this.jButtonLaunchSolo = new JButton();
        this.jLabelImageMode = new JLabel();
        this.jComboBoxImageMode = new JComboBox();
        this.jLabelQuickSave = new JLabel();
        this.jLabelAutoSaves = new JLabel();
        this.jLabelPrefix = new JLabel();
        this.jComboBoxAutoSaves = new JComboBox();
        this.jComboBoxQuickSaves = new JComboBox();
        this.jTextFieldPrefix = new JTextField();
        this.filler31 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.jLabelLaunchTarget = new JLabel();
        this.jLabelOnSkyrim = new JLabel();
        this.jLabelLaunchOptions = new JLabel();
        this.jTextFieldLaunchOptions = new JTextField();
        this.jLabelInitMode = new JLabel();
        this.jComboBoxInitMode = new JComboBox();
        this.filler21 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.jPanelBackup = new JPanel();
        this.jScrollPaneBackupCharacters = new JScrollPane();
        this.jListBackupCharacters = new JList();
        this.jButtonBackupCharacterRestore = new JButton();
        this.jButtonBackupCharacterDelete = new JButton();
        this.jButtonBackupCharacterClear = new JButton();
        this.jButtonBackupRescan = new JButton();
        this.jButtonBackupPath = new JButton();
        this.jScrollPaneBackupSaveFiles = new JScrollPane();
        this.jTableBackupSaveGames = new JTable();
        this.jTextFieldBackupPath = new JTextField();
        this.jButtonBackupSaveGameRestore = new JButton();
        this.jButtonBackupSaveGameDelete = new JButton();
        this.jPanelBackupCharacterData = new JPanel();
        this.jButtonBackupClipboard = new JButton();
        this.jTextFieldAmountBackup = new JTextField();
        this.jButtonBackupCharacterLaunch = new JButton();
        this.jTextFieldRaceBackupPlayer = new JTextField();
        this.jButtonBackupLaunchSavegame = new JButton();
        this.jPanelActive = new JPanel();
        this.jScrollPaneActiveCharacters = new JScrollPane();
        this.jListActiveCharacters = new JList();
        this.jButtonActiveCharacterBackup = new JButton();
        this.jButtonActiveCharacterDelete = new JButton();
        this.jButtonActiveCharacterClear = new JButton();
        this.jButtonActiveRescan = new JButton();
        this.jButtonActivePath = new JButton();
        this.jScrollPaneActiveSaveFiles = new JScrollPane();
        this.jTableActiveSaveGames = new JTable();
        this.jTextFieldActivePath = new JTextField();
        this.jButtonActiveSaveGameBackup = new JButton();
        this.jButtonActiveSaveGameDelete = new JButton();
        this.jPanelActiveCharacterData = new JPanel();
        this.jButtonActiveClipboard = new JButton();
        this.jTextFieldAmountActive = new JTextField();
        this.jButtonActiveCharacterLaunch = new JButton();
        this.jTextFieldRaceActivePlayer = new JTextField();
        this.jButtonActiveLaunchSavegame = new JButton();
        this.setDefaultCloseOperation(0);
        ResourceBundle bundle = ResourceBundle.getBundle("skyrimcharacterhelper/resources/SkyrimCharacterHelperView");
        this.setTitle(bundle.getString("Form.title"));
        this.setName("Form");
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanelProgress.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelProgress.setAlignmentX(1.0f);
        this.jPanelProgress.setAlignmentY(0.0f);
        this.jPanelProgress.setName("jPanelProgress");
        this.jLabelProgressTotal.setLabelFor(this.jProgressBarTotal);
        this.jLabelProgressTotal.setText(bundle.getString("jLabelProgressTotal.text"));
        this.jLabelProgressTotal.setName("jLabelProgressTotal");
        this.jLabelProgressCurrent.setLabelFor(this.jProgressBarCurrent);
        this.jLabelProgressCurrent.setText(bundle.getString("jLabelProgressCurrent.text"));
        this.jLabelProgressCurrent.setName("jLabelProgressCurrent");
        this.jProgressBarCurrent.setDoubleBuffered(true);
        this.jProgressBarCurrent.setName("jProgressBarCurrent");
        this.jProgressBarCurrent.setStringPainted(true);
        this.jProgressBarTotal.setDoubleBuffered(true);
        this.jProgressBarTotal.setName("jProgressBarTotal");
        this.jProgressBarTotal.setStringPainted(true);
        this.jTextFieldProgressAction.setBackground(new Color(Integer.valueOf(bundle.getString("displayTextfield.backgroundColor"), 16)));
        this.jTextFieldProgressAction.setEditable(false);
        this.jTextFieldProgressAction.setText(bundle.getString("jTextFieldProgressAction.text"));
        this.jTextFieldProgressAction.setName("jTextFieldProgressAction");
        this.jLabelProgressAction.setLabelFor(this.jTextFieldProgressAction);
        this.jLabelProgressAction.setText(bundle.getString("jLabelProgressAction.text"));
        this.jLabelProgressAction.setName("jLabelProgressAction");
        GroupLayout jPanelProgressLayout = new GroupLayout(this.jPanelProgress);
        this.jPanelProgress.setLayout(jPanelProgressLayout);
        jPanelProgressLayout.setHorizontalGroup(jPanelProgressLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelProgressLayout.createSequentialGroup().addContainerGap().addGroup(jPanelProgressLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelProgressLayout.createSequentialGroup().addComponent(this.jLabelProgressAction).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldProgressAction, -1, 1216, Short.MAX_VALUE)).addGroup(jPanelProgressLayout.createSequentialGroup().addGroup(jPanelProgressLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelProgressCurrent).addComponent(this.jLabelProgressTotal)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelProgressLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jProgressBarTotal, -1, 1216, Short.MAX_VALUE).addComponent(this.jProgressBarCurrent, -1, 1216, Short.MAX_VALUE)))).addContainerGap()));
        jPanelProgressLayout.linkSize(0, this.jLabelProgressAction, this.jLabelProgressCurrent, this.jLabelProgressTotal);
        jPanelProgressLayout.setVerticalGroup(jPanelProgressLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelProgressLayout.createSequentialGroup().addContainerGap().addGroup(jPanelProgressLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelProgressCurrent).addComponent(this.jProgressBarCurrent, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelProgressLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelProgressTotal).addComponent(this.jProgressBarTotal, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelProgressLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldProgressAction, -2, 29, -2).addComponent(this.jLabelProgressAction)).addContainerGap()));
        jPanelProgressLayout.linkSize(1, this.jLabelProgressAction, this.jLabelProgressCurrent, this.jLabelProgressTotal, this.jProgressBarCurrent, this.jProgressBarTotal, this.jTextFieldProgressAction);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(18, 10, 0, 10);
        this.getContentPane().add((Component)this.jPanelProgress, gridBagConstraints);
        this.jPanelControl.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelControl.setAlignmentX(1.0f);
        this.jPanelControl.setAlignmentY(0.0f);
        this.jPanelControl.setName("jPanelControl");
        this.jPanelControl.setLayout(new GridBagLayout());
        this.jComboBoxMode.setMaximumSize(new Dimension(Short.MAX_VALUE, 29));
        this.jComboBoxMode.setMinimumSize(new Dimension(97, 29));
        this.jComboBoxMode.setName("jComboBoxMode");
        this.jComboBoxMode.setPreferredSize(new Dimension(97, 29));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 5, 10, 0);
        this.jPanelControl.add((Component)this.jComboBoxMode, gridBagConstraints);
        ResourceMap resourceMap = Application.getInstance(SkyrimCharacterHelperApp.class).getContext().getResourceMap(SkyrimCharacterHelperView.class);
        this.jButtonProgressExit.setIcon(resourceMap.getIcon("jButtonProgressExit.icon"));
        this.jButtonProgressExit.setText(bundle.getString("jButtonProgressExit.text"));
        this.jButtonProgressExit.setToolTipText(bundle.getString("jButtonProgressExit.toolTipText"));
        this.jButtonProgressExit.setMaximumSize(new Dimension(29, 29));
        this.jButtonProgressExit.setMinimumSize(new Dimension(29, 29));
        this.jButtonProgressExit.setName("jButtonProgressExit");
        this.jButtonProgressExit.setPreferredSize(new Dimension(29, 29));
        this.jButtonProgressExit.setRolloverIcon(resourceMap.getIcon("jButtonProgressExit.rolloverIcon"));
        this.jButtonProgressExit.setRolloverSelectedIcon(resourceMap.getIcon("jButtonProgressExit.rolloverSelectedIcon"));
        this.jButtonProgressExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SkyrimCharacterHelperView.this.actionPerformedButtonProcessExit(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 16;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 5, 10, 5);
        this.jPanelControl.add((Component)this.jButtonProgressExit, gridBagConstraints);
        this.jButtonProgressCancel.setIcon(resourceMap.getIcon("jButtonProgressCancel.icon"));
        this.jButtonProgressCancel.setText(bundle.getString("jButtonProgressCancel.text"));
        this.jButtonProgressCancel.setToolTipText(bundle.getString("jButtonProgressCancel.toolTipText"));
        this.jButtonProgressCancel.setEnabled(false);
        this.jButtonProgressCancel.setMaximumSize(new Dimension(29, 29));
        this.jButtonProgressCancel.setMinimumSize(new Dimension(29, 29));
        this.jButtonProgressCancel.setName("jButtonProgressCancel");
        this.jButtonProgressCancel.setPreferredSize(new Dimension(29, 29));
        this.jButtonProgressCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SkyrimCharacterHelperView.this.actionPerformedButtonProcessCancel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 18;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        this.jPanelControl.add((Component)this.jButtonProgressCancel, gridBagConstraints);
        this.jLabelConfirm.setLabelFor(this.jComboBoxConfirmation);
        this.jLabelConfirm.setText(bundle.getString("jLabelConfirm.text"));
        this.jLabelConfirm.setName("jLabelConfirm");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipady = 15;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 20, 10, 0);
        this.jPanelControl.add((Component)this.jLabelConfirm, gridBagConstraints);
        this.jComboBoxConfirmation.setMaximumSize(new Dimension(Short.MAX_VALUE, 29));
        this.jComboBoxConfirmation.setMinimumSize(new Dimension(57, 29));
        this.jComboBoxConfirmation.setName("jComboBoxConfirmation");
        this.jComboBoxConfirmation.setPreferredSize(new Dimension(57, 29));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 5, 10, 0);
        this.jPanelControl.add((Component)this.jComboBoxConfirmation, gridBagConstraints);
        this.jLabelMode.setLabelFor(this.jComboBoxMode);
        this.jLabelMode.setText(bundle.getString("jLabelMode.text"));
        this.jLabelMode.setName("jLabelMode");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipady = 15;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        this.jPanelControl.add((Component)this.jLabelMode, gridBagConstraints);
        this.jLabelOverwrite.setLabelFor(this.jComboBoxOverwrite);
        this.jLabelOverwrite.setText(bundle.getString("jLabelOverwrite.text"));
        this.jLabelOverwrite.setName("jLabelOverwrite");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipady = 15;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 20, 10, 0);
        this.jPanelControl.add((Component)this.jLabelOverwrite, gridBagConstraints);
        this.jComboBoxOverwrite.setMaximumSize(new Dimension(Short.MAX_VALUE, 29));
        this.jComboBoxOverwrite.setMinimumSize(new Dimension(57, 29));
        this.jComboBoxOverwrite.setName("jComboBoxOverwrite");
        this.jComboBoxOverwrite.setPreferredSize(new Dimension(57, 29));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 10, 0);
        this.jPanelControl.add((Component)this.jComboBoxOverwrite, gridBagConstraints);
        this.jButtonAbout.setIcon(resourceMap.getIcon("jButtonAbout.icon"));
        this.jButtonAbout.setText(bundle.getString("jButtonAbout.text"));
        this.jButtonAbout.setToolTipText(bundle.getString("jButtonAbout.toolTipText"));
        this.jButtonAbout.setMaximumSize(new Dimension(29, 29));
        this.jButtonAbout.setMinimumSize(new Dimension(29, 29));
        this.jButtonAbout.setName("jButtonAbout");
        this.jButtonAbout.setPreferredSize(new Dimension(29, 29));
        this.jButtonAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SkyrimCharacterHelperView.this.actionPerformedButtonAbout(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 17;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 0, 10, 5);
        this.jPanelControl.add((Component)this.jButtonAbout, gridBagConstraints);
        this.jLabelBinaryPath.setText(bundle.getString("jLabelBinaryPath.text"));
        this.jLabelBinaryPath.setName("jLabelBinaryPath");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipady = 15;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 20, 10, 0);
        this.jPanelControl.add((Component)this.jLabelBinaryPath, gridBagConstraints);
        this.jTextFieldBinary.setBackground(new Color(Integer.valueOf(bundle.getString("displayTextfield.backgroundColor"), 16)));
        this.jTextFieldBinary.setEditable(false);
        this.jTextFieldBinary.setText(bundle.getString("jTextFieldBinary.text"));
        this.jTextFieldBinary.setMaximumSize(new Dimension(Integer.MAX_VALUE, 29));
        this.jTextFieldBinary.setMinimumSize(new Dimension(6, 29));
        this.jTextFieldBinary.setName("jTextFieldBinary");
        this.jTextFieldBinary.setPreferredSize(new Dimension(6, 29));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.insets = new Insets(0, 5, 10, 0);
        this.jPanelControl.add((Component)this.jTextFieldBinary, gridBagConstraints);
        this.jButtonChooseBinary.setIcon(resourceMap.getIcon("jButtonChooseBinary.icon"));
        this.jButtonChooseBinary.setText(bundle.getString("jButtonChooseBinary.text"));
        this.jButtonChooseBinary.setToolTipText(bundle.getString("jButtonChooseBinary.toolTipText"));
        this.jButtonChooseBinary.setMaximumSize(new Dimension(29, 29));
        this.jButtonChooseBinary.setMinimumSize(new Dimension(29, 29));
        this.jButtonChooseBinary.setName("jButtonChooseBinary");
        this.jButtonChooseBinary.setPreferredSize(new Dimension(29, 29));
        this.jButtonChooseBinary.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SkyrimCharacterHelperView.this.actionPerformedButtonChooseBinary(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.jPanelControl.add((Component)this.jButtonChooseBinary, gridBagConstraints);
        this.jButtonRestoreRegistryPath.setIcon(resourceMap.getIcon("jButtonRestoreRegistryPath.icon"));
        this.jButtonRestoreRegistryPath.setText(bundle.getString("jButtonRestoreRegistryPath.text"));
        this.jButtonRestoreRegistryPath.setToolTipText(bundle.getString("jButtonRestoreRegistryPath.toolTipText"));
        this.jButtonRestoreRegistryPath.setMaximumSize(new Dimension(29, 29));
        this.jButtonRestoreRegistryPath.setMinimumSize(new Dimension(29, 29));
        this.jButtonRestoreRegistryPath.setName("jButtonRestoreRegistryPath");
        this.jButtonRestoreRegistryPath.setPreferredSize(new Dimension(29, 29));
        this.jButtonRestoreRegistryPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SkyrimCharacterHelperView.this.actionPerformedButtonRestoreRegistry(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 5);
        this.jPanelControl.add((Component)this.jButtonRestoreRegistryPath, gridBagConstraints);
        this.jComboBoxMinimize.setMaximumSize(new Dimension(Short.MAX_VALUE, 29));
        this.jComboBoxMinimize.setMinimumSize(new Dimension(100, 29));
        this.jComboBoxMinimize.setName("jComboBoxMinimize");
        this.jComboBoxMinimize.setPreferredSize(new Dimension(100, 29));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.insets = new Insets(0, 5, 10, 0);
        this.jPanelControl.add((Component)this.jComboBoxMinimize, gridBagConstraints);
        this.jButtonLaunchSolo.setIcon(resourceMap.getIcon("jButtonLaunchSolo.icon"));
        this.jButtonLaunchSolo.setText(bundle.getString("jButtonLaunchSolo.text"));
        this.jButtonLaunchSolo.setToolTipText(bundle.getString("jButtonLaunchSolo.toolTipText"));
        this.jButtonLaunchSolo.setEnabled(false);
        this.jButtonLaunchSolo.setMaximumSize(new Dimension(29, 29));
        this.jButtonLaunchSolo.setMinimumSize(new Dimension(29, 29));
        this.jButtonLaunchSolo.setName("jButtonLaunchSolo");
        this.jButtonLaunchSolo.setPreferredSize(new Dimension(29, 29));
        this.jButtonLaunchSolo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SkyrimCharacterHelperView.this.actionPerformedButtonLaunchSolo(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 10, 5);
        this.jPanelControl.add((Component)this.jButtonLaunchSolo, gridBagConstraints);
        this.jLabelImageMode.setText(bundle.getString("jLabelImageMode.text"));
        this.jLabelImageMode.setName("jLabelImageMode");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipady = 15;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        this.jPanelControl.add((Component)this.jLabelImageMode, gridBagConstraints);
        this.jComboBoxImageMode.setMaximumSize(new Dimension(Short.MAX_VALUE, 29));
        this.jComboBoxImageMode.setMinimumSize(new Dimension(97, 29));
        this.jComboBoxImageMode.setName("jComboBoxImageMode");
        this.jComboBoxImageMode.setPreferredSize(new Dimension(97, 29));
        this.jComboBoxImageMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SkyrimCharacterHelperView.this.actionPerformedComboBoxImageMode(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 10, 0);
        this.jPanelControl.add((Component)this.jComboBoxImageMode, gridBagConstraints);
        this.jLabelQuickSave.setText(bundle.getString("jLabelQuickSave.text"));
        this.jLabelQuickSave.setMaximumSize(new Dimension(125, 144));
        this.jLabelQuickSave.setMinimumSize(new Dimension(120, 14));
        this.jLabelQuickSave.setName("jLabelQuickSave");
        this.jLabelQuickSave.setPreferredSize(new Dimension(120, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipady = 15;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 20, 10, 0);
        this.jPanelControl.add((Component)this.jLabelQuickSave, gridBagConstraints);
        this.jLabelAutoSaves.setText(bundle.getString("jLabelAutoSaves.text"));
        this.jLabelAutoSaves.setMaximumSize(new Dimension(125, 14));
        this.jLabelAutoSaves.setName("jLabelAutoSaves");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipady = 15;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 20, 10, 0);
        this.jPanelControl.add((Component)this.jLabelAutoSaves, gridBagConstraints);
        this.jLabelPrefix.setText(bundle.getString("jLabelPrefix.text"));
        this.jLabelPrefix.setName("jLabelPrefix");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipady = 15;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 5, 10, 0);
        this.jPanelControl.add((Component)this.jLabelPrefix, gridBagConstraints);
        this.jComboBoxAutoSaves.setMaximumSize(new Dimension(Short.MAX_VALUE, 29));
        this.jComboBoxAutoSaves.setMinimumSize(new Dimension(57, 29));
        this.jComboBoxAutoSaves.setName("jComboBoxAutoSaves");
        this.jComboBoxAutoSaves.setPreferredSize(new Dimension(57, 29));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 5, 10, 0);
        this.jPanelControl.add((Component)this.jComboBoxAutoSaves, gridBagConstraints);
        this.jComboBoxQuickSaves.setMaximumSize(new Dimension(Short.MAX_VALUE, 29));
        this.jComboBoxQuickSaves.setMinimumSize(new Dimension(57, 29));
        this.jComboBoxQuickSaves.setName("jComboBoxQuickSaves");
        this.jComboBoxQuickSaves.setPreferredSize(new Dimension(57, 29));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 10, 0);
        this.jPanelControl.add((Component)this.jComboBoxQuickSaves, gridBagConstraints);
        this.jTextFieldPrefix.setText(bundle.getString("jTextFieldPrefix.text"));
        this.jTextFieldPrefix.setMaximumSize(new Dimension(Integer.MAX_VALUE, 29));
        this.jTextFieldPrefix.setMinimumSize(new Dimension(60, 29));
        this.jTextFieldPrefix.setName("jTextFieldPrefix");
        this.jTextFieldPrefix.setPreferredSize(new Dimension(80, 29));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.insets = new Insets(10, 5, 10, 0);
        this.jPanelControl.add((Component)this.jTextFieldPrefix, gridBagConstraints);
        this.filler31.setName("filler31");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 15;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 50;
        this.jPanelControl.add((Component)this.filler31, gridBagConstraints);
        this.jLabelLaunchTarget.setText(bundle.getString("jLabelLaunchTarget.text"));
        this.jLabelLaunchTarget.setName("jLabelLaunchTarget");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipady = 15;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        this.jPanelControl.add((Component)this.jLabelLaunchTarget, gridBagConstraints);
        this.jLabelOnSkyrim.setHorizontalAlignment(0);
        this.jLabelOnSkyrim.setIcon(resourceMap.getIcon("jLabelOnSkyrim.icon"));
        this.jLabelOnSkyrim.setText(bundle.getString("jLabelOnSkyrim.text"));
        this.jLabelOnSkyrim.setBorder(BorderFactory.createEtchedBorder());
        this.jLabelOnSkyrim.setDisabledIcon(resourceMap.getIcon("jLabelOnSkyrim.disabledIcon"));
        this.jLabelOnSkyrim.setEnabled(false);
        this.jLabelOnSkyrim.setHorizontalTextPosition(4);
        this.jLabelOnSkyrim.setIconTextGap(15);
        this.jLabelOnSkyrim.setMaximumSize(new Dimension(5000, 29));
        this.jLabelOnSkyrim.setMinimumSize(new Dimension(82, 29));
        this.jLabelOnSkyrim.setName("jLabelOnSkyrim");
        this.jLabelOnSkyrim.setOpaque(true);
        this.jLabelOnSkyrim.setPreferredSize(new Dimension(79, 29));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.insets = new Insets(0, 5, 10, 0);
        this.jPanelControl.add((Component)this.jLabelOnSkyrim, gridBagConstraints);
        this.jLabelLaunchOptions.setText(bundle.getString("jLabelLaunchOptions.text"));
        this.jLabelLaunchOptions.setName("jLabelLaunchOptions");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipady = 15;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 10, 0);
        this.jPanelControl.add((Component)this.jLabelLaunchOptions, gridBagConstraints);
        this.jTextFieldLaunchOptions.setText(bundle.getString("jTextFieldLaunchOptions.text"));
        this.jTextFieldLaunchOptions.setMaximumSize(new Dimension(Integer.MAX_VALUE, 29));
        this.jTextFieldLaunchOptions.setMinimumSize(new Dimension(60, 29));
        this.jTextFieldLaunchOptions.setName("jTextFieldLaunchOptions");
        this.jTextFieldLaunchOptions.setPreferredSize(new Dimension(60, 29));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.insets = new Insets(0, 5, 10, 0);
        this.jPanelControl.add((Component)this.jTextFieldLaunchOptions, gridBagConstraints);
        this.jLabelInitMode.setText(bundle.getString("jLabelInitMode.text"));
        this.jLabelInitMode.setMaximumSize(new Dimension(63, 14));
        this.jLabelInitMode.setMinimumSize(new Dimension(63, 14));
        this.jLabelInitMode.setName("jLabelInitMode");
        this.jLabelInitMode.setPreferredSize(new Dimension(63, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipady = 15;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 20, 10, 0);
        this.jPanelControl.add((Component)this.jLabelInitMode, gridBagConstraints);
        this.jComboBoxInitMode.setFocusCycleRoot(true);
        this.jComboBoxInitMode.setMaximumSize(new Dimension(Short.MAX_VALUE, 29));
        this.jComboBoxInitMode.setMinimumSize(new Dimension(100, 29));
        this.jComboBoxInitMode.setName("jComboBoxInitMode");
        this.jComboBoxInitMode.setPreferredSize(new Dimension(100, 29));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.insets = new Insets(10, 5, 10, 0);
        this.jPanelControl.add((Component)this.jComboBoxInitMode, gridBagConstraints);
        this.filler21.setName("filler21");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 50;
        this.jPanelControl.add((Component)this.filler21, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(18, 10, 11, 10);
        this.getContentPane().add((Component)this.jPanelControl, gridBagConstraints);
        this.jPanelBackup.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelBackup.setAlignmentY(1.0f);
        this.jPanelBackup.setMinimumSize(new Dimension(496, 300));
        this.jPanelBackup.setName("jPanelBackup");
        this.jPanelBackup.setPreferredSize(new Dimension(819, 300));
        this.jPanelBackup.setLayout(new GridBagLayout());
        this.jScrollPaneBackupCharacters.setMaximumSize(new Dimension(165, Short.MAX_VALUE));
        this.jScrollPaneBackupCharacters.setMinimumSize(new Dimension(165, 130));
        this.jScrollPaneBackupCharacters.setName("jScrollPaneBackupCharacters");
        this.jScrollPaneBackupCharacters.setPreferredSize(new Dimension(165, 130));
        this.jListBackupCharacters.setBackground(new Color(Integer.valueOf(bundle.getString("jList.background"), 16)));
        this.jListBackupCharacters.setForeground(new Color(Integer.valueOf(bundle.getString("jList.foreground"), 16)));
        this.jListBackupCharacters.setAlignmentX(0.2f);
        this.jListBackupCharacters.setFocusable(false);
        this.jListBackupCharacters.setName("jListBackupCharacters");
        this.jListBackupCharacters.setSelectionBackground(new Color(Integer.valueOf(bundle.getString("jList.selectionBackground"), 16)));
        this.jListBackupCharacters.setSelectionForeground(new Color(Integer.valueOf(bundle.getString("jList.selectionForeground"), 16)));
        this.jScrollPaneBackupCharacters.setViewportView(this.jListBackupCharacters);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.jPanelBackup.add((Component)this.jScrollPaneBackupCharacters, gridBagConstraints);
        this.jButtonBackupCharacterRestore.setIcon(resourceMap.getIcon("jButtonBackupCharacterRestore.icon"));
        this.jButtonBackupCharacterRestore.setText(bundle.getString("jButtonBackupCharacterRestore.text"));
        this.jButtonBackupCharacterRestore.setToolTipText(bundle.getString("jButtonBackupCharacterRestore.toolTipText"));
        this.jButtonBackupCharacterRestore.setEnabled(false);
        this.jButtonBackupCharacterRestore.setMaximumSize(new Dimension(29, 29));
        this.jButtonBackupCharacterRestore.setMinimumSize(new Dimension(29, 29));
        this.jButtonBackupCharacterRestore.setName("jButtonBackupCharacterRestore");
        this.jButtonBackupCharacterRestore.setPreferredSize(new Dimension(29, 29));
        this.jButtonBackupCharacterRestore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SkyrimCharacterHelperView.this.actionPerformedButtonBackupPlayerRestore(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 5);
        this.jPanelBackup.add((Component)this.jButtonBackupCharacterRestore, gridBagConstraints);
        this.jButtonBackupCharacterDelete.setIcon(resourceMap.getIcon("jButtonBackupCharacterDelete.icon"));
        this.jButtonBackupCharacterDelete.setText(bundle.getString("jButtonBackupCharacterDelete.text"));
        this.jButtonBackupCharacterDelete.setToolTipText(bundle.getString("jButtonBackupCharacterDelete.toolTipText"));
        this.jButtonBackupCharacterDelete.setEnabled(false);
        this.jButtonBackupCharacterDelete.setMaximumSize(new Dimension(29, 29));
        this.jButtonBackupCharacterDelete.setMinimumSize(new Dimension(29, 29));
        this.jButtonBackupCharacterDelete.setName("jButtonBackupCharacterDelete");
        this.jButtonBackupCharacterDelete.setPreferredSize(new Dimension(29, 29));
        this.jButtonBackupCharacterDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SkyrimCharacterHelperView.this.actionPerformedButtonBackupDelete(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 5);
        this.jPanelBackup.add((Component)this.jButtonBackupCharacterDelete, gridBagConstraints);
        this.jButtonBackupCharacterClear.setIcon(resourceMap.getIcon("jButtonBackupCharacterClear.icon"));
        this.jButtonBackupCharacterClear.setText(bundle.getString("jButtonBackupCharacterClear.text"));
        this.jButtonBackupCharacterClear.setToolTipText(bundle.getString("jButtonBackupCharacterClear.toolTipText"));
        this.jButtonBackupCharacterClear.setEnabled(false);
        this.jButtonBackupCharacterClear.setMaximumSize(new Dimension(29, 29));
        this.jButtonBackupCharacterClear.setMinimumSize(new Dimension(29, 29));
        this.jButtonBackupCharacterClear.setName("jButtonBackupCharacterClear");
        this.jButtonBackupCharacterClear.setPreferredSize(new Dimension(29, 29));
        this.jButtonBackupCharacterClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SkyrimCharacterHelperView.this.actionPerformedButtonBackupClear(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 5);
        this.jPanelBackup.add((Component)this.jButtonBackupCharacterClear, gridBagConstraints);
        this.jButtonBackupRescan.setIcon(resourceMap.getIcon("jButtonBackupRescan.icon"));
        this.jButtonBackupRescan.setText(bundle.getString("jButtonBackupRescan.text"));
        this.jButtonBackupRescan.setToolTipText(bundle.getString("jButtonBackupRescan.toolTipText"));
        this.jButtonBackupRescan.setEnabled(false);
        this.jButtonBackupRescan.setMaximumSize(new Dimension(29, 29));
        this.jButtonBackupRescan.setMinimumSize(new Dimension(29, 29));
        this.jButtonBackupRescan.setName("jButtonBackupRescan");
        this.jButtonBackupRescan.setPreferredSize(new Dimension(29, 29));
        this.jButtonBackupRescan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SkyrimCharacterHelperView.this.actionPerformedButtonBackupRescan(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 5);
        this.jPanelBackup.add((Component)this.jButtonBackupRescan, gridBagConstraints);
        this.jButtonBackupPath.setIcon(resourceMap.getIcon("jButtonBackupPath.icon"));
        this.jButtonBackupPath.setText(bundle.getString("jButtonBackupPath.text"));
        this.jButtonBackupPath.setToolTipText(bundle.getString("jButtonBackupPath.toolTipText"));
        this.jButtonBackupPath.setAlignmentX(0.2f);
        this.jButtonBackupPath.setMaximumSize(new Dimension(29, 29));
        this.jButtonBackupPath.setMinimumSize(new Dimension(29, 29));
        this.jButtonBackupPath.setName("jButtonBackupPath");
        this.jButtonBackupPath.setPreferredSize(new Dimension(29, 29));
        this.jButtonBackupPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SkyrimCharacterHelperView.this.actionPerformedButtonBackupSelectDirectory(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 5);
        this.jPanelBackup.add((Component)this.jButtonBackupPath, gridBagConstraints);
        this.jScrollPaneBackupSaveFiles.setMinimumSize(new Dimension(260, 130));
        this.jScrollPaneBackupSaveFiles.setName("jScrollPaneBackupSaveFiles");
        this.jScrollPaneBackupSaveFiles.setPreferredSize(new Dimension(260, 130));
        this.jTableBackupSaveGames.setAutoCreateColumnsFromModel(false);
        this.jTableBackupSaveGames.setAutoCreateRowSorter(false);
        this.jTableBackupSaveGames.setBackground(new Color(Integer.valueOf(bundle.getString("jList.background"), 16)));
        this.jTableBackupSaveGames.setForeground(new Color(Integer.valueOf(bundle.getString("jList.foreground"), 16)));
        this.jTableBackupSaveGames.setEnabled(false);
        this.jTableBackupSaveGames.setFillsViewportHeight(true);
        this.jTableBackupSaveGames.setFocusable(false);
        this.jTableBackupSaveGames.setIntercellSpacing(new Dimension(0, 0));
        this.jTableBackupSaveGames.setName("jTableBackupSaveGames");
        this.jTableBackupSaveGames.setRowHeight(25);
        this.jTableBackupSaveGames.setSelectionBackground(new Color(Integer.valueOf(bundle.getString("jList.selectionBackground"), 16)));
        this.jTableBackupSaveGames.setSelectionForeground(new Color(Integer.valueOf(bundle.getString("jList.selectionForeground"), 16)));
        this.jTableBackupSaveGames.setShowHorizontalLines(false);
        this.jTableBackupSaveGames.setShowVerticalLines(false);
        this.jTableBackupSaveGames.setUpdateSelectionOnSort(false);
        this.jScrollPaneBackupSaveFiles.setViewportView(this.jTableBackupSaveGames);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 10;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 400;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        this.jPanelBackup.add((Component)this.jScrollPaneBackupSaveFiles, gridBagConstraints);
        this.jTextFieldBackupPath.setBackground(new Color(Integer.valueOf(bundle.getString("displayTextfield.backgroundColor"), 16)));
        this.jTextFieldBackupPath.setEditable(false);
        this.jTextFieldBackupPath.setText(bundle.getString("jTextFieldBackupPath.text"));
        this.jTextFieldBackupPath.setMaximumSize(new Dimension(Integer.MAX_VALUE, 29));
        this.jTextFieldBackupPath.setMinimumSize(new Dimension(150, 29));
        this.jTextFieldBackupPath.setName("jTextFieldBackupPath");
        this.jTextFieldBackupPath.setPreferredSize(new Dimension(100, 29));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 5);
        this.jPanelBackup.add((Component)this.jTextFieldBackupPath, gridBagConstraints);
        this.jButtonBackupSaveGameRestore.setIcon(resourceMap.getIcon("jButtonBackupSaveGameRestore.icon"));
        this.jButtonBackupSaveGameRestore.setText(bundle.getString("jButtonBackupSaveGameRestore.text"));
        this.jButtonBackupSaveGameRestore.setToolTipText(bundle.getString("jButtonBackupSaveGameRestore.toolTipText"));
        this.jButtonBackupSaveGameRestore.setEnabled(false);
        this.jButtonBackupSaveGameRestore.setMaximumSize(new Dimension(29, 29));
        this.jButtonBackupSaveGameRestore.setMinimumSize(new Dimension(29, 29));
        this.jButtonBackupSaveGameRestore.setName("jButtonBackupSaveGameRestore");
        this.jButtonBackupSaveGameRestore.setPreferredSize(new Dimension(29, 29));
        this.jButtonBackupSaveGameRestore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SkyrimCharacterHelperView.this.actionPerformedButtonBackupSaveGameRestore(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 14;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 5);
        this.jPanelBackup.add((Component)this.jButtonBackupSaveGameRestore, gridBagConstraints);
        this.jButtonBackupSaveGameDelete.setIcon(resourceMap.getIcon("jButtonBackupSaveGameDelete.icon"));
        this.jButtonBackupSaveGameDelete.setText(bundle.getString("jButtonBackupSaveGameDelete.text"));
        this.jButtonBackupSaveGameDelete.setToolTipText(bundle.getString("jButtonBackupSaveGameDelete.toolTipText"));
        this.jButtonBackupSaveGameDelete.setEnabled(false);
        this.jButtonBackupSaveGameDelete.setMaximumSize(new Dimension(29, 29));
        this.jButtonBackupSaveGameDelete.setMinimumSize(new Dimension(29, 29));
        this.jButtonBackupSaveGameDelete.setName("jButtonBackupSaveGameDelete");
        this.jButtonBackupSaveGameDelete.setPreferredSize(new Dimension(29, 29));
        this.jButtonBackupSaveGameDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SkyrimCharacterHelperView.this.actionPerformedButtonBackupSaveGameDelete(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 13;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 5);
        this.jPanelBackup.add((Component)this.jButtonBackupSaveGameDelete, gridBagConstraints);
        this.jPanelBackupCharacterData.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelBackupCharacterData.setAlignmentX(0.3f);
        this.jPanelBackupCharacterData.setMaximumSize(new Dimension(520, Short.MAX_VALUE));
        this.jPanelBackupCharacterData.setName("jPanelBackupCharacterData");
        this.jPanelBackupCharacterData.setPreferredSize(new Dimension(349, 263));
        GroupLayout jPanelBackupCharacterDataLayout = new GroupLayout(this.jPanelBackupCharacterData);
        this.jPanelBackupCharacterData.setLayout(jPanelBackupCharacterDataLayout);
        jPanelBackupCharacterDataLayout.setHorizontalGroup(jPanelBackupCharacterDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 410, Short.MAX_VALUE));
        jPanelBackupCharacterDataLayout.setVerticalGroup(jPanelBackupCharacterDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 296, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 16;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 410;
        gridBagConstraints.ipady = 200;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        this.jPanelBackup.add((Component)this.jPanelBackupCharacterData, gridBagConstraints);
        this.jButtonBackupClipboard.setIcon(resourceMap.getIcon("jButtonBackupClipboard.icon"));
        this.jButtonBackupClipboard.setText(bundle.getString("jButtonBackupClipboard.text"));
        this.jButtonBackupClipboard.setToolTipText(bundle.getString("jButtonBackupClipboard.toolTipText"));
        this.jButtonBackupClipboard.setEnabled(false);
        this.jButtonBackupClipboard.setMaximumSize(new Dimension(29, 29));
        this.jButtonBackupClipboard.setMinimumSize(new Dimension(29, 29));
        this.jButtonBackupClipboard.setName("jButtonBackupClipboard");
        this.jButtonBackupClipboard.setPreferredSize(new Dimension(29, 29));
        this.jButtonBackupClipboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SkyrimCharacterHelperView.this.actionPerformedButtonBackupClipboard(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 15;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        this.jPanelBackup.add((Component)this.jButtonBackupClipboard, gridBagConstraints);
        this.jTextFieldAmountBackup.setBackground(new Color(Integer.valueOf(bundle.getString("displayTextfield.backgroundColor"), 16)));
        this.jTextFieldAmountBackup.setEditable(false);
        this.jTextFieldAmountBackup.setText(bundle.getString("jTextFieldAmountBackup.text"));
        this.jTextFieldAmountBackup.setMaximumSize(new Dimension(60, 29));
        this.jTextFieldAmountBackup.setMinimumSize(new Dimension(60, 29));
        this.jTextFieldAmountBackup.setName("jTextFieldAmountBackup");
        this.jTextFieldAmountBackup.setPreferredSize(new Dimension(60, 29));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 5);
        this.jPanelBackup.add((Component)this.jTextFieldAmountBackup, gridBagConstraints);
        this.jButtonBackupCharacterLaunch.setIcon(resourceMap.getIcon("jButtonBackupCharacterLaunch.icon"));
        this.jButtonBackupCharacterLaunch.setText(bundle.getString("jButtonBackupCharacterLaunch.text"));
        this.jButtonBackupCharacterLaunch.setToolTipText(bundle.getString("jButtonBackupCharacterLaunch.toolTipText"));
        this.jButtonBackupCharacterLaunch.setEnabled(false);
        this.jButtonBackupCharacterLaunch.setMaximumSize(new Dimension(29, 29));
        this.jButtonBackupCharacterLaunch.setMinimumSize(new Dimension(29, 29));
        this.jButtonBackupCharacterLaunch.setName("jButtonBackupCharacterLaunch");
        this.jButtonBackupCharacterLaunch.setPreferredSize(new Dimension(29, 29));
        this.jButtonBackupCharacterLaunch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SkyrimCharacterHelperView.this.actionPerformedButtonBackupLaunchPlayer(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 10, 5);
        this.jPanelBackup.add((Component)this.jButtonBackupCharacterLaunch, gridBagConstraints);
        this.jTextFieldRaceBackupPlayer.setBackground(new Color(Integer.valueOf(bundle.getString("displayTextfield.backgroundColor"), 16)));
        this.jTextFieldRaceBackupPlayer.setEditable(false);
        this.jTextFieldRaceBackupPlayer.setText(bundle.getString("jTextFieldRaceBackupPlayer"));
        this.jTextFieldRaceBackupPlayer.setMaximumSize(new Dimension(100, 29));
        this.jTextFieldRaceBackupPlayer.setMinimumSize(new Dimension(100, 29));
        this.jTextFieldRaceBackupPlayer.setName("jTextFieldRaceBackupPlayer");
        this.jTextFieldRaceBackupPlayer.setPreferredSize(new Dimension(100, 29));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        this.jPanelBackup.add((Component)this.jTextFieldRaceBackupPlayer, gridBagConstraints);
        this.jButtonBackupLaunchSavegame.setIcon(resourceMap.getIcon("jButtonBackupLaunchSavegame.icon"));
        this.jButtonBackupLaunchSavegame.setText(bundle.getString("jButtonBackupLaunchSavegame.text"));
        this.jButtonBackupLaunchSavegame.setToolTipText(bundle.getString("jButtonBackupLaunchSavegame.toolTipText"));
        this.jButtonBackupLaunchSavegame.setEnabled(false);
        this.jButtonBackupLaunchSavegame.setMaximumSize(new Dimension(29, 29));
        this.jButtonBackupLaunchSavegame.setMinimumSize(new Dimension(29, 29));
        this.jButtonBackupLaunchSavegame.setName("jButtonBackupLaunchSavegame");
        this.jButtonBackupLaunchSavegame.setPreferredSize(new Dimension(29, 29));
        this.jButtonBackupLaunchSavegame.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SkyrimCharacterHelperView.this.actionPerformedButtonLaunchBackupSavegame(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 5);
        this.jPanelBackup.add((Component)this.jButtonBackupLaunchSavegame, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(18, 10, 0, 10);
        this.getContentPane().add((Component)this.jPanelBackup, gridBagConstraints);
        this.jPanelActive.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelActive.setAlignmentY(1.0f);
        this.jPanelActive.setMinimumSize(new Dimension(496, 300));
        this.jPanelActive.setName("jPanelActive");
        this.jPanelActive.setPreferredSize(new Dimension(819, 300));
        this.jPanelActive.setLayout(new GridBagLayout());
        this.jScrollPaneActiveCharacters.setMaximumSize(new Dimension(165, Short.MAX_VALUE));
        this.jScrollPaneActiveCharacters.setMinimumSize(new Dimension(165, 130));
        this.jScrollPaneActiveCharacters.setName("jScrollPaneActiveCharacters");
        this.jScrollPaneActiveCharacters.setPreferredSize(new Dimension(165, 130));
        this.jListActiveCharacters.setBackground(new Color(Integer.valueOf(bundle.getString("jList.background"), 16)));
        this.jListActiveCharacters.setForeground(new Color(Integer.valueOf(bundle.getString("jList.foreground"), 16)));
        this.jListActiveCharacters.setAlignmentX(0.2f);
        this.jListActiveCharacters.setFocusable(false);
        this.jListActiveCharacters.setName("jListActiveCharacters");
        this.jListActiveCharacters.setSelectionBackground(new Color(Integer.valueOf(bundle.getString("jList.selectionBackground"), 16)));
        this.jListActiveCharacters.setSelectionForeground(new Color(Integer.valueOf(bundle.getString("jList.selectionForeground"), 16)));
        this.jScrollPaneActiveCharacters.setViewportView(this.jListActiveCharacters);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.jPanelActive.add((Component)this.jScrollPaneActiveCharacters, gridBagConstraints);
        this.jButtonActiveCharacterBackup.setIcon(resourceMap.getIcon("jButtonActiveCharacterBackup.icon"));
        this.jButtonActiveCharacterBackup.setText(bundle.getString("jButtonActiveCharacterRestore.text"));
        this.jButtonActiveCharacterBackup.setToolTipText(bundle.getString("jButtonActiveCharacterBackup.toolTipText"));
        this.jButtonActiveCharacterBackup.setEnabled(false);
        this.jButtonActiveCharacterBackup.setMaximumSize(new Dimension(29, 29));
        this.jButtonActiveCharacterBackup.setMinimumSize(new Dimension(29, 29));
        this.jButtonActiveCharacterBackup.setName("jButtonActiveCharacterBackup");
        this.jButtonActiveCharacterBackup.setPreferredSize(new Dimension(29, 29));
        this.jButtonActiveCharacterBackup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SkyrimCharacterHelperView.this.actionPerformedButtonActiveBackupPlayer(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 5);
        this.jPanelActive.add((Component)this.jButtonActiveCharacterBackup, gridBagConstraints);
        this.jButtonActiveCharacterDelete.setIcon(resourceMap.getIcon("jButtonActiveCharacterDelete.icon"));
        this.jButtonActiveCharacterDelete.setText(bundle.getString("jButtonActiveCharacterDelete.text"));
        this.jButtonActiveCharacterDelete.setToolTipText(bundle.getString("jButtonActiveCharacterDelete.toolTipText"));
        this.jButtonActiveCharacterDelete.setEnabled(false);
        this.jButtonActiveCharacterDelete.setMaximumSize(new Dimension(29, 29));
        this.jButtonActiveCharacterDelete.setMinimumSize(new Dimension(29, 29));
        this.jButtonActiveCharacterDelete.setName("jButtonActiveCharacterDelete");
        this.jButtonActiveCharacterDelete.setPreferredSize(new Dimension(29, 29));
        this.jButtonActiveCharacterDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SkyrimCharacterHelperView.this.actionPerformedButtonActiveDelete(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 5);
        this.jPanelActive.add((Component)this.jButtonActiveCharacterDelete, gridBagConstraints);
        this.jButtonActiveCharacterClear.setIcon(resourceMap.getIcon("jButtonActiveCharacterClear.icon"));
        this.jButtonActiveCharacterClear.setText(bundle.getString("jButtonActiveCharacterClear.text"));
        this.jButtonActiveCharacterClear.setToolTipText(bundle.getString("jButtonActiveCharacterClear.toolTipText"));
        this.jButtonActiveCharacterClear.setEnabled(false);
        this.jButtonActiveCharacterClear.setMaximumSize(new Dimension(29, 29));
        this.jButtonActiveCharacterClear.setMinimumSize(new Dimension(29, 29));
        this.jButtonActiveCharacterClear.setName("jButtonActiveCharacterClear");
        this.jButtonActiveCharacterClear.setPreferredSize(new Dimension(29, 29));
        this.jButtonActiveCharacterClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SkyrimCharacterHelperView.this.actionPerformedButtonActiveClear(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 5);
        this.jPanelActive.add((Component)this.jButtonActiveCharacterClear, gridBagConstraints);
        this.jButtonActiveRescan.setIcon(resourceMap.getIcon("jButtonActiveRescan.icon"));
        this.jButtonActiveRescan.setText(bundle.getString("jButtonActiveRescan.text"));
        this.jButtonActiveRescan.setToolTipText(bundle.getString("jButtonActiveRescan.toolTipText"));
        this.jButtonActiveRescan.setEnabled(false);
        this.jButtonActiveRescan.setMaximumSize(new Dimension(29, 29));
        this.jButtonActiveRescan.setMinimumSize(new Dimension(29, 29));
        this.jButtonActiveRescan.setName("jButtonActiveRescan");
        this.jButtonActiveRescan.setPreferredSize(new Dimension(29, 29));
        this.jButtonActiveRescan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SkyrimCharacterHelperView.this.actionPerformedButtonActiveRescan(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 5);
        this.jPanelActive.add((Component)this.jButtonActiveRescan, gridBagConstraints);
        this.jButtonActivePath.setIcon(resourceMap.getIcon("jButtonActivePath.icon"));
        this.jButtonActivePath.setText(bundle.getString("jButtonActivePath.text"));
        this.jButtonActivePath.setToolTipText(bundle.getString("jButtonActivePath.toolTipText"));
        this.jButtonActivePath.setAlignmentX(0.2f);
        this.jButtonActivePath.setMaximumSize(new Dimension(29, 29));
        this.jButtonActivePath.setMinimumSize(new Dimension(29, 29));
        this.jButtonActivePath.setName("jButtonActivePath");
        this.jButtonActivePath.setPreferredSize(new Dimension(29, 29));
        this.jButtonActivePath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SkyrimCharacterHelperView.this.actionPerformedButtonActiveSelectDirectory(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 5);
        this.jPanelActive.add((Component)this.jButtonActivePath, gridBagConstraints);
        this.jScrollPaneActiveSaveFiles.setMinimumSize(new Dimension(260, 130));
        this.jScrollPaneActiveSaveFiles.setName("jScrollPaneActiveSaveFiles");
        this.jScrollPaneActiveSaveFiles.setPreferredSize(new Dimension(260, 130));
        this.jTableActiveSaveGames.setAutoCreateColumnsFromModel(false);
        this.jTableActiveSaveGames.setBackground(new Color(Integer.valueOf(bundle.getString("jList.background"), 16)));
        this.jTableActiveSaveGames.setForeground(new Color(Integer.valueOf(bundle.getString("jList.foreground"), 16)));
        this.jTableActiveSaveGames.setEnabled(false);
        this.jTableActiveSaveGames.setFillsViewportHeight(true);
        this.jTableActiveSaveGames.setFocusable(false);
        this.jTableActiveSaveGames.setIntercellSpacing(new Dimension(0, 0));
        this.jTableActiveSaveGames.setName("jTableActiveSaveGames");
        this.jTableActiveSaveGames.setRowHeight(25);
        this.jTableActiveSaveGames.setSelectionBackground(new Color(Integer.valueOf(bundle.getString("jList.selectionBackground"), 16)));
        this.jTableActiveSaveGames.setSelectionForeground(new Color(Integer.valueOf(bundle.getString("jList.selectionForeground"), 16)));
        this.jTableActiveSaveGames.setShowHorizontalLines(false);
        this.jTableActiveSaveGames.setShowVerticalLines(false);
        this.jTableActiveSaveGames.setUpdateSelectionOnSort(false);
        this.jScrollPaneActiveSaveFiles.setViewportView(this.jTableActiveSaveGames);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 10;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 400;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        this.jPanelActive.add((Component)this.jScrollPaneActiveSaveFiles, gridBagConstraints);
        this.jTextFieldActivePath.setBackground(new Color(Integer.valueOf(bundle.getString("displayTextfield.backgroundColor"), 16)));
        this.jTextFieldActivePath.setEditable(false);
        this.jTextFieldActivePath.setText(bundle.getString("jTextFieldActivePath.text"));
        this.jTextFieldActivePath.setMaximumSize(new Dimension(Integer.MAX_VALUE, 29));
        this.jTextFieldActivePath.setMinimumSize(new Dimension(150, 29));
        this.jTextFieldActivePath.setName("jTextFieldActivePath");
        this.jTextFieldActivePath.setPreferredSize(new Dimension(150, 29));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 5);
        this.jPanelActive.add((Component)this.jTextFieldActivePath, gridBagConstraints);
        this.jButtonActiveSaveGameBackup.setIcon(resourceMap.getIcon("jButtonActiveSaveGameBackup.icon"));
        this.jButtonActiveSaveGameBackup.setText(bundle.getString("jButtonActiveSaveGameRestore.text"));
        this.jButtonActiveSaveGameBackup.setToolTipText(bundle.getString("jButtonActiveSaveGameRestore.toolTipText"));
        this.jButtonActiveSaveGameBackup.setEnabled(false);
        this.jButtonActiveSaveGameBackup.setMaximumSize(new Dimension(29, 29));
        this.jButtonActiveSaveGameBackup.setMinimumSize(new Dimension(29, 29));
        this.jButtonActiveSaveGameBackup.setName("jButtonActiveSaveGameBackup");
        this.jButtonActiveSaveGameBackup.setPreferredSize(new Dimension(29, 29));
        this.jButtonActiveSaveGameBackup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SkyrimCharacterHelperView.this.actionPerformedButtonActiveSaveGameBackup(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 15;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 5);
        this.jPanelActive.add((Component)this.jButtonActiveSaveGameBackup, gridBagConstraints);
        this.jButtonActiveSaveGameDelete.setIcon(resourceMap.getIcon("jButtonActiveSaveGameDelete.icon"));
        this.jButtonActiveSaveGameDelete.setText(bundle.getString("jButtonActiveSaveGameDelete.text"));
        this.jButtonActiveSaveGameDelete.setToolTipText(bundle.getString("jButtonActiveSaveGameDelete.toolTipText"));
        this.jButtonActiveSaveGameDelete.setEnabled(false);
        this.jButtonActiveSaveGameDelete.setMaximumSize(new Dimension(29, 29));
        this.jButtonActiveSaveGameDelete.setMinimumSize(new Dimension(29, 29));
        this.jButtonActiveSaveGameDelete.setName("jButtonActiveSaveGameDelete");
        this.jButtonActiveSaveGameDelete.setPreferredSize(new Dimension(29, 29));
        this.jButtonActiveSaveGameDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SkyrimCharacterHelperView.this.actionPerformedButtonActiveSaveGameDelete(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 14;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 5);
        this.jPanelActive.add((Component)this.jButtonActiveSaveGameDelete, gridBagConstraints);
        this.jPanelActiveCharacterData.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelActiveCharacterData.setAlignmentX(0.3f);
        this.jPanelActiveCharacterData.setMaximumSize(new Dimension(520, Short.MAX_VALUE));
        this.jPanelActiveCharacterData.setName("jPanelActiveCharacterData");
        this.jPanelActiveCharacterData.setPreferredSize(new Dimension(349, 263));
        GroupLayout jPanelActiveCharacterDataLayout = new GroupLayout(this.jPanelActiveCharacterData);
        this.jPanelActiveCharacterData.setLayout(jPanelActiveCharacterDataLayout);
        jPanelActiveCharacterDataLayout.setHorizontalGroup(jPanelActiveCharacterDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 410, Short.MAX_VALUE));
        jPanelActiveCharacterDataLayout.setVerticalGroup(jPanelActiveCharacterDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 296, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 17;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 410;
        gridBagConstraints.ipady = 200;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        this.jPanelActive.add((Component)this.jPanelActiveCharacterData, gridBagConstraints);
        this.jButtonActiveClipboard.setIcon(resourceMap.getIcon("jButtonActiveClipboard.icon"));
        this.jButtonActiveClipboard.setText(bundle.getString("jButtonActiveClipboard.text"));
        this.jButtonActiveClipboard.setToolTipText(bundle.getString("jButtonActiveClipboard.toolTipText"));
        this.jButtonActiveClipboard.setEnabled(false);
        this.jButtonActiveClipboard.setMaximumSize(new Dimension(29, 29));
        this.jButtonActiveClipboard.setMinimumSize(new Dimension(29, 29));
        this.jButtonActiveClipboard.setName("jButtonActiveClipboard");
        this.jButtonActiveClipboard.setPreferredSize(new Dimension(29, 29));
        this.jButtonActiveClipboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SkyrimCharacterHelperView.this.actionPerformedButtonActiveClipboard(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 16;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        this.jPanelActive.add((Component)this.jButtonActiveClipboard, gridBagConstraints);
        this.jTextFieldAmountActive.setBackground(new Color(Integer.valueOf(bundle.getString("displayTextfield.backgroundColor"), 16)));
        this.jTextFieldAmountActive.setEditable(false);
        this.jTextFieldAmountActive.setText(bundle.getString("jTextFieldAmountActive.text"));
        this.jTextFieldAmountActive.setMaximumSize(new Dimension(60, 29));
        this.jTextFieldAmountActive.setMinimumSize(new Dimension(60, 29));
        this.jTextFieldAmountActive.setName("jTextFieldAmountActive");
        this.jTextFieldAmountActive.setPreferredSize(new Dimension(60, 29));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 5);
        this.jPanelActive.add((Component)this.jTextFieldAmountActive, gridBagConstraints);
        this.jButtonActiveCharacterLaunch.setIcon(resourceMap.getIcon("jButtonActiveCharacterLaunch.icon"));
        this.jButtonActiveCharacterLaunch.setText(bundle.getString("jButtonActiveCharacterLaunch.text"));
        this.jButtonActiveCharacterLaunch.setToolTipText(bundle.getString("jButtonActiveCharacterLaunch.toolTipText"));
        this.jButtonActiveCharacterLaunch.setEnabled(false);
        this.jButtonActiveCharacterLaunch.setMaximumSize(new Dimension(29, 29));
        this.jButtonActiveCharacterLaunch.setMinimumSize(new Dimension(29, 29));
        this.jButtonActiveCharacterLaunch.setName("jButtonActiveCharacterLaunch");
        this.jButtonActiveCharacterLaunch.setPreferredSize(new Dimension(29, 29));
        this.jButtonActiveCharacterLaunch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SkyrimCharacterHelperView.this.actionPerformedButtonActiveLaunchPlayer(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 10, 5);
        this.jPanelActive.add((Component)this.jButtonActiveCharacterLaunch, gridBagConstraints);
        this.jTextFieldRaceActivePlayer.setBackground(new Color(Integer.valueOf(bundle.getString("displayTextfield.backgroundColor"), 16)));
        this.jTextFieldRaceActivePlayer.setEditable(false);
        this.jTextFieldRaceActivePlayer.setText(bundle.getString("jTextFieldRaceActivePlayer.text"));
        this.jTextFieldRaceActivePlayer.setMaximumSize(new Dimension(Integer.MAX_VALUE, 29));
        this.jTextFieldRaceActivePlayer.setMinimumSize(new Dimension(100, 29));
        this.jTextFieldRaceActivePlayer.setName("jTextFieldRaceActivePlayer");
        this.jTextFieldRaceActivePlayer.setPreferredSize(new Dimension(100, 29));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        this.jPanelActive.add((Component)this.jTextFieldRaceActivePlayer, gridBagConstraints);
        this.jButtonActiveLaunchSavegame.setIcon(resourceMap.getIcon("jButtonActiveLaunchSavegame.icon"));
        this.jButtonActiveLaunchSavegame.setText(bundle.getString("jButtonActiveLaunchSavegame.text"));
        this.jButtonActiveLaunchSavegame.setToolTipText(bundle.getString("jButtonActiveLaunchSavegame.toolTipText"));
        this.jButtonActiveLaunchSavegame.setEnabled(false);
        this.jButtonActiveLaunchSavegame.setMaximumSize(new Dimension(29, 29));
        this.jButtonActiveLaunchSavegame.setMinimumSize(new Dimension(29, 29));
        this.jButtonActiveLaunchSavegame.setName("jButtonActiveLaunchSavegame");
        this.jButtonActiveLaunchSavegame.setPreferredSize(new Dimension(29, 29));
        this.jButtonActiveLaunchSavegame.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SkyrimCharacterHelperView.this.actionPerformedButtonLaunchActiveSavegame(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 13;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 5);
        this.jPanelActive.add((Component)this.jButtonActiveLaunchSavegame, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(18, 10, 0, 10);
        this.getContentPane().add((Component)this.jPanelActive, gridBagConstraints);
        this.pack();
    }

    private void actionPerformedButtonProcessExit(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonExit();
        }
    }

    private void actionPerformedButtonProcessCancel(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonProcessCancel();
        }
    }

    private void actionPerformedButtonBackupClipboard(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonBackupClipboard();
        }
    }

    private void actionPerformedButtonBackupSaveGameDelete(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonBackupDeleteSaveGame();
        }
    }

    private void actionPerformedButtonBackupSaveGameRestore(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonBackupSaveGameRestore();
        }
    }

    private void actionPerformedButtonActiveClipboard(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonActiveClipboard();
        }
    }

    private void actionPerformedButtonActiveSelectDirectory(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonSelectActivePath();
        }
    }

    private void actionPerformedButtonBackupSelectDirectory(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonSelectBackupPath();
        }
    }

    private void actionPerformedButtonActiveRescan(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonSelectActiveRescan(null, true);
        }
    }

    private void actionPerformedButtonBackupRescan(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonSelectBackupRescan();
        }
    }

    private void actionPerformedButtonActiveClear(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonActiveClearPlayers();
        }
    }

    private void actionPerformedButtonBackupClear(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonBackupClearPlayers();
        }
    }

    private void actionPerformedButtonActiveDelete(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonActiveDeletePlayer();
        }
    }

    private void actionPerformedButtonBackupDelete(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonBackupDeletePlayer();
        }
    }

    private void actionPerformedButtonActiveBackupPlayer(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonActiveBackupPlayer();
        }
    }

    private void actionPerformedButtonBackupPlayerRestore(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonBackupPlayerRestore();
        }
    }

    private void actionPerformedButtonActiveSaveGameBackup(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonActiveBackupSaveGame();
        }
    }

    private void actionPerformedButtonActiveSaveGameDelete(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonActiveDeleteSaveGame();
        }
    }

    private void actionPerformedButtonAbout(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonAbout();
        }
    }

    private void actionPerformedButtonActiveLaunchPlayer(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonActiveLaunchPlayer();
        }
    }

    private void actionPerformedButtonBackupLaunchPlayer(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonBackupLaunchPlayer();
        }
    }

    private void actionPerformedButtonChooseBinary(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonChooseBinary();
        }
    }

    private void actionPerformedButtonRestoreRegistry(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonRestoreLaunchPath();
        }
    }

    private void actionPerformedButtonLaunchSolo(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonLaunchSolo();
        }
    }

    private void actionPerformedComboBoxImageMode(ActionEvent evt) {
        this.setImageModeDisplay(0 == this.getImageMode());
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleComboBoxImageMode();
        }
    }

    private void actionPerformedButtonLaunchActiveSavegame(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonActiveLaunchSaveGame();
        }
    }

    private void actionPerformedButtonLaunchBackupSavegame(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonBackupLaunchSaveGame();
        }
    }

    @Override
    public void mouseClicked(MouseEvent pa_tEvent) {
        int lc_iIndex = -1;
        int lc_iFirstSelection = -1;
        if (this.m_bLocked) {
            return;
        }
        if (null != pa_tEvent) {
            if (pa_tEvent.getSource() == this.jTableActiveSaveGames.getTableHeader()) {
                lc_iIndex = this.jTableActiveSaveGames.convertColumnIndexToModel(this.jTableActiveSaveGames.columnAtPoint(pa_tEvent.getPoint()));
                if (0 <= lc_iIndex && lc_iIndex < 4 && -1 != (lc_iFirstSelection = this.jTableActiveSaveGames.getSelectedRow()) && null != this.m_tStoredActiveSaveGameSelection) {
                    this.restoreSaveGameSelection(true, false);
                }
            } else if (pa_tEvent.getSource() == this.jTableBackupSaveGames.getTableHeader() && 0 <= (lc_iIndex = this.jTableBackupSaveGames.convertColumnIndexToModel(this.jTableBackupSaveGames.columnAtPoint(pa_tEvent.getPoint()))) && lc_iIndex < 4 && -1 != (lc_iFirstSelection = this.jTableBackupSaveGames.getSelectedRow()) && null != this.m_tStoredBackupSaveGameSelection) {
                this.restoreSaveGameSelection(false, false);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent pa_tEvent) {
    }

    @Override
    public void mouseExited(MouseEvent pa_tEvent) {
    }

    @Override
    public void mousePressed(MouseEvent pa_tEvent) {
        int lc_iIndex = -1;
        int lc_iFirstSelection = -1;
        if (this.m_bLocked) {
            return;
        }
        if (null != pa_tEvent) {
            if (pa_tEvent.getSource() == this.jTableActiveSaveGames.getTableHeader()) {
                lc_iIndex = this.jTableActiveSaveGames.convertColumnIndexToModel(this.jTableActiveSaveGames.columnAtPoint(pa_tEvent.getPoint()));
                if (0 <= lc_iIndex && lc_iIndex < 4 && -1 != (lc_iFirstSelection = this.jTableActiveSaveGames.getSelectedRow())) {
                    this.storeSaveGameSelection(true);
                }
            } else if (pa_tEvent.getSource() == this.jTableBackupSaveGames.getTableHeader() && 0 <= (lc_iIndex = this.jTableBackupSaveGames.convertColumnIndexToModel(this.jTableBackupSaveGames.columnAtPoint(pa_tEvent.getPoint()))) && lc_iIndex < 4 && -1 != (lc_iFirstSelection = this.jTableBackupSaveGames.getSelectedRow())) {
                this.storeSaveGameSelection(false);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent pa_tEvent) {
        int lc_iIndex = -1;
        int lc_iColumn = -1;
        int lc_iRow = -1;
        if (this.m_bLocked) {
            return;
        }
        if (null != pa_tEvent && null != this.m_tGuiConnector) {
            if (pa_tEvent.getSource() == this.jTableActiveSaveGames.getTableHeader()) {
                return;
            }
            if (pa_tEvent.getSource() == this.jTableBackupSaveGames.getTableHeader()) {
                return;
            }
            if (pa_tEvent.getSource() == this.jListActiveCharacters && -1 != (lc_iIndex = this.jListActiveCharacters.locationToIndex(pa_tEvent.getPoint())) && lc_iIndex < this.jListActiveCharacters.getModel().getSize()) {
                this.m_tGuiConnector.handleListSelectionActivePlayers();
            }
            if (pa_tEvent.getSource() == this.jListBackupCharacters && -1 != (lc_iIndex = this.jListBackupCharacters.locationToIndex(pa_tEvent.getPoint())) && lc_iIndex < this.jListBackupCharacters.getModel().getSize()) {
                this.m_tGuiConnector.handleListSelectionBackupPlayers();
            }
            if (pa_tEvent.getSource() == this.jTableActiveSaveGames && null != pa_tEvent.getPoint()) {
                lc_iRow = this.jTableActiveSaveGames.rowAtPoint(pa_tEvent.getPoint());
                lc_iColumn = this.jTableActiveSaveGames.columnAtPoint(pa_tEvent.getPoint());
                if (0 <= lc_iRow && lc_iRow < this.jTableActiveSaveGames.getModel().getRowCount() && 0 <= lc_iColumn && lc_iColumn < this.jTableActiveSaveGames.getModel().getColumnCount() && -1 != (lc_iIndex = this.jTableActiveSaveGames.convertRowIndexToModel(lc_iRow))) {
                    this.m_tGuiConnector.handleListSelectionActiveSaveGames();
                }
            }
            if (pa_tEvent.getSource() == this.jTableBackupSaveGames && null != pa_tEvent.getPoint()) {
                lc_iRow = this.jTableBackupSaveGames.rowAtPoint(pa_tEvent.getPoint());
                lc_iColumn = this.jTableBackupSaveGames.columnAtPoint(pa_tEvent.getPoint());
                if (0 <= lc_iRow && lc_iRow < this.jTableBackupSaveGames.getModel().getRowCount() && 0 <= lc_iColumn && lc_iColumn < this.jTableBackupSaveGames.getModel().getColumnCount() && -1 != (lc_iIndex = this.jTableBackupSaveGames.convertRowIndexToModel(lc_iRow))) {
                    this.m_tGuiConnector.handleListSelectionBackupSaveGames();
                }
            }
        }
    }

    private boolean checkForWindows() {
        String lc_sOs = System.getProperty("os.name");
        if (null != lc_sOs) {
            return lc_sOs.toUpperCase().startsWith("WINDOWS");
        }
        return false;
    }

    public final void selectActivePlayer(SkyrimCharacterHelperPlayer pa_tPlayer) {
        SkyrimCharacterHelperPlayer lc_tPlayer = null;
        SkyrimCharacterHelperListModel lc_tModel = (SkyrimCharacterHelperListModel)this.jListActiveCharacters.getModel();
        SkyrimCharacterHelperSaveGame[] lc_tSaveGames = null;
        Object[] lc_tEntries = null;
        int lc_iPos = 0;
        if (null != pa_tPlayer && null != lc_tModel && null != (lc_tEntries = lc_tModel.elements())) {
            for (Object lc_tObject : lc_tEntries) {
                if (!(lc_tObject instanceof SkyrimCharacterHelperPlayer) || null == (lc_tPlayer = (SkyrimCharacterHelperPlayer)lc_tObject)) continue;
                if (lc_tPlayer.equals(pa_tPlayer)) break;
                ++lc_iPos;
            }
            if (-1 != lc_iPos) {
                this.jListActiveCharacters.getSelectionModel().clearSelection();
                this.jListActiveCharacters.setSelectedIndex(lc_iPos);
                lc_tSaveGames = pa_tPlayer.getSaveGames();
                if (null != lc_tSaveGames) {
                    this.initSaveGameList(lc_tSaveGames, true, false);
                }
            }
        }
    }

    private void removeArrowKeysFromList(JList pa_tList) {
        InputMap lc_tInputMap;
        KeyStroke lc_tKeyRemove1 = KeyStroke.getKeyStroke(38, 0);
        KeyStroke lc_tKeyRemove2 = KeyStroke.getKeyStroke(40, 0);
        InputMap inputMap = lc_tInputMap = null != pa_tList ? pa_tList.getInputMap() : null;
        if (null != lc_tInputMap && null != lc_tKeyRemove1 && null != lc_tKeyRemove2) {
            lc_tInputMap.put(lc_tKeyRemove1, "none");
            lc_tInputMap.put(lc_tKeyRemove2, "none");
        }
    }

    private void removeArrowKeysFromTable(JTable pa_tTable) {
        InputMap lc_tInputMap;
        KeyStroke lc_tKeyRemove1 = KeyStroke.getKeyStroke(38, 0);
        KeyStroke lc_tKeyRemove2 = KeyStroke.getKeyStroke(40, 0);
        InputMap inputMap = lc_tInputMap = null != pa_tTable ? pa_tTable.getInputMap(1) : null;
        if (null != lc_tInputMap && null != lc_tKeyRemove1 && null != lc_tKeyRemove2) {
            lc_tInputMap.put(lc_tKeyRemove1, "none");
            lc_tInputMap.put(lc_tKeyRemove2, "none");
        }
    }

    public final boolean hasOneActivePlayer() {
        return 1 == this.getListSize(this.jListActiveCharacters);
    }

    public final boolean hasOneActiveSaveGame() {
        return 1 == this.getTableSize(this.jTableActiveSaveGames);
    }

    public final List disableTableRowSorter(JTable pa_tTable) {
        TableRowSorter lc_tRowSorter = null != pa_tTable ? (TableRowSorter)pa_tTable.getRowSorter() : null;
        List<RowSorter.SortKey> lc_tSortKeys = null;
        if (lc_tRowSorter != null) {
            lc_tSortKeys = lc_tRowSorter.getSortKeys();
            lc_tRowSorter.setSortsOnUpdates(false);
        }
        return lc_tSortKeys;
    }

    public final void enableTableRowSorter(JTable pa_tTable, List pa_tSortKeys) {
        if (pa_tSortKeys != null) {
            TableRowSorter lc_tRowSorter;
            TableRowSorter tableRowSorter = lc_tRowSorter = null != pa_tTable ? (TableRowSorter)pa_tTable.getRowSorter() : null;
            if (null != lc_tRowSorter) {
                lc_tRowSorter.setSortsOnUpdates(true);
                lc_tRowSorter.setSortKeys(pa_tSortKeys);
            }
        }
    }

    public final String getHeaderArrangement(boolean pa_bMode) {
        JTable lc_tTable = true == pa_bMode ? this.jTableActiveSaveGames : this.jTableBackupSaveGames;
        StringBuffer lc_tStringBuffer = new StringBuffer();
        int lc_iI = 0;
        int lc_iModelIndex = 0;
        if (null != lc_tStringBuffer && null != lc_tTable) {
            for (lc_iI = 0; lc_iI < 4; ++lc_iI) {
                lc_iModelIndex = lc_tTable.convertColumnIndexToModel(lc_iI);
                lc_tStringBuffer.append(Integer.toString(lc_iModelIndex));
            }
        }
        return null != lc_tStringBuffer ? lc_tStringBuffer.toString() : "0123";
    }

    public final String getSortOrder(boolean pa_bMode) {
        JTable lc_tTable = true == pa_bMode ? this.jTableActiveSaveGames : this.jTableBackupSaveGames;
        SortOrder lc_tSortOrder = SortOrder.ASCENDING;
        StringBuffer lc_tStringBuffer = new StringBuffer();
        List<RowSorter.SortKey> lc_tSortKeys = null;
        int lc_iColumn = 0;
        boolean lc_bOk = false;
        if (null != lc_tTable && null != lc_tStringBuffer && null != lc_tTable && null != lc_tTable.getRowSorter() && null != (lc_tSortKeys = lc_tTable.getRowSorter().getSortKeys())) {
            lc_iColumn = lc_tSortKeys.get(0).getColumn();
            lc_tSortOrder = lc_tSortKeys.get(0).getSortOrder();
            lc_tStringBuffer.append(Integer.toString(lc_iColumn));
            if (lc_tSortOrder == SortOrder.ASCENDING) {
                lc_tStringBuffer.append(Integer.toString(0));
            } else if (lc_tSortOrder == SortOrder.DESCENDING) {
                lc_tStringBuffer.append(Integer.toString(1));
            } else if (lc_tSortOrder == SortOrder.UNSORTED) {
                lc_tStringBuffer.append(Integer.toString(2));
            }
            lc_bOk = true;
        }
        return true == lc_bOk ? lc_tStringBuffer.toString() : "00";
    }

    private String checkHeaderArrangement(String pa_sInput) {
        boolean lc_b0 = false;
        boolean lc_b1 = false;
        boolean lc_b2 = false;
        boolean lc_b3 = false;
        boolean lc_b4 = false;
        if (null != pa_sInput && 4 == pa_sInput.length()) {
            lc_b0 = -1 != pa_sInput.indexOf("0");
            lc_b1 = -1 != pa_sInput.indexOf("1");
            lc_b2 = -1 != pa_sInput.indexOf("2");
            lc_b3 = -1 != pa_sInput.indexOf("3");
        }
        return true == (lc_b4 = lc_b0 & lc_b1 & lc_b2 & lc_b3) ? pa_sInput : "0123";
    }

    private String checkSortOrder(String pa_sInput) {
        boolean lc_bOk = false;
        int lc_i1 = 0;
        int lc_i2 = 0;
        if (null != pa_sInput && 2 == pa_sInput.length()) {
            lc_i1 = Character.digit(pa_sInput.charAt(0), 10);
            lc_i2 = Character.digit(pa_sInput.charAt(1), 10);
            if (0 <= lc_i1 && lc_i1 < 4 && (lc_i2 == 0 || lc_i2 == 1 || lc_i2 == 2)) {
                lc_bOk = true;
            }
        }
        return true == lc_bOk ? pa_sInput : "00";
    }

    private int setSortOrder(TableRowSorter<TableModel> pa_tRowSorter, String pa_sValue, JTable pa_tTable) {
        ArrayList<RowSorter.SortKey> lc_tSortKeys = new ArrayList<RowSorter.SortKey>();
        SortOrder lc_tSortOrder = SortOrder.ASCENDING;
        int lc_iColumn = 0;
        int lc_iSortOrder = 0;
        if (null != pa_sValue && null != pa_tRowSorter && 2 == pa_sValue.length()) {
            lc_iColumn = Character.digit(pa_sValue.charAt(0), 10);
            lc_iSortOrder = Character.digit(pa_sValue.charAt(1), 10);
            switch (lc_iSortOrder) {
                case 0: {
                    lc_tSortOrder = SortOrder.ASCENDING;
                    break;
                }
                case 1: {
                    lc_tSortOrder = SortOrder.DESCENDING;
                    break;
                }
                default: {
                    lc_tSortOrder = SortOrder.UNSORTED;
                }
            }
            if (null != lc_tSortKeys) {
                lc_tSortKeys.add(new RowSorter.SortKey(lc_iColumn, lc_tSortOrder));
                pa_tRowSorter.setSortKeys(lc_tSortKeys);
                pa_tRowSorter.toggleSortOrder(lc_iColumn);
                pa_tRowSorter.toggleSortOrder(lc_iColumn);
            }
        }
        return lc_iColumn;
    }

    public final void setActivePlayerRace(String pa_sRace) {
        this.jTextFieldRaceActivePlayer.setText(pa_sRace);
        this.jTextFieldRaceActivePlayer.setCaretPosition(0);
    }

    public final void setBackupPlayerRace(String pa_sRace) {
        this.jTextFieldRaceBackupPlayer.setText(pa_sRace);
        this.jTextFieldRaceBackupPlayer.setCaretPosition(0);
    }

    public final synchronized void restoreSaveGameSelection(boolean pa_bMode, boolean pa_bNotify) {
        if (pa_bMode) {
            this.reselectSaveGames(this.m_tStoredActiveSaveGameSelection, true, pa_bNotify);
        } else {
            this.reselectSaveGames(this.m_tStoredBackupSaveGameSelection, false, pa_bNotify);
        }
    }

    public final synchronized void restorePlayerSelection(boolean pa_bMode) {
        if (pa_bMode) {
            this.reselectPlayers(this.m_tStoredActivePlayerSelection, true);
        } else {
            this.reselectPlayers(this.m_tStoredBackupPlayerSelection, false);
        }
    }

    public final synchronized void storeSaveGameSelection(boolean pa_bMode) {
        if (pa_bMode) {
            this.m_tStoredActiveSaveGameSelection = this.getSelectedActiveSaveGames();
        } else {
            this.m_tStoredBackupSaveGameSelection = this.getSelectedBackupSaveGames();
        }
    }

    public final synchronized void storePlayerSelection(boolean pa_bMode) {
        if (pa_bMode) {
            this.m_tStoredActivePlayerSelection = this.getSelectedActivePlayers();
        } else {
            this.m_tStoredBackupPlayerSelection = this.getSelectedBackupPlayers();
        }
    }

    public final void setImageModeDisplay(boolean pa_bMode) {
        this.jPanelActiveCharacterData.setVisible(pa_bMode);
        this.jPanelBackupCharacterData.setVisible(pa_bMode);
    }

    public final String getPrefix() {
        String lc_sText = this.jTextFieldPrefix.getText();
        return null != lc_sText ? lc_sText.trim() : null;
    }

    public final void setPrefix(String pa_sValue) {
        this.jTextFieldPrefix.setText(pa_sValue);
        this.jTextFieldPrefix.setCaretPosition(0);
    }

    @Override
    public void changedUpdate(DocumentEvent pa_tEvent) {
        this.updateUIElements();
    }

    @Override
    public void removeUpdate(DocumentEvent pa_tEvent) {
        this.updateUIElements();
    }

    @Override
    public void insertUpdate(DocumentEvent pa_tEvent) {
        this.updateUIElements();
    }

    public final void setOnSkyrim(boolean pa_bState) {
        this.jLabelOnSkyrim.setEnabled(pa_bState);
        this.jLabelOnSkyrim.setBackground(true == pa_bState ? this.m_tLabelOnSkyrimActiveBg : this.m_tLabelOnSkyrimNormalBg);
        this.jLabelOnSkyrim.setText(true == pa_bState ? this.m_tMonitoringDisplays[1] : this.m_tMonitoringDisplays[0]);
    }

    public final void ensureSaveGameSelectionIsVisible(boolean pa_bMode) {
        int lc_iIndex;
        JTable lc_tTable = true == pa_bMode ? this.jTableActiveSaveGames : this.jTableBackupSaveGames;
        int n = lc_iIndex = null != lc_tTable ? lc_tTable.getSelectedRow() : -1;
        if (-1 != lc_iIndex) {
            lc_tTable.scrollRectToVisible(new Rectangle(lc_tTable.getCellRect(lc_iIndex, 0, true)));
        }
    }

    public final void removeSaveGameSelections(boolean pa_bMode) {
        JTable lc_tTable;
        JTable jTable = lc_tTable = true == pa_bMode ? this.jTableActiveSaveGames : this.jTableBackupSaveGames;
        if (null != lc_tTable && null != lc_tTable.getSelectionModel()) {
            lc_tTable.getSelectionModel().clearSelection();
        }
        if (pa_bMode) {
            this.setActiveSaveGameScreenshot(null);
        } else {
            this.setBackupSaveGameScreenshot(null);
        }
    }

    private class SaveGameComparator
    implements Comparator<SkyrimCharacterHelperSaveGame> {
        private Collator m_tCollator = Collator.getInstance();
        private int m_iColumn;

        public SaveGameComparator(int pa_iColumn) {
            this.m_tCollator.setStrength(2);
            this.m_iColumn = pa_iColumn;
        }

        @Override
        public int compare(SkyrimCharacterHelperSaveGame o1, SkyrimCharacterHelperSaveGame o2) {
            if (null == o1 && null == o2) {
                return 0;
            }
            if (null == o1) {
                return -1;
            }
            if (null == o2) {
                return 1;
            }
            try {
                switch (this.m_iColumn) {
                    case 0: {
                        if (o1.getPlayerLevel() < o2.getPlayerLevel()) {
                            return -1;
                        }
                        if (o1.getPlayerLevel() == o2.getPlayerLevel()) {
                            return 0;
                        }
                        return 1;
                    }
                    case 1: {
                        if (null == o1.getPlayerLocation()) {
                            return -1;
                        }
                        if (null == o2.getPlayerLocation()) {
                            return 1;
                        }
                        return null != this.m_tCollator ? this.m_tCollator.compare(o1.getPlayerLocation(), o2.getPlayerLocation()) : 0;
                    }
                    case 2: {
                        if (o1.getFileDate() < o2.getFileDate()) {
                            return -1;
                        }
                        if (o1.getFileDate() == o2.getFileDate()) {
                            return 0;
                        }
                        return 1;
                    }
                    case 3: {
                        return null != this.m_tCollator ? this.m_tCollator.compare(o1.getFileName(), o2.getFileName()) : 0;
                    }
                }
                return null != this.m_tCollator ? this.m_tCollator.compare(o1.toString(), o2.toString()) : 0;
            }
            catch (Exception lc_tException) {
                return 0;
            }
        }
    }
}

