/*
 * Decompiled with CFR 0.152.
 */
package skyrimcharacterhelper;

import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import skyrimcharacterhelper.SkyrimCharacterHelperSaveGame;
import skyrimcharacterhelper.SkyrimCharacterHelperThreadNotifier;

public class SkyrimCharacterHelperDirectorySnifferThread
extends Thread
implements LineListener {
    private String m_sDirectory;
    private String m_sSeparator;
    private String m_sPrefix;
    private File m_tDirectory;
    private WatchService m_tWatchService;
    private WatchKey m_tWatchKey;
    private boolean m_bCopyAutoSaves;
    private boolean m_bCopyQuickSaves;
    private boolean m_bRunning;
    private boolean m_bSoundLoaded;
    private SkyrimCharacterHelperThreadNotifier m_tNotifier;
    private byte[] m_tSoundClipArray;
    private Clip m_tClip;
    private AudioInputStream m_tAudioInputStream;
    private InputStream m_tInputStream;
    private InputStream m_tBufferedInputStream;

    public SkyrimCharacterHelperDirectorySnifferThread(SkyrimCharacterHelperThreadNotifier pa_tNotifier, String pa_sPrefix, String pa_sDirectory, boolean pa_bCopyAutoSaves, boolean pa_bCopyQuickSaves) {
        this.m_sDirectory = pa_sDirectory;
        this.m_bRunning = false;
        this.m_sPrefix = pa_sPrefix;
        this.m_sSeparator = System.getProperty("file.separator");
        this.m_tDirectory = new File(pa_sDirectory);
        this.m_tWatchKey = null;
        this.m_tWatchService = null;
        this.m_tSoundClipArray = null;
        this.m_tClip = null;
        this.m_tAudioInputStream = null;
        this.m_tInputStream = null;
        this.m_tBufferedInputStream = null;
        this.m_bCopyAutoSaves = pa_bCopyAutoSaves;
        this.m_bCopyQuickSaves = pa_bCopyQuickSaves;
        this.m_tNotifier = pa_tNotifier;
    }

    public final boolean isRunning() {
        return this.m_bRunning;
    }

    public final void terminate() {
        this.m_bRunning = false;
    }

    private void goToSleep(long pa_lTime) {
        try {
            SkyrimCharacterHelperDirectorySnifferThread.sleep(pa_lTime);
        }
        catch (InterruptedException lc_tException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public final void run() {
        boolean lc_bContinue = false;
        Path lc_tPath = null;
        Path lc_tPathContext = null;
        String lc_sFileName = null;
        List<WatchEvent<?>> lc_tEvents = null;
        WatchEvent.Kind<?> lc_tKind = null;
        if (null != this.m_tDirectory && this.m_tDirectory.isDirectory() && this.m_tDirectory.canWrite() && this.m_tDirectory.canRead()) {
            lc_bContinue = true;
        }
        if (lc_bContinue) {
            lc_bContinue = false;
            lc_tPath = this.m_tDirectory.toPath();
            if (null != lc_tPath) {
                try {
                    this.m_tWatchService = lc_tPath.getFileSystem().newWatchService();
                    if (null != this.m_tWatchService) {
                        lc_tPath.register(this.m_tWatchService, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                        lc_bContinue = true;
                    }
                }
                catch (IOException lc_tException) {
                    lc_tPath = null;
                }
            }
        }
        this.m_bSoundLoaded = this.readSoundFile();
        if (lc_bContinue) {
            this.m_bRunning = true;
            while (this.m_bRunning) {
                try {
                    if (null != this.m_tWatchService) {
                        this.m_tWatchKey = this.m_tWatchService.take();
                    }
                }
                catch (InterruptedException lc_tException) {
                }
                catch (Exception lc_tException) {
                    // empty catch block
                }
                if (null == this.m_tWatchKey || !this.m_tWatchKey.isValid()) continue;
                lc_tEvents = null;
                lc_tEvents = this.m_tWatchKey.pollEvents();
                if (null == lc_tEvents) continue;
                this.m_tWatchKey.reset();
                if (0 >= lc_tEvents.size()) continue;
                for (WatchEvent<?> lc_tWatchEvent : lc_tEvents) {
                    if (null == lc_tWatchEvent) continue;
                    lc_tKind = lc_tWatchEvent.kind();
                    lc_tPathContext = (Path)lc_tWatchEvent.context();
                    lc_sFileName = lc_tPathContext.toString();
                    if (!lc_sFileName.toLowerCase().endsWith(".ess") && !lc_sFileName.toLowerCase().endsWith(".ess.bak")) continue;
                    if (lc_tKind.equals(StandardWatchEventKinds.ENTRY_MODIFY)) {
                        if (null != this.m_tNotifier) {
                            this.m_tNotifier.notifySkyrimSavegameModified(lc_sFileName);
                        }
                        if (lc_sFileName.endsWith(".ess.bak") || (!this.m_bCopyAutoSaves || !lc_sFileName.startsWith("autosave")) && (!this.m_bCopyQuickSaves || !lc_sFileName.startsWith("quicksave"))) continue;
                        this.checkCreateSavegame(lc_sFileName);
                        continue;
                    }
                    if (!lc_tKind.equals(StandardWatchEventKinds.ENTRY_DELETE) || null == this.m_tNotifier) continue;
                    this.m_tNotifier.notifySkyrimSavegameDeleted(lc_sFileName);
                }
            }
        }
        if (null != this.m_tWatchKey) {
            try {
                if (this.m_tWatchKey.isValid()) {
                    this.m_tWatchKey.cancel();
                }
            }
            catch (Exception lc_tException) {
                // empty catch block
            }
        }
        if (null != this.m_tWatchService) {
            try {
                this.m_tWatchService.close();
            }
            catch (Exception lc_tException) {
                // empty catch block
            }
        }
    }

    private void checkCreateSavegame(String pa_sFileName) {
        SkyrimCharacterHelperSaveGame lc_tSaveGame = null;
        String lc_sFullPath = null;
        String lc_sSaveGamePath = null;
        String lc_sNewSaveGamePath = null;
        String lc_sPlayerName = null;
        String lc_sPlayerLocation = null;
        String lc_sGameDate = null;
        String lc_sGameNumber = null;
        String lc_sNewGameNumber = null;
        File[] lc_tFiles = null;
        int lc_iMaxNum = 0;
        int lc_iSubStartPos = -1;
        int lc_iSubEndPos = -1;
        int lc_iStartPos = -1;
        int lc_iEndPos = -1;
        int lc_iGameNumber = 0;
        int lc_iNewGameNumber = 0;
        if (null != pa_sFileName) {
            lc_sFullPath = this.m_sDirectory + this.m_sSeparator + pa_sFileName;
            lc_tSaveGame = new SkyrimCharacterHelperSaveGame();
            if (null != lc_tSaveGame && lc_tSaveGame.read(lc_sFullPath, null, true)) {
                lc_sPlayerName = lc_tSaveGame.getPlayerName();
                lc_sPlayerLocation = lc_tSaveGame.getPlayerLocation();
                lc_sGameDate = lc_tSaveGame.getGameDate();
                lc_tFiles = this.m_tDirectory.listFiles();
                if (null != lc_tFiles) {
                    for (File lc_tFile : lc_tFiles) {
                        if (null == lc_tFile || null == (lc_sSaveGamePath = lc_tFile.getName()) || -1 == (lc_iEndPos = lc_sSaveGamePath.indexOf(lc_sPlayerName)) || -1 == (lc_iStartPos = lc_sSaveGamePath.indexOf(this.m_sPrefix))) continue;
                        lc_iSubStartPos = lc_iStartPos + this.m_sPrefix.length() + 1;
                        lc_iSubEndPos = lc_iEndPos - 3;
                        if (0 > lc_iStartPos || 0 > lc_iSubEndPos || lc_iSubStartPos >= lc_sSaveGamePath.length() || lc_iSubEndPos >= lc_sSaveGamePath.length()) continue;
                        try {
                            lc_sGameNumber = lc_sSaveGamePath.substring(lc_iSubStartPos, lc_iSubEndPos);
                            if (null == lc_sGameNumber) continue;
                            if (null == lc_sGameNumber) {
                                lc_sGameNumber = "1";
                            }
                            if (lc_sGameNumber.isEmpty()) {
                                lc_sGameNumber = "1";
                            }
                            if ((lc_iGameNumber = Integer.valueOf(lc_sGameNumber).intValue()) <= lc_iMaxNum) continue;
                            lc_iMaxNum = lc_iGameNumber;
                        }
                        catch (Exception lc_tException) {
                            // empty catch block
                        }
                    }
                    try {
                        lc_iNewGameNumber = 0x7FFFFFFE > lc_iMaxNum ? lc_iMaxNum + 1 : 1;
                        lc_sNewGameNumber = Integer.toString(lc_iNewGameNumber);
                    }
                    catch (Exception lc_tException) {
                        lc_iNewGameNumber = 1;
                    }
                    if (null != lc_sGameDate) {
                        if (!lc_sGameDate.startsWith("00.") && lc_sGameDate.startsWith("00")) {
                            lc_sGameDate = lc_sGameDate.substring(1);
                        }
                        if (lc_sGameDate.startsWith("0") && !lc_sGameDate.startsWith("00")) {
                            lc_sGameDate = lc_sGameDate.substring(1);
                        }
                    }
                    if (this.copyFile(lc_sFullPath, lc_sNewSaveGamePath = this.m_sDirectory + this.m_sSeparator + this.m_sPrefix + " " + lc_sNewGameNumber + " - " + lc_sPlayerName + " " + lc_sPlayerLocation + " " + lc_sGameDate + ".ess")) {
                        this.playSoundFromByteArray();
                    }
                }
            }
        }
    }

    private boolean copyFile(String pa_sSource, String pa_sDestination) {
        boolean lc_bResult;
        block14: {
            int lc_iBytesRead = 0;
            int lc_iBytesReadTotal = 0;
            File lc_tSourceFile = null;
            File lc_tDestinationFile = null;
            FileInputStream lc_tInputStream = null;
            FileOutputStream lc_tOutputStream = null;
            byte[] lc_tBuffer = new byte[0x100000];
            lc_bResult = false;
            if (null != pa_sSource && null != pa_sDestination && null != lc_tBuffer && !pa_sSource.isEmpty() && !pa_sDestination.isEmpty() && null != (lc_tSourceFile = new File(pa_sSource))) {
                lc_iBytesRead = 0;
                try {
                    lc_tInputStream = new FileInputStream(lc_tSourceFile);
                    if (null == lc_tInputStream) break block14;
                    lc_tOutputStream = new FileOutputStream(pa_sDestination);
                    if (null != lc_tOutputStream) {
                        try {
                            while ((lc_iBytesRead = lc_tInputStream.read(lc_tBuffer)) > 0) {
                                lc_tOutputStream.write(lc_tBuffer, 0, lc_iBytesRead);
                                lc_iBytesReadTotal += lc_iBytesRead;
                            }
                        }
                        catch (Exception lc_tException) {
                            // empty catch block
                        }
                        if (null != lc_tOutputStream) {
                            try {
                                lc_tOutputStream.close();
                            }
                            catch (Exception lc_tException) {
                                // empty catch block
                            }
                        }
                        if (null != (lc_tDestinationFile = new File(pa_sDestination))) {
                            lc_tDestinationFile.setLastModified(lc_tSourceFile.lastModified());
                        }
                        lc_bResult = true;
                    }
                    if (null != lc_tInputStream) {
                        try {
                            lc_tInputStream.close();
                        }
                        catch (Exception lc_tException) {}
                    }
                }
                catch (Exception lc_tException) {
                    // empty catch block
                }
            }
        }
        return lc_bResult;
    }

    private void playSoundFromFile() {
        if (!this.m_bSoundLoaded) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        try {
            this.m_tClip = AudioSystem.getClip();
            if (null != this.m_tClip && null != SkyrimCharacterHelperDirectorySnifferThread.class.getClassLoader() && null != (this.m_tInputStream = SkyrimCharacterHelperDirectorySnifferThread.class.getClassLoader().getResourceAsStream("skyrimcharacterhelper/resources/42899__freqman__canon-dos-d30-no-focus.wav")) && null != (this.m_tBufferedInputStream = new BufferedInputStream(this.m_tInputStream)) && null != (this.m_tAudioInputStream = AudioSystem.getAudioInputStream(this.m_tBufferedInputStream))) {
                try {
                    this.m_tClip.addLineListener(this);
                    this.m_tClip.open(this.m_tAudioInputStream);
                    this.m_tClip.loop(0);
                }
                catch (Exception lc_tException) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void playSoundFromByteArray() {
        if (!this.m_bSoundLoaded) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        try {
            if (null != this.m_tSoundClipArray && null != (this.m_tClip = AudioSystem.getClip()) && null != SkyrimCharacterHelperDirectorySnifferThread.class.getClassLoader() && null != (this.m_tInputStream = new ByteArrayInputStream(this.m_tSoundClipArray)) && null != (this.m_tBufferedInputStream = new BufferedInputStream(this.m_tInputStream)) && null != (this.m_tAudioInputStream = AudioSystem.getAudioInputStream(this.m_tBufferedInputStream))) {
                try {
                    this.m_tClip.addLineListener(this);
                    this.m_tClip.open(this.m_tAudioInputStream);
                    this.m_tClip.loop(0);
                }
                catch (Exception lc_tException) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean readSoundFile() {
        FileInputStream lc_tFileInputStream = null;
        FileOutputStream lc_tFileOutputStream = null;
        InputStream lc_tInputStream = null;
        BufferedInputStream lc_tBufferedInputStream = null;
        File lc_tFile = null;
        int lc_iBytesRead = 0;
        int lc_iSize = 0;
        byte[] lc_tBytes = new byte[100000];
        boolean lc_bHasTemp = false;
        boolean lc_bResult = false;
        lc_tInputStream = SkyrimCharacterHelperDirectorySnifferThread.class.getClassLoader().getResourceAsStream("skyrimcharacterhelper/resources/42899__freqman__canon-dos-d30-no-focus.wav");
        if (null != lc_tInputStream) {
            lc_tBufferedInputStream = new BufferedInputStream(lc_tInputStream);
            if (null != lc_tBufferedInputStream) {
                block22: {
                    try {
                        lc_tFileOutputStream = new FileOutputStream("tmpSnd.wav");
                        if (null == lc_tFileOutputStream) break block22;
                        try {
                            while (0 < (lc_iBytesRead = ((InputStream)lc_tBufferedInputStream).read(lc_tBytes))) {
                                lc_tFileOutputStream.write(lc_tBytes, 0, lc_iBytesRead);
                            }
                        }
                        catch (Exception lc_tException) {
                            // empty catch block
                        }
                        try {
                            lc_tFileOutputStream.close();
                        }
                        catch (Exception lc_tException) {
                            // empty catch block
                        }
                        lc_bHasTemp = true;
                    }
                    catch (Exception lc_tException) {
                        // empty catch block
                    }
                }
                try {
                    ((InputStream)lc_tBufferedInputStream).close();
                }
                catch (Exception lc_tException) {
                    // empty catch block
                }
            }
            try {
                lc_tInputStream.close();
            }
            catch (Exception lc_tException) {
                // empty catch block
            }
        }
        if (lc_bHasTemp && null != (lc_tFile = new File("tmpSnd.wav"))) {
            lc_iSize = (int)lc_tFile.length();
            if (0 < lc_iSize && null != (this.m_tSoundClipArray = new byte[lc_iSize])) {
                try {
                    lc_tFileInputStream = new FileInputStream(lc_tFile);
                    if (null != lc_tFileInputStream) {
                        lc_iBytesRead = lc_tFileInputStream.read(this.m_tSoundClipArray, 0, lc_iSize);
                        lc_bResult = lc_iBytesRead == lc_iSize;
                        try {
                            lc_tFileInputStream.close();
                        }
                        catch (Exception lc_tException) {}
                    }
                }
                catch (Exception lc_tException) {
                    // empty catch block
                }
            }
            try {
                lc_tFile.delete();
            }
            catch (Exception lc_tException) {
                // empty catch block
            }
        }
        return lc_bResult;
    }

    @Override
    public void update(LineEvent pa_tLineEvent) {
        if (null != pa_tLineEvent && pa_tLineEvent.getType() == LineEvent.Type.STOP) {
            try {
                if (null != this.m_tClip) {
                    this.m_tClip.close();
                    this.m_tClip = null;
                }
            }
            catch (Exception lc_tException) {
                // empty catch block
            }
            try {
                if (null != this.m_tAudioInputStream) {
                    this.m_tAudioInputStream.close();
                    this.m_tAudioInputStream = null;
                }
            }
            catch (Exception lc_tException) {
                // empty catch block
            }
            try {
                if (null != this.m_tBufferedInputStream) {
                    this.m_tBufferedInputStream.close();
                    this.m_tBufferedInputStream = null;
                }
            }
            catch (Exception lc_tException) {
                // empty catch block
            }
            try {
                if (null != this.m_tInputStream) {
                    this.m_tInputStream.close();
                    this.m_tInputStream = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

