/*
 * Decompiled with CFR 0.152.
 */
package skyrimcharacterhelper;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import skyrimcharacterhelper.SkyrimCharacterHelperPlayer;
import skyrimcharacterhelper.SkyrimCharacterHelperSaveGame;

public class SkyrimCharacterHelperPlayerManager {
    private int m_iAmountOfChars = 0;
    private int m_iAmountOfSaveFiles = 0;
    private HashMap<String, SkyrimCharacterHelperPlayer> m_tCharMap = new HashMap();
    private static Collator m_tCollator;

    public SkyrimCharacterHelperPlayerManager() {
        m_tCollator = Collator.getInstance();
        m_tCollator.setStrength(2);
    }

    public final void clear() {
        if (null != this.m_tCharMap) {
            this.m_tCharMap.clear();
        }
        this.m_iAmountOfChars = 0;
        this.m_iAmountOfSaveFiles = 0;
    }

    public final int getSaveGameAmountForList(List<SkyrimCharacterHelperPlayer> pa_tPlayers) {
        int lc_iResult = 0;
        if (null != pa_tPlayers) {
            for (SkyrimCharacterHelperPlayer lc_tPlayer : pa_tPlayers) {
                if (null == lc_tPlayer) continue;
                lc_iResult += lc_tPlayer.getSaveGameAmount();
            }
        }
        return lc_iResult;
    }

    public final SkyrimCharacterHelperPlayer[] getPlayers() {
        Collection<SkyrimCharacterHelperPlayer> lc_tChars = null;
        Iterator<SkyrimCharacterHelperPlayer> lc_tCharsIterator = null;
        SkyrimCharacterHelperPlayer lc_tCharacter = null;
        Object[] lc_tResult = null;
        int lc_iAmount = 0;
        int lc_iCount = 0;
        if (null != this.m_tCharMap && 0 < (lc_iAmount = this.m_iAmountOfChars) && null != (lc_tChars = this.m_tCharMap.values()) && null != (lc_tCharsIterator = lc_tChars.iterator()) && null != (lc_tResult = new SkyrimCharacterHelperPlayer[lc_iAmount])) {
            while (lc_tCharsIterator.hasNext()) {
                lc_tCharacter = lc_tCharsIterator.next();
                if (null == lc_tCharacter) continue;
                lc_tResult[lc_iCount++] = lc_tCharacter;
            }
            if (0 < lc_iCount) {
                Arrays.sort(lc_tResult);
            }
            return lc_tResult;
        }
        return null;
    }

    public final SkyrimCharacterHelperPlayer getPlayer(String pa_sName) {
        SkyrimCharacterHelperPlayer lc_tCharacter = null;
        if (null != this.m_tCharMap && null != pa_sName && !pa_sName.isEmpty()) {
            lc_tCharacter = this.m_tCharMap.get(pa_sName);
        }
        return lc_tCharacter;
    }

    public final SkyrimCharacterHelperSaveGame[] getSaveGames(String pa_sName) {
        SkyrimCharacterHelperPlayer lc_tCharacter = null;
        SkyrimCharacterHelperSaveGame[] lc_tSaveGames = null;
        lc_tCharacter = this.getPlayer(pa_sName);
        if (null != lc_tCharacter && null != (lc_tSaveGames = lc_tCharacter.getSaveGames())) {
            Arrays.sort(lc_tSaveGames, new Comparator<SkyrimCharacterHelperSaveGame>(){

                @Override
                public int compare(SkyrimCharacterHelperSaveGame o1, SkyrimCharacterHelperSaveGame o2) {
                    return m_tCollator.compare(o1.getFileName(), o2.getFileName());
                }
            });
            return lc_tSaveGames;
        }
        return null;
    }

    public final List<SkyrimCharacterHelperSaveGame> getSaveGamesList(String pa_sName) {
        SkyrimCharacterHelperSaveGame[] lc_tSaveGames = null;
        ArrayList<SkyrimCharacterHelperSaveGame> lc_tList = null;
        lc_tSaveGames = this.getSaveGames(pa_sName);
        if (null != lc_tSaveGames && null != (lc_tList = new ArrayList<SkyrimCharacterHelperSaveGame>())) {
            lc_tList.addAll(Arrays.asList(lc_tSaveGames));
        }
        return lc_tList;
    }

    public final int getAmountOfPlayers() {
        return this.m_iAmountOfChars;
    }

    public final int getSaveGameAmount() {
        return this.m_iAmountOfSaveFiles;
    }

    public final boolean add(SkyrimCharacterHelperSaveGame pa_tSaveGame) {
        boolean lc_bResult = false;
        SkyrimCharacterHelperPlayer lc_tEntry = null;
        if (null != this.m_tCharMap && null != pa_tSaveGame) {
            lc_tEntry = this.m_tCharMap.get(pa_tSaveGame.getPlayerName());
            if (null == lc_tEntry) {
                lc_tEntry = new SkyrimCharacterHelperPlayer(pa_tSaveGame);
                if (null != lc_tEntry && null == this.m_tCharMap.put(pa_tSaveGame.getPlayerName(), lc_tEntry)) {
                    ++this.m_iAmountOfChars;
                    ++this.m_iAmountOfSaveFiles;
                    lc_bResult = true;
                }
            } else {
                if (lc_tEntry.addSaveGame(pa_tSaveGame)) {
                    ++this.m_iAmountOfSaveFiles;
                }
                lc_bResult = true;
            }
        }
        return lc_bResult;
    }

    public final boolean add(SkyrimCharacterHelperSaveGame pa_tSaveGame, String pa_sDestinationFullPath) {
        return this.add(new SkyrimCharacterHelperSaveGame(pa_tSaveGame, pa_sDestinationFullPath));
    }

    public final boolean removeSaveGame(SkyrimCharacterHelperSaveGame pa_tSaveGame) {
        SkyrimCharacterHelperPlayer lc_tEntry = null;
        if (null != this.m_tCharMap && null != pa_tSaveGame && null != (lc_tEntry = this.m_tCharMap.get(pa_tSaveGame.getPlayerName()))) {
            --this.m_iAmountOfSaveFiles;
            return lc_tEntry.removeSaveGame(pa_tSaveGame);
        }
        return false;
    }

    public final SkyrimCharacterHelperSaveGame removeSaveGame(String pa_sFileName) {
        SkyrimCharacterHelperPlayer lc_tEntry = null;
        String lc_sPlayer = null;
        if (null != this.m_tCharMap && null != (lc_sPlayer = this.hasSaveGame(pa_sFileName)) && null != (lc_tEntry = this.m_tCharMap.get(lc_sPlayer))) {
            --this.m_iAmountOfSaveFiles;
            return lc_tEntry.removeSaveGame(pa_sFileName);
        }
        return null;
    }

    public final SkyrimCharacterHelperPlayer removePlayer(String pa_sName) {
        SkyrimCharacterHelperPlayer lc_tPlayer = null;
        if (null != this.m_tCharMap && null != pa_sName && null != (lc_tPlayer = this.m_tCharMap.get(pa_sName))) {
            --this.m_iAmountOfChars;
            this.m_iAmountOfSaveFiles -= lc_tPlayer.getSaveGameAmount();
            return this.m_tCharMap.remove(pa_sName);
        }
        return null;
    }

    public final boolean hasPlayer(String pa_sName) {
        boolean lc_bResult = false;
        if (null != this.m_tCharMap && null != pa_sName) {
            return null != this.m_tCharMap.get(pa_sName);
        }
        return lc_bResult;
    }

    public final boolean hasSaveGame(SkyrimCharacterHelperSaveGame pa_tSaveGame) {
        boolean lc_bResult = false;
        String lc_sName = null;
        SkyrimCharacterHelperPlayer lc_tPlayer = null;
        if (null != this.m_tCharMap && null != pa_tSaveGame && null != (lc_sName = pa_tSaveGame.getPlayerName()) && null != (lc_tPlayer = this.m_tCharMap.get(lc_sName))) {
            lc_bResult = lc_tPlayer.hasSaveGame(pa_tSaveGame);
        }
        return lc_bResult;
    }

    public final String hasSaveGame(String pa_sFileName) {
        String lc_sResult = null;
        int lc_iAmount = 0;
        Collection<SkyrimCharacterHelperPlayer> lc_tChars = null;
        Iterator<SkyrimCharacterHelperPlayer> lc_tCharsIterator = null;
        SkyrimCharacterHelperPlayer lc_tCharacter = null;
        if (null != this.m_tCharMap && null != pa_sFileName && 0 < (lc_iAmount = this.m_iAmountOfChars) && null != (lc_tChars = this.m_tCharMap.values()) && null != (lc_tCharsIterator = lc_tChars.iterator())) {
            while (null == lc_sResult && lc_tCharsIterator.hasNext()) {
                lc_tCharacter = lc_tCharsIterator.next();
                if (null == lc_tCharacter) continue;
                lc_sResult = null != lc_tCharacter.hasSaveGame(pa_sFileName) ? lc_tCharacter.getName() : null;
            }
        }
        return lc_sResult;
    }

    public final int getSaveGameAmount(String pa_sPlayer) {
        SkyrimCharacterHelperPlayer lc_tPlayer = null;
        if (null != this.m_tCharMap && null != pa_sPlayer) {
            lc_tPlayer = this.m_tCharMap.get(pa_sPlayer);
            if (null != lc_tPlayer) {
                return lc_tPlayer.getSaveGameAmount();
            }
            return 0;
        }
        return -1;
    }
}

