/*
 * Decompiled with CFR 0.152.
 */
package skyrimcharacterhelper;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileInputStream;
import java.text.Collator;
import java.util.Objects;
import skyrimcharacterhelper.SkyrimCharacterHelperProgressNotifier;
import skyrimcharacterhelper.SkyrimCharacterHelperScreenshot;

public class SkyrimCharacterHelperSaveGame
implements Comparable<SkyrimCharacterHelperSaveGame> {
    private SkyrimCharacterHelperScreenshot m_tScreenshot;
    private String m_sPlayerName;
    private String m_sPlayerLocation;
    private String m_sPlayerRace;
    private int m_iPlayerLevel;
    private String m_sFileName;
    private String m_sFilePath;
    private String m_sGameDate;
    private long m_lFileDate;
    private int m_iScreenShotWidth;
    private int m_iScreenShotHeight;
    private int m_iSaveNumber;
    private int m_iVersion;
    private static Collator m_tCollator;

    public SkyrimCharacterHelperSaveGame() {
        this.init();
    }

    public SkyrimCharacterHelperSaveGame(SkyrimCharacterHelperSaveGame pa_tSource, String pa_sDestinationFullPath) {
        this.init();
        WritableRaster lc_tRaster = null;
        ColorModel lc_tColorModel = null;
        boolean lc_bIsAlphaPremultiplied = false;
        SkyrimCharacterHelperScreenshot lc_tScreenshot = null;
        if (this != pa_tSource && pa_tSource != null) {
            this.m_sFileName = pa_tSource.getFileName();
            this.m_sPlayerName = pa_tSource.getPlayerName();
            this.m_sPlayerLocation = pa_tSource.getPlayerLocation();
            this.m_sPlayerRace = pa_tSource.getPlayerRace();
            this.m_iPlayerLevel = pa_tSource.getPlayerLevel();
            this.m_sGameDate = pa_tSource.getGameDate();
            this.m_lFileDate = pa_tSource.getFileDate();
            this.m_iSaveNumber = pa_tSource.getSaveNumber();
            this.m_iVersion = pa_tSource.getVersion();
            this.m_sFilePath = pa_sDestinationFullPath;
            this.m_tScreenshot = null;
            this.m_iScreenShotWidth = 0;
            this.m_iScreenShotHeight = 0;
            lc_tScreenshot = pa_tSource.getScreenshot();
            if (null != lc_tScreenshot && null != lc_tScreenshot.getImage() && null != (this.m_tScreenshot = new SkyrimCharacterHelperScreenshot())) {
                this.m_iScreenShotWidth = pa_tSource.getScreenShotWidth();
                this.m_iScreenShotHeight = pa_tSource.getScreenShotHeight();
                lc_tColorModel = lc_tScreenshot.getImage().getColorModel();
                lc_bIsAlphaPremultiplied = lc_tColorModel.isAlphaPremultiplied();
                lc_tRaster = lc_tScreenshot.getImage().copyData(null);
                this.m_tScreenshot.init(this.m_iScreenShotWidth, this.m_iScreenShotHeight, new BufferedImage(lc_tColorModel, lc_tRaster, lc_bIsAlphaPremultiplied, null));
            }
        }
    }

    private void init() {
        this.m_tScreenshot = null;
        this.m_sFileName = null;
        this.m_sPlayerName = null;
        this.m_sPlayerLocation = null;
        this.m_sGameDate = null;
        this.m_sPlayerRace = null;
        this.m_sFilePath = null;
        this.m_lFileDate = 0L;
        this.m_iPlayerLevel = 0;
        this.m_iScreenShotWidth = 0;
        this.m_iScreenShotHeight = 0;
        this.m_iSaveNumber = 0;
        this.m_iVersion = 0;
        m_tCollator = Collator.getInstance();
        m_tCollator.setStrength(2);
    }

    public final int getScreenShotWidth() {
        return this.m_iScreenShotWidth;
    }

    public final int getScreenShotHeight() {
        return this.m_iScreenShotHeight;
    }

    public final int getSaveNumber() {
        return this.m_iSaveNumber;
    }

    public final int getVersion() {
        return this.m_iVersion;
    }

    public final String getPlayerName() {
        return this.m_sPlayerName;
    }

    public final String getPlayerLocation() {
        return this.m_sPlayerLocation;
    }

    public final String getPlayerRace() {
        return this.m_sPlayerRace;
    }

    public final int getPlayerLevel() {
        return this.m_iPlayerLevel;
    }

    public final String getFileName() {
        return this.m_sFileName;
    }

    public final String getFilePath() {
        return this.m_sFilePath;
    }

    public final long getFileDate() {
        return this.m_lFileDate;
    }

    public final String getGameDate() {
        return this.m_sGameDate;
    }

    public final SkyrimCharacterHelperScreenshot getScreenshot() {
        return this.m_tScreenshot;
    }

    private int getInt(byte[] pa_tBytes) {
        int lc_iValue = 0;
        if (4 == pa_tBytes.length) {
            lc_iValue += (0xFF & pa_tBytes[3]) << 24;
            lc_iValue += (0xFF & pa_tBytes[2]) << 16;
            lc_iValue += (0xFF & pa_tBytes[1]) << 8;
            lc_iValue += 0xFF & pa_tBytes[0];
        }
        if (2 == pa_tBytes.length) {
            lc_iValue += (0xFF & pa_tBytes[1]) << 8;
            lc_iValue += 0xFF & pa_tBytes[0];
        }
        return lc_iValue;
    }

    public final boolean read(String pa_sFileName, SkyrimCharacterHelperProgressNotifier pa_tNotifier, boolean pa_bReadScreenShotData) {
        boolean lc_bResult = false;
        File lc_tFile = null;
        FileInputStream lc_tInputStream = null;
        int lc_iPos = -1;
        lc_tFile = new File(pa_sFileName);
        if (null != lc_tFile && lc_tFile.exists() && lc_tFile.isFile()) {
            this.m_lFileDate = lc_tFile.lastModified();
            try {
                lc_tInputStream = new FileInputStream(lc_tFile);
                if (null != lc_tInputStream) {
                    this.m_sFilePath = pa_sFileName;
                    this.m_sFileName = pa_sFileName;
                    lc_iPos = pa_sFileName.lastIndexOf(System.getProperty("file.separator"));
                    if (-1 != lc_iPos) {
                        this.m_sFileName = pa_sFileName.substring(1 + lc_iPos);
                    }
                    if (this.readMagic(lc_tInputStream) && this.readHeader(lc_tInputStream)) {
                        lc_bResult = true == pa_bReadScreenShotData ? this.readScreenShotData(lc_tInputStream, pa_tNotifier) : true;
                    }
                }
            }
            catch (Exception lc_tException) {
                lc_bResult = false;
            }
        }
        if (null != lc_tInputStream) {
            try {
                lc_tInputStream.close();
            }
            catch (Exception lc_tException) {
                // empty catch block
            }
        }
        return lc_bResult;
    }

    private boolean readMagic(FileInputStream pa_tInputStream) {
        byte[] lc_tMagic = new byte[13];
        String lc_sResult = null;
        if (null != pa_tInputStream) {
            try {
                if (13 == pa_tInputStream.read(lc_tMagic, 0, 13) && null != (lc_sResult = new String(lc_tMagic))) {
                    return lc_sResult.equalsIgnoreCase("TESV_SAVEGAME");
                }
            }
            catch (Exception lc_tException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean readHeader(FileInputStream pa_tInputStream) {
        int lc_iHeaderSize = 0;
        boolean lc_bResult = false;
        if (null != pa_tInputStream) {
            try {
                lc_iHeaderSize = this.readUInt32(pa_tInputStream);
                if (0 < lc_iHeaderSize) {
                    this.m_iSaveNumber = this.readUInt32(pa_tInputStream);
                    this.m_iVersion = this.readUInt32(pa_tInputStream);
                    this.m_sPlayerName = this.readWString(pa_tInputStream);
                    this.m_iPlayerLevel = this.readUInt32(pa_tInputStream);
                    this.m_sPlayerLocation = this.readWString(pa_tInputStream);
                    this.m_sGameDate = this.readWString(pa_tInputStream);
                    this.m_sPlayerRace = this.readWString(pa_tInputStream);
                    this.readSkip(pa_tInputStream, 18);
                    this.m_iScreenShotWidth = this.readUInt32(pa_tInputStream);
                    this.m_iScreenShotHeight = this.readUInt32(pa_tInputStream);
                    lc_bResult = true;
                }
            }
            catch (Exception lc_tException) {
                // empty catch block
            }
        }
        return lc_bResult;
    }

    private boolean readScreenShotData(FileInputStream pa_tInputStream, SkyrimCharacterHelperProgressNotifier pa_tNotifier) {
        int lc_iColumns = 0;
        int lc_iRows = 0;
        int lc_iRed = 0;
        int lc_iGreen = 0;
        int lc_iBlue = 0;
        int lc_iValue = 0;
        int lc_iCount = 0;
        int lc_iAmount = 0;
        int lc_iProgressStep = 0;
        int lc_iProgressCount = 0;
        int lc_iProgressDisplay = 0;
        boolean lc_bResult = false;
        this.m_tScreenshot = new SkyrimCharacterHelperScreenshot();
        if (null != this.m_tScreenshot) {
            this.m_tScreenshot.init(this.m_iScreenShotWidth, this.m_iScreenShotHeight);
            if (null != pa_tNotifier) {
                pa_tNotifier.notifyProgress(lc_iProgressDisplay);
            }
            try {
                lc_iAmount = this.m_tScreenshot.getHeight() * this.m_tScreenshot.getWidth();
                lc_iProgressStep = lc_iAmount / 100;
                for (lc_iRows = 0; lc_iRows < this.m_tScreenshot.getHeight(); ++lc_iRows) {
                    for (lc_iColumns = 0; lc_iColumns < this.m_tScreenshot.getWidth(); ++lc_iColumns) {
                        lc_iRed = this.readUInt8(pa_tInputStream);
                        lc_iGreen = this.readUInt8(pa_tInputStream);
                        lc_iBlue = this.readUInt8(pa_tInputStream);
                        lc_iValue = 0 <= lc_iRed && 255 >= lc_iRed && 0 <= lc_iGreen && 255 >= lc_iGreen && 0 <= lc_iBlue && 255 >= lc_iBlue ? 0xFF000000 | (lc_iRed & 0xFF) << 16 | (lc_iGreen & 0xFF) << 8 | (lc_iBlue & 0xFF) << 0 : 0;
                        this.m_tScreenshot.setRGB(lc_iColumns, lc_iRows, lc_iValue);
                        ++lc_iCount;
                        if (++lc_iProgressCount < lc_iProgressStep) continue;
                        lc_iProgressCount = 0;
                        if (null == pa_tNotifier) continue;
                        pa_tNotifier.notifyProgress(++lc_iProgressDisplay);
                    }
                }
                lc_bResult = lc_iCount == lc_iAmount;
            }
            catch (Exception lc_tException) {
                // empty catch block
            }
        }
        return lc_bResult;
    }

    private int readUInt32(FileInputStream pa_tInputStream) {
        byte[] lc_tBytes = new byte[4];
        try {
            if (4 == pa_tInputStream.read(lc_tBytes)) {
                return this.getInt(lc_tBytes);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    private int readUInt16(FileInputStream pa_tInputStream) {
        byte[] lc_tBytes = new byte[2];
        try {
            if (2 == pa_tInputStream.read(lc_tBytes)) {
                return this.getInt(lc_tBytes);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    private int readUInt8(FileInputStream pa_tInputStream) {
        try {
            return 0xFF & pa_tInputStream.read();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private String readWString(FileInputStream pa_tInputStream) {
        byte[] lc_tBytesSize = new byte[2];
        byte[] lc_tBytesString = null;
        int lc_iSize = 0;
        StringBuffer lc_tResult = new StringBuffer();
        try {
            if (null != lc_tResult && 2 == pa_tInputStream.read(lc_tBytesSize) && 0 < (lc_iSize = this.getInt(lc_tBytesSize)) && null != (lc_tBytesString = new byte[lc_iSize]) && lc_iSize == pa_tInputStream.read(lc_tBytesString)) {
                for (byte lc_tCharByte : lc_tBytesString) {
                    lc_tResult.append(Character.toChars(0xFF & lc_tCharByte));
                }
                return lc_tResult.toString();
            }
        }
        catch (Exception lc_tException) {
            // empty catch block
        }
        return null;
    }

    private void readSkip(FileInputStream pa_tInputStream, int pa_iAmount) {
        byte[] lc_tSkipBytes = new byte[pa_iAmount];
        if (null != lc_tSkipBytes) {
            try {
                pa_tInputStream.read(lc_tSkipBytes);
            }
            catch (Exception lc_tException) {
                // empty catch block
            }
        }
    }

    @Override
    public int compareTo(SkyrimCharacterHelperSaveGame pa_tObject) {
        String lc_sFileName = null;
        if (null == pa_tObject) {
            return 1;
        }
        lc_sFileName = pa_tObject.getFileName();
        if (null == lc_sFileName) {
            return null == this.getFileName() ? 0 : 1;
        }
        return null == this.getFileName() ? -1 : m_tCollator.compare(this.getFileName(), lc_sFileName);
    }

    public int hashCode() {
        int lc_iHash = 3;
        lc_iHash = 11 * lc_iHash + Objects.hashCode(this.m_sFileName);
        return lc_iHash;
    }

    public boolean equals(Object pa_tObject) {
        SkyrimCharacterHelperSaveGame lc_tSaveGame = null;
        if (this == pa_tObject) {
            return true;
        }
        if (null != pa_tObject && this.getClass() == pa_tObject.getClass() && null != (lc_tSaveGame = (SkyrimCharacterHelperSaveGame)pa_tObject)) {
            return 0 == m_tCollator.compare(this.getFileName(), lc_tSaveGame.getFileName());
        }
        return false;
    }

    public String toString() {
        return this.m_sFileName;
    }
}

