/*
 * Decompiled with CFR 0.152.
 */
package skyrimcharacterhelper;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.ResourceBundle;
import javax.swing.JPanel;

public class SkyrimCharacterHelperScreenshotPanel
extends JPanel {
    private BufferedImage m_tImage;
    private RenderingHints m_tRenderingHints;
    private Color m_tColorBackground = this.getBackground();
    private Color m_tFrameColor = Color.black;
    private Color m_tShadowColor1 = new Color(0x888888);
    private Color m_tShadowColor2 = new Color(0xCCCCCC);
    private JPanel m_tPanelParent;

    public SkyrimCharacterHelperScreenshotPanel(JPanel pa_tParentPanel, ResourceBundle pa_tResources) {
        this.m_tPanelParent = pa_tParentPanel;
        this.m_tRenderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (null != pa_tResources) {
            try {
                this.m_tColorBackground = new Color(Integer.valueOf(pa_tResources.getString("paintPanel.backgroundColor"), 16));
                this.m_tFrameColor = new Color(Integer.valueOf(pa_tResources.getString("paintPanel.frameColor"), 16));
                this.m_tShadowColor1 = new Color(Integer.valueOf(pa_tResources.getString("paintPanel.shadow1Color"), 16));
                this.m_tShadowColor2 = new Color(Integer.valueOf(pa_tResources.getString("paintPanel.shadow2Color"), 16));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final void setImage(BufferedImage pa_tImage) {
        this.m_tImage = pa_tImage;
        this.repaint();
    }

    public final Image getImage() {
        if (null != this.m_tImage && null != this.m_tImage.getSource()) {
            return Toolkit.getDefaultToolkit().createImage(this.m_tImage.getSource());
        }
        return null;
    }

    public final BufferedImage getBufferedImage() {
        return this.m_tImage;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension lc_tParentSize;
        Dimension dimension = lc_tParentSize = null != this.m_tPanelParent ? this.m_tPanelParent.getSize() : null;
        if (null != this.m_tImage) {
            return new Dimension(20 + this.m_tImage.getWidth(), 20 + this.m_tImage.getHeight());
        }
        if (null != lc_tParentSize) {
            return new Dimension(lc_tParentSize.width, lc_tParentSize.height);
        }
        return new Dimension(100, 100);
    }

    @Override
    public void paintComponent(Graphics pa_tGraphics) {
        super.paintComponent(pa_tGraphics);
        Graphics2D lc_tGraphics2D = null;
        if (null != pa_tGraphics && null != (lc_tGraphics2D = (Graphics2D)pa_tGraphics)) {
            try {
                this.paintCustom(lc_tGraphics2D);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void paintCustom(Graphics2D pa_tGraphics) {
        super.paintComponent(pa_tGraphics);
        Graphics2D lc_tGraphics2D = null;
        Dimension lc_tDimensionContainer = null;
        int lc_iX = 0;
        int lc_iY = 0;
        int lc_iDx = 0;
        int lc_iDy = 0;
        if (null != pa_tGraphics && null != (lc_tGraphics2D = pa_tGraphics)) {
            lc_tDimensionContainer = this.getSize();
            if (null != lc_tDimensionContainer) {
                lc_tGraphics2D.setColor(this.m_tColorBackground);
                lc_tGraphics2D.fillRect(0, 0, lc_tDimensionContainer.width, lc_tDimensionContainer.height);
            }
            if (null != this.m_tImage) {
                lc_iDx = this.m_tImage.getWidth();
                lc_iDy = this.m_tImage.getHeight();
                lc_iX = Math.abs(lc_tDimensionContainer.width - lc_iDx) / 2;
                lc_iY = Math.abs(lc_tDimensionContainer.height - lc_iDy) / 2;
                if (lc_iX < 0 || lc_iX > lc_tDimensionContainer.width) {
                    lc_iX = 0;
                }
                if (lc_iY < 0 || lc_iY > lc_tDimensionContainer.height) {
                    lc_iY = 0;
                }
                lc_tGraphics2D.setColor(this.m_tShadowColor1);
                lc_tGraphics2D.drawRect(lc_iX + 1, lc_iY + 1, lc_iDx, lc_iDy);
                lc_tGraphics2D.setColor(this.m_tShadowColor2);
                lc_tGraphics2D.drawRect(lc_iX + 2, lc_iY + 2, lc_iDx, lc_iDy);
                lc_tGraphics2D.setColor(this.m_tFrameColor);
                lc_tGraphics2D.drawRect(lc_iX - 1, lc_iY - 1, lc_iDx + 1, lc_iDy + 1);
                lc_tGraphics2D.drawRect(lc_iX, lc_iY, lc_iDx, lc_iDy);
                lc_tGraphics2D.drawImage((Image)this.m_tImage, lc_iX, lc_iY, this);
            }
        }
    }
}

