/**
 * SkyrimCharacterHelper
 * 
 * UI based tool to save and backup skyrim character save-files
 * 
 */
package skyrimcharacterhelper;



/**
 * About dialog
 * 
 * @author Ulf Wagemann
 */
public class SkyrimCharacterHelperAboutDialog extends javax.swing.JDialog 
{
 private java.awt.Frame            m_tParentFrame;
   
 /** Creates new form SkyrimCharacterHelperAboutDialog */
 public SkyrimCharacterHelperAboutDialog(java.awt.Frame pa_tParent, boolean pa_bModal) 
 {
  super(pa_tParent, pa_bModal);
  initComponents();
  
  m_tParentFrame = pa_tParent;
  centerOnParentView();
 }

 
 
 /**
  * Centers the dialof view on the parent view
  * 
  * @param pa_tParent   parent JFrame
  */
 private void centerOnParentView()
 {
  java.awt.Rectangle lc_tBounds      = (null != m_tParentFrame ? m_tParentFrame.getBounds() : null);
  java.awt.Dimension lc_tSize        = getSize();
  java.awt.Point     lc_tNewLocation = new java.awt.Point();
  
  if (null != lc_tBounds && null != lc_tSize && null != lc_tNewLocation)
  {
   lc_tNewLocation.x = lc_tBounds.x + (lc_tBounds.width /2) - (lc_tSize.width /2); 
   lc_tNewLocation.y = lc_tBounds.y + (lc_tBounds.height/2) - (lc_tSize.height/2); 
  
   if (0 > lc_tNewLocation.x) lc_tNewLocation.x = 0;
   if (0 > lc_tNewLocation.y) lc_tNewLocation.y = 0;
    
   setLocation(lc_tNewLocation);
  }
 }
  
  
  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabelAbout = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("skyrimcharacterhelper/resources/SkyrimCharacterHelperAboutDialog"); // NOI18N
        setTitle(bundle.getString("Form.title")); // NOI18N
        setAlwaysOnTop(true);
        setModal(true);
        setName("Form"); // NOI18N
        setResizable(false);

        org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(skyrimcharacterhelper.SkyrimCharacterHelperApp.class).getContext().getResourceMap(SkyrimCharacterHelperAboutDialog.class);
        jLabelAbout.setIcon(resourceMap.getIcon("jLabelAbout.icon")); // NOI18N
        jLabelAbout.setText(bundle.getString("jLabelAbout.text")); // NOI18N
        jLabelAbout.setName("jLabelAbout"); // NOI18N
        jLabelAbout.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                handleEventMousePressed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jLabelAbout, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jLabelAbout, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

  private void handleEventMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_handleEventMousePressed
    this.dispose();
  }//GEN-LAST:event_handleEventMousePressed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabelAbout;
    // End of variables declaration//GEN-END:variables
}
