/**
 * SkyrimCharacterHelper
 * 
 * UI based tool to save and backup skyrim character save-files
 * 
 */
package skyrimcharacterhelper;



/**
 * Imports
 * 
 */
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.DataFlavor  ; 
import java.awt.image.BufferedImage      ;

import java.io.IOException;
import java.awt.datatransfer.UnsupportedFlavorException;



/**
 * Class for copying an image to clibaord
 * 
 * @author Ulf Wagemann
 */
public class SkyrimCharacterHelperClipboardImage implements Transferable
{
 private BufferedImage m_tImage;
 
 
 
 /**
  * Constructor
  * 
  * @param pa_tImage    image
  */
 public SkyrimCharacterHelperClipboardImage(BufferedImage pa_tImage)
 {
  m_tImage = pa_tImage;
 }

 
 
 /**
  * Returns supprted data flavors, which in this case is an image.
  * 
  * @return  data flavors
  */
 public DataFlavor[] getTransferDataFlavors() {return new DataFlavor[] {DataFlavor.imageFlavor};}
  

 
 /**
  * Returns we support the given flavor.
  * 
  * @return true, if the given flavor is supprted (= is an image flavor), otherwise false
  */
 public boolean isDataFlavorSupported(DataFlavor pa_tFlavor)  {return DataFlavor.imageFlavor.equals(pa_tFlavor);}

 
 
 /**
  * Returns the transfer data, which in this case is an image
  * 
  * @param pa_tFlavor  data flavor
  * @return            image, null in case of error
  * 
  * @throws UnsupportedFlavorException
  * @throws IOException 
  */ 
  public Object getTransferData(DataFlavor pa_tFlavor) throws UnsupportedFlavorException, IOException
  {
   if (!DataFlavor.imageFlavor.equals(pa_tFlavor))
   {
    throw new UnsupportedFlavorException(pa_tFlavor);
   }
   return m_tImage;
  }

} // eoc
