/**
 * SkyrimCharacterHelper
 * 
 * UI based tool to save and backup skyrim character save-files
 * 
 */
package skyrimcharacterhelper;



/**
 * Global constants
 * 
 * @author Ulf Wagemann
 */
public class SkyrimCharacterHelperConstants 
{ 
 //
 // it's magic :) 
 //
 public final static int  SKH_IMAGE_PADDING                   = 20;
 public final static int  SKH_FILE_BUFFER_SIZE                = 1048576;
 public final static int  SKH_FILE_MAX_NUMBER                 = 9999999; 
 public final static long SKH_FILE_PROCESS_MAX_WAIT_TIME      = 60000  ; // 60 seconds in ms 
 public final static long SKH_FILE_PROCESS_DELAY_TIME         = 5000   ; // 5  seconds in ms 
 public final static long SKH_FILE_SAVEGAME_WORKER_DELAY_TIME = 100    ; // 0.1  seconds in ms 
 public final static long SKH_FILE_SYSTEM_COMMAND_OK          = 0      ; 
 
 
 //
 // string replacement stuff
 //
 public final static String SKH_MESSAGE_NUM_REPLACER = "%d";
 public final static String SKH_MESSAGE_STR_REPLACER = "%s";
 
 
 //
 // os stuff
 //
 public final static String SKH_OS_WINDOWS_XP  = "5.1"    ;
 public final static String SKH_OS_WINDOWS_2K  = "6.0"    ;
 public final static String SKH_OS_WINDOWS_7   = "6.1"    ;
 
 //
 // prefix stuff
 //
 public final static String SKH_PREFIX_GERMAN  = "Speichern";
 public final static String SKH_PREFIX_ENGLISH = "Save"     ;

 
 //
 // savegame stuff and own files
 //

 public final static String SKH_FILE_NUMBER_FORMAT             = "%03d"      ;
 public final static String SKH_FILE_DEFAULT_NUMBER            = "1"         ;
 
 public final static String SKH_FILE_EXTENSION_TXT             = ".txt"      ;  
 public final static String SKH_FILE_EXTENSION_ESS             = ".ess"      ;  
 public final static String SKH_FILE_EXTENSION_ESS_BAK         = ".ess.bak"  ;  
 public final static String SKH_FILE_EXTENSION_BAK             =  ".bak"     ;  
 public final static String SKH_FILE_PREFIX_SEPARATOR          =  " "        ;  
 
 public final static String SKH_FILE_TEMP_SLOT_AUTO            = "autosave"  ;  
 public final static String SKH_FILE_TEMP_SLOT_QUICK           = "quicksave" ;  
 
 public final static String SKH_FILE_DOCUMENT_FOLDER_2K_XP     = "\\My Documents";  
 public final static String SKH_FILE_DOCUMENT_FOLDER_LATER     = "\\Documents"   ;  
 
 public final static String SKH_FILE_DOCUMENT_SAVEGAME_FOLDER_2K_XP   = "\\Saved Games";  
 public final static String SKH_FILE_DOCUMENT_SAVEGAME_FOLDER_LATER   = "\\My Games"   ;  // i just hate doing this crap
 
 public final static String SKH_FILE_SKYRIM_SAVEGAME_FOLDER    = "\\Skyrim\\Saves"   ;  
 public final static String SKH_FILE_INTERFACE_FOLDER          = "Data\\Interface\\" ;  
 public final static String SKH_FILE_TRANSLATION               = "Translate_"        ;  
 public final static String SKH_FILE_DEFAULT_INI               = "Skyrim_default.ini";  
 
 public final static String SKH_FILE_DEFAULT_INI_LANGUAGE_KEY        = "sLanguage";  
 public final static String SKH_FILE_DEFAULT_INI_LANGUAGE_SEPARATOR  = "="        ;  
 public final static String SKH_FILE_LANGUAGE_SAVE_KEY               = "$SAVE"    ;
 public final static String SKH_FILE_LANGUAGE_SAVE_SEPARATOR         = "\t"       ;
 
 public final static String SKH_FILE_TEMP_SOUND_FILE     = "tmpSnd.wav"  ; 
 public final static String SKH_FILE_PROPERTIES          = "settings.prs"; 
 public final static String SKH_FILE_LOCALIZED_MESSAGES  = "skyrimcharacterhelper/resources/SkyrimCharacterHelperMessages";
 public final static String SKH_FILE_VIEW_RESOURCES      = "skyrimcharacterhelper/resources/SkyrimCharacterHelperView"    ;
 public final static String SKH_FILE_CLICK_SOUND         = "skyrimcharacterhelper/resources/42899__freqman__canon-dos-d30-no-focus.wav";

 public final static String SKH_FILE_TESV_SAVEGAME_MAGIC        = "TESV_SAVEGAME"; 
 public final static int    SKH_FILE_TESV_SAVEGAME_MAGIC_LENGTH = 13;

 
 //
 // properties file
 //
 public final static String SKH_PROPERTIES_ANNOTATION            = "Last modified on:";
 public final static String SKH_PROPERTIES_KEY_ACTIVE_PATH       = "ACTIVE_PATH"      ; 
 public final static String SKH_PROPERTIES_KEY_BACKUP_PATH       = "DESTINATION_PATH" ; 
 public final static String SKH_PROPERTIES_KEY_WORK_MODE         = "WORK_MODE"        ; 
 public final static String SKH_PROPERTIES_KEY_CONFIRMATION_MODE = "CONFIRMATION_MODE"; 
 public final static String SKH_PROPERTIES_KEY_OVERWRITE_MODE    = "OVERWRITE_MODE"   ; 
 public final static String SKH_PROPERTIES_KEY_MINIMIZE_MODE     = "MINIMIZE_MODE"    ;
 public final static String SKH_PROPERTIES_KEY_IMAGE_MODE        = "IMAGE_MODE"       ; 
 public final static String SKH_PROPERTIES_KEY_LAUNCH_BINARY     = "LAUNCH_BINARY"    ; 
 public final static String SKH_PROPERTIES_KEY_HEADER_ACTIVE     = "HEADER_ACTIVE"    ; 
 public final static String SKH_PROPERTIES_KEY_HEADER_BACKUP     = "HEADER_BACKUP"    ; 
 public final static String SKH_PROPERTIES_KEY_SORT_ORDER_ACTIVE = "SORT_ORDER_ACTIVE"; 
 public final static String SKH_PROPERTIES_KEY_SORT_ORDER_BACKUP = "SORT_ORDER_BACKUP"; 
 public final static String SKH_PROPERTIES_KEY_AUTOSAVE_MODE     = "AUTOSAVE_MODE"    ; 
 public final static String SKH_PROPERTIES_KEY_QUICKSAVE_MODE    = "QUICKSAVE_MODE"   ; 
 public final static String SKH_PROPERTIES_KEY_INIT_MODE         = "INIT_MODE"        ; 
 public final static String SKH_PROPERTIES_KEY_LAUNCH_PARAMETERS = "LAUNCH_PARAMETERS"; 
 public final static String SKH_PROPERTIES_KEY_PREFIX            = "PREFIX"           ; 
 public final static String SKH_PROPERTIES_SEPARATOR             = ",";
 
 public final static int SKH_PROPERTIES_SORTORDER_ASCENDING  = 0;
 public final static int SKH_PROPERTIES_SORTORDER_DESCENDING = 1;
 public final static int SKH_PROPERTIES_SORTORDER_UNSORTED   = 2;
 
 //
 // UI overdrive
 //
 public final static String SKH_FUGLY_BACKGROUND          = "jProgressBar.background"         ;
 public final static String SKH_FUGLY_FOREGROUND          = "jProgressBar.foreground"         ;
 public final static String SKH_FUGLY_SELECTED_FOREGROUND = "jProgressBar.selectionForeground";
 public final static String SKH_FUGLY_SELECTED_BACKGROUND = "jProgressBar.selectionBackground";
 public final static String SKH_COMBO_SELECTED_BACKGROUND = "jComboBox.dropDownList.selectionBackground";
 public final static String SKH_COMBO_SELECTED_FOREGROUND = "jComboBox.dropDownList.selectionForeground";
 
 public final static String SKH_PAINTPANEL_BACKGROUND = "paintPanel.backgroundColor";
 public final static String SKH_PAINTPANEL_FRAME      = "paintPanel.frameColor"     ;
 public final static String SKH_PAINTPANEL_SHADOW1    = "paintPanel.shadow1Color"   ;
 public final static String SKH_PAINTPANEL_SHADOW2    = "paintPanel.shadow2Color"   ;
 
 public final static String SKH_LABEL_ON_SKYRIM_ACTIVE_BGCOLOR ="jLabelOnSkyrim.bgColorActive";

 
 //
 // localization
 //
 public final static String SKH_CHOOSER_OPEN_TEXT         = "fileChooserOk"          ;
 public final static String SKH_CHOOSER_CANCEL_TEXT       = "jFileChooser.cancelText";

 public static final String SKH_DIALOG_TEXT_NOT_EXECUTABLE_ERROR         = "dialogTextNotExecutableError"         ;
 public static final String SKH_DIALOG_TITLE_FILEREQUESTER_LAUNCH_BINARY = "dialogTitleFileRequesterLaunchBinary";
 public static final String SKH_DIALOG_TITLE_FILEREQUESTER_ACTIVE_DIR    = "dialogTitleFileRequesterSaveGamesDir";
 public static final String SKH_DIALOG_TITLE_FILEREQUESTER_BACKUP_DIR    = "dialogTitleFileRequesterBackupDir"   ;
 public static final String SKH_DIALOG_TITLE_RESULTS                     = "dialogTitleResults"                  ;
 public static final String SKH_DIALOG_TITLE_INFORMATION                 = "dialogTitleInformation"              ;
 public static final String SKH_DIALOG_TITLE_ERROR                       = "dialogTitleError"                    ;
 public static final String SKH_DIALOG_TITLE_WARNING                     = "dialogTitleWarning"                  ;

 public static final String SKH_DIALOG_TEXT_NOT_READABLE_ERROR     = "dialogTextNotReadable"        ;
 public static final String SKH_DIALOG_TEXT_DELETE_PLAYER          = "dialogTextDeletePlayer"       ;
 public static final String SKH_DIALOG_TEXT_DELETE_PLAYERS         = "dialogTextDeletePlayers"      ;
 public static final String SKH_DIALOG_TEXT_CLEAR_PLAYERS          = "dialogTextClearPlayers"       ;
 public static final String SKH_DIALOG_TEXT_DELETE_SAVEGAME        = "dialogTextDeleteSaveGame"     ;
 public static final String SKH_DIALOG_TEXT_DELETE_SAVEGAMES       = "dialogTextDeleteSaveGames"    ;
 public static final String SKH_DIALOG_TEXT_OVERWRITE_SAVEGAME     = "dialogTextOverwriteSaveGame"  ;
 public static final String SKH_DIALOG_TEXT_DELETE_AFTER_COPY      = "dialogTextDeleteAfterCopy"    ;
 
 public static final String SKH_DIALOG_TEXT_MOVE_FOR_LAUNCH_ACTIVE_PLAYER = "dialogTextActivePlayerMoveForLaunch";
 public static final String SKH_DIALOG_TEXT_MOVE_FOR_LAUNCH_BACKUP_PLAYER = "dialogTextBackupPlayerMoveForLaunch";
 public static final String SKH_DIALOG_TEXT_MOVE_FOR_LAUNCH_ACTIVE_SAVEGAME = "dialogTextActiveSavegameMoveForLaunch";
 public static final String SKH_DIALOG_TEXT_MOVE_FOR_LAUNCH_BACKUP_SAVEGAME = "dialogTextBackupSavegameMoveForLaunch";
 
 public static final String SKH_DIALOG_TEXT_FRESH_START            = "dialogTextFreshStart"         ;
 public static final String SKH_DIALOG_TEXT_FRESH_START_SAVEGAME   = "dialogTextFreshSaveGame"      ;
 
 public static final String SKH_DIALOG_OPTION_OK       = "dialogOptionOk"      ;
 public static final String SKH_DIALOG_OPTION_CANCEL   = "dialogOptionCancel"  ;
 public static final String SKH_DIALOG_OPTION_YES      = "dialogOptionYes"     ;
 public static final String SKH_DIALOG_OPTION_NO       = "dialogOptionNo"      ;

 public static final String SKH_JLABEL_TEXT_NOT_MONITORING  = "jLabel.text.notMonitoring";
 public static final String SKH_JLABEL_TEXT_MONITORING      = "jLabel.text.monitoring"   ;

 public static final String SKH_COMBOBOX_OPTION_MOVE   = "comboBoxOptionMove";
 public static final String SKH_COMBOBOX_OPTION_COPY   = "comboBoxOptionCopy"  ;
 public static final String SKH_COMBOBOX_OPTION_YES    = "comboBoxOptionYes"   ;
 public static final String SKH_COMBOBOX_OPTION_NO     = "comboBoxOptionNo"    ;
 public static final String SKH_COMBOBOX_OPTION_SHOW   = "comboBoxOptionShow"  ;
 public static final String SKH_COMBOBOX_OPTION_HIDE   = "comboBoxOptionHide"  ;
 
 public static final String SKH_COMBOBOX_OPTION_SCAN_ALL         = "comboBoxOptionScanAll"       ;
 public static final String SKH_COMBOBOX_OPTION_SCAN_SKYRIM_ONLY = "comboBoxOptionScanSkyrimOnly";
 
 public static final String SKH_COMBOBOX_OPTION_LAUNCH_MINIMIZED = "comboBoxOptionLaunchMinimized";
 public static final String SKH_COMBOBOX_OPTION_LAUNCH_NORMAL    = "comboBoxOptionLaunchNormal"   ;

 public static final String SKH_MESSAGE_SCANNING_SAVEGAMES         = "messageScanningSaveGames"      ;
 public static final String SKH_MESSAGE_SCANNING_ACTIVE_SAVEGAMES  = "messageScanningActiveSaveGames";
 public static final String SKH_MESSAGE_SCANNING_BACKUP_SAVEGAMES  = "messageScanningBackupSaveGames";
         
 public static final String SKH_MESSAGE_READY               = "messageReady"            ;
 public static final String SKH_MESSAGE_DELETE_ALL_PLAYERS  = "messageDeleteAllPlayers" ;
 public static final String SKH_MESSAGE_DELETE_PLAYERS      = "messageDeletePlayers"    ;
 public static final String SKH_MESSAGE_DELETE_SAVEGAMES    = "messageDeleteSaveGames"  ;
 public static final String SKH_MESSAGE_BACKING_UP          = "messageBackingUp"        ;
 public static final String SKH_MESSAGE_RESTORING           = "messageRestoring"        ;
 public static final String SKH_MESSAGE_CLIPBOARD_DONE      = "messageClipboardDone"    ;
 public static final String SKH_MESSAGE_BACKUP_DONE         = "messageBackupDone"       ;
 public static final String SKH_MESSAGE_CLEAR_DONE          = "messageClearDone"        ;
 public static final String SKH_MESSAGE_DELETE_DONE         = "messageDeleteDone"       ;
 public static final String SKH_MESSAGE_RESTORE_DONE        = "messageRestoreDone"      ;
 public static final String SKH_MESSAGE_LEVEL               = "messageLevel"            ;
 public static final String SKH_MESSAGE_LOCATION            = "messageLocation"         ;
 public static final String SKH_MESSAGE_TIMESTAMP           = "messageTimestamp"        ;
 public static final String SKH_MESSAGE_EQUAL_DIRS          = "messageEqualDirs"        ;
 public static final String SKH_MESSAGE_INTERRUPTED         = "messageInterrupted"      ;
 public static final String SKH_MESSAGE_LAUNCH_ACTIVE       = "messageLaunchActive"     ;
 public static final String SKH_MESSAGE_LAUNCH_BACKUP       = "messageLaunchBackup"     ;
 public static final String SKH_MESSAGE_LAUNCH_SINGLE       = "messageLaunchSingle"     ;
 public static final String SKH_MESSAGE_LAUNCH_RESTORED     = "messageLaunchRestored"   ;
 public static final String SKH_MESSAGE_NOT_EXECUTABLE      = "messageNotExecutable"    ;
 public static final String SKH_MESSAGE_LAUNCH_DONE         = "messageLaunchDone"       ;
 public static final String SKH_MESSAGE_LAUNCH_ABORTED      = "mdssageLaunchAborted"    ;
 public static final String SKH_MESSAGE_READING_SAVEGAME    = "messageReadingSaveGame"  ;
 
 public static final String SKH_TABLE_HEADER_LEVEL    = "tableHeader.level"   ;
 public static final String SKH_TABLE_HEADER_LOCATION = "tableHeader.location";
 public static final String SKH_TABLE_HEADER_FILETIME = "tableHeader.filetime";
 public static final String SKH_TABLE_HEADER_FILENAME = "tableHeader.filename";
 
 
 //
 // UI control area settings
 //
 public static final int SKH_NOT_MONITORING = 0;
 public static final int SKH_MONITORING     = 1;

 public static final int SKH_INIT_SCAN_ALL         = 0;
 public static final int SKH_INIT_SCAN_SYKRIM_ONLY = 1;

 public static final int SKH_WORKMODE_MOVE = 1;
 public static final int SKH_WORKMODE_COPY = 0;

 public static final int SKH_IMAGEMODE_HIDE = 1;
 public static final int SKH_IMAGEMODE_SHOW = 0;

 public static final int SKH_CONFIRM_DELETE   = 0;
 public static final int SKH_NOCONFIRM_DELETE = 1;
 
 public static final int SKH_CONFIRM_YES  = 0;
 public static final int SKH_CONFIRM_NO   = 1;
 
 public static final int SKH_QUICKSAVE_YES = 0;
 public static final int SKH_AUTOSAVE_YES  = 0;
 
 
 //
 // modes for threads
 //
 public final static int SKH_WORKER_THREAD_MODE_DELETE         = 0;
 public final static int SKH_WORKER_THREAD_MODE_BACKUP         = 1;
 public final static int SKH_WORKER_THREAD_MODE_RESTORE        = 2;
 public final static int SKH_WORKER_THREAD_LAUNCH_FROM_BACKUP  = 3;
 public final static int SKH_WORKER_THREAD_LAUNCH_FROM_ACTIVE  = 4; 
 public final static int SKH_WORKER_THREAD_LOAD_SAVEGAME       = 5; 
 
 
 
 //
 // stuff for getting Skyrim's install path from the windows registry
 //
 public final static String SKH_REGISTRY_REG_COMMAND  = "reg"   ;
 public final static String SKH_REGISTRY_QUERY        = "query" ;
 public final static String SKH_REGISTRY_QUERY_OPTION = "/v"    ;
 public final static String SKH_REGISTRY_VALUE_TYPE   = "REG_SZ";
 public final static String SKH_REGISTRY_KEY_PATH     = "\"Installed Path\"";
 
 public final static String SKH_REGISTRY_QUERY_STRING_32BIT = "\"HKLM\\Software\\Bethesda Softworks\\Skyrim\""             ;
 public final static String SKH_REGISTRY_QUERY_STRING_64BIT = "\"HKLM\\Software\\Wow6432Node\\Bethesda Softworks\\Skyrim\"";
 
 
 
 //
 // ordinary skyrim binary and launcher binary
 //
 public final static String SKH_SKYRIM_BINARY_SKSE     = "skse_loader.exe"         ;
 public final static String SKH_SKYRIM_BINARY_NORMAL   = "TESV.exe"                ;
 public final static String SKH_SKYRIM_BINARY_LAUNCHER = "SkyrimLauncher.exe"      ; 
 public final static String SKH_SKYRIM_TASKLIST_CMD    = "tasklist.exe /fo csv /nh";
 
 
 //
 // operating system
 //
 public final static String SKH_OS_NAME      = "os.name"    ;
 public final static String SKH_OS_VERSION   = "os.version" ;
 public final static String SKH_OS_WINDOWS   = "WINDOWS"    ;
 public final static String SKH_USER_PROFILE = "USERPROFILE";
 
 
 
 //
 // table stuff
 //
 public final static int    SKH_TABLE_COLUMNS = 4;
 public final static String SKH_DEFAULT_HEADER_ARRANGEMENT = "0123";
 public final static String SKH_DEFAULT_SORT_ORDER         = "00";
 
 
} // eoc