/**
 * SkyrimCharacterHelper
 * 
 * UI based tool to save and backup skyrim character save-files
 * 
 */
package skyrimcharacterhelper;



/**
 * GUI connector class
 * 
 * @author Ulf Wagemann
 */
public abstract interface SkyrimCharacterHelperGuiConnector 
{
 public abstract void handleButtonExit();

 public abstract void handleButtonAbout();

 public abstract void handleButtonProcessCancel();

 public abstract void handleButtonChooseBinary();
 
 public abstract void handleButtonRestoreLaunchPath();
 
 public abstract void handleButtonLaunchSolo();

 
 
 public abstract void handleButtonSelectActivePath();
 
 public abstract void handleButtonSelectBackupPath();
 
 public abstract void handleButtonSelectActiveRescan(String pa_sMessage, boolean pa_bShowMessage);
 
 public abstract void handleButtonSelectBackupRescan();
 

 
 public abstract void handleButtonActiveClipboard();

 public abstract void handleButtonActiveDeletePlayer();
 
 public abstract void handleButtonActiveBackupSaveGame();

 public abstract void handleButtonActiveDeleteSaveGame();

 public abstract void handleButtonActiveBackupPlayer();

 public abstract void handleButtonActiveClearPlayers();

 public abstract void handleButtonActiveLaunchPlayer();

 public abstract void handleButtonActiveLaunchSaveGame();
         
 public abstract void handleButtonBackupLaunchSaveGame(); 
 
 
 
 
 public abstract void handleButtonBackupClipboard();

 public abstract void handleButtonBackupDeletePlayer();

 public abstract void handleButtonBackupDeleteSaveGame();

 public abstract void handleButtonBackupPlayerRestore();
 
 public abstract void handleButtonBackupSaveGameRestore();

 public abstract void handleButtonBackupClearPlayers();

 public abstract void handleButtonBackupLaunchPlayer();
 
 
 
 
 public abstract void handleListSelectionActivePlayers();
 
 public abstract void handleListSelectionBackupPlayers();
 
 public abstract void handleListSelectionActiveSaveGames();
 
 public abstract void handleListSelectionBackupSaveGames();
 
 
 public abstract void handleComboBoxImageMode();
} // eoc
