/**
 * SkyrimCharacterHelper
 * 
 * UI based tool to save and backup skyrim character save-files
 * 
 */
package skyrimcharacterhelper;



/**
 * Imports
 * 
 */
import java.awt.Component            ;
import java.awt.Color                ;
import javax.swing.JList             ;
import javax.swing.JLabel            ;
import javax.swing.border.Border     ;
import javax.swing.border.EmptyBorder;
import javax.swing.ListCellRenderer  ;
import javax.swing.SwingConstants    ;




/**
 * Custom ListCellRenderer
 * 
 * @author Ulf Wagemann
 */
public class SkyrimCharacterHelperListCellRenderer extends JLabel
                                                   implements ListCellRenderer 
{
 protected static Border m_tNoFocusBorder;
 protected static Border m_tFocusBorder  ; 
  
 /**
  * Constructor
  * 
  */
 public SkyrimCharacterHelperListCellRenderer()
 { 
  super();
  
  m_tNoFocusBorder = new EmptyBorder(5,5,5,5);
  m_tFocusBorder   = new EmptyBorder(5,5,5,5);
  
  setOpaque(true);
  setBorder(m_tNoFocusBorder);
  
 }
 
 
 
 @Override
 public Component getListCellRendererComponent(JList   pa_tList        ,
                                               Object  pa_tValue       ,
                                               int     pa_iIndex       ,
                                               boolean pa_bIsSelected  ,
                                               boolean pa_bCellHasFocus) 
 {
  if (null != pa_tList && null != pa_tValue)
  {
   setBackground(true == pa_bIsSelected ? pa_tList.getSelectionBackground() : pa_tList.getBackground());
   setForeground(true == pa_bIsSelected ? pa_tList.getSelectionForeground() : pa_tList.getForeground());
   setFont(pa_tList.getFont());
  
   setBorder(true == pa_bCellHasFocus ? m_tFocusBorder : m_tNoFocusBorder); // UIManager.getBorder("List.focusCellHighlightBorder")
   setHorizontalTextPosition(SwingConstants.RIGHT );
   setVerticalTextPosition  (SwingConstants.CENTER);
   
   if (pa_tValue instanceof SkyrimCharacterHelperSaveGame)
   { 
    setText(((SkyrimCharacterHelperSaveGame) pa_tValue).getFileName());  
   }
   else if (pa_tValue instanceof SkyrimCharacterHelperPlayer)
   { 
    setText(((SkyrimCharacterHelperPlayer) pa_tValue).getName());  
   }
   else if (pa_tValue instanceof String)
   { 
    setText((String) pa_tValue);  
   }
   else
   {
    setText(pa_tValue.toString());
   }
  }
  return this;
 }

 
 
}
