/**
 * SkyrimCharacterHelper
 * 
 * UI based tool to save and backup skyrim character save-files
 * 
 */
package skyrimcharacterhelper;



/**
 * Imports
 * 
 */
import java.util.SortedSet ;
import java.util.TreeSet   ;
import java.util.Collection;
import java.util.Arrays    ;
import java.util.List      ;
import java.util.ArrayList ;
import java.util.Iterator  ;
import javax.swing.AbstractListModel;



/**
 * Thread-safe sorted list model. The list is sorted if the elements implement a Comparable interface.
 * See SkyrimCharacterHelperCharacter.java and SkyrimCharacterHelperCharacter.java for more information.
 * 
 * @author Ulf Wagemann
 */
public class SkyrimCharacterHelperListModel extends AbstractListModel  
{
 private SortedSet<Object> m_tModel; 
 
 
 /**
  * Constructor
  * 
  */
  public SkyrimCharacterHelperListModel() 
  {
  m_tModel = new TreeSet<>();
  }

  
  /**
   * Returns the model's size
   * 
   * @return   size, may be 0
   */
  public synchronized int getSize() 
  {
   return (null != m_tModel ? m_tModel.size() : 0);
  }

  
  
    /**
   * Returns the model's size
   * 
   * @return   size, may be 0
   */
  public final synchronized int size() 
  {
   return (null != m_tModel ? m_tModel.size() : 0);
  }

  
  
  /**
   * Returns the element at the given position
   * 
   * @param pa_iIndex   position
   * @return object, may be null
   */
  public synchronized Object getElementAt(int pa_iIndex) 
  {
   if (0 < getSize())
   {
    if (0 <= pa_iIndex && pa_iIndex < getSize())
    {
     return m_tModel.toArray()[pa_iIndex]; 
    }
   }
   return null;
  }


  
  /**
   * Returns an array of elements
   * 
   * @return   array of elements, may be null
   */
  public final synchronized Object[] elements()
  {
   return (0 < getSize() ? m_tModel.toArray() : null); 
  }
  
  
  
  /**
   * Adds an element
   * 
   * @param pa_tElement new element
   */
  public final synchronized void add(Object pa_tElement) 
  {
   if (null != m_tModel)
   {
    if (true == m_tModel.contains(pa_tElement)) m_tModel.remove(pa_tElement);
    m_tModel.add(pa_tElement);
    fireContentsChanged(this, 0, getSize()-1); // fixed on 02/07/2012   fireContentsChanged(this, 0, getSize());  
   }
  }
   
  
  
  /**
   * Adds all given elements
   * 
   * @param pa_tElements new elements
   */
  public final synchronized void addAll(Object pa_tElements[]) 
  {
   Collection<Object> lc_tCollection = null;
   
   if (null != m_tModel && null != pa_tElements)
   {
    if (null != (lc_tCollection = Arrays.asList(pa_tElements)))
    {
     m_tModel.addAll(lc_tCollection);
     fireContentsChanged(this, 0, getSize()-1); // fixed on 02/07/2012   fireContentsChanged(this, 0, getSize());  
    }
   }
  }

  
  
  /**
   * Clears the model
   * 
   */
  public final synchronized void clear() 
  {
   if (0 < getSize())
   {
    m_tModel.clear();
    fireContentsChanged(this, 0, getSize() -1); // fixed on 02/07/2012   fireContentsChanged(this, 0, getSize());
   }
  }

  
  
  /**
   * Tests whether the given object is element of the model
   * 
   * @param pa_tElement  element to test
   * @return false, if the object is not part of the model, true otherwise
   */
  public final synchronized boolean contains(Object pa_tElement) 
  {
   return (null != m_tModel ? m_tModel.contains(pa_tElement) : false);
  }

  
  
  /**
   * Returns the first element
   * 
   * @return first element, may be null
   */
  public final synchronized Object firstElement() 
  {
   return (null != m_tModel ?  m_tModel.first() : null);
  }

  
  
  /**
   * Returns the last element
   * 
   * @return last element, may be null
   */
  public final synchronized Object lastElement() 
  {
   return (null != m_tModel ?  m_tModel.last() : null);
  }

  
  
  /**
   * Returns the iterator
   * 
   * @return  iterator, may be null
   */
  public final synchronized Iterator iterator() 
  {
   return (null != m_tModel ? m_tModel.iterator() : null);
  }


  
  /**
   * Removes the given element
   * 
   * @param pa_tElement  element to remove
   * @return true, if the element could be removed, false otherwise
   */
  public final synchronized boolean removeElement(Object pa_tElement) 
  {
   boolean lc_bRemoved = false;
   
   if (0 < getSize())
   {
    if (null != pa_tElement)
    {
     if (true == (lc_bRemoved = m_tModel.remove(pa_tElement)))
     {
      fireContentsChanged(this, 0, getSize()-1); // fixed on 02/07/2012   fireContentsChanged(this, 0, getSize());      
     }
    }
   }
   return lc_bRemoved;
  }
  
  
 
/**
  * Retrieves a listr of all players
  * 
  * @return  list, null in case of error
  */
 public final synchronized List<SkyrimCharacterHelperPlayer> getPlayerList()
 {
  Object[]                                 lc_tPlayers  = null;
  SkyrimCharacterHelperPlayer              lc_tPlayer   = null;
  ArrayList<SkyrimCharacterHelperPlayer>   lc_tList     = null;
  
  if (0 < getSize())
  {
   if (null != (lc_tPlayers = m_tModel.toArray()))
   {
    if (null != (lc_tList = new ArrayList<>()))
    {
     for (Object lc_tObject : lc_tPlayers) // I've been waiting years for iterating object arrays, slists and whatever that easyly! <3
     {
      if (null != lc_tObject)
      {
       if (lc_tObject instanceof SkyrimCharacterHelperPlayer) 
       {
        if (null != (lc_tPlayer = (SkyrimCharacterHelperPlayer) lc_tObject))
        {
         lc_tList.add(lc_tPlayer); 
        }
       }
      }
     } // for 
    }
   }
  }
  return lc_tList;
 } 
  
} // eoc

  

