/**
 * SkyrimCharacterHelper
 * 
 * UI based tool to save and backup skyrim character save-files
 * 
 */
package skyrimcharacterhelper;



/**
 * Imports
 * 
 */
import java.io.File      ;
import java.io.FileFilter;
import java.io.IOException;



/**
 * Simple filename filter only accepting files ending with ".ess" and ".ess.bak". Very basic. 
 *
 * @author Ulf Wagemann
 */
public class SkyrimCharacterHelperSaveFileFilter implements FileFilter
{
 /**
  * FilenameFilter.accept
  *
  * @param   lc_tFile  Directory (!)
  * @param   pa_sName  File name
  * @return  true, if we have a file ending with .zip, false otherwise
  */
 @Override
 public boolean accept(File pa_tFile)
 {
  boolean lc_bResult = false;

  if (null != pa_tFile)
  {
   if (true == pa_tFile.isFile())
   {
    try 
    {
     lc_bResult  = pa_tFile.getCanonicalPath().endsWith(SkyrimCharacterHelperConstants.SKH_FILE_EXTENSION_ESS);
     lc_bResult |= pa_tFile.getCanonicalPath().endsWith(SkyrimCharacterHelperConstants.SKH_FILE_EXTENSION_ESS_BAK);
    } 
    catch (IOException lc_tException) 
    {}
   }
  }
  return lc_bResult;
 }  
}
