/**
 * SkyrimCharacterHelper
 * 
 * UI based tool to save and backup skyrim character save-files
 * 
 */
package skyrimcharacterhelper;



/**
 * Imports
 *
 */
import java.awt.image.BufferedImage;



/**
 * Class storing a Skyrim screenshot
 * 
 * @author Ulf Wagemann
 */
public class SkyrimCharacterHelperScreenshot 
{
 private BufferedImage m_tImage ;
 private int           m_iWidth ;
 private int           m_iHeight;
 
 
 /**
  * Constructor
  * 
  */ 
 public SkyrimCharacterHelperScreenshot()
 {
  m_tImage = null;
  m_iWidth     = 0   ;
  m_iHeight    = 0   ;
 }
 
 
 
 /**
  * Initializes the object
  * 
  * @param pa_iWidth   image width
  * @param pa_iHeight  image height
  */
 public final void init(int pa_iWidth, int pa_iHeight) 
 {
   m_iWidth  = pa_iWidth;
   m_iHeight = pa_iHeight;
   
   m_tImage  = new BufferedImage(m_iWidth, m_iHeight, BufferedImage.TYPE_INT_RGB);
 }
 
 
 
 /**
  * Initializes the object
  * 
  * @param pa_iWidth   image width
  * @param pa_iHeight  image height
  * @param pa_tImage   image
  */
 public final void init(int pa_iWidth, int pa_iHeight, BufferedImage pa_tImage)
 {
  m_iWidth  = pa_iWidth;
  m_iHeight = pa_iHeight;
  m_tImage  = pa_tImage;
 }
 
 
 /**
  * Returns the image
  * 
  * @return   image, may be null
  */
 public final BufferedImage getImage() {return m_tImage;}
 
 
 
 /**
  * Returns the image width
  * 
  * @return    width, may be 0
  */
 public final int getWidth() {return m_iWidth;}

 
 
 /**
  * Returns the image height
  * 
  * @return    height, may be 0
  */
 public final int getHeight() {return m_iHeight;}

 
 
 
 /**
  * Sets the RGB value at the given poimt
  * 
  * @param pa_iX      x coordinate
  * @param pa_iY      y coordinate
  * @param pa_iValue  RGB value
  */
 public final void setRGB(int pa_iX, int pa_iY, int pa_iValue)
 {
  if (null != m_tImage)
  {
   m_tImage.setRGB(pa_iX, pa_iY, pa_iValue); 
  }
 }

} // eoc
