/**
 * SkyrimCharacterHelper
 * 
 * UI based tool to save and backup skyrim character save-files
 * 
 */
package skyrimcharacterhelper;

/**
 * Imports
 * 
 */
import java.awt.image.BufferedImage;
import java.awt.Dimension          ;
import java.awt.Image              ;
import java.awt.Color              ;
import java.awt.Graphics           ;
import java.awt.Graphics2D         ;
import java.awt.Toolkit            ;
import java.awt.RenderingHints     ;
import javax.swing.JPanel          ;
import java.util.ResourceBundle    ;




/**
 * Paint panel class
 * 
 * @author Ulf Wagemann
 */
public class SkyrimCharacterHelperScreenshotPanel extends JPanel
{
 private BufferedImage  m_tImage          ;
 private RenderingHints m_tRenderingHints ;
 private Color          m_tColorBackground;
 private Color          m_tFrameColor     ;
 private Color          m_tShadowColor1   ;
 private Color          m_tShadowColor2   ;
 private JPanel         m_tPanelParent    ;


 
 /**
  * Constructor
  * 
  * @param pa_tParentPanel   parent panel
  */
 public SkyrimCharacterHelperScreenshotPanel(JPanel pa_tParentPanel, ResourceBundle pa_tResources)  
 {
  super();  

  m_tColorBackground   = getBackground();
  m_tFrameColor        = Color.black    ;
  m_tShadowColor1      = new Color(0x888888);
  m_tShadowColor2      = new Color(0xcccccc);
  m_tPanelParent       = pa_tParentPanel;
  m_tRenderingHints    = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);  
  
  //
  // if possible, get colors from resource file
  //
  if (null != pa_tResources)
  {
   try
   {
    m_tColorBackground   = new Color(Integer.valueOf((pa_tResources.getString(SkyrimCharacterHelperConstants.SKH_PAINTPANEL_BACKGROUND)), 16));
    m_tFrameColor        = new Color(Integer.valueOf((pa_tResources.getString(SkyrimCharacterHelperConstants.SKH_PAINTPANEL_FRAME     )), 16));
    m_tShadowColor1      = new Color(Integer.valueOf((pa_tResources.getString(SkyrimCharacterHelperConstants.SKH_PAINTPANEL_SHADOW1   )), 16));
    m_tShadowColor2      = new Color(Integer.valueOf((pa_tResources.getString(SkyrimCharacterHelperConstants.SKH_PAINTPANEL_SHADOW2   )), 16));
   }
   catch (Exception lc_tException) {}
  }
 }
 

 /**
  * Sets the image
  * 
  * @param pa_tImage    image
  */
 public final void setImage(BufferedImage pa_tImage)
 {
  m_tImage = pa_tImage;
  repaint();
 }
 
 
 
 /**
  * Returns the image for pasting it to clipboard
  * 
  * @return   image, may be null
  */
 public final Image getImage()
 {
  if (null != m_tImage)
  {
   if (null != m_tImage.getSource())
   {
    return Toolkit.getDefaultToolkit().createImage(m_tImage.getSource());
   }
  }
  return null;
 }
 
 
 
 
 /**
  * Returns the image for pasting it to clipboard
  * 
  * @return   image, may be null
  */
 public final BufferedImage getBufferedImage()
 {
  return m_tImage;
 }
 
 
 
 
 /**
  * Returns preferred size
  * 
  * @return   preferred size
  */
 @Override
 public Dimension getPreferredSize()
 {
  Dimension lc_tParentSize = (null != m_tPanelParent ? m_tPanelParent.getSize() : null);
  
  if (null != m_tImage)
  {
   return new Dimension(SkyrimCharacterHelperConstants.SKH_IMAGE_PADDING + m_tImage.getWidth(), SkyrimCharacterHelperConstants.SKH_IMAGE_PADDING + m_tImage.getHeight());
  }
  else
  {
   if (null != lc_tParentSize)
   {
    return new Dimension(lc_tParentSize.width, lc_tParentSize.height); 
   }
  }
  return new Dimension(100,100);
 }
 
 
 
 /**
  * Overriden paintComponent() method which first lets the superclass perform its drawings and then
  * calls the custom drawing method.
  *  
  * @param pa_tGraphics Paint on it!
  */ 
/**
  * Overriden paintComponent() method which first lets the superclass perform its drawings and then
  * calls the custom drawing method.
  * 
  * @param pa_tGraphics Paint on it!
  */ 
 @Override 
 public void paintComponent(Graphics pa_tGraphics)
 {
  super.paintComponent(pa_tGraphics);  
  
  Graphics2D lc_tGraphics2D = null;

  if (null != pa_tGraphics)
  {
   if (null != (lc_tGraphics2D = (Graphics2D) pa_tGraphics))
   {
    try
    {
     paintCustom(lc_tGraphics2D);  
    }
    catch (Exception lc_tException)
    {}
   }
  }
 }
 
 
 
 /**
  * Does the custom drawing, image + shadow
  * 
  * @param pa_tGraphics   paint on it :)
  */
 public void paintCustom(Graphics2D pa_tGraphics)
 {
  super.paintComponent(pa_tGraphics);  
  
  Graphics2D  lc_tGraphics2D         = null;
  Dimension   lc_tDimensionContainer = null;
  
  int lc_iX  = 0;
  int lc_iY  = 0;
  int lc_iDx = 0;
  int lc_iDy = 0;
  
  if (null != pa_tGraphics)
  {
   if (null != (lc_tGraphics2D = (Graphics2D) pa_tGraphics))
   {
    //
    // draw background
    //
    if (null != (lc_tDimensionContainer = getSize())) 
    {
     lc_tGraphics2D.setColor(m_tColorBackground); 
     lc_tGraphics2D.fillRect(0, 0, lc_tDimensionContainer.width, lc_tDimensionContainer.height);
    }

    //
    // draw screenshot
    //
    if (null != m_tImage)
    {
     lc_iDx = m_tImage.getWidth();
     lc_iDy = m_tImage.getHeight();
        
     lc_iX = Math.abs(lc_tDimensionContainer.width  - lc_iDx)/2;
     lc_iY = Math.abs(lc_tDimensionContainer.height - lc_iDy)/2;
         
     if (lc_iX < 0 || lc_iX > lc_tDimensionContainer.width ) lc_iX = 0;
     if (lc_iY < 0 || lc_iY > lc_tDimensionContainer.height) lc_iY = 0;
     
     //
     // draw shadow
     //
     lc_tGraphics2D.setColor(m_tShadowColor1);
     lc_tGraphics2D.drawRect(lc_iX+1, lc_iY+1, lc_iDx, lc_iDy);        

     lc_tGraphics2D.setColor(m_tShadowColor2);
     lc_tGraphics2D.drawRect(lc_iX+2, lc_iY+2, lc_iDx, lc_iDy);        
     
     //
     // draw black frame
     //
     lc_tGraphics2D.setColor(m_tFrameColor);
     lc_tGraphics2D.drawRect(lc_iX-1, lc_iY-1, lc_iDx+1, lc_iDy+1);        
     
     //
     // draw image
     //
     lc_tGraphics2D.drawRect(lc_iX, lc_iY, lc_iDx, lc_iDy);
     lc_tGraphics2D.drawImage(m_tImage, lc_iX, lc_iY, this);
    }
   }
  }
 } 
 
 
} // eoc
