/**
 * SkyrimCharacterHelper
 * 
 * UI based tool to save and backup skyrim character save-files
 * 
 */
package skyrimcharacterhelper;



/**
 * Imports
 * 
 */
import java.util.Locale          ;
import java.util.Date            ;
import java.text.DateFormat      ;
import java.text.SimpleDateFormat;

import java.awt.Component                 ;
import javax.swing.JTable                 ;
import javax.swing.JLabel                 ;
import javax.swing.border.Border          ;
import javax.swing.border.EmptyBorder     ;
import javax.swing.SwingConstants         ;
import javax.swing.table.TableCellRenderer;



/**
 * Table cell renderer. This renderer decides based on the column model (!!!) index which part
 * of the current value object is to be displayed as text. Tricky, eh? ;-) 
 * 
 * But this of course works only provided the table model supports this interpretation. See
 * SkyrimCharacterHelperTableModel.java for more information.
 * 
 * @author Ulf Wagemann
 */
public class SkyrimCharacterHelperTableCellRenderer extends JLabel
                                                    implements TableCellRenderer
{
 protected static Border             m_tNoFocusBorder;
 protected static Border             m_tFocusBorder  ; 
 protected static SimpleDateFormat   m_tTimeFormatter;
 
 
 
 /**
  * Constructor
  * 
  */
 public SkyrimCharacterHelperTableCellRenderer()
 { 
  super();
  
  m_tNoFocusBorder = new EmptyBorder(5,5,5,5);
  m_tFocusBorder   = new EmptyBorder(5,5,5,5);
  
  m_tTimeFormatter = (SimpleDateFormat) DateFormat.getDateTimeInstance(DateFormat.LONG, DateFormat.LONG, Locale.getDefault());
  
  setOpaque(true);
  setBorder(m_tNoFocusBorder);  
  setHorizontalTextPosition(SwingConstants.LEFT  );
  setVerticalTextPosition  (SwingConstants.CENTER);
 }

 
 
 /**
  * Returns the cell renderer component (basically itself)
  * 
  * @param pa_tTable               table
  * @param pa_tValue               cell value
  * @param pa_bIsSelected          cell selected?
  * @param pa_bCellHasFocus        has cell focus?
  * @param pa_iRow                 cell row     (view index)
  * @param pa_iColumn              cell column  (view index)
  * @return  JLabel
  */
 public Component getTableCellRendererComponent(JTable pa_tTable, Object pa_tValue, boolean pa_bIsSelected, boolean pa_bCellHasFocus, int pa_iRow, int pa_iColumn) 
 {
  SkyrimCharacterHelperSaveGame lc_tSaveGame    = null;
  
  if (null != pa_tTable && null != pa_tValue)
  {
   setBackground(true == pa_bIsSelected ? pa_tTable.getSelectionBackground() : pa_tTable.getBackground());
   setForeground(true == pa_bIsSelected ? pa_tTable.getSelectionForeground() : pa_tTable.getForeground());
   setBorder(true == pa_bCellHasFocus ? m_tFocusBorder : m_tNoFocusBorder);
   setFont(pa_tTable.getFont());  

   if (pa_tValue instanceof SkyrimCharacterHelperSaveGame)
   {
    if (null != (lc_tSaveGame = (SkyrimCharacterHelperSaveGame) pa_tValue))
    {
     switch(pa_tTable.convertColumnIndexToModel(pa_iColumn)) // view index -> model index
     {
      case 0 : setText(Integer.toString(lc_tSaveGame.getPlayerLevel())                                                ); break; // level
      case 1 : setText(lc_tSaveGame.getPlayerLocation()                                                               ); break; // location
      case 2 : setText(null != m_tTimeFormatter ? m_tTimeFormatter.format(new Date(lc_tSaveGame.getFileDate())) : null); break; // time
      case 3 : setText(lc_tSaveGame.getFileName()                                                                     ); break; // file path
      default: setText(pa_tValue.toString());
     } 
    }    
   }
  }
  return this;
 }
    
    
 
 
 
}
