/**
 * SkyrimCharacterHelper
 * 
 * UI based tool to save and backup skyrim character save-files
 * 
 */
package skyrimcharacterhelper;



/**
 * Imports
 * 
 */
import javax.swing.table.AbstractTableModel;
import java.util.ArrayList ;
import java.util.Arrays    ;
import java.util.List      ;



/**
 * Threadsafe table model for savegames (that's why all the stuff is synchronized...)
 * 
 * @author Ulf Wagemann
 */
public class SkyrimCharacterHelperTableModel extends AbstractTableModel
{
 private ArrayList<SkyrimCharacterHelperSaveGame> m_tModel;
 protected static String[]                        m_tColumnHeaders;

 
 
 /**
  * Constructor
  * 
  */
 public SkyrimCharacterHelperTableModel(String[] pa_tColumnHeaders)
 {
  super();
  m_tModel = new ArrayList<>();
  m_tColumnHeaders = pa_tColumnHeaders;  
 }
 
 
 
 /**
  * Returns the model's size
  * 
  * @return   size, may be 0
  */
 public final synchronized int getSize() 
 {
  return (null != m_tModel ? m_tModel.size() : 0);
 }

  
  
 /**
  * Returns the model's size
  * 
  * @return   size, may be 0
  */
 public final synchronized int size() 
 {
  return (null != m_tModel ? m_tModel.size() : 0);
 }

 
 /**
  * Tests whether the given object is element of the model
  * 
  * @param pa_tElement  element to test
  * @return false, if the object is not part of the model, true otherwise
  */
 public final synchronized boolean contains(SkyrimCharacterHelperSaveGame pa_tElement) 
 {
  return (null != m_tModel ? m_tModel.contains(pa_tElement) : false);
 }
  
  
  
 /**
  * Returns a list of savegames
  * 
  * @return   list of savegames, may be null
  */
 public final synchronized List<SkyrimCharacterHelperSaveGame> getSaveGames()
 {
  ArrayList<SkyrimCharacterHelperSaveGame> lc_tList     = new ArrayList<>();
  SkyrimCharacterHelperSaveGame            lc_tSaveGame = null;
  
  if (0 < getSize())
  {
   if (null != lc_tList)
   {
    for (Object lc_tValue : m_tModel) 
    {
     if (null != lc_tValue)
     {
      if (lc_tValue instanceof SkyrimCharacterHelperSaveGame)
      {
       if (null != (lc_tSaveGame = (SkyrimCharacterHelperSaveGame) lc_tValue))
       {
        lc_tList.add(lc_tSaveGame); 
       }
      }
     }
    }// for
   }
  }
  return lc_tList;
 }
  

 
 /**
  * AbstractTableModel.getRowCount
  * 
  * @return   amount of rows, may be 0
  */
 @Override
 public synchronized int getRowCount() 
 {
  return getSize();
 }

 
 
 /**
  * AbstractTableModel.getColumnCount
  * 
  * @return  SKH_TABLE_COLUMNS
  */
 @Override
 public synchronized int getColumnCount() 
 {
  return SkyrimCharacterHelperConstants.SKH_TABLE_COLUMNS;
 }

 
 
 /**
  * AbstractTableModel.isCellEditable
  * 
  * @param pa_iRowIndex  row index
  * @param pa_iColumnIndex  colum index
  * @return false
  */
 @Override
 public synchronized boolean isCellEditable(int pa_iRowIndex, int pa_iColumnIndex) {return false;}
 
 
 
 
 /**
  * AbstractTableModel.getColumnName
  * 
  * @param pa_iIndex  index
  * @return column name
  */
 @Override
 public synchronized String getColumnName(int pa_iIndex)
 {
  return m_tColumnHeaders[pa_iIndex];
 }
 
 
 
 /**
  * Checks hwether the model containsthe savegame and returns its model index
  * 
  * @param pa_tSaveGame
  * @return -1 in case of error or not found
  */
 public final synchronized int indexOf(SkyrimCharacterHelperSaveGame pa_tSaveGame)
 {
  return (null != m_tModel ? m_tModel.indexOf(pa_tSaveGame) : -1);
 }
 
 

 /**
  * Returns the savegame at the given row
  * 
  * @param pa_iRowIndex  row
  * @return object, may be null
  */
 public synchronized Object get(int pa_iRowIndex)
 {
  SkyrimCharacterHelperSaveGame lc_tSaveGame = null;
  Object                        lc_tObject   = null;
   
  if (0 < getSize())
  {
   if (0 <= pa_iRowIndex && pa_iRowIndex < getSize())   
   {
    if (null != (lc_tObject =  m_tModel.get(pa_iRowIndex)))
    {
     if (lc_tObject instanceof SkyrimCharacterHelperSaveGame)
     {
      lc_tSaveGame = (SkyrimCharacterHelperSaveGame) lc_tObject; 
     }
    }
   }
  }
  return lc_tSaveGame;
 }
 
 
 
 /**
  * AbstractTableModel.getValueAt
  * 
  * @return   we don't care about the column, because our TableCellRenderer will sort this out,
  * if we provide it with a SkyrimCharacterHelperSaveGame :)
  */
 public synchronized Object getValueAt(int pa_iRowIndex, int pa_iColumnIndex) 
 {
  SkyrimCharacterHelperSaveGame lc_tSaveGame = null;
  Object                        lc_tObject   = null;
  
  if (0 < getSize())
  {
   if (0 <= pa_iRowIndex && pa_iRowIndex < getSize())   
   {
    if (0 <= pa_iColumnIndex && pa_iColumnIndex < SkyrimCharacterHelperConstants.SKH_TABLE_COLUMNS) 
    {
     if (null != (lc_tObject =  m_tModel.get(pa_iRowIndex)))
     {
      if (lc_tObject instanceof SkyrimCharacterHelperSaveGame)
      {
       lc_tSaveGame = (SkyrimCharacterHelperSaveGame) lc_tObject; 
      }
     }
    }
   }
  }
  return lc_tSaveGame;
 }
 
 
 
 /**
  * AbstractTableModel.getColumnClass
  * 
  * @param pa_iColumnIndex column index
  * @return SkyrimCharacterHelperSaveGame.class
  */
 @Override
 public synchronized Class<?> getColumnClass(int pa_iColumnIndex) 
 {
  return SkyrimCharacterHelperSaveGame.class;
 }
   
 
 
 /**
  * Adds the given savegame to the model
  * 
  * @param pa_tSaveGame   savegame to add
  */
 public synchronized final int add(SkyrimCharacterHelperSaveGame pa_tSaveGame)
 {
  int lc_iIndex = -1;
  
  if (null != m_tModel && null != pa_tSaveGame)
  {
   if (-1 != (lc_iIndex = m_tModel.indexOf(pa_tSaveGame)))
   {
    m_tModel.set(lc_iIndex, pa_tSaveGame);
    fireTableRowsUpdated(lc_iIndex, lc_iIndex);
   }
   else
   {
    if (true == m_tModel.add(pa_tSaveGame))
    {
     if (-1 != (lc_iIndex = m_tModel.indexOf(pa_tSaveGame)))
     {
      fireTableRowsInserted(lc_iIndex, lc_iIndex);
     }
    }
   }
  }
  if (0 == getSize()) lc_iIndex = -1;
  
  return lc_iIndex;
 }
 
 
   
 /**
  * Removes the given element
  * 
  * @param pa_tElement  element to remove
  * @return true, if the element could be removed, false otherwise
  */
 public final synchronized int removeElement(SkyrimCharacterHelperSaveGame pa_tElement) 
 {
  int lc_iPos = -1;
  
  if (0 < getSize())
  {
   if (null != pa_tElement)
   {
    if (-1 != (lc_iPos = m_tModel.indexOf(pa_tElement)))
    {
     m_tModel.remove(pa_tElement);
     if (0 < getSize())fireTableRowsDeleted(lc_iPos, lc_iPos);
     else              fireTableDataChanged();
    }
   }
  }
  if (0       == getSize()) lc_iPos = -1; 
  if (lc_iPos >= getSize()) lc_iPos = getSize()-1; 
   
  return lc_iPos;
 }
  
  
  
 
 /**
  * Adss the given array of savegames to the model
  * 
  * @param pa_tSaveGames   stuff to add
  */
 public final synchronized boolean addAll(SkyrimCharacterHelperSaveGame[] pa_tSaveGames)
 {
  boolean lc_bAddOk = false;
  
  if (null != m_tModel && null != pa_tSaveGames)
  {
   if (0 < getSize()) m_tModel.clear();
   
   lc_bAddOk = m_tModel.addAll(Arrays.asList(pa_tSaveGames));
   fireTableDataChanged();
  }
  return lc_bAddOk;
 }
 
 
 
 /**
  * Returns an array of savegames
  * 
  * @return   array of savegames, my be null
  */
 public final synchronized SkyrimCharacterHelperSaveGame[] elements()
 {
  SkyrimCharacterHelperSaveGame[] lc_tResult = null;
  
  int lc_iCount = 0;
  
  if (0 < getSize())
  {
   if (null != (lc_tResult = new SkyrimCharacterHelperSaveGame[getSize()])) 
   {
    for (SkyrimCharacterHelperSaveGame lc_tSaveGame : m_tModel)
    {
     lc_tResult[lc_iCount++] =  lc_tSaveGame;
    }
   }
  }
  return lc_tResult;
 }
 
 
 
 /**
  * Clears the whole model
  * 
  */
 public final synchronized void clear()
 {
  if (0 < getSize())
  {
   m_tModel.clear();
   fireTableDataChanged();
  }   
 }
 

 /**
  * Returns a list of savegames for the given indices
  * 
  * @param pa_tIndices
  * @return  list of savegames, may be null
  */
 public final synchronized java.util.List<SkyrimCharacterHelperSaveGame> getSaveGamesForIndices(int[] pa_tIndices)
 {
  ArrayList<SkyrimCharacterHelperSaveGame> lc_tList     = null;
  SkyrimCharacterHelperSaveGame            lc_tSaveGame = null;
  
  int lc_iAmount = 0;
  
  if (0 < getSize())
  {
   if (null != pa_tIndices)
   {
    if (0 < (lc_iAmount = pa_tIndices.length)) 
    {
     if (null != (lc_tList = new ArrayList<>()))
     {
      for (int lc_iIndex : pa_tIndices) 
      {
       if (0 <= lc_iIndex && lc_iIndex < getSize())
       {
        if (null != (lc_tSaveGame = m_tModel.get(lc_iIndex))) 
        {
         lc_tList.add(lc_tSaveGame);   
        }
       }
      }
     }
    }
   }
  }
  return lc_tList;
 }
 
 
} // eoc
