/*
 * Decompiled with CFR 0.152.
 */
package ace64base;

import ace64base.Ace64BaseGuiConnector;
import ace64base.Ace64BaseMainView;
import ace64base.Base64;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.jdesktop.application.Application;
import org.jdesktop.application.SingleFrameApplication;

public class Ace64BaseApp
extends SingleFrameApplication
implements Ace64BaseGuiConnector,
WindowListener {
    private Ace64BaseMainView m_tView;
    private ResourceBundle m_tLocalizedMessages = ResourceBundle.getBundle("ace64base/resources/Ace64BaseMessages");
    private String m_sEncryptFilePath = null;
    private String m_sEncryptDestinationPath = null;
    private String m_sDecryptFilePath = null;
    private String m_sDecryptDestinationPath = null;
    private Ace64BaseWorker m_tWorkerThread = null;
    private static final int BYTE_BUFFER_CHUNK_SIZE = 131072;

    @Override
    protected void startup() {
        this.m_tView = new Ace64BaseMainView(this, this);
        if (null != this.m_tView) {
            this.show(this.m_tView);
        }
    }

    @Override
    protected void configureWindow(Window root) {
    }

    public static Ace64BaseApp getApplication() {
        return Application.getInstance(Ace64BaseApp.class);
    }

    public static void main(String[] args) {
        Ace64BaseApp.launch(Ace64BaseApp.class, args);
    }

    private void handleProgramExit() {
        this.m_tView.setVisible(false);
        this.m_tView.dispose();
        System.exit(1);
    }

    private String getLocalizedString(String pa_sKey) {
        return null != this.m_tLocalizedMessages ? this.m_tLocalizedMessages.getString(pa_sKey) : "";
    }

    @Override
    public void windowClosing(WindowEvent pa_tEvent) {
        Object lc_tWindowObject = null;
        lc_tWindowObject = pa_tEvent.getSource();
        if (null != lc_tWindowObject && lc_tWindowObject instanceof JFrame && (JFrame)lc_tWindowObject == this.m_tView) {
            this.handleProgramExit();
        }
    }

    @Override
    public void windowClosed(WindowEvent pa_tEvent) {
    }

    @Override
    public void windowOpened(WindowEvent pa_tEvent) {
        Object lc_tWindowObject = null;
        lc_tWindowObject = pa_tEvent.getSource();
        if (null == lc_tWindowObject || !(lc_tWindowObject instanceof JFrame) || (JFrame)lc_tWindowObject == this.m_tView) {
            // empty if block
        }
    }

    @Override
    public void windowIconified(WindowEvent pa_tEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent pa_tEvent) {
    }

    @Override
    public void windowActivated(WindowEvent pa_tEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent pa_tEvent) {
    }

    @Override
    public void handleButtonEncryptClear() {
        this.m_tView.clearEncryptList();
    }

    @Override
    public void handleButtonEncryptRemove() {
        this.m_tView.removeSelectedEncryptListEntry();
    }

    @Override
    public void handleButtonEncryptAdd() {
        JFileChooser lc_tFileChooser = new JFileChooser();
        File[] lc_tFiles = null;
        if (null != lc_tFileChooser) {
            if (null != this.m_sEncryptFilePath) {
                lc_tFileChooser.setCurrentDirectory(new File(this.m_sEncryptFilePath));
            }
            lc_tFileChooser.setFileSelectionMode(0);
            lc_tFileChooser.setAcceptAllFileFilterUsed(true);
            lc_tFileChooser.setMultiSelectionEnabled(true);
            lc_tFileChooser.setDialogTitle(this.getLocalizedString("dialogTitleFileRequesterEncrypt"));
            lc_tFileChooser.setApproveButtonText(this.getLocalizedString("dialogOptionOk"));
            if (0 == lc_tFileChooser.showOpenDialog(this.m_tView) && null != (lc_tFiles = lc_tFileChooser.getSelectedFiles())) {
                try {
                    this.m_sEncryptFilePath = lc_tFileChooser.getCurrentDirectory().getCanonicalPath();
                }
                catch (IOException lc_tException) {
                    // empty catch block
                }
                for (File lc_tFile : lc_tFiles) {
                    if (null == lc_tFile || !lc_tFile.canRead()) continue;
                    try {
                        this.m_tView.addEncryptListEntry(lc_tFile.getCanonicalPath());
                    }
                    catch (IOException lc_tException) {
                        // empty catch block
                    }
                }
                this.m_tView.checkButtons();
            }
        }
    }

    @Override
    public void handleButtonEncryptSelectDestination() {
        JFileChooser lc_tFileChooser = new JFileChooser();
        File lc_tFile = null;
        if (null != lc_tFileChooser) {
            if (null != this.m_sEncryptDestinationPath) {
                lc_tFileChooser.setCurrentDirectory(new File(this.m_sEncryptDestinationPath));
            }
            lc_tFileChooser.setFileSelectionMode(1);
            lc_tFileChooser.setAcceptAllFileFilterUsed(false);
            lc_tFileChooser.setMultiSelectionEnabled(false);
            lc_tFileChooser.setDialogTitle(this.getLocalizedString("dialogTitleFileRequesterEncryptDestination"));
            lc_tFileChooser.setApproveButtonText(this.getLocalizedString("dialogOptionOk"));
            if (0 == lc_tFileChooser.showOpenDialog(this.m_tView) && null != (lc_tFile = lc_tFileChooser.getSelectedFile())) {
                if (lc_tFile.canWrite()) {
                    try {
                        this.m_sEncryptDestinationPath = lc_tFileChooser.getCurrentDirectory().getCanonicalPath();
                        this.m_tView.setEncryptDestination(lc_tFile.getCanonicalPath());
                    }
                    catch (IOException iOException) {}
                } else {
                    JOptionPane.showMessageDialog(this.m_tView, this.getLocalizedString("dialogTextNotWriteableError"), this.getLocalizedString("dialogTitleError"), 0);
                }
            }
        }
    }

    @Override
    public void handleButtonDecryptClear() {
        this.m_tView.clearDecryptList();
    }

    @Override
    public void handleButtonDecryptRemove() {
        this.m_tView.removeSelectedDecryptListEntry();
    }

    @Override
    public void handleButtonDecryptAdd() {
        JFileChooser lc_tFileChooser = new JFileChooser();
        File[] lc_tFiles = null;
        if (null != lc_tFileChooser) {
            if (null != this.m_sDecryptFilePath) {
                lc_tFileChooser.setCurrentDirectory(new File(this.m_sDecryptFilePath));
            }
            lc_tFileChooser.setFileSelectionMode(0);
            lc_tFileChooser.setAcceptAllFileFilterUsed(true);
            lc_tFileChooser.setMultiSelectionEnabled(true);
            lc_tFileChooser.setDialogTitle(this.getLocalizedString("dialogTitleFileRequesterDecrypt"));
            lc_tFileChooser.setApproveButtonText(this.getLocalizedString("dialogOptionOk"));
            if (0 == lc_tFileChooser.showOpenDialog(this.m_tView) && null != (lc_tFiles = lc_tFileChooser.getSelectedFiles())) {
                try {
                    this.m_sDecryptFilePath = lc_tFileChooser.getCurrentDirectory().getCanonicalPath();
                }
                catch (IOException lc_tException) {
                    // empty catch block
                }
                for (File lc_tFile : lc_tFiles) {
                    if (null == lc_tFile || !lc_tFile.canRead()) continue;
                    try {
                        this.m_tView.addDecryptListEntry(lc_tFile.getCanonicalPath());
                    }
                    catch (IOException lc_tException) {
                        // empty catch block
                    }
                }
                this.m_tView.checkButtons();
            }
        }
    }

    @Override
    public void handleButtonDecryptSelectDestination() {
        JFileChooser lc_tFileChooser = new JFileChooser();
        File lc_tFile = null;
        if (null != lc_tFileChooser) {
            if (null != this.m_sDecryptDestinationPath) {
                lc_tFileChooser.setCurrentDirectory(new File(this.m_sDecryptDestinationPath));
            }
            lc_tFileChooser.setFileSelectionMode(1);
            lc_tFileChooser.setAcceptAllFileFilterUsed(false);
            lc_tFileChooser.setMultiSelectionEnabled(false);
            lc_tFileChooser.setDialogTitle(this.getLocalizedString("dialogTitleFileRequesterDecryptDestination"));
            lc_tFileChooser.setApproveButtonText(this.getLocalizedString("dialogOptionOk"));
            if (0 == lc_tFileChooser.showOpenDialog(this.m_tView) && null != (lc_tFile = lc_tFileChooser.getSelectedFile())) {
                if (lc_tFile.canWrite()) {
                    try {
                        this.m_sDecryptDestinationPath = lc_tFileChooser.getCurrentDirectory().getCanonicalPath();
                        this.m_tView.setDecryptDestination(lc_tFile.getCanonicalPath());
                    }
                    catch (IOException iOException) {}
                } else {
                    JOptionPane.showMessageDialog(this.m_tView, this.getLocalizedString("dialogTextNotWriteableError"), this.getLocalizedString("dialogTitleError"), 0);
                }
            }
        }
    }

    @Override
    public void handleButtonCancel() {
        if (null != this.m_tWorkerThread) {
            this.m_tWorkerThread.cancel(true);
        }
    }

    @Override
    public void handleButtonStart() {
        this.m_tWorkerThread = new Ace64BaseWorker();
        if (null != this.m_tWorkerThread) {
            this.m_tView.lockGui(true);
            this.m_tView.clearLog();
            this.m_tWorkerThread.init();
            this.m_tWorkerThread.execute();
        }
    }

    @Override
    public void handleButtonCopyToClipboard() {
        StringSelection lc_tStringSelection = null;
        lc_tStringSelection = new StringSelection(this.m_tView.getLog());
        if (null != lc_tStringSelection) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(lc_tStringSelection, null);
        }
    }

    public final void handleWorkerThreadFinished(String pa_sMessage) {
        JOptionPane.showMessageDialog(this.m_tView, pa_sMessage, this.getLocalizedString("dialogTitleInformation"), 1);
        this.m_tView.addLogMessage(this.getLocalizedString("localizedMessageFinished"));
        this.m_tView.resetProgress();
        this.m_tView.lockGui(false);
        this.m_tView.checkButtons();
    }

    class Ace64BaseWorker
    extends SwingWorker {
        private Object[] m_tEncryptFiles = null;
        private Object[] m_tDecryptFiles = null;
        private String m_sEncryptDir = null;
        private String m_sDecryptDir = null;
        private int m_iEncryptedOk = 0;
        private int m_iDecryptedOk = 0;
        private int m_iEncryptedAmount = 0;
        private int m_iDecryptedAmount = 0;

        Ace64BaseWorker() {
        }

        public void init() {
            this.m_tDecryptFiles = Ace64BaseApp.this.m_tView.getDecryptFiles();
            this.m_tEncryptFiles = Ace64BaseApp.this.m_tView.getEncryptFiles();
            this.m_sDecryptDir = Ace64BaseApp.this.m_tView.getDecryptDestination();
            this.m_sEncryptDir = Ace64BaseApp.this.m_tView.getEncryptDestination();
        }

        public Object doInBackground() {
            File lc_tFile = null;
            int lc_iCount = 0;
            int lc_iSize = 0;
            int lc_iToGo = 0;
            int lc_iLength = 0;
            String lc_sDestinationFileName = null;
            String lc_sSeparator = System.getProperty("file.separator");
            String lc_sFileName = null;
            String lc_sLogMessage = null;
            this.m_iEncryptedAmount = null != this.m_tEncryptFiles ? this.m_tEncryptFiles.length : 0;
            this.m_iDecryptedAmount = null != this.m_tDecryptFiles ? this.m_tDecryptFiles.length : 0;
            lc_iToGo = lc_iSize = this.m_iDecryptedAmount + this.m_iEncryptedAmount;
            if (0 < lc_iSize) {
                Ace64BaseApp.this.m_tView.initTotalProgress(lc_iSize);
                Ace64BaseApp.this.m_tView.setProgressTotalString(new Integer(lc_iSize).toString());
                if (null != this.m_tEncryptFiles && 0 < this.m_tEncryptFiles.length) {
                    Ace64BaseApp.this.m_tView.setProgressModeString(Ace64BaseApp.this.getLocalizedString("localizedModeEncrpyting"));
                    this.m_iEncryptedOk = 0;
                    for (Object lc_tFileName : this.m_tEncryptFiles) {
                        if (this.isCancelled()) {
                            return null;
                        }
                        Ace64BaseApp.this.m_tView.setProgressCurrentString(Integer.toString(lc_iToGo--));
                        if (!(lc_tFileName instanceof String) || null == (lc_sFileName = (String)lc_tFileName)) continue;
                        lc_sLogMessage = Ace64BaseApp.this.getLocalizedString("localizedMessageEncrpyting") + " " + lc_sFileName + " > ";
                        lc_tFile = new File((String)lc_tFileName);
                        if (null == lc_tFile) continue;
                        if (lc_tFile.isFile()) {
                            lc_sDestinationFileName = this.m_sEncryptDir + lc_sSeparator + lc_tFile.getName();
                            lc_iLength = (int)lc_tFile.length();
                            lc_sLogMessage = lc_sLogMessage + lc_sDestinationFileName + " ... ";
                            Ace64BaseApp.this.m_tView.setCurrentFile(lc_sFileName);
                            Ace64BaseApp.this.m_tView.initCurrentProgress(lc_iLength);
                            if (this.encodeBase64(lc_sFileName, lc_iLength, lc_sDestinationFileName)) {
                                ++this.m_iEncryptedOk;
                                lc_sLogMessage = lc_sLogMessage + Ace64BaseApp.this.getLocalizedString("localizedMessageResultOk");
                            } else {
                                lc_sLogMessage = true == this.isCancelled() ? lc_sLogMessage + Ace64BaseApp.this.getLocalizedString("localizedMessageCancelled") : lc_sLogMessage + Ace64BaseApp.this.getLocalizedString("localizedMessageResultError");
                            }
                        }
                        Ace64BaseApp.this.m_tView.addLogMessage(lc_sLogMessage);
                        if (this.isCancelled()) continue;
                        Ace64BaseApp.this.m_tView.setTotalProgress(++lc_iCount);
                    }
                }
                if (null != this.m_tDecryptFiles && 0 < this.m_tDecryptFiles.length) {
                    Ace64BaseApp.this.m_tView.setProgressModeString(Ace64BaseApp.this.getLocalizedString("localizedModeDecrpyting"));
                    this.m_iDecryptedOk = 0;
                    for (Object lc_tFileName : this.m_tDecryptFiles) {
                        if (this.isCancelled()) {
                            return null;
                        }
                        Ace64BaseApp.this.m_tView.setProgressCurrentString(Integer.toString(lc_iToGo--));
                        if (!(lc_tFileName instanceof String)) continue;
                        lc_sFileName = (String)lc_tFileName;
                        lc_sLogMessage = Ace64BaseApp.this.getLocalizedString("localizedMessageDecrpyting") + " " + lc_sFileName + " > ";
                        lc_tFile = new File((String)lc_tFileName);
                        if (null == lc_tFile) continue;
                        if (lc_tFile.isFile()) {
                            lc_sDestinationFileName = this.m_sDecryptDir + lc_sSeparator + lc_tFile.getName();
                            lc_iLength = (int)lc_tFile.length();
                            lc_sLogMessage = lc_sLogMessage + lc_sDestinationFileName + " ... ";
                            Ace64BaseApp.this.m_tView.setCurrentFile((String)lc_tFileName);
                            Ace64BaseApp.this.m_tView.initCurrentProgress(lc_iLength);
                            if (this.decodeBase64(lc_sFileName, lc_iLength, lc_sDestinationFileName)) {
                                ++this.m_iDecryptedOk;
                                lc_sLogMessage = lc_sLogMessage + Ace64BaseApp.this.getLocalizedString("localizedMessageResultOk");
                            } else {
                                lc_sLogMessage = true == this.isCancelled() ? lc_sLogMessage + Ace64BaseApp.this.getLocalizedString("localizedMessageCancelled") : lc_sLogMessage + Ace64BaseApp.this.getLocalizedString("localizedMessageResultError");
                            }
                        }
                        Ace64BaseApp.this.m_tView.addLogMessage(lc_sLogMessage);
                        if (this.isCancelled()) continue;
                        Ace64BaseApp.this.m_tView.setTotalProgress(++lc_iCount);
                    }
                }
            }
            return null;
        }

        @Override
        protected void done() {
            String lc_sMessage = "";
            if (0 < this.getEncryptedAmount()) {
                lc_sMessage = lc_sMessage + this.getEncryptedOk() + "/" + this.getEncryptedAmount() + " " + Ace64BaseApp.this.getLocalizedString("dialogTextResultEncryption") + "\n";
            }
            if (0 < this.getDecryptedAmount()) {
                lc_sMessage = lc_sMessage + this.getDecryptedOk() + "/" + this.getDecryptedAmount() + " " + Ace64BaseApp.this.getLocalizedString("dialogTextResultDecryption") + "\n";
            }
            Ace64BaseApp.this.handleWorkerThreadFinished(lc_sMessage);
        }

        public int getEncryptedOk() {
            return this.m_iEncryptedOk;
        }

        public int getEncryptedAmount() {
            return this.m_iEncryptedAmount;
        }

        public int getDecryptedOk() {
            return this.m_iDecryptedOk;
        }

        public int getDecryptedAmount() {
            return this.m_iDecryptedAmount;
        }

        private void writeBytes(FileOutputStream pa_tStream, byte[] pa_tBytes) {
            try {
                pa_tStream.write(pa_tBytes);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void createNewFile(String pa_sFileName) {
            File lc_tFile = new File(pa_sFileName);
            if (null != lc_tFile) {
                try {
                    lc_tFile.delete();
                    lc_tFile.createNewFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private void deleteFile(String pa_sFileName) {
            File lc_tFile = new File(pa_sFileName);
            if (null != lc_tFile) {
                lc_tFile.delete();
            }
        }

        public final boolean encodeBase64(String pa_sSourceFileName, int pa_iLength, String pa_sDestinationFileName) {
            OutputStream lc_tFileOutputStream;
            FileInputStream lc_tFileInputStream;
            boolean lc_bResult;
            block18: {
                lc_bResult = false;
                byte[] lc_tInputBytes = new byte[131072];
                int lc_lBytesRead = 0;
                long lc_lTotalBytesRead = 0L;
                lc_tFileInputStream = null;
                lc_tFileOutputStream = null;
                if (null != pa_sSourceFileName && null != pa_sDestinationFileName) {
                    this.createNewFile(pa_sDestinationFileName);
                    try {
                        lc_tFileInputStream = new FileInputStream(pa_sSourceFileName);
                        if (null == lc_tFileInputStream) break block18;
                        try {
                            lc_tFileOutputStream = new FileOutputStream(pa_sDestinationFileName);
                            if (null != lc_tFileOutputStream) {
                                while (-1 != lc_lBytesRead && !this.isCancelled()) {
                                    byte[] lc_tEncodedBytes = null;
                                    lc_lBytesRead = lc_tFileInputStream.read(lc_tInputBytes);
                                    lc_lTotalBytesRead += (long)lc_lBytesRead;
                                    if (!this.isCancelled()) {
                                        Ace64BaseApp.this.m_tView.setCurrentProgress((int)lc_lTotalBytesRead);
                                    }
                                    if (0 >= lc_lBytesRead) continue;
                                    if (lc_lBytesRead != 131072) {
                                        byte[] lc_tChunkBytes = new byte[lc_lBytesRead];
                                        if (null != lc_tChunkBytes) {
                                            System.arraycopy(lc_tInputBytes, 0, lc_tChunkBytes, 0, lc_lBytesRead);
                                            lc_tEncodedBytes = Base64.encodeToByte(lc_tChunkBytes, false);
                                        }
                                    } else {
                                        lc_tEncodedBytes = Base64.encodeToByte(lc_tInputBytes, true);
                                    }
                                    if (null == lc_tEncodedBytes) continue;
                                    ((FileOutputStream)lc_tFileOutputStream).write(lc_tEncodedBytes, 0, lc_tEncodedBytes.length);
                                }
                                lc_bResult = true;
                            }
                        }
                        catch (IOException lc_tException) {}
                    }
                    catch (IOException lc_tException) {
                        // empty catch block
                    }
                }
            }
            if (null != lc_tFileOutputStream) {
                try {
                    lc_tFileOutputStream.flush();
                    ((FileOutputStream)lc_tFileOutputStream).close();
                }
                catch (IOException lc_tException) {
                    // empty catch block
                }
            }
            if (null != lc_tFileInputStream) {
                try {
                    lc_tFileInputStream.close();
                }
                catch (IOException lc_tException) {
                    // empty catch block
                }
            }
            if (this.isCancelled()) {
                this.deleteFile(pa_sDestinationFileName);
                lc_bResult = false;
            }
            return lc_bResult;
        }

        public final boolean decodeBase64(String pa_sSourceFileName, int pa_iLength, String pa_sDestinationFileName) {
            OutputStream lc_tFileOutputStream;
            FileInputStream lc_tFileInputStream;
            boolean lc_bResult;
            block18: {
                lc_bResult = false;
                byte[] lc_tInputBytes = new byte[131072];
                int lc_lBytesRead = 0;
                long lc_lTotalBytesRead = 0L;
                lc_tFileInputStream = null;
                lc_tFileOutputStream = null;
                if (null != pa_sSourceFileName && null != pa_sDestinationFileName) {
                    try {
                        lc_tFileInputStream = new FileInputStream(pa_sSourceFileName);
                        if (null == lc_tFileInputStream) break block18;
                        this.createNewFile(pa_sDestinationFileName);
                        try {
                            lc_tFileOutputStream = new FileOutputStream(pa_sDestinationFileName);
                            if (null != lc_tFileOutputStream) {
                                lc_lBytesRead = 0;
                                while (-1 != lc_lBytesRead && !this.isCancelled()) {
                                    byte[] lc_tDecodedBytes = null;
                                    lc_lBytesRead = lc_tFileInputStream.read(lc_tInputBytes);
                                    lc_lTotalBytesRead += (long)lc_lBytesRead;
                                    if (!this.isCancelled()) {
                                        Ace64BaseApp.this.m_tView.setCurrentProgress((int)lc_lTotalBytesRead);
                                    }
                                    if (0 >= lc_lBytesRead) continue;
                                    if (lc_lBytesRead != 131072) {
                                        byte[] lc_tChunkBytes = new byte[lc_lBytesRead];
                                        if (null != lc_tChunkBytes) {
                                            System.arraycopy(lc_tInputBytes, 0, lc_tChunkBytes, 0, lc_lBytesRead);
                                            lc_tDecodedBytes = Base64.decode(lc_tChunkBytes);
                                        }
                                    } else {
                                        lc_tDecodedBytes = Base64.decode(lc_tInputBytes);
                                    }
                                    if (null == lc_tDecodedBytes) continue;
                                    ((FileOutputStream)lc_tFileOutputStream).write(lc_tDecodedBytes, 0, lc_tDecodedBytes.length);
                                }
                                lc_bResult = true;
                            }
                        }
                        catch (IOException lc_tException) {}
                    }
                    catch (IOException lc_tException) {
                        // empty catch block
                    }
                }
            }
            if (null != lc_tFileOutputStream) {
                try {
                    lc_tFileOutputStream.flush();
                    ((FileOutputStream)lc_tFileOutputStream).close();
                }
                catch (IOException lc_tException) {
                    // empty catch block
                }
            }
            if (null != lc_tFileInputStream) {
                try {
                    lc_tFileInputStream.close();
                }
                catch (IOException lc_tException) {
                    // empty catch block
                }
            }
            if (this.isCancelled()) {
                this.deleteFile(pa_sDestinationFileName);
                lc_bResult = false;
            }
            return lc_bResult;
        }
    }
}

