/*
 * Decompiled with CFR 0.152.
 */
package ace64base;

import ace64base.Ace64BaseGuiConnector;
import ace64base.Ace64BaseListCellRenderer;
import ace64base.Ace64BaseListModel;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class Ace64BaseMainView
extends JFrame
implements ListSelectionListener {
    private Ace64BaseGuiConnector m_tGuiConnector;
    private boolean m_bGuiLocked;
    private ResourceBundle m_tResources = ResourceBundle.getBundle("ace64base/resources/Ace64BaseMainView");
    private JButton jButtonDecryptAdd;
    private JButton jButtonDecryptClear;
    private JButton jButtonDecryptRemove;
    private JButton jButtonDecryptSelectDestination;
    private JButton jButtonEncryptAdd;
    private JButton jButtonEncryptClear;
    private JButton jButtonEncryptRemove;
    private JButton jButtonEncryptSelectDestination;
    private JButton jButtonLogCopy;
    private JButton jButtonProgressCancel;
    private JButton jButtonProgressStart;
    private JLabel jLabelDecryptDestination;
    private JLabel jLabelEncryptDestination;
    private JLabel jLabelProgressCurrent;
    private JLabel jLabelProgressFile;
    private JLabel jLabelProgressTotal;
    private JList jListDecrypt;
    private JList jListEncrypt;
    private JPanel jPanelDecrypt;
    private JPanel jPanelEncrypt;
    private JPanel jPanelLog;
    private JPanel jPanelProgress;
    private JProgressBar jProgressBarCurrent;
    private JProgressBar jProgressBarTotal;
    private JScrollPane jScrollPaneDecrypt;
    private JScrollPane jScrollPaneEncrypt;
    private JScrollPane jScrollPaneLog;
    private JTabbedPane jTabbedPaneFiles;
    private JTextArea jTextAreaLog;
    private JTextField jTextFieldDecryptDestination;
    private JTextField jTextFieldEncryptDestination;
    private JTextField jTextFieldProgressCurrent;
    private JTextField jTextFieldProgressFile;
    private JTextField jTextFieldProgressMode;
    private JTextField jTextFieldProgressTotal;

    public Ace64BaseMainView(Ace64BaseGuiConnector pa_tGuiConnector, WindowListener pa_tListener) {
        if (null != this.m_tResources) {
            UIManager.put("ProgressBar.background", new Color(Integer.valueOf(this.m_tResources.getString("jProgressBar.background"), 16)));
            UIManager.put("ProgressBar.foreground", new Color(Integer.valueOf(this.m_tResources.getString("jProgressBar.foreground"), 16)));
            UIManager.put("ProgressBar.selectionBackground", new Color(Integer.valueOf(this.m_tResources.getString("jProgressBar.selectionBackground"), 16)));
            UIManager.put("ProgressBar.selectionForeground", new Color(Integer.valueOf(this.m_tResources.getString("jProgressBar.selectionForeground"), 16)));
            UIManager.put("FileChooser.cancelButtonText", this.m_tResources.getString("jFileChooser.cancelText"));
        }
        this.initComponents();
        this.m_bGuiLocked = false;
        this.jListDecrypt.setModel(new Ace64BaseListModel());
        this.jListDecrypt.setCellRenderer(new Ace64BaseListCellRenderer());
        this.jListDecrypt.addListSelectionListener(this);
        this.jListEncrypt.setModel(new Ace64BaseListModel());
        this.jListEncrypt.setCellRenderer(new Ace64BaseListCellRenderer());
        this.jListEncrypt.addListSelectionListener(this);
        this.jTextAreaLog.setFont(this.jButtonDecryptAdd.getFont());
        this.m_tGuiConnector = pa_tGuiConnector;
        this.addWindowListener(pa_tListener);
    }

    @Override
    public void valueChanged(ListSelectionEvent pa_tEvent) {
        if (null != pa_tEvent && !pa_tEvent.getValueIsAdjusting()) {
            this.checkButtons();
        }
    }

    public void lockGui(boolean pa_bLock) {
        this.m_bGuiLocked = pa_bLock;
        this.checkButtons();
    }

    public void setEncryptDestination(String pa_sPath) {
        this.jTextFieldEncryptDestination.setText(pa_sPath);
        this.checkButtons();
    }

    public String getEncryptDestination() {
        return this.jTextFieldEncryptDestination.getText();
    }

    public void setDecryptDestination(String pa_sPath) {
        this.jTextFieldDecryptDestination.setText(pa_sPath);
        this.checkButtons();
    }

    public String getDecryptDestination() {
        return this.jTextFieldDecryptDestination.getText();
    }

    public void clearEncryptList() {
        Ace64BaseListModel lc_tModel = (Ace64BaseListModel)this.jListEncrypt.getModel();
        if (null != lc_tModel) {
            lc_tModel.clear();
            this.checkButtons();
        }
    }

    public void clearDecryptList() {
        Ace64BaseListModel lc_tModel = (Ace64BaseListModel)this.jListDecrypt.getModel();
        if (null != lc_tModel) {
            lc_tModel.clear();
            this.checkButtons();
        }
    }

    public final void clearLog() {
        this.jTextAreaLog.setText("");
        this.checkButtons();
    }

    public final void addLogMessage(String pa_sMessage) {
        this.jTextAreaLog.append(pa_sMessage + "\n");
    }

    public final String getLog() {
        return this.jTextAreaLog.getText();
    }

    public String getSelectedDecryptListEntry() {
        int lc_iPos = this.jListDecrypt.getSelectedIndex();
        return -1 != lc_iPos ? (String)this.jListDecrypt.getSelectedValue() : null;
    }

    public String getSelectedEncryptListEntry() {
        int lc_iPos = this.jListEncrypt.getSelectedIndex();
        return -1 != lc_iPos ? (String)this.jListEncrypt.getSelectedValue() : null;
    }

    public void removeSelectedEncryptListEntry() {
        int lc_iPos = this.jListEncrypt.getSelectedIndex();
        int lc_iNewSize = 0;
        Ace64BaseListModel lc_tModel = (Ace64BaseListModel)this.jListEncrypt.getModel();
        if (-1 != lc_iPos && null != lc_tModel) {
            lc_tModel.removeElement(this.getSelectedEncryptListEntry());
            this.jListEncrypt.clearSelection();
            lc_iNewSize = lc_tModel.getSize();
            if (0 < lc_iNewSize) {
                if (lc_iPos >= lc_iNewSize) {
                    lc_iPos = lc_iNewSize - 1;
                }
                this.jListEncrypt.setSelectedIndex(lc_iPos);
            }
        }
        this.checkButtons();
    }

    public void removeSelectedDecryptListEntry() {
        int lc_iPos = this.jListDecrypt.getSelectedIndex();
        int lc_iNewSize = 0;
        Ace64BaseListModel lc_tModel = (Ace64BaseListModel)this.jListDecrypt.getModel();
        if (-1 != lc_iPos && null != lc_tModel) {
            lc_tModel.removeElement(this.getSelectedDecryptListEntry());
            this.jListDecrypt.clearSelection();
            lc_iNewSize = lc_tModel.getSize();
            if (0 < lc_iNewSize) {
                if (lc_iPos >= lc_iNewSize) {
                    lc_iPos = lc_iNewSize - 1;
                }
                this.jListDecrypt.setSelectedIndex(lc_iPos);
            }
        }
        this.checkButtons();
    }

    public void addEncryptListEntry(String pa_sFileName) {
        Ace64BaseListModel lc_tModel = (Ace64BaseListModel)this.jListEncrypt.getModel();
        if (null != lc_tModel) {
            lc_tModel.removeElement(pa_sFileName);
            lc_tModel.add(pa_sFileName);
        }
    }

    public void addDecryptListEntry(String pa_sFileName) {
        Ace64BaseListModel lc_tModel = (Ace64BaseListModel)this.jListDecrypt.getModel();
        if (null != lc_tModel) {
            lc_tModel.removeElement(pa_sFileName);
            lc_tModel.add(pa_sFileName);
        }
    }

    public Object[] getDecryptFiles() {
        Ace64BaseListModel lc_tModel = (Ace64BaseListModel)this.jListDecrypt.getModel();
        if (null != lc_tModel) {
            return lc_tModel.elements();
        }
        return null;
    }

    public Object[] getEncryptFiles() {
        Ace64BaseListModel lc_tModel = (Ace64BaseListModel)this.jListEncrypt.getModel();
        if (null != lc_tModel) {
            return lc_tModel.elements();
        }
        return null;
    }

    public void initCurrentProgress(int pa_iMaxValue) {
        final int lc_iFugly = pa_iMaxValue;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Ace64BaseMainView.this.jProgressBarCurrent.setMinimum(0);
                Ace64BaseMainView.this.jProgressBarCurrent.setMaximum(lc_iFugly);
                Ace64BaseMainView.this.jProgressBarCurrent.setValue(0);
            }
        });
    }

    public void initTotalProgress(int pa_iMaxValue) {
        final int lc_iFugly = pa_iMaxValue;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Ace64BaseMainView.this.jProgressBarTotal.setMinimum(0);
                Ace64BaseMainView.this.jProgressBarTotal.setMaximum(lc_iFugly);
                Ace64BaseMainView.this.jProgressBarTotal.setValue(0);
            }
        });
    }

    public void setCurrentProgress(int pa_iValue) {
        final int lc_iFugly = pa_iValue;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Ace64BaseMainView.this.jProgressBarCurrent.setValue(lc_iFugly);
            }
        });
    }

    public void resetProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Ace64BaseMainView.this.setCurrentProgress(0);
                Ace64BaseMainView.this.setTotalProgress(0);
                Ace64BaseMainView.this.setCurrentFile("");
                Ace64BaseMainView.this.setProgressModeString("");
                Ace64BaseMainView.this.setProgressTotalString("");
                Ace64BaseMainView.this.setProgressCurrentString("");
            }
        });
    }

    public void setTotalProgress(int pa_iValue) {
        final int lc_iFugly = pa_iValue;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Ace64BaseMainView.this.jProgressBarTotal.setValue(lc_iFugly);
            }
        });
    }

    public void setCurrentFile(String pa_sFile) {
        this.jTextFieldProgressFile.setText(pa_sFile);
    }

    public void setProgressModeString(String pa_sMode) {
        this.jTextFieldProgressMode.setText(pa_sMode);
    }

    public void setProgressTotalString(String pa_sTotal) {
        this.jTextFieldProgressTotal.setText(pa_sTotal);
    }

    public void setProgressCurrentString(String pa_sCurrent) {
        this.jTextFieldProgressCurrent.setText(pa_sCurrent);
    }

    public void checkButtons() {
        boolean lc_bHasEncryptFiles;
        boolean lc_bHasLog;
        Ace64BaseListModel lc_tModelEncrypt = (Ace64BaseListModel)this.jListEncrypt.getModel();
        Ace64BaseListModel lc_tModelDecrypt = (Ace64BaseListModel)this.jListDecrypt.getModel();
        String lc_sEncryptDestination = this.jTextFieldEncryptDestination.getText();
        String lc_sDecryptDestination = this.jTextFieldDecryptDestination.getText();
        String lc_sLog = this.jTextAreaLog.getText();
        boolean lc_bHasEncryptDestination = null != lc_sEncryptDestination && false == lc_sEncryptDestination.isEmpty();
        boolean lc_bHasDecryptDestination = null != lc_sDecryptDestination && false == lc_sDecryptDestination.isEmpty();
        boolean bl = lc_bHasLog = null != lc_sLog && false == lc_sLog.isEmpty();
        boolean bl2 = null != lc_tModelEncrypt ? 0 < lc_tModelEncrypt.getSize() : (lc_bHasEncryptFiles = false);
        boolean lc_bHasDecryptFiles = null != lc_tModelDecrypt ? 0 < lc_tModelDecrypt.getSize() : false;
        boolean lc_bHasEncryptSelection = -1 != this.jListEncrypt.getSelectedIndex();
        boolean lc_bHasDecryptSelection = -1 != this.jListDecrypt.getSelectedIndex();
        this.jButtonDecryptAdd.setEnabled(false == this.m_bGuiLocked);
        this.jButtonEncryptAdd.setEnabled(false == this.m_bGuiLocked);
        this.jButtonDecryptClear.setEnabled(false == this.m_bGuiLocked && true == lc_bHasDecryptFiles);
        this.jButtonEncryptClear.setEnabled(false == this.m_bGuiLocked && true == lc_bHasEncryptFiles);
        this.jButtonDecryptRemove.setEnabled(false == this.m_bGuiLocked && true == lc_bHasDecryptSelection && true == lc_bHasDecryptFiles);
        this.jButtonEncryptRemove.setEnabled(false == this.m_bGuiLocked && true == lc_bHasEncryptSelection && true == lc_bHasEncryptFiles);
        this.jButtonDecryptSelectDestination.setEnabled(false == this.m_bGuiLocked);
        this.jButtonEncryptSelectDestination.setEnabled(false == this.m_bGuiLocked);
        this.jButtonLogCopy.setEnabled(false == this.m_bGuiLocked && true == lc_bHasLog);
        this.jButtonProgressCancel.setEnabled(true == this.m_bGuiLocked);
        this.jButtonProgressStart.setEnabled(false == this.m_bGuiLocked && (true == lc_bHasEncryptDestination && true == lc_bHasEncryptFiles || true == lc_bHasDecryptDestination && true == lc_bHasDecryptFiles));
    }

    private void jButtonProgressCancelactionPerformedButtonCancel(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonCancel();
        }
    }

    private void jButtonProgressStartactionPerformedButtonStart(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonStart();
        }
    }

    private void jButtonEncryptAddactionPerformedButtonEncryptAdd(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonEncryptAdd();
        }
    }

    private void jButtonEncryptRemoveactionPerformedButtonEncryptRemove(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonEncryptRemove();
        }
    }

    private void jButtonEncryptClearactionPerformedButtonEncryptClear(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonEncryptClear();
        }
    }

    private void jButtonEncryptSelectDestinationactionPerformedButtonEncryptSelectDestination(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonEncryptSelectDestination();
        }
    }

    private void jButtonDecryptAddactionPerformedButtonDecryptAdd(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonDecryptAdd();
        }
    }

    private void jButtonDecryptRemoveactionPerformedButtonDecryptRemove(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonDecryptRemove();
        }
    }

    private void jButtonDecryptClearactionPerformedButtonDecryptClear(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonDecryptClear();
        }
    }

    private void jButtonDecryptSelectDestinationactionPerformedButtonDecryptSelectDestination(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonDecryptSelectDestination();
        }
    }

    private void jButtonLogCopyactionPerformedButtonCopyToClipboard(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonCopyToClipboard();
        }
    }

    private void initComponents() {
        this.jPanelProgress = new JPanel();
        this.jLabelProgressCurrent = new JLabel();
        this.jLabelProgressTotal = new JLabel();
        this.jProgressBarCurrent = new JProgressBar();
        this.jProgressBarTotal = new JProgressBar();
        this.jButtonProgressCancel = new JButton();
        this.jButtonProgressStart = new JButton();
        this.jTextFieldProgressCurrent = new JTextField();
        this.jTextFieldProgressTotal = new JTextField();
        this.jLabelProgressFile = new JLabel();
        this.jTextFieldProgressFile = new JTextField();
        this.jTextFieldProgressMode = new JTextField();
        this.jTabbedPaneFiles = new JTabbedPane();
        this.jPanelEncrypt = new JPanel();
        this.jScrollPaneEncrypt = new JScrollPane();
        this.jListEncrypt = new JList();
        this.jLabelEncryptDestination = new JLabel();
        this.jTextFieldEncryptDestination = new JTextField();
        this.jButtonEncryptAdd = new JButton();
        this.jButtonEncryptRemove = new JButton();
        this.jButtonEncryptClear = new JButton();
        this.jButtonEncryptSelectDestination = new JButton();
        this.jPanelDecrypt = new JPanel();
        this.jScrollPaneDecrypt = new JScrollPane();
        this.jListDecrypt = new JList();
        this.jLabelDecryptDestination = new JLabel();
        this.jButtonDecryptAdd = new JButton();
        this.jButtonDecryptRemove = new JButton();
        this.jButtonDecryptClear = new JButton();
        this.jButtonDecryptSelectDestination = new JButton();
        this.jTextFieldDecryptDestination = new JTextField();
        this.jPanelLog = new JPanel();
        this.jScrollPaneLog = new JScrollPane();
        this.jTextAreaLog = new JTextArea();
        this.jButtonLogCopy = new JButton();
        this.setDefaultCloseOperation(0);
        ResourceBundle bundle = ResourceBundle.getBundle("ace64base/resources/Ace64BaseMainView");
        this.setTitle(bundle.getString("Form.title"));
        this.setName("Form");
        this.jPanelProgress.setBorder(BorderFactory.createTitledBorder(bundle.getString("jPanelProgress.border.title")));
        this.jPanelProgress.setName("jPanelProgress");
        this.jLabelProgressCurrent.setLabelFor(this.jProgressBarCurrent);
        this.jLabelProgressCurrent.setText(bundle.getString("jLabelProgressCurrent.text"));
        this.jLabelProgressCurrent.setName("jLabelProgressCurrent");
        this.jLabelProgressTotal.setLabelFor(this.jProgressBarTotal);
        this.jLabelProgressTotal.setText(bundle.getString("jLabelProgressTotal.text"));
        this.jLabelProgressTotal.setName("jLabelProgressTotal");
        this.jProgressBarCurrent.setName("jProgressBarCurrent");
        this.jProgressBarCurrent.setStringPainted(true);
        this.jProgressBarTotal.setName("jProgressBarTotal");
        this.jProgressBarTotal.setStringPainted(true);
        this.jButtonProgressCancel.setText(bundle.getString("jButtonProgressCancel.text"));
        this.jButtonProgressCancel.setEnabled(false);
        this.jButtonProgressCancel.setName("jButtonProgressCancel");
        this.jButtonProgressCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Ace64BaseMainView.this.jButtonProgressCancelactionPerformedButtonCancel(evt);
            }
        });
        this.jButtonProgressStart.setText(bundle.getString("jButtonProgressStart.text"));
        this.jButtonProgressStart.setEnabled(false);
        this.jButtonProgressStart.setName("jButtonProgressStart");
        this.jButtonProgressStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Ace64BaseMainView.this.jButtonProgressStartactionPerformedButtonStart(evt);
            }
        });
        this.jTextFieldProgressCurrent.setEditable(false);
        this.jTextFieldProgressCurrent.setText(bundle.getString("jTextFieldProgressCurrent.text"));
        this.jTextFieldProgressCurrent.setName("jTextFieldProgressCurrent");
        this.jTextFieldProgressTotal.setEditable(false);
        this.jTextFieldProgressTotal.setText(bundle.getString("jTextFieldProgressTotal.text"));
        this.jTextFieldProgressTotal.setName("jTextFieldProgressTotal");
        this.jLabelProgressFile.setLabelFor(this.jTextFieldProgressFile);
        this.jLabelProgressFile.setText(bundle.getString("jLabelProgressFile.text"));
        this.jLabelProgressFile.setName("jLabelProgressFile");
        this.jTextFieldProgressFile.setEditable(false);
        this.jTextFieldProgressFile.setText(bundle.getString("jTextFieldProgressFile.text"));
        this.jTextFieldProgressFile.setName("jTextFieldProgressFile");
        this.jTextFieldProgressMode.setEditable(false);
        this.jTextFieldProgressMode.setText(bundle.getString("jTextFieldProgressMode.text"));
        this.jTextFieldProgressMode.setName("jTextFieldProgressMode");
        GroupLayout jPanelProgressLayout = new GroupLayout(this.jPanelProgress);
        this.jPanelProgress.setLayout(jPanelProgressLayout);
        jPanelProgressLayout.setHorizontalGroup(jPanelProgressLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelProgressLayout.createSequentialGroup().addContainerGap().addGroup(jPanelProgressLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelProgressLayout.createSequentialGroup().addComponent(this.jButtonProgressStart).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonProgressCancel)).addGroup(jPanelProgressLayout.createSequentialGroup().addGroup(jPanelProgressLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelProgressFile).addComponent(this.jLabelProgressCurrent).addComponent(this.jLabelProgressTotal)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanelProgressLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jProgressBarTotal, -1, 439, Short.MAX_VALUE).addComponent(this.jProgressBarCurrent, -1, 439, Short.MAX_VALUE).addComponent(this.jTextFieldProgressFile, -1, 439, Short.MAX_VALUE)).addGap(6, 6, 6).addGroup(jPanelProgressLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelProgressLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTextFieldProgressCurrent, -2, 36, -2).addComponent(this.jTextFieldProgressTotal, -2, 36, -2)).addComponent(this.jTextFieldProgressMode, -2, 36, -2)).addGap(8, 8, 8))).addContainerGap()));
        jPanelProgressLayout.linkSize(0, this.jTextFieldProgressCurrent, this.jTextFieldProgressMode, this.jTextFieldProgressTotal);
        jPanelProgressLayout.linkSize(0, this.jButtonProgressCancel, this.jButtonProgressStart);
        jPanelProgressLayout.linkSize(0, this.jLabelProgressCurrent, this.jLabelProgressFile, this.jLabelProgressTotal);
        jPanelProgressLayout.setVerticalGroup(jPanelProgressLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelProgressLayout.createSequentialGroup().addContainerGap().addGroup(jPanelProgressLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelProgressLayout.createSequentialGroup().addGroup(jPanelProgressLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelProgressFile).addComponent(this.jTextFieldProgressFile, -2, -1, -2).addComponent(this.jTextFieldProgressMode, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelProgressLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelProgressCurrent).addComponent(this.jProgressBarCurrent, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelProgressLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jProgressBarTotal, -2, -1, -2).addComponent(this.jLabelProgressTotal))).addGroup(jPanelProgressLayout.createSequentialGroup().addGap(26, 26, 26).addComponent(this.jTextFieldProgressCurrent, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldProgressTotal, -2, -1, -2))).addGap(18, 18, 18).addGroup(jPanelProgressLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonProgressCancel).addComponent(this.jButtonProgressStart)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelProgressLayout.linkSize(1, this.jButtonProgressCancel, this.jButtonProgressStart, this.jLabelProgressCurrent, this.jLabelProgressFile, this.jLabelProgressTotal, this.jProgressBarCurrent, this.jProgressBarTotal, this.jTextFieldProgressCurrent, this.jTextFieldProgressFile, this.jTextFieldProgressMode, this.jTextFieldProgressTotal);
        this.jTabbedPaneFiles.setName("jTabbedPaneFiles");
        this.jPanelEncrypt.setName("jPanelEncrypt");
        this.jScrollPaneEncrypt.setName("jScrollPaneEncrypt");
        this.jListEncrypt.setBackground(new Color(Integer.valueOf(bundle.getString("jList.background"), 16)));
        this.jListEncrypt.setForeground(new Color(Integer.valueOf(bundle.getString("jList.foreground"), 16)));
        this.jListEncrypt.setSelectionMode(0);
        this.jListEncrypt.setName("jListEncrypt");
        this.jListEncrypt.setSelectionBackground(new Color(Integer.valueOf(bundle.getString("jList.selectionBackground"), 16)));
        this.jListEncrypt.setSelectionForeground(new Color(Integer.valueOf(bundle.getString("jList.selectionForeground"), 16)));
        this.jScrollPaneEncrypt.setViewportView(this.jListEncrypt);
        this.jLabelEncryptDestination.setLabelFor(this.jTextFieldEncryptDestination);
        this.jLabelEncryptDestination.setText(bundle.getString("jLabelEncryptDestination.text"));
        this.jLabelEncryptDestination.setName("jLabelEncryptDestination");
        this.jTextFieldEncryptDestination.setEditable(false);
        this.jTextFieldEncryptDestination.setText(bundle.getString("jTextFieldEncryptDestination.text"));
        this.jTextFieldEncryptDestination.setName("jTextFieldEncryptDestination");
        this.jButtonEncryptAdd.setText(bundle.getString("jButtonEncryptAdd.text"));
        this.jButtonEncryptAdd.setName("jButtonEncryptAdd");
        this.jButtonEncryptAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Ace64BaseMainView.this.jButtonEncryptAddactionPerformedButtonEncryptAdd(evt);
            }
        });
        this.jButtonEncryptRemove.setText(bundle.getString("jButtonEncryptRemove.text"));
        this.jButtonEncryptRemove.setEnabled(false);
        this.jButtonEncryptRemove.setName("jButtonEncryptRemove");
        this.jButtonEncryptRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Ace64BaseMainView.this.jButtonEncryptRemoveactionPerformedButtonEncryptRemove(evt);
            }
        });
        this.jButtonEncryptClear.setText(bundle.getString("jButtonEncryptClear.text"));
        this.jButtonEncryptClear.setEnabled(false);
        this.jButtonEncryptClear.setName("jButtonEncryptClear");
        this.jButtonEncryptClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Ace64BaseMainView.this.jButtonEncryptClearactionPerformedButtonEncryptClear(evt);
            }
        });
        this.jButtonEncryptSelectDestination.setText(bundle.getString("jButtonEncryptSelectDestination.text"));
        this.jButtonEncryptSelectDestination.setName("jButtonEncryptSelectDestination");
        this.jButtonEncryptSelectDestination.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Ace64BaseMainView.this.jButtonEncryptSelectDestinationactionPerformedButtonEncryptSelectDestination(evt);
            }
        });
        GroupLayout jPanelEncryptLayout = new GroupLayout(this.jPanelEncrypt);
        this.jPanelEncrypt.setLayout(jPanelEncryptLayout);
        jPanelEncryptLayout.setHorizontalGroup(jPanelEncryptLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelEncryptLayout.createSequentialGroup().addContainerGap().addGroup(jPanelEncryptLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelEncryptLayout.createSequentialGroup().addComponent(this.jLabelEncryptDestination).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldEncryptDestination, -1, 394, Short.MAX_VALUE)).addComponent(this.jScrollPaneEncrypt, GroupLayout.Alignment.TRAILING, -1, 452, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelEncryptLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonEncryptSelectDestination, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonEncryptClear, -1, 85, Short.MAX_VALUE).addComponent(this.jButtonEncryptAdd, GroupLayout.Alignment.TRAILING, -1, 85, Short.MAX_VALUE).addComponent(this.jButtonEncryptRemove, GroupLayout.Alignment.TRAILING, -1, 85, Short.MAX_VALUE)).addContainerGap()));
        jPanelEncryptLayout.linkSize(0, this.jButtonEncryptAdd, this.jButtonEncryptClear, this.jButtonEncryptRemove, this.jButtonEncryptSelectDestination);
        jPanelEncryptLayout.setVerticalGroup(jPanelEncryptLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelEncryptLayout.createSequentialGroup().addContainerGap().addGroup(jPanelEncryptLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneEncrypt, -1, 319, Short.MAX_VALUE).addGroup(jPanelEncryptLayout.createSequentialGroup().addComponent(this.jButtonEncryptAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonEncryptRemove).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonEncryptClear))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanelEncryptLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldEncryptDestination, -2, -1, -2).addComponent(this.jButtonEncryptSelectDestination).addComponent(this.jLabelEncryptDestination)).addContainerGap()));
        jPanelEncryptLayout.linkSize(1, this.jButtonEncryptAdd, this.jButtonEncryptClear, this.jButtonEncryptRemove, this.jButtonEncryptSelectDestination, this.jLabelEncryptDestination, this.jTextFieldEncryptDestination);
        this.jTabbedPaneFiles.addTab(bundle.getString("jPanelEncrypt.TabConstraints.tabTitle"), this.jPanelEncrypt);
        this.jPanelDecrypt.setName("jPanelDecrypt");
        this.jScrollPaneDecrypt.setName("jScrollPaneDecrypt");
        this.jListDecrypt.setBackground(new Color(Integer.valueOf(bundle.getString("jList.background"), 16)));
        this.jListDecrypt.setForeground(new Color(Integer.valueOf(bundle.getString("jList.foreground"), 16)));
        this.jListDecrypt.setSelectionMode(0);
        this.jListDecrypt.setName("jListDecrypt");
        this.jListDecrypt.setSelectionBackground(new Color(Integer.valueOf(bundle.getString("jList.selectionBackground"), 16)));
        this.jListDecrypt.setSelectionForeground(new Color(Integer.valueOf(bundle.getString("jList.selectionForeground"), 16)));
        this.jScrollPaneDecrypt.setViewportView(this.jListDecrypt);
        this.jLabelDecryptDestination.setLabelFor(this.jTextFieldDecryptDestination);
        this.jLabelDecryptDestination.setText(bundle.getString("jLabelDecryptDestination.text"));
        this.jLabelDecryptDestination.setName("jLabelDecryptDestination");
        this.jButtonDecryptAdd.setText(bundle.getString("jButtonDecryptAdd.text"));
        this.jButtonDecryptAdd.setName("jButtonDecryptAdd");
        this.jButtonDecryptAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Ace64BaseMainView.this.jButtonDecryptAddactionPerformedButtonDecryptAdd(evt);
            }
        });
        this.jButtonDecryptRemove.setText(bundle.getString("jButtonDecryptRemove.text"));
        this.jButtonDecryptRemove.setEnabled(false);
        this.jButtonDecryptRemove.setName("jButtonDecryptRemove");
        this.jButtonDecryptRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Ace64BaseMainView.this.jButtonDecryptRemoveactionPerformedButtonDecryptRemove(evt);
            }
        });
        this.jButtonDecryptClear.setText(bundle.getString("jButtonDecryptClear.text"));
        this.jButtonDecryptClear.setEnabled(false);
        this.jButtonDecryptClear.setName("jButtonDecryptClear");
        this.jButtonDecryptClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Ace64BaseMainView.this.jButtonDecryptClearactionPerformedButtonDecryptClear(evt);
            }
        });
        this.jButtonDecryptSelectDestination.setText(bundle.getString("jButtonDecryptSelectDestination.text"));
        this.jButtonDecryptSelectDestination.setName("jButtonDecryptSelectDestination");
        this.jButtonDecryptSelectDestination.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Ace64BaseMainView.this.jButtonDecryptSelectDestinationactionPerformedButtonDecryptSelectDestination(evt);
            }
        });
        this.jTextFieldDecryptDestination.setEditable(false);
        this.jTextFieldDecryptDestination.setText(bundle.getString("jTextFieldDecryptDestination.text"));
        this.jTextFieldDecryptDestination.setName("jTextFieldDecryptDestination");
        GroupLayout jPanelDecryptLayout = new GroupLayout(this.jPanelDecrypt);
        this.jPanelDecrypt.setLayout(jPanelDecryptLayout);
        jPanelDecryptLayout.setHorizontalGroup(jPanelDecryptLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDecryptLayout.createSequentialGroup().addContainerGap().addGroup(jPanelDecryptLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDecryptLayout.createSequentialGroup().addComponent(this.jLabelDecryptDestination).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldDecryptDestination, -1, 390, Short.MAX_VALUE)).addComponent(this.jScrollPaneDecrypt, GroupLayout.Alignment.TRAILING, -1, 448, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelDecryptLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanelDecryptLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButtonDecryptRemove, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonDecryptClear, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonDecryptAdd, -2, 89, -2)).addComponent(this.jButtonDecryptSelectDestination, -2, 81, -2)).addContainerGap()));
        jPanelDecryptLayout.linkSize(0, this.jButtonDecryptAdd, this.jButtonDecryptClear, this.jButtonDecryptRemove, this.jButtonDecryptSelectDestination);
        jPanelDecryptLayout.setVerticalGroup(jPanelDecryptLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDecryptLayout.createSequentialGroup().addContainerGap().addGroup(jPanelDecryptLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDecryptLayout.createSequentialGroup().addComponent(this.jButtonDecryptAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDecryptRemove).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDecryptClear)).addGroup(GroupLayout.Alignment.TRAILING, jPanelDecryptLayout.createSequentialGroup().addComponent(this.jScrollPaneDecrypt, -1, 319, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanelDecryptLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelDecryptDestination).addComponent(this.jTextFieldDecryptDestination, -2, -1, -2).addComponent(this.jButtonDecryptSelectDestination)))).addContainerGap()));
        jPanelDecryptLayout.linkSize(1, this.jButtonDecryptAdd, this.jButtonDecryptClear, this.jButtonDecryptRemove, this.jButtonDecryptSelectDestination, this.jLabelDecryptDestination, this.jTextFieldDecryptDestination);
        this.jTabbedPaneFiles.addTab(bundle.getString("jPanelDecrypt.TabConstraints.tabTitle"), this.jPanelDecrypt);
        this.jPanelLog.setName("jPanelLog");
        this.jScrollPaneLog.setName("jScrollPaneLog");
        this.jTextAreaLog.setColumns(20);
        this.jTextAreaLog.setEditable(false);
        this.jTextAreaLog.setRows(5);
        this.jTextAreaLog.setText(bundle.getString("jTextAreaLog.text"));
        this.jTextAreaLog.setName("jTextAreaLog");
        this.jScrollPaneLog.setViewportView(this.jTextAreaLog);
        this.jButtonLogCopy.setText(bundle.getString("jButtonLogCopy.text"));
        this.jButtonLogCopy.setEnabled(false);
        this.jButtonLogCopy.setName("jButtonLogCopy");
        this.jButtonLogCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Ace64BaseMainView.this.jButtonLogCopyactionPerformedButtonCopyToClipboard(evt);
            }
        });
        GroupLayout jPanelLogLayout = new GroupLayout(this.jPanelLog);
        this.jPanelLog.setLayout(jPanelLogLayout);
        jPanelLogLayout.setHorizontalGroup(jPanelLogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelLogLayout.createSequentialGroup().addContainerGap().addGroup(jPanelLogLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButtonLogCopy, -2, 141, -2).addComponent(this.jScrollPaneLog, -1, 543, Short.MAX_VALUE)).addContainerGap()));
        jPanelLogLayout.setVerticalGroup(jPanelLogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelLogLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneLog, -1, 324, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonLogCopy).addContainerGap()));
        this.jTabbedPaneFiles.addTab(bundle.getString("jPanelLog.TabConstraints.tabTitle"), this.jPanelLog);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanelProgress, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jTabbedPaneFiles, GroupLayout.Alignment.LEADING, -1, 568, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPaneFiles, -1, 403, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelProgress, -2, -1, -2).addContainerGap()));
        this.pack();
    }
}

