/*
 * Decompiled with CFR 0.152.
 */
package charmate;

import charmate.CharMateGuiConnector;
import charmate.CharMateView;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JFrame;
import org.jdesktop.application.Application;
import org.jdesktop.application.SingleFrameApplication;

public class CharMateApp
extends SingleFrameApplication
implements CharMateGuiConnector,
WindowListener {
    private Properties m_tProperties = new Properties();
    private CharMateView m_tView;
    private int m_iCodePoint = 0;

    @Override
    protected void startup() {
        String lc_sFontName = null;
        Object lc_tObject = null;
        this.m_tView = new CharMateView(this, this);
        if (null != this.m_tView) {
            this.show(this.m_tView);
            if (this.loadProperties()) {
                lc_tObject = this.m_tProperties.get("CodePoint");
                if (null != lc_tObject) {
                    this.m_iCodePoint = Integer.valueOf(lc_tObject.toString());
                }
                if (null != (lc_tObject = this.m_tProperties.get("Font"))) {
                    lc_sFontName = lc_tObject.toString();
                }
                if (!Character.isValidCodePoint(this.m_iCodePoint)) {
                    this.m_iCodePoint = 0x10FFFF;
                }
                if (null == lc_sFontName) {
                    lc_sFontName = "Monospaced";
                }
                if (lc_sFontName.isEmpty()) {
                    lc_sFontName = "Monospaced";
                }
                this.m_tView.setDisplayFont(lc_sFontName, true);
            }
            this.processInput(0, true, false);
        }
    }

    @Override
    protected void configureWindow(Window root) {
    }

    public static CharMateApp getApplication() {
        return Application.getInstance(CharMateApp.class);
    }

    public static void main(String[] pa_tArgs) {
        CharMateApp.launch(CharMateApp.class, pa_tArgs);
    }

    @Override
    public void windowClosing(WindowEvent pa_tEvent) {
        Object lc_tWindowObject = null;
        lc_tWindowObject = pa_tEvent.getSource();
        if (null != lc_tWindowObject && lc_tWindowObject instanceof JFrame && (JFrame)lc_tWindowObject == this.m_tView) {
            this.saveProperties("Last modified on:");
            this.m_tView.dispose();
            System.exit(1);
        }
    }

    @Override
    public void windowClosed(WindowEvent pa_tEvent) {
    }

    @Override
    public void windowOpened(WindowEvent pa_tEvent) {
    }

    @Override
    public void windowIconified(WindowEvent pa_tEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent pa_tEvent) {
    }

    @Override
    public void windowActivated(WindowEvent pa_tEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent pa_tEvent) {
    }

    @Override
    public void handleInputCharacter(boolean pa_bFocusLost) {
        String lc_sInput = this.m_tView.getCharacter();
        boolean lc_bEmpty = true;
        if (null != lc_sInput) {
            lc_bEmpty = lc_sInput.isEmpty();
        }
        this.m_iCodePoint = false == lc_bEmpty ? lc_sInput.codePointAt(0) : 0;
        this.processInput(1, lc_bEmpty, pa_bFocusLost);
    }

    @Override
    public void handleInputHtmlEntity(boolean pa_bFocusLost) {
        String lc_sInput = this.m_tView.getHtmlEntity();
        String lc_sValue = "";
        boolean lc_bEmpty = true;
        if (null != lc_sInput) {
            lc_bEmpty = lc_sInput.isEmpty();
        }
        lc_sValue = true == lc_bEmpty ? "0" : lc_sInput;
        this.m_iCodePoint = Integer.valueOf(lc_sValue);
        this.processInput(2, lc_bEmpty, pa_bFocusLost);
    }

    @Override
    public void handleInputUnicode(boolean pa_bFocusLost) {
        String lc_sInput = this.m_tView.getUnicode();
        String lc_sValue = "";
        boolean lc_bEmpty = true;
        if (null != lc_sInput) {
            lc_bEmpty = lc_sInput.isEmpty();
        }
        lc_sValue = true == lc_bEmpty ? "0" : lc_sInput;
        this.m_iCodePoint = Integer.valueOf(lc_sValue, 16);
        this.processInput(3, lc_bEmpty, pa_bFocusLost);
    }

    @Override
    public void handleButtonSelectFont() {
        if (null != this.m_tProperties) {
            this.m_tProperties.put("Font", this.m_tView.getDisplayFont());
        }
    }

    private void processInput(int pa_iInputSource, boolean lc_bWasEmpty, boolean pa_bFocusLost) {
        String lc_sCharacter = "";
        String lc_sUniCode = "";
        String lc_sHtmlEntity = "";
        String lc_sUniCodeResult = "";
        boolean lc_bCorrection = false;
        if (0x10FFFF < this.m_iCodePoint) {
            lc_bCorrection = true;
            this.m_iCodePoint = 0x10FFFF;
        }
        if (!Character.isValidCodePoint(this.m_iCodePoint)) {
            lc_bCorrection = true;
            this.m_iCodePoint = 0x10FFFF;
        }
        if (!Character.isIdentifierIgnorable(this.m_iCodePoint)) {
            lc_sCharacter = new String(Character.toChars(this.m_iCodePoint));
        }
        lc_sHtmlEntity = Integer.toString(this.m_iCodePoint);
        lc_sUniCode = Integer.toHexString(this.m_iCodePoint).toUpperCase();
        lc_sUniCodeResult = this.formatHexString(lc_sUniCode);
        if (1 != pa_iInputSource || 1 == pa_iInputSource && lc_bCorrection || lc_bWasEmpty && pa_bFocusLost) {
            this.m_tView.setCharacter(lc_sCharacter);
        }
        if (2 != pa_iInputSource || 2 == pa_iInputSource && lc_bCorrection || lc_bWasEmpty && pa_bFocusLost) {
            this.m_tView.setHtmlEntity(lc_sHtmlEntity);
        }
        if (3 != pa_iInputSource || 3 == pa_iInputSource && lc_bCorrection || lc_bWasEmpty && pa_bFocusLost) {
            this.m_tView.setUnicode(lc_sUniCode);
        }
        this.m_tView.setUnicodeResult(lc_sUniCodeResult);
        this.m_tView.setHtmlEntityResult(lc_sHtmlEntity);
        this.m_tView.setHugeDisplay(this.m_iCodePoint);
    }

    private boolean loadProperties() {
        File lc_tPropertiesFile = new File("settings.prs");
        FileInputStream lc_tInputStream = null;
        boolean lc_bResult = false;
        if (null != lc_tPropertiesFile && null != this.m_tProperties && lc_tPropertiesFile.exists() && lc_tPropertiesFile.isFile()) {
            try {
                lc_tInputStream = new FileInputStream(lc_tPropertiesFile);
                if (null != lc_tInputStream) {
                    this.m_tProperties.load(lc_tInputStream);
                    lc_tInputStream.close();
                    lc_bResult = true;
                }
            }
            catch (IOException lc_tExcpetion) {
                // empty catch block
            }
        }
        return lc_bResult;
    }

    private void saveProperties(String pa_sAnnotation) {
        File lc_tPropertiesFile = new File("settings.prs");
        FileOutputStream lc_tOutputStream = null;
        if (null != lc_tPropertiesFile && null != this.m_tProperties) {
            this.m_tProperties.put("CodePoint", Integer.toString(this.m_iCodePoint));
            this.m_tProperties.put("Font", this.m_tView.getDisplayFont());
            try {
                if (!lc_tPropertiesFile.exists()) {
                    lc_tPropertiesFile.createNewFile();
                }
                if (lc_tPropertiesFile.exists() && lc_tPropertiesFile.isFile() && null != (lc_tOutputStream = new FileOutputStream(lc_tPropertiesFile))) {
                    this.m_tProperties.store(lc_tOutputStream, pa_sAnnotation);
                    lc_tOutputStream.close();
                }
            }
            catch (IOException lc_tException) {
                // empty catch block
            }
        }
    }

    private String formatHexString(String pa_sString) {
        StringBuffer lc_tResult = new StringBuffer();
        boolean lc_bFill = false;
        if (null != pa_sString && null != lc_tResult) {
            boolean bl = lc_bFill = pa_sString.length() < 4;
            if (lc_bFill) {
                lc_tResult.append("0000");
            }
            lc_tResult.append(pa_sString);
            return true == lc_bFill ? lc_tResult.substring(lc_tResult.length() - 4) : lc_tResult.toString();
        }
        return "";
    }
}

