/*
 * Decompiled with CFR 0.152.
 */
package charmate;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import javax.swing.JPanel;

public class CharMatePaintPanel
extends JPanel {
    private RenderingHints m_tRenderingHints;
    private Color m_tColorBackground = this.getBackground();
    private Color m_tDrawColor = Color.black;
    private JPanel m_tPanelParent;
    private Font m_tFont;
    private int m_iCodePoint = -1;
    private int[] m_tFontHeights;

    public CharMatePaintPanel(JPanel pa_tParentPanel) {
        this.m_tPanelParent = pa_tParentPanel;
        this.m_tRenderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.m_tFont = new Font("Monospaced", 1, 36);
        this.m_tFontHeights = new int[]{36, 48, 54, 72, 96, 128, 146, 172, 196, 224};
    }

    public void setCodePoint(int pa_iCodePoint) {
        this.m_iCodePoint = pa_iCodePoint;
        this.repaint();
    }

    public int getCodePoint() {
        return this.m_iCodePoint;
    }

    private Dimension setBestFontHeight(Graphics2D pa_tGraphics2D, Dimension pa_tMaxSize) {
        int lc_iSize = 0;
        int lc_iDx = 0;
        int lc_iDy = 0;
        Dimension lc_tTextDimension = null;
        Font lc_tFont = null;
        FontRenderContext lc_tFontRenderContext = null;
        LineMetrics lc_tLineMetrics = null;
        String lc_sFontName = null != this.m_tFont ? this.m_tFont.getName() : "Monospaced";
        String lc_sDisplay = this.getDisplayString();
        if (null != pa_tMaxSize && null != this.m_tFontHeights && null != pa_tGraphics2D && null != lc_sDisplay) {
            for (int lc_iFontSize : this.m_tFontHeights) {
                lc_tFont = new Font(lc_sFontName, 1, lc_iFontSize);
                if (null == lc_tFont) continue;
                pa_tGraphics2D.setFont(lc_tFont);
                lc_tFontRenderContext = pa_tGraphics2D.getFontRenderContext();
                if (null == lc_tFontRenderContext) continue;
                lc_iDx = (int)lc_tFont.getStringBounds(lc_sDisplay, lc_tFontRenderContext).getWidth();
                lc_tLineMetrics = lc_tFont.getLineMetrics(lc_sDisplay, lc_tFontRenderContext);
                if (null == lc_tLineMetrics) continue;
                lc_iDy = (int)lc_tLineMetrics.getHeight();
                if (lc_iDy >= pa_tMaxSize.height || lc_iDx >= pa_tMaxSize.width) break;
                lc_iSize = lc_iFontSize;
                lc_iDy -= (int)lc_tLineMetrics.getAscent();
                lc_tTextDimension = new Dimension(lc_iDx, lc_iDy += (int)lc_tLineMetrics.getDescent());
            }
            if (null != (this.m_tFont = new Font(lc_sFontName, 1, lc_iSize))) {
                pa_tGraphics2D.setFont(this.m_tFont);
            }
        }
        return lc_tTextDimension;
    }

    public void setDisplayFont(String pa_sFont) {
        this.m_tFont = new Font(pa_sFont, 1, null != this.m_tFont ? this.m_tFont.getSize() : 36);
        this.repaint();
    }

    public String getDisplayFont() {
        return null != this.m_tFont ? this.m_tFont.getName() : null;
    }

    private String getDisplayString() {
        char[] lc_tDisplayChars = null;
        String lc_sDisplay = null;
        lc_tDisplayChars = Character.toChars(this.m_iCodePoint);
        if (null != lc_tDisplayChars && null != (lc_sDisplay = new String(lc_tDisplayChars))) {
            return lc_sDisplay;
        }
        return null;
    }

    @Override
    public void paintComponent(Graphics pa_tGraphics) {
        super.paintComponent(pa_tGraphics);
        Graphics2D lc_tGraphics2D = null;
        Dimension lc_tDimensionContainer = null;
        Dimension lc_tTextDimension = null;
        int lc_iX = 0;
        int lc_iY = 0;
        int lc_iDx = 0;
        int lc_iDy = 0;
        String lc_sDisplay = null;
        if (0 < this.m_iCodePoint && null != (lc_sDisplay = this.getDisplayString()) && null != pa_tGraphics && null != lc_sDisplay && null != (lc_tGraphics2D = (Graphics2D)pa_tGraphics)) {
            lc_tGraphics2D.setRenderingHints(this.m_tRenderingHints);
            lc_tGraphics2D.setFont(this.m_tFont);
            lc_tDimensionContainer = this.getSize();
            if (null != lc_tDimensionContainer) {
                lc_tGraphics2D.setColor(this.m_tColorBackground);
                lc_tGraphics2D.fillRect(0, 0, lc_tDimensionContainer.width, lc_tDimensionContainer.height);
            }
            if (null != (lc_tTextDimension = this.setBestFontHeight(lc_tGraphics2D, lc_tDimensionContainer))) {
                lc_iDx = lc_tTextDimension.width;
                lc_iDy = lc_tTextDimension.height;
                lc_iX = (lc_tDimensionContainer.width - lc_iDx) / 2;
                lc_iY = (lc_tDimensionContainer.height + lc_iDy) / 2;
                lc_tGraphics2D.setColor(this.m_tDrawColor);
                lc_tGraphics2D.drawString(lc_sDisplay, lc_iX, lc_iY);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension lc_tParentSize;
        Dimension dimension = lc_tParentSize = null != this.m_tPanelParent ? this.m_tPanelParent.getSize() : null;
        if (null != lc_tParentSize) {
            return new Dimension(lc_tParentSize.width - 10, lc_tParentSize.height - 10);
        }
        return new Dimension(100, 100);
    }
}

