/*
 * Decompiled with CFR 0.152.
 */
package charmate;

import charmate.CharMateGuiConnector;
import charmate.CharMatePaintPanel;
import charmate.CharMateTextfieldFormatter;
import com.xenoage.util.gui.FontChooserComboBox;
import java.awt.GridLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.text.DefaultFormatterFactory;

public class CharMateView
extends JFrame
implements ItemListener {
    private CharMateGuiConnector m_tGuiConnector;
    private CharMatePaintPanel m_tPaintPanel;
    private String m_sWindowTitle;
    private FontChooserComboBox m_tFontChooserComboBox;
    private JFormattedTextField jFormattedTextFieldCharacter;
    private JFormattedTextField jFormattedTextFieldHtmlEntity;
    private JFormattedTextField jFormattedTextFieldUnicode;
    private JLabel jLabelCharacter;
    private JLabel jLabelDisplayFont;
    private JLabel jLabelHtmlEntity;
    private JLabel jLabelUnicode;
    private JPanel jPanelFontSelection;
    private JPanel jPanelHuge;
    private JTextField jTextFieldHtmlEntityResult;
    private JTextField jTextFieldUnicodeResult;

    public CharMateView(CharMateGuiConnector pa_tGuiConnector, WindowListener pa_tWindowListener) {
        this.initComponents();
        this.jFormattedTextFieldCharacter.setFormatterFactory(new DefaultFormatterFactory(new CharMateTextfieldFormatter(Pattern.compile("[\\w\\W\\s\\S\\d\\D]{0,1}"))));
        this.jFormattedTextFieldHtmlEntity.setFormatterFactory(new DefaultFormatterFactory(new CharMateTextfieldFormatter(Pattern.compile("[0-9]{0,7}"))));
        this.jFormattedTextFieldUnicode.setFormatterFactory(new DefaultFormatterFactory(new CharMateTextfieldFormatter(Pattern.compile("[[0-9]*[A-F]*]{0,6}"))));
        this.m_tPaintPanel = new CharMatePaintPanel(this.jPanelHuge);
        if (null != this.m_tPaintPanel) {
            this.jPanelHuge.setLayout(new GridLayout(1, 1));
            this.jPanelHuge.add(this.m_tPaintPanel);
            this.m_tFontChooserComboBox = new FontChooserComboBox();
            if (null != this.m_tFontChooserComboBox) {
                this.m_tFontChooserComboBox.setSelectedItem(this.m_tPaintPanel.getDisplayFont());
                this.jPanelFontSelection.setLayout(new GridLayout(1, 1));
                this.jPanelFontSelection.add(this.m_tFontChooserComboBox);
                this.m_tFontChooserComboBox.addItemListener(this);
            }
            this.pack();
        }
        this.m_tGuiConnector = pa_tGuiConnector;
        this.m_sWindowTitle = this.getTitle();
        this.addWindowListener(pa_tWindowListener);
    }

    public String getCharacter() {
        return this.jFormattedTextFieldCharacter.getText();
    }

    public String getUnicode() {
        return this.jFormattedTextFieldUnicode.getText();
    }

    public String getHtmlEntity() {
        return this.jFormattedTextFieldHtmlEntity.getText();
    }

    public void setCharacter(String pa_sValue) {
        try {
            this.jFormattedTextFieldCharacter.setText(pa_sValue);
        }
        catch (Exception lc_tException) {
            this.jFormattedTextFieldCharacter.setText("");
        }
    }

    public void setUnicode(String pa_sValue) {
        try {
            this.jFormattedTextFieldUnicode.setText(pa_sValue);
        }
        catch (Exception lc_tException) {
            this.jFormattedTextFieldUnicode.setText("");
        }
    }

    public void setHtmlEntity(String pa_sValue) {
        try {
            this.jFormattedTextFieldHtmlEntity.setText(pa_sValue);
        }
        catch (Exception lc_tException) {
            this.jFormattedTextFieldHtmlEntity.setText("");
        }
    }

    public void setHtmlEntityResult(String pa_sValue) {
        this.jTextFieldHtmlEntityResult.setText(null != pa_sValue ? "&#" + pa_sValue + ";" : "");
    }

    public void setUnicodeResult(String pa_sValue) {
        this.jTextFieldUnicodeResult.setText(null != pa_sValue ? "\\u" + pa_sValue : "");
    }

    public void setHugeDisplay(int pa_iValue) {
        String lc_sAdd = null;
        String lc_sTitle = this.m_sWindowTitle;
        if (null != this.m_tPaintPanel) {
            this.m_tPaintPanel.setCodePoint(pa_iValue);
            lc_sAdd = Character.getName(this.m_tPaintPanel.getCodePoint());
            if (null != lc_sAdd && !lc_sAdd.equals("NULL")) {
                lc_sTitle = lc_sTitle + "    " + lc_sAdd;
            }
        }
        this.setTitle(lc_sTitle);
    }

    public void setDisplayFont(String pa_sFont, boolean pa_bUpdateComboBox) {
        if (null != this.m_tPaintPanel) {
            this.m_tPaintPanel.setDisplayFont(pa_sFont);
            if (pa_bUpdateComboBox) {
                this.m_tFontChooserComboBox.setSelectedItem(pa_sFont);
            }
        }
    }

    public String getDisplayFont() {
        return this.m_tPaintPanel.getDisplayFont();
    }

    private void initComponents() {
        this.jLabelCharacter = new JLabel();
        this.jLabelUnicode = new JLabel();
        this.jFormattedTextFieldUnicode = new JFormattedTextField();
        this.jLabelHtmlEntity = new JLabel();
        this.jFormattedTextFieldHtmlEntity = new JFormattedTextField();
        this.jFormattedTextFieldCharacter = new JFormattedTextField();
        this.jTextFieldUnicodeResult = new JTextField();
        this.jTextFieldHtmlEntityResult = new JTextField();
        this.jPanelHuge = new JPanel();
        this.jPanelFontSelection = new JPanel();
        this.jLabelDisplayFont = new JLabel();
        this.setDefaultCloseOperation(0);
        ResourceBundle bundle = ResourceBundle.getBundle("charmate/resources/CharMateView");
        this.setTitle(bundle.getString("Form.title"));
        this.setName("Form");
        this.jLabelCharacter.setLabelFor(this.jFormattedTextFieldCharacter);
        this.jLabelCharacter.setText(bundle.getString("jLabelCharacter.text"));
        this.jLabelCharacter.setName("jLabelCharacter");
        this.jLabelUnicode.setText(bundle.getString("jLabelUnicode.text"));
        this.jLabelUnicode.setName("jLabelUnicode");
        this.jFormattedTextFieldUnicode.setText(bundle.getString("jFormattedTextFieldUnicode.text"));
        this.jFormattedTextFieldUnicode.setName("jFormattedTextFieldUnicode");
        this.jFormattedTextFieldUnicode.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                CharMateView.this.focusLostInputUnicode(evt);
            }
        });
        this.jFormattedTextFieldUnicode.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                CharMateView.this.keyReleasedUnicode(evt);
            }
        });
        this.jLabelHtmlEntity.setLabelFor(this.jFormattedTextFieldHtmlEntity);
        this.jLabelHtmlEntity.setText(bundle.getString("jLabelHtmlEntity.text"));
        this.jLabelHtmlEntity.setName("jLabelHtmlEntity");
        this.jFormattedTextFieldHtmlEntity.setText(bundle.getString("jFormattedTextFieldHtmlEntity.text"));
        this.jFormattedTextFieldHtmlEntity.setName("jFormattedTextFieldHtmlEntity");
        this.jFormattedTextFieldHtmlEntity.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                CharMateView.this.focusLostInputHtmlEntity(evt);
            }
        });
        this.jFormattedTextFieldHtmlEntity.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                CharMateView.this.keyReleasedHtmlEntity(evt);
            }
        });
        this.jFormattedTextFieldCharacter.setText(bundle.getString("jFormattedTextFieldCharacter.text"));
        this.jFormattedTextFieldCharacter.setName("jFormattedTextFieldCharacter");
        this.jFormattedTextFieldCharacter.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                CharMateView.this.focusLostInputCharacter(evt);
            }
        });
        this.jFormattedTextFieldCharacter.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                CharMateView.this.keyReleasedCharacter(evt);
            }
        });
        this.jTextFieldUnicodeResult.setEditable(false);
        this.jTextFieldUnicodeResult.setText(bundle.getString("jTextFieldUnicodeResult.text"));
        this.jTextFieldUnicodeResult.setName("jTextFieldUnicodeResult");
        this.jTextFieldHtmlEntityResult.setEditable(false);
        this.jTextFieldHtmlEntityResult.setText(bundle.getString("jTextFieldHtmlEntityResult.text"));
        this.jTextFieldHtmlEntityResult.setName("jTextFieldHtmlEntityResult");
        this.jPanelHuge.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelHuge.setName("jPanelHuge");
        GroupLayout jPanelHugeLayout = new GroupLayout(this.jPanelHuge);
        this.jPanelHuge.setLayout(jPanelHugeLayout);
        jPanelHugeLayout.setHorizontalGroup(jPanelHugeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 98, Short.MAX_VALUE));
        jPanelHugeLayout.setVerticalGroup(jPanelHugeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 106, Short.MAX_VALUE));
        this.jPanelFontSelection.setName("jPanelFontSelection");
        GroupLayout jPanelFontSelectionLayout = new GroupLayout(this.jPanelFontSelection);
        this.jPanelFontSelection.setLayout(jPanelFontSelectionLayout);
        jPanelFontSelectionLayout.setHorizontalGroup(jPanelFontSelectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 230, Short.MAX_VALUE));
        jPanelFontSelectionLayout.setVerticalGroup(jPanelFontSelectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 23, Short.MAX_VALUE));
        this.jLabelDisplayFont.setText(bundle.getString("jLabelDisplayFont.text"));
        this.jLabelDisplayFont.setName("jLabelDisplayFont");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabelUnicode).addComponent(this.jLabelHtmlEntity, -1, 57, Short.MAX_VALUE).addComponent(this.jLabelCharacter)).addGap(10, 10, 10)).addGroup(layout.createSequentialGroup().addComponent(this.jLabelDisplayFont).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jFormattedTextFieldCharacter, -1, 92, Short.MAX_VALUE).addComponent(this.jFormattedTextFieldUnicode, -1, 107, Short.MAX_VALUE).addComponent(this.jFormattedTextFieldHtmlEntity)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldUnicodeResult, -2, 117, -2).addComponent(this.jTextFieldHtmlEntityResult, -2, 117, -2))).addComponent(this.jPanelFontSelection, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelHuge, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.linkSize(0, this.jLabelCharacter, this.jLabelDisplayFont, this.jLabelHtmlEntity, this.jLabelUnicode);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelHuge, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jFormattedTextFieldCharacter, GroupLayout.Alignment.LEADING).addComponent(this.jLabelCharacter, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jFormattedTextFieldHtmlEntity, -2, -1, -2).addComponent(this.jLabelHtmlEntity).addComponent(this.jTextFieldHtmlEntityResult, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jFormattedTextFieldUnicode, -2, -1, -2).addComponent(this.jLabelUnicode).addComponent(this.jTextFieldUnicodeResult, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabelDisplayFont).addComponent(this.jPanelFontSelection, -2, -1, -2)))).addContainerGap()));
        layout.linkSize(1, this.jFormattedTextFieldCharacter, this.jFormattedTextFieldHtmlEntity, this.jFormattedTextFieldUnicode, this.jLabelCharacter, this.jLabelDisplayFont, this.jLabelHtmlEntity, this.jLabelUnicode, this.jPanelFontSelection, this.jTextFieldHtmlEntityResult, this.jTextFieldUnicodeResult);
        this.pack();
    }

    private void keyReleasedCharacter(KeyEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleInputCharacter(false);
        }
    }

    private void focusLostInputCharacter(FocusEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleInputCharacter(true);
        }
    }

    private void keyReleasedUnicode(KeyEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleInputUnicode(false);
        }
    }

    private void focusLostInputUnicode(FocusEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleInputUnicode(true);
        }
    }

    private void keyReleasedHtmlEntity(KeyEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleInputHtmlEntity(false);
        }
    }

    private void focusLostInputHtmlEntity(FocusEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleInputHtmlEntity(true);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent pa_tEvent) {
        String lc_sFontName = null;
        if (null != this.m_tFontChooserComboBox && null != (lc_sFontName = this.m_tFontChooserComboBox.getSelectedFontName())) {
            this.setDisplayFont(lc_sFontName, false);
            if (null != this.m_tGuiConnector) {
                this.m_tGuiConnector.handleButtonSelectFont();
            }
        }
    }
}

