/**
 * CharMate
 * 
 */
package charmate;



/**
 * Imports
 * 
 */
import org.jdesktop.application.Application;
import org.jdesktop.application.SingleFrameApplication;

import java.awt.event.WindowListener;
import java.awt.event.WindowEvent  ;

import javax.swing.JFrame  ;
import java.util.Properties;

import java.io.File            ;
import java.io.IOException     ;
import java.io.FileInputStream ;
import java.io.FileOutputStream;



/**
 * The main class of the application.
 * 
 * @author Ulf Wagemann
 */
public class CharMateApp extends   SingleFrameApplication
                        implements CharMateGuiConnector,
                                   WindowListener
{ 
 private Properties   m_tProperties;
 private CharMateView m_tView      ;
 private int          m_iCodePoint ;

 
 
 /**
  * Constructor
  * 
  */
 public CharMateApp()
 {
  super();
  
   m_iCodePoint  = 0;
   m_tProperties = new Properties();   
 }
 

 
 /**
  * At startup create and show the main frame of the application.
  *
  */
  @Override protected void startup() 
  {
   String lc_sFontName = null;
   Object lc_tObject   = null;
   
   if (null != (m_tView = new CharMateView((CharMateGuiConnector) this, (WindowListener) this))) 
   {
    show(m_tView);
    
    //
    // try loading properties and initializing display
    //
    if (true == loadProperties())
    {
     if (null != (lc_tObject = m_tProperties.get(CharMateConstants.CHM_KEY_CODEPOINT))) m_iCodePoint = Integer.valueOf(lc_tObject.toString());
     if (null != (lc_tObject = m_tProperties.get(CharMateConstants.CHM_KEY_FONT     ))) lc_sFontName = lc_tObject.toString()                 ;
     
     //
     // check settingds
     //
     if (false == Character.isValidCodePoint(m_iCodePoint))
     {
      m_iCodePoint = Character.MAX_CODE_POINT;
     }
     if (null == lc_sFontName          ) lc_sFontName = CharMateConstants.CHM_DEFAULT_FONT;
     if (true == lc_sFontName.isEmpty()) lc_sFontName = CharMateConstants.CHM_DEFAULT_FONT;
     
     //
     // update display with font
     //
     m_tView.setDisplayFont(lc_sFontName, true);      
    }
    
    //
    // compute remaining values
    //
    processInput(CharMateConstants.CHM_INPUT_PROPERTIES, true, false); 
   }
  }
  
  

 /**
  * This method is to initialize the specified window by injecting resources.
  * Windows shown in our application come fully initialized from the GUI
  * builder, so this additional configuration is not needed.
   * 
  */
  @Override protected void configureWindow(java.awt.Window root) {}

  
  
 /**
  * A convenient static getter for the application instance.
  * @return the instance of CharMateApp
  */
 public static CharMateApp getApplication() {return Application.getInstance(CharMateApp.class);}

 
 
 /**
  * Main method launching the application.
  * 
  * @param pa_tArgs command line arguments
  */
 public static void main(String[] pa_tArgs) {launch(CharMateApp.class, pa_tArgs);}


 
 /**
  * WindowListener.windowClosing()
  * 
  * @param pa_tEvent  Event
  */ 
  public void windowClosing(WindowEvent pa_tEvent) 
  {
   Object lc_tWindowObject = null;
  
   if (null != (lc_tWindowObject = pa_tEvent.getSource()))
   {
    if (lc_tWindowObject instanceof JFrame)
    {
     if ((JFrame) lc_tWindowObject == m_tView)   
     {
      saveProperties(CharMateConstants.CHM_ANNOTATION);
      m_tView.dispose();
      System.exit(1);
     }
    }
   }
  }

 
 
 /**
  * WindowListener.windowClosed()
  * 
  * @param pa_tEvent  Event
  */ 
  public void windowClosed(WindowEvent pa_tEvent) 
  {}

 
 
 /**
  * WindowListener.windowOpened()
  *
  * As soon as the main window is open, do all the intialization stuff
  *
  * @param pa_tEvent  Event
  */ 
 public void windowOpened(WindowEvent pa_tEvent) 
 {}



 /**
  * WindowListener.windowIconified()
  * 
  * @param pa_tEvent  Event
  */ 
 public void windowIconified(WindowEvent pa_tEvent) 
 {}



 /**
  * WindowListener.windowDeiconified()
  * 
  * @param pa_tEvent  Event
  */ 
 public void windowDeiconified(WindowEvent pa_tEvent) 
 {}



 /**
  * WindowListener.windowActivated()
  * 
  * @param pa_tEvent  Event
  */ 
 public void windowActivated(WindowEvent pa_tEvent) 
 {}



 /**
  * WindowListener.windowDeactivated()
  * 
  * @param pa_tEvent  Event
  */ 
 public void windowDeactivated(WindowEvent pa_tEvent) 
 {}



 /**
  * Handles an input in the character textfield
  * 
  * @param pa_bFocusLost  true, if the method was triggered by a focusLost-event
  */
 public void handleInputCharacter(boolean pa_bFocusLost)
 {
  String     lc_sInput = m_tView.getCharacter();
  boolean    lc_bEmpty = true ;
  
  if (null != lc_sInput)
  {
   lc_bEmpty = lc_sInput.isEmpty();
  }
  m_iCodePoint = (false == lc_bEmpty ? lc_sInput.codePointAt(0) : 0);
  processInput(CharMateConstants.CHM_INPUT_CHARACTER, lc_bEmpty, pa_bFocusLost); 
 }
 
 
 
 /**
  * Handles an input in the htmlentity textfield
  * 
  * @param pa_bFocusLost  true, if the method was triggered by a focusLost-event
  */
 public void handleInputHtmlEntity(boolean pa_bFocusLost)
 {
  String     lc_sInput   = m_tView.getHtmlEntity();
  String     lc_sValue   = ""   ;
  boolean    lc_bEmpty   = true ;

  if (null != lc_sInput)
  {
   lc_bEmpty = lc_sInput.isEmpty();
  }
  lc_sValue     = (true == lc_bEmpty ? "0" : lc_sInput);
  m_iCodePoint  = Integer.valueOf(lc_sValue);
  
  processInput(CharMateConstants.CHM_INPUT_HTML, lc_bEmpty, pa_bFocusLost); 
 }
 

 
/**
 * Handles an input in the unicode textfield
 * 
 * @param pa_bFocusLost  true, if the method was triggered by a focusLost-event
 */
public void handleInputUnicode(boolean pa_bFocusLost)
{
 String     lc_sInput   = m_tView.getUnicode();
 String     lc_sValue   = ""   ;
 boolean    lc_bEmpty   = true ;

 if (null != lc_sInput)
 {
  lc_bEmpty = lc_sInput.isEmpty();
 }
 lc_sValue     = (true == lc_bEmpty ? "0" : lc_sInput);
 m_iCodePoint  = Integer.valueOf(lc_sValue, 16);
 
 processInput(CharMateConstants.CHM_INPUT_UNICODE, lc_bEmpty, pa_bFocusLost); 
}  
  
  
  
/**
 * A new font was selected and set, we just need to memorize its name
 * 
 */ 
public void handleButtonSelectFont()
{
 if (null != m_tProperties) 
 {
  m_tProperties.put(CharMateConstants.CHM_KEY_FONT, m_tView.getDisplayFont()); 
 }
}
 
 
 
/**
 * Processes input and changes the display
 * 
 * @param pa_iInputSource CHM_INPUT_CHARACTER or CHM_INPUT_HTML or CHM_INPUT_UNICODE
 * @param lc_bWasEmpty    true, if the input string was empty
 * @param pa_bFocusLost   true, if the method was triggered by a focusLost-event
 */
 private void processInput(int pa_iInputSource, boolean lc_bWasEmpty, boolean pa_bFocusLost)
 {
  String lc_sCharacter        = "";
  String lc_sUniCode          = "";
  String lc_sHtmlEntity       = "";
  String lc_sUniCodeResult    = "";
  boolean lc_bCorrection = false;

  //
  // check max boundaries
  //
  if (Character.MAX_CODE_POINT < m_iCodePoint) 
  {
   lc_bCorrection = true;
   m_iCodePoint = Character.MAX_CODE_POINT;
  }
   
  //
  // check codepoint validity
  //
  if (false == Character.isValidCodePoint(m_iCodePoint))
  {
   lc_bCorrection = true;
   m_iCodePoint = Character.MAX_CODE_POINT;
  }
  
  //
  // get character(s) for codepoint
  //
  if (false == Character.isIdentifierIgnorable(m_iCodePoint))
  {
   lc_sCharacter = new String(Character.toChars(m_iCodePoint));
  }
   
  //
  // compute remaining displays
  //
  lc_sHtmlEntity    = Integer.toString   (m_iCodePoint);
  lc_sUniCode       = Integer.toHexString(m_iCodePoint).toUpperCase();
  lc_sUniCodeResult = formatHexString    (lc_sUniCode );
   
  //
  // update display
  //
  if (CharMateConstants.CHM_INPUT_CHARACTER != pa_iInputSource || (CharMateConstants.CHM_INPUT_CHARACTER == pa_iInputSource && true == lc_bCorrection) || (true == lc_bWasEmpty && true == pa_bFocusLost)) m_tView.setCharacter (lc_sCharacter );
  if (CharMateConstants.CHM_INPUT_HTML      != pa_iInputSource || (CharMateConstants.CHM_INPUT_HTML      == pa_iInputSource && true == lc_bCorrection) || (true == lc_bWasEmpty && true == pa_bFocusLost)) m_tView.setHtmlEntity(lc_sHtmlEntity);
  if (CharMateConstants.CHM_INPUT_UNICODE   != pa_iInputSource || (CharMateConstants.CHM_INPUT_UNICODE   == pa_iInputSource && true == lc_bCorrection) || (true == lc_bWasEmpty && true == pa_bFocusLost)) m_tView.setUnicode   (lc_sUniCode   ); 
   
  m_tView.setUnicodeResult   (lc_sUniCodeResult);
  m_tView.setHtmlEntityResult(lc_sHtmlEntity   );
  m_tView.setHugeDisplay     (m_iCodePoint     );
 }


 
 /**
  * Loads the properties file as defined in GridLifeConstants
  * 
  */
 private boolean loadProperties()
 {
  File             lc_tPropertiesFile = new File(CharMateConstants.CHM_SETTINGS);
  FileInputStream  lc_tInputStream    = null;       
  boolean          lc_bResult         = false;
  
  if (null != lc_tPropertiesFile && null != m_tProperties)
  {
   if (true == lc_tPropertiesFile.exists() && true == lc_tPropertiesFile.isFile()) 
   {
    try
    {
     if (null != (lc_tInputStream = new FileInputStream(lc_tPropertiesFile)))
     {
      m_tProperties.load(lc_tInputStream);    
      lc_tInputStream.close();
      lc_bResult = true;
     }
    }
    catch (IOException lc_tExcpetion)
    {}    
   }
  }
  return lc_bResult;
 }

 
 
  
 /**
  * This routine saves the settings for each of the stored JInternalFrames in the properties file
  * 
  * @param pa_sAnnotation Annotation
  */
 private void saveProperties(String pa_sAnnotation)
 {
  File              lc_tPropertiesFile = new File(CharMateConstants.CHM_SETTINGS);
  FileOutputStream  lc_tOutputStream   = null;       
        
  if (null != lc_tPropertiesFile && null != m_tProperties)
  {
   m_tProperties.put(CharMateConstants.CHM_KEY_CODEPOINT, Integer.toString(m_iCodePoint));
   m_tProperties.put(CharMateConstants.CHM_KEY_FONT     , m_tView.getDisplayFont());
     
   try
   {
    if (false == lc_tPropertiesFile.exists()) 
    {
     lc_tPropertiesFile.createNewFile();
    }
    
    if (true == lc_tPropertiesFile.exists() && true == lc_tPropertiesFile.isFile()) 
    {
     if (null != (lc_tOutputStream = new FileOutputStream(lc_tPropertiesFile)))
     {
      m_tProperties.store(lc_tOutputStream, pa_sAnnotation);  
      lc_tOutputStream.close();
     }
    }
   }
   catch (IOException lc_tException)
   {}
  }   
 }
 
 
 
 
 /**
  * Fills up a heax string with leasding zeroes, if its length is < 4
  * 
  * @param pa_sString   string to check
  * @return  filled up string
  */
 private String formatHexString(String pa_sString)
 {
  StringBuffer lc_tResult = new StringBuffer();
  boolean      lc_bFill   = false;
  
  if (null != pa_sString && null != lc_tResult)
  {
   lc_bFill = (pa_sString.length() < 4);
   
   if     (true == lc_bFill) lc_tResult.append("0000");
   lc_tResult.append(pa_sString);
   
   return (true == lc_bFill  ? lc_tResult.substring(lc_tResult.length() - 4) : lc_tResult.toString());
  }
  return "";
 }
 
 
} // eoc
