/**
 * CharMate
 * 
 */
package charmate;



/**
 * Imports
 * 
 */
import java.util.regex.*;
import javax.swing.text.*;
import java.text.*;



/**
 * This class provides a pattern formatter for JFormattedTextField, which compares the input to a given
 * regular expression. Losing the focus is granted for matching input only.
 *
 * @author Ulf Wagemann
 */ 
public class CharMateTextfieldFormatter extends DefaultFormatter
{
 /** Pattern matcher */
 public Matcher m_tPatternMatcher;
 
 
 
 /**
  * Creates a new instance
  *
  * @param pa_tPatternToMatch Regular expression to match against
  */  
 public CharMateTextfieldFormatter(Pattern pa_tPatternToMatch)
 {
  super();
  setOverwriteMode(false);
  setAllowsInvalid(false);
  setPattern(pa_tPatternToMatch);
 }
 
 
 
 /**
  * Sets the pattern to match
  *
  * @param pa_tPatternToMatch Regular expression to match against
  *
  */
 public final void setPattern(Pattern pa_tPatternToMatch)
 {
  if (null != pa_tPatternToMatch)
  {
   m_tPatternMatcher = pa_tPatternToMatch.matcher("");
  }
  else
  {
   m_tPatternMatcher = null; 
  }
 }
 
 
 
 /**
  * Returns null in case of non-matching
  *
  * @param pa_sInputString Input string
  * @return null, if the input does not match the expression, string otherwise
  *
  */
 @Override
 public Object stringToValue(String pa_sInputString) throws ParseException
 {
  if (null != pa_sInputString)
  {
   if (null != m_tPatternMatcher)
   {
    m_tPatternMatcher.reset(pa_sInputString);
    if (!m_tPatternMatcher.matches())
    {
     throw new ParseException("Input does not match regex", 0);
    }
    else
    {
     return super.stringToValue(pa_sInputString);
    }
   }
   else
   {
    return super.stringToValue(pa_sInputString);
   }
  }
  return null;
 }
 
 
 
} //eoc