/**
 * CharMate
 *
 */
package charmate;



/**
 * Imports
 * 
 */
import java.awt.event.ItemEvent;




/**
 * UI
 * 
 * @author Ulf Wagemann
 */
public class CharMateView extends javax.swing.JFrame 
                          implements java.awt.event.ItemListener
{
 private CharMateGuiConnector m_tGuiConnector;
 private CharMatePaintPanel   m_tPaintPanel  ; 
 private String               m_sWindowTitle ; 
 private com.xenoage.util.gui.FontChooserComboBox m_tFontChooserComboBox;
 
 
 
 /**
  * Constructor
  * 
  * @param pa_tGuiConnector     gui connector object
  * @param pa_tWindowListener   window listener
  */
  public CharMateView(CharMateGuiConnector pa_tGuiConnector, java.awt.event.WindowListener pa_tWindowListener)
  {
   initComponents();
    
   jFormattedTextFieldCharacter.setFormatterFactory (new javax.swing.text.DefaultFormatterFactory(new CharMateTextfieldFormatter(java.util.regex.Pattern.compile(CharMateConstants.CHM_REGEX_CHARACTER  ))));
   jFormattedTextFieldHtmlEntity.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new CharMateTextfieldFormatter(java.util.regex.Pattern.compile(CharMateConstants.CHM_REGEX_DECIMAL    ))));
   jFormattedTextFieldUnicode.setFormatterFactory   (new javax.swing.text.DefaultFormatterFactory(new CharMateTextfieldFormatter(java.util.regex.Pattern.compile(CharMateConstants.CHM_REGEX_HEXADECIMAL))));
       
   //
   // add codepoint painting panel
   //
   if (null != (m_tPaintPanel = new CharMatePaintPanel(jPanelHuge)))
   {
    jPanelHuge.setLayout(new java.awt.GridLayout(1,1));
    jPanelHuge.add(m_tPaintPanel);
   
    //
    // add fontchoser combobox
    //
    if (null != (m_tFontChooserComboBox = new com.xenoage.util.gui.FontChooserComboBox()))
    {
     m_tFontChooserComboBox.setSelectedItem(m_tPaintPanel.getDisplayFont()); 
     jPanelFontSelection.setLayout(new java.awt.GridLayout(1,1));
     jPanelFontSelection.add(m_tFontChooserComboBox);
     m_tFontChooserComboBox.addItemListener((java.awt.event.ItemListener) this);
    }
    pack();
   }
   
   m_tGuiConnector = pa_tGuiConnector;
   m_sWindowTitle  = getTitle();
   addWindowListener(pa_tWindowListener);
  }

  
  
  /**
   * Returns the character
   * 
   * @return   character
   */
  public String getCharacter() {return jFormattedTextFieldCharacter.getText();}
  
  
  /**
   * Returns the unicode string
   * 
   * @return unicode string
   */
  public String getUnicode() {return jFormattedTextFieldUnicode.getText();}
  
  
  
  
  /**
   * Returns the int value string
   * 
   * @return int value string
   */
  public String getHtmlEntity() {return jFormattedTextFieldHtmlEntity.getText();}

  
  
  /**
   * Returns the character
   * 
   * @param  pa_sValue  character string
   */
  public void setCharacter(String pa_sValue) 
  {
   try
   {
    jFormattedTextFieldCharacter.setText(pa_sValue);
   }
   catch (Exception lc_tException)
   {
    jFormattedTextFieldCharacter.setText(""); 
   }
  }
  
  
  
  /**
   * Returns the unicode string
   * 
   * @param  pa_sValue  unicode string
   */
  public void setUnicode(String pa_sValue) 
  {
   try
   {
    jFormattedTextFieldUnicode.setText(pa_sValue);
   }
   catch (Exception lc_tException)
   {
    jFormattedTextFieldUnicode.setText(""); 
   }
  }
  
  
  
  
  /**
   * Returns the html entity string
   * 
   * @param  pa_sValue  html entity string
   */
  public void setHtmlEntity(String pa_sValue) 
  {
   try
   {
    jFormattedTextFieldHtmlEntity.setText(pa_sValue);
   }  
   catch (Exception lc_tException)
   {
    jFormattedTextFieldHtmlEntity.setText(""); 
   }
  }

  
  
  /**
   * Sets the html result string
   * 
   * @param pa_sValue   html string
   */
  public void setHtmlEntityResult(String pa_sValue) {jTextFieldHtmlEntityResult.setText(null != pa_sValue ? CharMateConstants.CHM_HTML_START + pa_sValue +  CharMateConstants.CHM_HTML_END : "");}
  
  
  
  /**
   * Sets the unicode result string
   * 
   * @param pa_sValue   unicode string
   */
  public void setUnicodeResult(String pa_sValue) {jTextFieldUnicodeResult.setText(null != pa_sValue ? CharMateConstants.CHM_UNICODE_START + pa_sValue : "");}
  
  
  
  /**
   * Updates the huge display
   * 
   * @param pa_iValue   codepoint
   */
  public void setHugeDisplay(int pa_iValue)
  {
   String lc_sAdd   = null;
   String lc_sTitle = m_sWindowTitle;
   
   if (null != m_tPaintPanel) 
   {
    m_tPaintPanel.setCodePoint(pa_iValue);
    if (null != (lc_sAdd = Character.getName(m_tPaintPanel.getCodePoint())))
    {
     if (false == lc_sAdd.equals(CharMateConstants.CHM_NULL))
     {
      lc_sTitle += "    " + lc_sAdd;
     }
    }
   }
   setTitle(lc_sTitle);  
  }
  
  
  
  /**
   * Sets a new display font
   * 
   * @param pa_sFont   font name
   */
  public void setDisplayFont(String pa_sFont, boolean pa_bUpdateComboBox)
  {
   if (null != m_tPaintPanel) 
   {
    m_tPaintPanel.setDisplayFont(pa_sFont);
    if (true == pa_bUpdateComboBox)
    {
     m_tFontChooserComboBox.setSelectedItem(pa_sFont); 
    }
   }
  }
  
  
  
  /**
   * Returns the display font name
   * 
   * @return 
   */
  public String getDisplayFont() {return m_tPaintPanel.getDisplayFont();}
  
  
  
  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   * 
   */
  @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabelCharacter = new javax.swing.JLabel();
        jLabelUnicode = new javax.swing.JLabel();
        jFormattedTextFieldUnicode = new javax.swing.JFormattedTextField();
        jLabelHtmlEntity = new javax.swing.JLabel();
        jFormattedTextFieldHtmlEntity = new javax.swing.JFormattedTextField();
        jFormattedTextFieldCharacter = new javax.swing.JFormattedTextField();
        jTextFieldUnicodeResult = new javax.swing.JTextField();
        jTextFieldHtmlEntityResult = new javax.swing.JTextField();
        jPanelHuge = new javax.swing.JPanel();
        jPanelFontSelection = new javax.swing.JPanel();
        jLabelDisplayFont = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("charmate/resources/CharMateView"); // NOI18N
        setTitle(bundle.getString("Form.title")); // NOI18N
        setName("Form"); // NOI18N

        jLabelCharacter.setLabelFor(jFormattedTextFieldCharacter);
        jLabelCharacter.setText(bundle.getString("jLabelCharacter.text")); // NOI18N
        jLabelCharacter.setName("jLabelCharacter"); // NOI18N

        jLabelUnicode.setText(bundle.getString("jLabelUnicode.text")); // NOI18N
        jLabelUnicode.setName("jLabelUnicode"); // NOI18N

        jFormattedTextFieldUnicode.setText(bundle.getString("jFormattedTextFieldUnicode.text")); // NOI18N
        jFormattedTextFieldUnicode.setName("jFormattedTextFieldUnicode"); // NOI18N
        jFormattedTextFieldUnicode.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                focusLostInputUnicode(evt);
            }
        });
        jFormattedTextFieldUnicode.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                keyReleasedUnicode(evt);
            }
        });

        jLabelHtmlEntity.setLabelFor(jFormattedTextFieldHtmlEntity);
        jLabelHtmlEntity.setText(bundle.getString("jLabelHtmlEntity.text")); // NOI18N
        jLabelHtmlEntity.setName("jLabelHtmlEntity"); // NOI18N

        jFormattedTextFieldHtmlEntity.setText(bundle.getString("jFormattedTextFieldHtmlEntity.text")); // NOI18N
        jFormattedTextFieldHtmlEntity.setName("jFormattedTextFieldHtmlEntity"); // NOI18N
        jFormattedTextFieldHtmlEntity.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                focusLostInputHtmlEntity(evt);
            }
        });
        jFormattedTextFieldHtmlEntity.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                keyReleasedHtmlEntity(evt);
            }
        });

        jFormattedTextFieldCharacter.setText(bundle.getString("jFormattedTextFieldCharacter.text")); // NOI18N
        jFormattedTextFieldCharacter.setName("jFormattedTextFieldCharacter"); // NOI18N
        jFormattedTextFieldCharacter.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                focusLostInputCharacter(evt);
            }
        });
        jFormattedTextFieldCharacter.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                keyReleasedCharacter(evt);
            }
        });

        jTextFieldUnicodeResult.setEditable(false);
        jTextFieldUnicodeResult.setText(bundle.getString("jTextFieldUnicodeResult.text")); // NOI18N
        jTextFieldUnicodeResult.setName("jTextFieldUnicodeResult"); // NOI18N

        jTextFieldHtmlEntityResult.setEditable(false);
        jTextFieldHtmlEntityResult.setText(bundle.getString("jTextFieldHtmlEntityResult.text")); // NOI18N
        jTextFieldHtmlEntityResult.setName("jTextFieldHtmlEntityResult"); // NOI18N

        jPanelHuge.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jPanelHuge.setName("jPanelHuge"); // NOI18N

        javax.swing.GroupLayout jPanelHugeLayout = new javax.swing.GroupLayout(jPanelHuge);
        jPanelHuge.setLayout(jPanelHugeLayout);
        jPanelHugeLayout.setHorizontalGroup(
            jPanelHugeLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 98, Short.MAX_VALUE)
        );
        jPanelHugeLayout.setVerticalGroup(
            jPanelHugeLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 106, Short.MAX_VALUE)
        );

        jPanelFontSelection.setName("jPanelFontSelection"); // NOI18N

        javax.swing.GroupLayout jPanelFontSelectionLayout = new javax.swing.GroupLayout(jPanelFontSelection);
        jPanelFontSelection.setLayout(jPanelFontSelectionLayout);
        jPanelFontSelectionLayout.setHorizontalGroup(
            jPanelFontSelectionLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 230, Short.MAX_VALUE)
        );
        jPanelFontSelectionLayout.setVerticalGroup(
            jPanelFontSelectionLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 23, Short.MAX_VALUE)
        );

        jLabelDisplayFont.setText(bundle.getString("jLabelDisplayFont.text")); // NOI18N
        jLabelDisplayFont.setName("jLabelDisplayFont"); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(jLabelUnicode)
                            .addComponent(jLabelHtmlEntity, javax.swing.GroupLayout.DEFAULT_SIZE, 57, Short.MAX_VALUE)
                            .addComponent(jLabelCharacter))
                        .addGap(10, 10, 10))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabelDisplayFont)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)))
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(jFormattedTextFieldCharacter, javax.swing.GroupLayout.DEFAULT_SIZE, 92, Short.MAX_VALUE)
                            .addComponent(jFormattedTextFieldUnicode, javax.swing.GroupLayout.DEFAULT_SIZE, 107, Short.MAX_VALUE)
                            .addComponent(jFormattedTextFieldHtmlEntity))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jTextFieldUnicodeResult, javax.swing.GroupLayout.PREFERRED_SIZE, 117, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jTextFieldHtmlEntityResult, javax.swing.GroupLayout.PREFERRED_SIZE, 117, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addComponent(jPanelFontSelection, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanelHuge, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );

        layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {jLabelCharacter, jLabelDisplayFont, jLabelHtmlEntity, jLabelUnicode});

        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanelHuge, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                            .addComponent(jFormattedTextFieldCharacter, javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabelCharacter, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jFormattedTextFieldHtmlEntity, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabelHtmlEntity)
                            .addComponent(jTextFieldHtmlEntityResult, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jFormattedTextFieldUnicode, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabelUnicode)
                            .addComponent(jTextFieldUnicodeResult, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(jLabelDisplayFont)
                            .addComponent(jPanelFontSelection, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))))
                .addContainerGap())
        );

        layout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {jFormattedTextFieldCharacter, jFormattedTextFieldHtmlEntity, jFormattedTextFieldUnicode, jLabelCharacter, jLabelDisplayFont, jLabelHtmlEntity, jLabelUnicode, jPanelFontSelection, jTextFieldHtmlEntityResult, jTextFieldUnicodeResult});

        pack();
    }// </editor-fold>//GEN-END:initComponents

  private void keyReleasedCharacter(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_keyReleasedCharacter
      if (null != m_tGuiConnector) m_tGuiConnector.handleInputCharacter(false);
  }//GEN-LAST:event_keyReleasedCharacter

  private void focusLostInputCharacter(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_focusLostInputCharacter
    if (null != m_tGuiConnector) m_tGuiConnector.handleInputCharacter(true);
  }//GEN-LAST:event_focusLostInputCharacter

  private void keyReleasedUnicode(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_keyReleasedUnicode

    if (null != m_tGuiConnector) {       m_tGuiConnector.handleInputUnicode(false);     }   }//GEN-LAST:event_keyReleasedUnicode

  private void focusLostInputUnicode(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_focusLostInputUnicode

    if (null != m_tGuiConnector) {       m_tGuiConnector.handleInputUnicode(true);     }   }//GEN-LAST:event_focusLostInputUnicode

  private void keyReleasedHtmlEntity(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_keyReleasedHtmlEntity

    if (null != m_tGuiConnector) {       m_tGuiConnector.handleInputHtmlEntity(false);     }   }//GEN-LAST:event_keyReleasedHtmlEntity

  private void focusLostInputHtmlEntity(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_focusLostInputHtmlEntity

    if (null != m_tGuiConnector) {       m_tGuiConnector.handleInputHtmlEntity(true);     }   }//GEN-LAST:event_focusLostInputHtmlEntity

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JFormattedTextField jFormattedTextFieldCharacter;
    private javax.swing.JFormattedTextField jFormattedTextFieldHtmlEntity;
    private javax.swing.JFormattedTextField jFormattedTextFieldUnicode;
    private javax.swing.JLabel jLabelCharacter;
    private javax.swing.JLabel jLabelDisplayFont;
    private javax.swing.JLabel jLabelHtmlEntity;
    private javax.swing.JLabel jLabelUnicode;
    private javax.swing.JPanel jPanelFontSelection;
    private javax.swing.JPanel jPanelHuge;
    private javax.swing.JTextField jTextFieldHtmlEntityResult;
    private javax.swing.JTextField jTextFieldUnicodeResult;
    // End of variables declaration//GEN-END:variables

 
  /**
   * Handle change in font selector
     * 
   * @param pa_tEvent  event
   */
  public void itemStateChanged(ItemEvent pa_tEvent) 
  {
   String lc_sFontName = null;
   
   if (null != m_tFontChooserComboBox)
   {
    if (null != (lc_sFontName = m_tFontChooserComboBox.getSelectedFontName()))
    {
     setDisplayFont(lc_sFontName, false); 
     if (null != m_tGuiConnector) m_tGuiConnector.handleButtonSelectFont();
    }
   }
  }



} // eoc
