/*
 * Decompiled with CFR 0.152.
 */
package colorpal2;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;

public class ColorPal2ColorRecord {
    private Color m_tColor;
    private ImageIcon m_tImage;
    private int m_iSteps;

    public ColorPal2ColorRecord(String pa_sColor, int pa_iSteps) {
        String lc_sTemp = "";
        if (null != pa_sColor && !pa_sColor.isEmpty()) {
            if (!pa_sColor.startsWith("#")) {
                lc_sTemp = "#";
            }
            lc_sTemp = lc_sTemp + pa_sColor;
            this.m_iSteps = pa_iSteps;
            this.m_tColor = Color.decode(lc_sTemp);
        }
        this.createImage();
    }

    public ColorPal2ColorRecord(Color pa_tColor, int pa_iSteps) {
        if (null != pa_tColor) {
            this.m_iSteps = pa_iSteps;
            this.m_tColor = new Color(pa_tColor.getRGB());
        }
        this.createImage();
    }

    public ColorPal2ColorRecord(ColorPal2ColorRecord pa_tObject) {
        if (null != pa_tObject && this != pa_tObject) {
            this.m_iSteps = pa_tObject.getSteps();
            this.m_tColor = new Color(pa_tObject.getColor().getRGB());
        }
        this.createImage();
    }

    public boolean isEqual(ColorPal2ColorRecord pa_tRecord) {
        if (null == pa_tRecord) {
            return false;
        }
        if (null == pa_tRecord.getColor()) {
            return false;
        }
        return this.m_tColor.getRGB() == pa_tRecord.getColor().getRGB() && this.m_iSteps == pa_tRecord.getSteps();
    }

    protected void createImage() {
        Graphics lc_tGraphics = null;
        BufferedImage lc_tImage = null;
        lc_tImage = new BufferedImage(100, 20, 1);
        if (null != lc_tImage && null != (lc_tGraphics = lc_tImage.getGraphics())) {
            lc_tGraphics.setColor(Color.black);
            lc_tGraphics.drawRect(0, 0, 120, 20);
            lc_tGraphics.setColor(this.m_tColor);
            lc_tGraphics.fillRect(1, 1, 119, 19);
            this.m_tImage = new ImageIcon(lc_tImage);
        }
    }

    public ImageIcon getImage() {
        return this.m_tImage;
    }

    public String getColorString() {
        String lc_sColorString;
        String string = lc_sColorString = null == this.m_tColor ? null : Integer.toHexString(this.m_tColor.getRGB());
        if (null != lc_sColorString) {
            return lc_sColorString.length() > 6 ? lc_sColorString.substring(2) : lc_sColorString;
        }
        return null;
    }

    public Color getColor() {
        return this.m_tColor;
    }

    public int getSteps() {
        return this.m_iSteps;
    }

    public void setSteps(int pa_iSteps) {
        if (0 < pa_iSteps && Integer.MAX_VALUE > pa_iSteps) {
            this.m_iSteps = pa_iSteps;
        }
    }

    public String toString() {
        return this.getColorString();
    }
}

