/*
 * Decompiled with CFR 0.152.
 */
package colorpal2;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class ColorPal2Settings {
    private Properties m_tProperties = new Properties();
    private boolean m_bValid = false;
    protected static final String COLORPAL2_SETTINGS_FILENAME = "ColorPal2.prs";
    protected static final String COLORPAL2_SETTINGS_LOADPATH = "LoadPath";
    protected static final String COLORPAL2_SETTINGS_SAVEPATH = "SavePath";
    protected static final String COLORPAL2_SETTINGS_COLORNODES = "ColorNodes";
    protected static final String COLORPAL2_SETTINGS_SEPARATOR = ",";

    public ColorPal2Settings(boolean pa_bLoad) {
        if (pa_bLoad) {
            this.load(null);
        }
    }

    public boolean isValid() {
        return this.m_bValid;
    }

    public void load(String pa_sPath) {
        File lc_tPropertiesFile = new File(null != pa_sPath ? pa_sPath : COLORPAL2_SETTINGS_FILENAME);
        FileInputStream lc_tInputStream = null;
        if (null != lc_tPropertiesFile && null != this.m_tProperties && lc_tPropertiesFile.exists()) {
            try {
                lc_tInputStream = new FileInputStream(lc_tPropertiesFile);
                if (null != lc_tInputStream) {
                    this.m_tProperties.load(lc_tInputStream);
                    lc_tInputStream.close();
                    this.m_bValid = false == this.m_tProperties.isEmpty();
                }
            }
            catch (IOException lc_tExcpetion) {
                // empty catch block
            }
        }
    }

    public void save(String pa_sPath, String pa_sComment) {
        File lc_tPropertiesFile = new File(null != pa_sPath ? pa_sPath : COLORPAL2_SETTINGS_FILENAME);
        FileOutputStream lc_tOutputStream = null;
        if (null != lc_tPropertiesFile && null != this.m_tProperties) {
            try {
                if (!lc_tPropertiesFile.exists()) {
                    lc_tPropertiesFile.createNewFile();
                }
                if (lc_tPropertiesFile.exists() && null != (lc_tOutputStream = new FileOutputStream(lc_tPropertiesFile))) {
                    this.m_tProperties.store(lc_tOutputStream, pa_sComment);
                    lc_tOutputStream.close();
                }
            }
            catch (IOException lc_tException) {
                // empty catch block
            }
        }
    }

    private String getPropertyValue(String pa_sKey) {
        Object lc_tObject = null;
        String lc_sResult = null;
        if (null != this.m_tProperties & null != pa_sKey && null != (lc_tObject = this.m_tProperties.get(pa_sKey)) && lc_tObject instanceof String) {
            lc_sResult = lc_tObject.toString();
        }
        return lc_sResult;
    }

    public String getLoadPath() {
        return this.getPropertyValue(COLORPAL2_SETTINGS_LOADPATH);
    }

    public void setLoadPath(String pa_sPath) {
        if (null != this.m_tProperties) {
            this.m_tProperties.put(COLORPAL2_SETTINGS_LOADPATH, pa_sPath);
        }
    }

    public String getSavePath() {
        return this.getPropertyValue(COLORPAL2_SETTINGS_SAVEPATH);
    }

    public void setSavePath(String pa_sPath) {
        if (null != this.m_tProperties) {
            this.m_tProperties.put(COLORPAL2_SETTINGS_SAVEPATH, pa_sPath);
        }
    }

    public String getColorNodes() {
        return this.getPropertyValue(COLORPAL2_SETTINGS_COLORNODES);
    }

    public void setColorNodes(String pa_sValue) {
        if (null != this.m_tProperties) {
            this.m_tProperties.put(COLORPAL2_SETTINGS_COLORNODES, pa_sValue);
        }
    }
}

