/*
 * Decompiled with CFR 0.152.
 */
package colorpal2;

import colorpal2.ColorPal2App;
import colorpal2.ColorPal2ColorRecord;
import colorpal2.ColorPal2GuiConnector;
import colorpal2.ColorPal2ListCellRenderer;
import colorpal2.ColorPal2Settings;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class ColorPal2View
extends JFrame
implements MouseListener {
    private ColorPal2GuiConnector m_tGuiConnector;
    private ColorPal2Settings m_tSettings;
    private Color m_tDefaultBackground;
    private ResourceBundle m_tLocalizedMessages;
    private ResourceBundle m_tResources;
    private JButton jButtonClipboard;
    private JButton jButtonColor;
    private JButton jButtonNodesClear;
    private JButton jButtonNodesClone;
    private JButton jButtonNodesDelete;
    private JButton jButtonNodesDown;
    private JButton jButtonNodesFirst;
    private JButton jButtonNodesFlip;
    private JButton jButtonNodesLast;
    private JButton jButtonNodesLoad;
    private JButton jButtonNodesNew;
    private JButton jButtonNodesSave;
    private JButton jButtonNodesUp;
    private JLabel jLabelSteps;
    private JList jListColors;
    private JList jListNodes;
    private JPanel jPanelColors;
    private JPanel jPanelNodes;
    private JPanel jPanelProperties;
    private JScrollPane jScrollPaneColors;
    private JScrollPane jScrollPaneNodes;
    private JSpinner jSpinnerStepping;
    private JTextField jTextFieldColor;

    public ColorPal2View(ColorPal2GuiConnector pa_tGuiConnector, WindowListener pa_tListener, ListSelectionListener pa_tListSelectionListener) {
        this.m_tGuiConnector = pa_tGuiConnector;
        this.m_tSettings = new ColorPal2Settings(true);
        this.m_tLocalizedMessages = ResourceBundle.getBundle("colorpal2/resources/ColorPal2Messages");
        this.m_tResources = ResourceBundle.getBundle("colorpal2/resources/ColorPal2View");
        if (null != this.m_tResources) {
            UIManager.put("FileChooser.cancelButtonText", this.m_tResources.getString("jFileChooser.cancelText"));
        }
        this.initComponents();
        this.m_tDefaultBackground = this.jTextFieldColor.getBackground();
        this.jListColors.setCellRenderer(new ColorPal2ListCellRenderer());
        this.jListColors.setBackground(Color.white);
        this.jListNodes.setCellRenderer(new ColorPal2ListCellRenderer());
        this.jListNodes.setBackground(Color.white);
        this.jScrollPaneColors.setBackground(Color.white);
        this.jScrollPaneNodes.setBackground(Color.white);
        if (null != this.m_tSettings && this.m_tSettings.isValid()) {
            this.initBySettings();
        }
        this.jListNodes.addMouseListener(this);
        this.addWindowListener(pa_tListener);
        this.jListNodes.addListSelectionListener(pa_tListSelectionListener);
    }

    private void initBySettings() {
        DefaultListModel lc_tListModel = (DefaultListModel)this.jListNodes.getModel();
        String lc_sColor = null;
        String lc_sColorNodes = this.m_tSettings.getColorNodes();
        StringTokenizer lc_tTokenizer = new StringTokenizer(lc_sColorNodes, ",");
        ColorPal2ColorRecord lc_tNewValue = null;
        int lc_iLen = 0;
        int lc_iI = 0;
        int lc_iSteps = 0;
        int lc_iCount = 0;
        if (null != lc_sColorNodes && null != lc_tTokenizer) {
            lc_iLen = Integer.valueOf(lc_tTokenizer.nextToken());
            if (0 < lc_iLen) {
                lc_tListModel.clear();
                for (lc_iI = 0; lc_iI < lc_iLen; ++lc_iI) {
                    lc_sColor = lc_tTokenizer.nextToken();
                    if (null == lc_sColor || null == (lc_tNewValue = new ColorPal2ColorRecord(lc_sColor, lc_iSteps = Integer.valueOf(lc_tTokenizer.nextToken()).intValue()))) continue;
                    lc_tListModel.addElement(lc_tNewValue);
                    ++lc_iCount;
                }
            }
            if (0 < lc_iCount) {
                this.jListNodes.setSelectedIndex(0);
                this.updateCurrentProperties();
                this.computeColors();
            }
        }
    }

    private boolean existsFile(String pa_sFileName) {
        File lc_tFile = null;
        lc_tFile = new File(pa_sFileName);
        if (null != lc_tFile) {
            return true == lc_tFile.exists();
        }
        return false;
    }

    public void saveNodesFile() {
        boolean lc_bSave = true;
        String lc_sFileName = null;
        String lc_sSavePath = null != this.m_tSettings ? this.m_tSettings.getSavePath() : null;
        JFileChooser lc_tFileChooser = null != lc_sSavePath ? new JFileChooser(lc_sSavePath) : new JFileChooser();
        ColorPal2Settings lc_tSettings = new ColorPal2Settings(false);
        Object[] lc_tDialogOptions = new Object[]{this.getLocalizedString("dialogOptionOk"), this.getLocalizedString("dialogOptionCancel")};
        if (null != lc_tFileChooser && null != lc_tSettings) {
            lc_tSettings.setColorNodes(this.getColorNodesString());
            lc_tFileChooser.setDialogTitle(this.getLocalizedString("dialogTitleSave"));
            lc_tFileChooser.setApproveButtonText(this.getLocalizedString("dialogOptionSave"));
            lc_tFileChooser.setFileSelectionMode(0);
            lc_tFileChooser.setAcceptAllFileFilterUsed(false);
            lc_tFileChooser.setMultiSelectionEnabled(false);
            if (0 == lc_tFileChooser.showOpenDialog(this) && null != (lc_sFileName = lc_tFileChooser.getSelectedFile().getAbsolutePath())) {
                if (this.existsFile(lc_sFileName)) {
                    boolean bl = lc_bSave = 0 == JOptionPane.showOptionDialog(this, this.getLocalizedString("dialogMessageOverwrite") + " \"" + lc_sFileName + "\" ? <br />", this.getLocalizedString("dialogTitleWarning"), 0, 2, null, lc_tDialogOptions, lc_tDialogOptions[0]);
                }
                if (lc_bSave) {
                    lc_tSettings.save(lc_sFileName, "ColorPal2 palette file");
                    if (null != this.m_tSettings) {
                        this.m_tSettings.setSavePath(lc_sFileName);
                    }
                    JOptionPane.showMessageDialog(this, this.getLocalizedString("dialogMessageSaved") + " \"" + lc_sFileName + "\"" + this.getLocalizedString("dialogMessageSaved2"), this.getLocalizedString("dialogTitleInformation"), 1);
                }
            }
        }
    }

    public void loadNodesFile() {
        String lc_sFileName = null;
        String lc_sLoadPath = null != this.m_tSettings ? this.m_tSettings.getLoadPath() : null;
        JFileChooser lc_tFileChooser = null != lc_sLoadPath ? new JFileChooser(lc_sLoadPath) : new JFileChooser();
        ColorPal2Settings lc_tSettings = new ColorPal2Settings(false);
        if (null != lc_tFileChooser && null != lc_tSettings) {
            lc_tSettings.setColorNodes(this.getColorNodesString());
            lc_tFileChooser.setDialogTitle(this.getLocalizedString("dialogTitleLoad"));
            lc_tFileChooser.setApproveButtonText(this.getLocalizedString("dialogOptionLoad"));
            lc_tFileChooser.setFileSelectionMode(0);
            lc_tFileChooser.setAcceptAllFileFilterUsed(false);
            lc_tFileChooser.setMultiSelectionEnabled(false);
            if (0 == lc_tFileChooser.showOpenDialog(this) && null != (lc_sFileName = lc_tFileChooser.getSelectedFile().getAbsolutePath()) && this.existsFile(lc_sFileName)) {
                lc_tSettings.load(lc_sFileName);
                if (lc_tSettings.isValid() && null != this.m_tSettings) {
                    this.m_tSettings.setLoadPath(lc_sFileName);
                    this.m_tSettings.setColorNodes(lc_tSettings.getColorNodes());
                    this.initBySettings();
                }
            }
        }
    }

    private String getColorNodesString() {
        StringBuffer lc_tColorNodeString = new StringBuffer();
        DefaultListModel lc_tListModel = (DefaultListModel)this.jListNodes.getModel();
        Object lc_tNodeObject = null;
        ColorPal2ColorRecord lc_tNodeValue = null;
        int lc_iLen = lc_tListModel.getSize();
        int lc_iI = 0;
        lc_tColorNodeString.append(lc_iLen);
        if (0 < lc_iLen) {
            for (lc_iI = 0; lc_iI < lc_iLen; ++lc_iI) {
                Object e = lc_tListModel.elementAt(lc_iI);
                lc_tNodeObject = e;
                if (null == e || null == (lc_tNodeValue = (ColorPal2ColorRecord)lc_tNodeObject)) continue;
                lc_tColorNodeString.append(",");
                lc_tColorNodeString.append(lc_tNodeValue.getColorString());
                lc_tColorNodeString.append(",");
                lc_tColorNodeString.append(lc_tNodeValue.getSteps());
            }
        }
        return null != lc_tColorNodeString ? lc_tColorNodeString.toString() : "";
    }

    public void saveSettings(String pa_sPath) {
        if (null != this.m_tSettings) {
            this.m_tSettings.setColorNodes(this.getColorNodesString());
            this.m_tSettings.save(pa_sPath, "ColorPal2 settings file");
        }
    }

    public int getSteps() {
        return (Integer)this.jSpinnerStepping.getValue();
    }

    public void setSteps(int pa_iValue) {
        this.jSpinnerStepping.setValue(pa_iValue);
    }

    public Color getColor() {
        return this.jTextFieldColor.getBackground();
    }

    public void setColor(Color pa_tColor) {
        this.jTextFieldColor.setBackground(pa_tColor);
    }

    public ColorPal2ColorRecord getCurrentProperties() {
        return new ColorPal2ColorRecord(this.getColor(), this.getSteps());
    }

    public void updateCurrentProperties() {
        boolean lc_bHasNodes;
        DefaultListModel lc_tListModel = (DefaultListModel)this.jListNodes.getModel();
        boolean bl = lc_bHasNodes = lc_tListModel.getSize() > 0;
        boolean lc_bHasNodeSelection = lc_bHasNodes ? this.jListNodes.getSelectedIndex() != -1 : false;
        Object lc_tSelectionObject = null;
        ColorPal2ColorRecord lc_tSelectionValue = null;
        if (lc_bHasNodeSelection) {
            Object e = this.jListNodes.getSelectedValue();
            lc_tSelectionObject = e;
            if (null != e && lc_tSelectionObject instanceof ColorPal2ColorRecord && null != (lc_tSelectionValue = (ColorPal2ColorRecord)lc_tSelectionObject)) {
                this.setColor(lc_tSelectionValue.getColor());
                this.setSteps(lc_tSelectionValue.getSteps());
            }
        }
    }

    public void addNode(Color pa_tColor, int pa_iSteps) {
        DefaultListModel lc_tListModel = (DefaultListModel)this.jListNodes.getModel();
        int lc_iSelectionPos = this.jListNodes.getSelectedIndex();
        ColorPal2ColorRecord lc_tNewNode = new ColorPal2ColorRecord(pa_tColor, pa_iSteps);
        if (-1 == lc_iSelectionPos) {
            lc_tListModel.addElement(lc_tNewNode);
        } else {
            lc_tListModel.insertElementAt(lc_tNewNode, lc_iSelectionPos);
        }
        this.jListNodes.setSelectedIndex(-1 == lc_iSelectionPos ? 0 : lc_iSelectionPos);
        this.updateCurrentProperties();
        this.computeColors();
    }

    public void changeCurrentColor() {
        Color lc_tOldColor = this.getColor();
        Color lc_tNewColor = JColorChooser.showDialog(this, this.getLocalizedString("dialogTitleColor"), this.getColor());
        if (lc_tNewColor != null && lc_tOldColor != null && lc_tNewColor.getRGB() != lc_tOldColor.getRGB()) {
            this.setColor(lc_tNewColor);
        }
    }

    public void applyProperties() {
        DefaultListModel lc_tListModel = (DefaultListModel)this.jListNodes.getModel();
        int lc_iSelectionPos = this.jListNodes.getSelectedIndex();
        ColorPal2ColorRecord lc_tNewNode = this.getCurrentProperties();
        if (-1 != lc_iSelectionPos) {
            lc_tListModel.setElementAt(lc_tNewNode, lc_iSelectionPos);
            this.computeColors();
        }
    }

    public void clearNodes() {
        DefaultListModel lc_tNodeModel = (DefaultListModel)this.jListNodes.getModel();
        DefaultListModel lc_tColorModel = (DefaultListModel)this.jListColors.getModel();
        lc_tNodeModel.clear();
        lc_tColorModel.clear();
        this.setColor(this.m_tDefaultBackground);
        this.setSteps(5);
    }

    public void deleteNode() {
        DefaultListModel lc_tListModel = (DefaultListModel)this.jListNodes.getModel();
        int lc_iNewSelectionPos = 0;
        int lc_iSelectionPos = this.jListNodes.getSelectedIndex();
        int lc_iSize = lc_tListModel.getSize();
        if (-1 != lc_iSelectionPos) {
            lc_tListModel.removeElementAt(lc_iSelectionPos);
            if (0 < lc_iSize - 1) {
                lc_iNewSelectionPos = lc_iSelectionPos - 1;
                if (0 > lc_iNewSelectionPos) {
                    lc_iNewSelectionPos = 0;
                }
                this.jListNodes.setSelectedIndex(lc_iNewSelectionPos);
            } else {
                this.setColor(this.m_tDefaultBackground);
                this.setSteps(5);
            }
            this.updateCurrentProperties();
            this.computeColors();
        }
    }

    public void cloneNode() {
        int lc_iSelectionPos;
        DefaultListModel lc_tListModel = (DefaultListModel)this.jListNodes.getModel();
        int lc_iInsertPos = lc_iSelectionPos = this.jListNodes.getSelectedIndex();
        Object lc_tSelectionObject = null;
        ColorPal2ColorRecord lc_tSelectionValue = null;
        ColorPal2ColorRecord lc_tCloneValue = null;
        if (-1 != lc_iSelectionPos) {
            Object e = this.jListNodes.getSelectedValue();
            lc_tSelectionObject = e;
            if (null != e && lc_tSelectionObject instanceof ColorPal2ColorRecord && null != (lc_tSelectionValue = (ColorPal2ColorRecord)lc_tSelectionObject) && null != (lc_tCloneValue = new ColorPal2ColorRecord(lc_tSelectionValue))) {
                lc_tListModel.insertElementAt(lc_tSelectionObject, lc_iInsertPos);
                this.updateCurrentProperties();
                this.computeColors();
            }
        }
    }

    private void moveNode(int pa_iToIndex) {
        DefaultListModel lc_tListModel = (DefaultListModel)this.jListNodes.getModel();
        int lc_iSelectionPos = this.jListNodes.getSelectedIndex();
        Object lc_tSelectionObject = null;
        ColorPal2ColorRecord lc_tSelectionValue = null;
        ColorPal2ColorRecord lc_tCloneValue = null;
        Object e = this.jListNodes.getSelectedValue();
        lc_tSelectionObject = e;
        if (null != e && lc_tSelectionObject instanceof ColorPal2ColorRecord && null != (lc_tSelectionValue = (ColorPal2ColorRecord)lc_tSelectionObject) && null != (lc_tCloneValue = new ColorPal2ColorRecord(lc_tSelectionValue))) {
            lc_tListModel.removeElementAt(lc_iSelectionPos);
            lc_tListModel.insertElementAt(lc_tCloneValue, pa_iToIndex);
            this.jListNodes.setSelectedIndex(pa_iToIndex);
            this.updateCurrentProperties();
            this.computeColors();
        }
    }

    public void moveNodeToTop() {
        int lc_iSelectionPos = this.jListNodes.getSelectedIndex();
        if (0 < lc_iSelectionPos) {
            this.moveNode(0);
        }
    }

    public void moveNodeUp() {
        int lc_iSelectionPos = this.jListNodes.getSelectedIndex();
        if (0 < lc_iSelectionPos) {
            this.moveNode(lc_iSelectionPos - 1);
        }
    }

    public void moveNodeDown() {
        DefaultListModel lc_tListModel = (DefaultListModel)this.jListNodes.getModel();
        int lc_iSelectionPos = this.jListNodes.getSelectedIndex();
        int lc_iSize = lc_tListModel.getSize() - 1;
        if (lc_iSize > lc_iSelectionPos) {
            this.moveNode(lc_iSelectionPos + 1);
        }
    }

    public void moveNodeToBottom() {
        DefaultListModel lc_tListModel = (DefaultListModel)this.jListNodes.getModel();
        int lc_iSelectionPos = this.jListNodes.getSelectedIndex();
        int lc_iSize = lc_tListModel.getSize() - 1;
        if (lc_iSize > lc_iSelectionPos) {
            this.moveNode(lc_iSize);
        }
    }

    public void flipNodes() {
        DefaultListModel lc_tListModel = (DefaultListModel)this.jListNodes.getModel();
        int lc_iSelectionPos = this.jListNodes.getSelectedIndex();
        int lc_iSize = lc_tListModel.getSize();
        int lc_iI = 0;
        ColorPal2ColorRecord lc_tOldValue = null;
        ColorPal2ColorRecord lc_tNewValue = null;
        for (lc_iI = lc_iSize - 1; lc_iI >= 0; --lc_iI) {
            lc_tOldValue = (ColorPal2ColorRecord)lc_tListModel.elementAt(lc_iI);
            if (null == lc_tOldValue || null == (lc_tNewValue = new ColorPal2ColorRecord(lc_tOldValue))) continue;
            lc_tListModel.addElement(lc_tNewValue);
        }
        lc_tListModel.removeRange(0, lc_iSize - 1);
        this.jListNodes.setSelectedIndex(lc_iSelectionPos);
        this.updateCurrentProperties();
        this.computeColors();
    }

    public void checkButtons() {
        boolean lc_bHasNodes;
        int lc_iSelectedNodeIndex = this.jListNodes.getSelectedIndex();
        int lc_iColorAmount = this.jListColors.getModel().getSize();
        int lc_iNodeAmount = this.jListNodes.getModel().getSize();
        boolean lc_bHasColors = lc_iColorAmount > 0;
        boolean bl = lc_bHasNodes = lc_iNodeAmount > 0;
        boolean lc_bHasNodeSelection = lc_bHasNodes ? lc_iSelectedNodeIndex != -1 : false;
        this.jButtonNodesSave.setEnabled(lc_bHasNodes);
        this.jButtonNodesFlip.setEnabled(lc_bHasNodes && 1 < lc_iNodeAmount);
        this.jButtonNodesClear.setEnabled(lc_bHasNodes);
        this.jButtonNodesUp.setEnabled(lc_bHasNodeSelection && lc_iSelectedNodeIndex > 0);
        this.jButtonNodesDown.setEnabled(lc_bHasNodeSelection && lc_iSelectedNodeIndex < lc_iNodeAmount - 1);
        this.jButtonNodesFirst.setEnabled(lc_bHasNodeSelection && lc_iSelectedNodeIndex > 0);
        this.jButtonNodesLast.setEnabled(lc_bHasNodeSelection && lc_iSelectedNodeIndex < lc_iNodeAmount - 1);
        this.jButtonNodesDelete.setEnabled(lc_bHasNodeSelection);
        this.jButtonNodesClone.setEnabled(lc_bHasNodeSelection);
        this.jButtonColor.setEnabled(lc_bHasNodeSelection);
        this.jSpinnerStepping.setEnabled(lc_bHasNodeSelection);
        this.jButtonClipboard.setEnabled(lc_bHasColors);
        this.jButtonNodesLoad.setEnabled(true);
        this.jButtonNodesNew.setEnabled(true);
    }

    private void initComponents() {
        this.jPanelColors = new JPanel();
        this.jScrollPaneColors = new JScrollPane();
        this.jListColors = new JList();
        this.jButtonClipboard = new JButton();
        this.jPanelNodes = new JPanel();
        this.jScrollPaneNodes = new JScrollPane();
        this.jListNodes = new JList();
        this.jPanelProperties = new JPanel();
        this.jButtonColor = new JButton();
        this.jTextFieldColor = new JTextField();
        this.jSpinnerStepping = new JSpinner();
        this.jLabelSteps = new JLabel();
        this.jButtonNodesFirst = new JButton();
        this.jButtonNodesUp = new JButton();
        this.jButtonNodesDown = new JButton();
        this.jButtonNodesLast = new JButton();
        this.jButtonNodesDelete = new JButton();
        this.jButtonNodesClone = new JButton();
        this.jButtonNodesLoad = new JButton();
        this.jButtonNodesSave = new JButton();
        this.jButtonNodesClear = new JButton();
        this.jButtonNodesFlip = new JButton();
        this.jButtonNodesNew = new JButton();
        this.setDefaultCloseOperation(0);
        ResourceBundle bundle = ResourceBundle.getBundle("colorpal2/resources/ColorPal2View");
        this.setTitle(bundle.getString("Form.title"));
        this.setName("Form");
        this.jPanelColors.setBorder(BorderFactory.createTitledBorder(bundle.getString("jPanelColors.border.title")));
        this.jPanelColors.setName("jPanelColors");
        ResourceMap resourceMap = Application.getInstance(ColorPal2App.class).getContext().getResourceMap(ColorPal2View.class);
        this.jScrollPaneColors.setBackground(resourceMap.getColor("jScrollPaneColors.background"));
        this.jScrollPaneColors.setName("jScrollPaneColors");
        this.jListColors.setBackground(new Color(Integer.valueOf(bundle.getString("jList.background"), 16)));
        this.jListColors.setForeground(new Color(Integer.valueOf(bundle.getString("jList.foreground"), 16)));
        this.jListColors.setModel(new DefaultListModel());
        this.jListColors.setSelectionMode(0);
        this.jListColors.setName("jListColors");
        this.jListColors.setSelectionBackground(new Color(Integer.valueOf(bundle.getString("jList.selectionBackground"), 16)));
        this.jListColors.setSelectionForeground(new Color(Integer.valueOf(bundle.getString("jList.selectionForeground"), 16)));
        this.jScrollPaneColors.setViewportView(this.jListColors);
        this.jButtonClipboard.setText(bundle.getString("jButtonClipboard.text"));
        this.jButtonClipboard.setToolTipText(bundle.getString("jButtonClipboard.toolTipText"));
        this.jButtonClipboard.setName("jButtonClipboard");
        this.jButtonClipboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorPal2View.this.actionPerformed_Button_Clipboard(evt);
            }
        });
        GroupLayout jPanelColorsLayout = new GroupLayout(this.jPanelColors);
        this.jPanelColors.setLayout(jPanelColorsLayout);
        jPanelColorsLayout.setHorizontalGroup(jPanelColorsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelColorsLayout.createSequentialGroup().addContainerGap().addGroup(jPanelColorsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPaneColors, GroupLayout.Alignment.LEADING, -1, 197, Short.MAX_VALUE).addComponent(this.jButtonClipboard, GroupLayout.Alignment.LEADING, -1, 197, Short.MAX_VALUE)).addContainerGap()));
        jPanelColorsLayout.setVerticalGroup(jPanelColorsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelColorsLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneColors, -1, 495, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonClipboard).addContainerGap()));
        this.jPanelNodes.setBorder(BorderFactory.createTitledBorder(bundle.getString("jPanelNodes.border.title")));
        this.jPanelNodes.setName("jPanelNodes");
        this.jScrollPaneNodes.setBackground(resourceMap.getColor("jScrollPaneNodes.background"));
        this.jScrollPaneNodes.setName("jScrollPaneNodes");
        this.jListNodes.setBackground(new Color(Integer.valueOf(bundle.getString("jList.background"), 16)));
        this.jListNodes.setForeground(new Color(Integer.valueOf(bundle.getString("jList.foreground"), 16)));
        this.jListNodes.setModel(new DefaultListModel());
        this.jListNodes.setSelectionMode(0);
        this.jListNodes.setName("jListNodes");
        this.jListNodes.setSelectionBackground(new Color(Integer.valueOf(bundle.getString("jList.selectionBackground"), 16)));
        this.jListNodes.setSelectionForeground(new Color(Integer.valueOf(bundle.getString("jList.selectionForeground"), 16)));
        this.jScrollPaneNodes.setViewportView(this.jListNodes);
        this.jPanelProperties.setBorder(BorderFactory.createTitledBorder(bundle.getString("jPanelProperties.border.title")));
        this.jPanelProperties.setName("jPanelProperties");
        this.jButtonColor.setText(bundle.getString("jButtonColor.text"));
        this.jButtonColor.setToolTipText(bundle.getString("jButtonColor.toolTipText"));
        this.jButtonColor.setName("jButtonColor");
        this.jButtonColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorPal2View.this.actionPerformed_Button_Color(evt);
            }
        });
        this.jTextFieldColor.setEditable(false);
        this.jTextFieldColor.setText(bundle.getString("jTextFieldColor.text"));
        this.jTextFieldColor.setName("jTextFieldColor");
        this.jSpinnerStepping.setModel(new SpinnerNumberModel(1, 1, 256, 1));
        this.jSpinnerStepping.setName("jSpinnerStepping");
        this.jSpinnerStepping.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ColorPal2View.this.stateChanged_Spinner_Steps(evt);
            }
        });
        this.jLabelSteps.setText(bundle.getString("jLabelSteps.text"));
        GroupLayout jPanelPropertiesLayout = new GroupLayout(this.jPanelProperties);
        this.jPanelProperties.setLayout(jPanelPropertiesLayout);
        jPanelPropertiesLayout.setHorizontalGroup(jPanelPropertiesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelPropertiesLayout.createSequentialGroup().addContainerGap().addComponent(this.jButtonColor, -2, 76, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldColor, -1, 101, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelSteps, -2, 33, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinnerStepping, -2, 56, -2).addContainerGap()));
        jPanelPropertiesLayout.setVerticalGroup(jPanelPropertiesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelPropertiesLayout.createSequentialGroup().addContainerGap().addGroup(jPanelPropertiesLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonColor).addComponent(this.jTextFieldColor, -2, -1, -2).addComponent(this.jSpinnerStepping, -2, -1, -2).addComponent(this.jLabelSteps)).addContainerGap()));
        jPanelPropertiesLayout.linkSize(1, this.jButtonColor, this.jLabelSteps, this.jSpinnerStepping, this.jTextFieldColor);
        this.jButtonNodesFirst.setIcon(resourceMap.getIcon("jButtonNodesFirst.icon"));
        this.jButtonNodesFirst.setText(bundle.getString("jButtonNodesFirst.text"));
        this.jButtonNodesFirst.setToolTipText(bundle.getString("jButtonNodesFirst.toolTipText"));
        this.jButtonNodesFirst.setName("jButtonNodesFirst");
        this.jButtonNodesFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorPal2View.this.actionPerformed_Button_NodesFirst(evt);
            }
        });
        this.jButtonNodesUp.setIcon(resourceMap.getIcon("jButtonNodesUp.icon"));
        this.jButtonNodesUp.setText(bundle.getString("jButtonNodesUp.text"));
        this.jButtonNodesUp.setToolTipText(bundle.getString("jButtonNodesUp.toolTipText"));
        this.jButtonNodesUp.setName("jButtonNodesUp");
        this.jButtonNodesUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorPal2View.this.actionPerformed_Button_NodesUp(evt);
            }
        });
        this.jButtonNodesDown.setIcon(resourceMap.getIcon("jButtonNodesDown.icon"));
        this.jButtonNodesDown.setText(bundle.getString("jButtonNodesDown.text"));
        this.jButtonNodesDown.setToolTipText(bundle.getString("jButtonNodesDown.toolTipText"));
        this.jButtonNodesDown.setName("jButtonNodesDown");
        this.jButtonNodesDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorPal2View.this.actionPerformed_Button_NodesDown(evt);
            }
        });
        this.jButtonNodesLast.setIcon(resourceMap.getIcon("jButtonNodesLast.icon"));
        this.jButtonNodesLast.setText(bundle.getString("jButtonNodesLast.text"));
        this.jButtonNodesLast.setToolTipText(bundle.getString("jButtonNodesLast.toolTipText"));
        this.jButtonNodesLast.setName("jButtonNodesLast");
        this.jButtonNodesLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorPal2View.this.actionPerformed_Button_NodesLast(evt);
            }
        });
        this.jButtonNodesDelete.setIcon(resourceMap.getIcon("jButtonNodesDelete.icon"));
        this.jButtonNodesDelete.setText(bundle.getString("jButtonNodesDelete.text"));
        this.jButtonNodesDelete.setToolTipText(bundle.getString("jButtonNodesDelete.toolTipText"));
        this.jButtonNodesDelete.setName("jButtonNodesDelete");
        this.jButtonNodesDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorPal2View.this.actionPerformed_Button_NodesDelete(evt);
            }
        });
        this.jButtonNodesClone.setIcon(resourceMap.getIcon("jButtonNodesClone.icon"));
        this.jButtonNodesClone.setText(bundle.getString("jButtonNodesClone.text"));
        this.jButtonNodesClone.setToolTipText(bundle.getString("jButtonNodesClone.toolTipText"));
        this.jButtonNodesClone.setName("jButtonNodesClone");
        this.jButtonNodesClone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorPal2View.this.actionPerformed_Button_NodesClone(evt);
            }
        });
        this.jButtonNodesLoad.setIcon(resourceMap.getIcon("jButtonNodesLoad.icon"));
        this.jButtonNodesLoad.setText(bundle.getString("jButtonNodesLoad.text"));
        this.jButtonNodesLoad.setToolTipText(bundle.getString("jButtonNodesLoad.toolTipText"));
        this.jButtonNodesLoad.setName("jButtonNodesLoad");
        this.jButtonNodesLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorPal2View.this.actionPerformed_Button_NodesLoad(evt);
            }
        });
        this.jButtonNodesSave.setIcon(resourceMap.getIcon("jButtonNodesSave.icon"));
        this.jButtonNodesSave.setText(bundle.getString("jButtonNodesSave.text"));
        this.jButtonNodesSave.setToolTipText(bundle.getString("jButtonNodesSave.toolTipText"));
        this.jButtonNodesSave.setName("jButtonNodesSave");
        this.jButtonNodesSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorPal2View.this.actionPerformed_Button_NodesSave(evt);
            }
        });
        this.jButtonNodesClear.setIcon(resourceMap.getIcon("jButtonNodesClear.icon"));
        this.jButtonNodesClear.setText(bundle.getString("jButtonNodesClear.text"));
        this.jButtonNodesClear.setToolTipText(bundle.getString("jButtonNodesClear.toolTipText"));
        this.jButtonNodesClear.setName("jButtonNodesClear");
        this.jButtonNodesClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorPal2View.this.actionPerformed_Button_NodesClear(evt);
            }
        });
        this.jButtonNodesFlip.setIcon(resourceMap.getIcon("jButtonNodesFlip.icon"));
        this.jButtonNodesFlip.setText(bundle.getString("jButtonNodesFlip.text"));
        this.jButtonNodesFlip.setToolTipText(bundle.getString("jButtonNodesFlip.toolTipText"));
        this.jButtonNodesFlip.setName("jButtonNodesFlip");
        this.jButtonNodesFlip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorPal2View.this.actionPerformed_Button_NodesFlip(evt);
            }
        });
        this.jButtonNodesNew.setIcon(resourceMap.getIcon("jButtonNodesNew.icon"));
        this.jButtonNodesNew.setText(bundle.getString("jButtonNodesNew.text"));
        this.jButtonNodesNew.setToolTipText(bundle.getString("jButtonNodesNew.toolTipText"));
        this.jButtonNodesNew.setName("jButtonNodesNew");
        this.jButtonNodesNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorPal2View.this.actionPerformed_Button_NodesNew(evt);
            }
        });
        GroupLayout jPanelNodesLayout = new GroupLayout(this.jPanelNodes);
        this.jPanelNodes.setLayout(jPanelNodesLayout);
        jPanelNodesLayout.setHorizontalGroup(jPanelNodesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelNodesLayout.createSequentialGroup().addContainerGap().addGroup(jPanelNodesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelNodesLayout.createSequentialGroup().addComponent(this.jScrollPaneNodes, -1, 275, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelNodesLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanelNodesLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButtonNodesLast, 0, 0, Short.MAX_VALUE).addComponent(this.jButtonNodesDown, 0, 0, Short.MAX_VALUE).addComponent(this.jButtonNodesUp, 0, 0, Short.MAX_VALUE).addComponent(this.jButtonNodesFirst, -2, 31, Short.MAX_VALUE)).addComponent(this.jButtonNodesFlip, 0, 0, Short.MAX_VALUE).addGroup(jPanelNodesLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButtonNodesClear, 0, 0, Short.MAX_VALUE).addComponent(this.jButtonNodesSave, 0, 0, Short.MAX_VALUE).addComponent(this.jButtonNodesLoad, 0, 0, Short.MAX_VALUE).addComponent(this.jButtonNodesNew, 0, 0, Short.MAX_VALUE).addComponent(this.jButtonNodesClone, 0, 0, Short.MAX_VALUE).addComponent(this.jButtonNodesDelete, -2, 0, -2)))).addComponent(this.jPanelProperties, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanelNodesLayout.linkSize(0, this.jButtonNodesClear, this.jButtonNodesClone, this.jButtonNodesDelete, this.jButtonNodesDown, this.jButtonNodesFirst, this.jButtonNodesFlip, this.jButtonNodesLast, this.jButtonNodesLoad, this.jButtonNodesNew, this.jButtonNodesSave, this.jButtonNodesUp);
        jPanelNodesLayout.setVerticalGroup(jPanelNodesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelNodesLayout.createSequentialGroup().addContainerGap().addGroup(jPanelNodesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelNodesLayout.createSequentialGroup().addComponent(this.jButtonNodesFirst).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonNodesUp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonNodesDown).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonNodesLast).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonNodesFlip).addGap(18, 18, 18).addComponent(this.jButtonNodesDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonNodesClone).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonNodesNew).addGap(18, 18, 18).addComponent(this.jButtonNodesLoad).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonNodesSave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonNodesClear)).addComponent(this.jScrollPaneNodes, -1, 450, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanelProperties, -2, -1, -2).addContainerGap()));
        jPanelNodesLayout.linkSize(1, this.jButtonNodesClear, this.jButtonNodesClone, this.jButtonNodesDelete, this.jButtonNodesDown, this.jButtonNodesFirst, this.jButtonNodesFlip, this.jButtonNodesLast, this.jButtonNodesLoad, this.jButtonNodesNew, this.jButtonNodesSave, this.jButtonNodesUp);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanelColors, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanelNodes, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanelNodes, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelColors, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void actionPerformed_Button_NodesNew(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonNodesNew();
        }
    }

    private void actionPerformed_Button_Color(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonColor();
        }
    }

    private void stateChanged_Spinner_Steps(ChangeEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleSpinnerSteps();
        }
    }

    private void actionPerformed_Button_NodesClear(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonNodesClear();
        }
    }

    private void actionPerformed_Button_NodesDelete(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonNodesDelete();
        }
    }

    private void actionPerformed_Button_NodesClone(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonNodesClone();
        }
    }

    private void actionPerformed_Button_NodesFirst(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonNodesFirst();
        }
    }

    private void actionPerformed_Button_NodesLast(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonNodesLast();
        }
    }

    private void actionPerformed_Button_NodesUp(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonNodesUp();
        }
    }

    private void actionPerformed_Button_NodesDown(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonNodesDown();
        }
    }

    private void actionPerformed_Button_NodesFlip(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonNodesFlip();
        }
    }

    private void actionPerformed_Button_NodesLoad(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonNodesLoad();
        }
    }

    private void actionPerformed_Button_NodesSave(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonNodesSave();
        }
    }

    private void actionPerformed_Button_Clipboard(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonCopyToClipboard();
        }
    }

    public JList getColorList() {
        return this.jListColors;
    }

    public JList getNodeList() {
        return this.jListNodes;
    }

    private int getTotalAmountOfColors() {
        DefaultListModel lc_tListModel = (DefaultListModel)this.jListNodes.getModel();
        int lc_iSize = lc_tListModel.getSize();
        int lc_iLast = lc_iSize - 1;
        int lc_iTotal = lc_iSize;
        int lc_iI = 0;
        ColorPal2ColorRecord lc_tNodeValue = null;
        for (lc_iI = 0; lc_iI < lc_iSize; ++lc_iI) {
            lc_tNodeValue = (ColorPal2ColorRecord)lc_tListModel.elementAt(lc_iI);
            if (null == lc_tNodeValue || lc_iI == lc_iLast) continue;
            lc_iTotal += lc_tNodeValue.getSteps() - 1;
        }
        return lc_iTotal;
    }

    public void computeColors() {
        DefaultListModel lc_tColorListModel = (DefaultListModel)this.jListColors.getModel();
        DefaultListModel lc_tNodeListModel = (DefaultListModel)this.jListNodes.getModel();
        ColorPal2ColorRecord lc_tNodeValueFrom = null;
        ColorPal2ColorRecord lc_tNodeValueTo = null;
        ColorPal2ColorRecord[] lc_tColors = null;
        Color lc_tColorFrom = null;
        Color lc_tColorTo = null;
        Color lc_tColorNew = null;
        int lc_iSize = lc_tNodeListModel.getSize();
        int lc_iLast = lc_iSize - 1;
        int lc_iTotal = this.getTotalAmountOfColors();
        int lc_iI = 0;
        int lc_iJ = 0;
        int lc_iColorCount = 0;
        int lc_iSteps = 0;
        float lc_fR = 0.0f;
        float lc_fG = 0.0f;
        float lc_fB = 0.0f;
        float lc_fdR = 0.0f;
        float lc_fdG = 0.0f;
        float lc_fdB = 0.0f;
        if (0 < lc_iSize && null != (lc_tColors = new ColorPal2ColorRecord[lc_iTotal])) {
            lc_tColorListModel.clear();
            for (lc_iI = 0; lc_iI < lc_iSize; ++lc_iI) {
                lc_tNodeValueFrom = (ColorPal2ColorRecord)lc_tNodeListModel.elementAt(lc_iI);
                if (null == lc_tNodeValueFrom) continue;
                lc_tColorFrom = lc_tNodeValueFrom.getColor();
                lc_iSteps = lc_tNodeValueFrom.getSteps();
                lc_fR = lc_tColorFrom.getRed();
                lc_fG = lc_tColorFrom.getGreen();
                lc_fB = lc_tColorFrom.getBlue();
                lc_tColors[lc_iColorCount++] = new ColorPal2ColorRecord(lc_tColorFrom, 1);
                if (lc_iI >= lc_iLast || null == (lc_tNodeValueTo = (ColorPal2ColorRecord)lc_tNodeListModel.elementAt(lc_iI + 1))) continue;
                lc_tColorTo = lc_tNodeValueTo.getColor();
                lc_fdR = ((float)lc_tColorTo.getRed() - lc_fR) / (float)lc_iSteps;
                lc_fdG = ((float)lc_tColorTo.getGreen() - lc_fG) / (float)lc_iSteps;
                lc_fdB = ((float)lc_tColorTo.getBlue() - lc_fB) / (float)lc_iSteps;
                for (lc_iJ = 0; lc_iJ < lc_iSteps - 1; ++lc_iJ) {
                    lc_tColorNew = new Color((int)(lc_fR += lc_fdR), (int)(lc_fG += lc_fdG), (int)(lc_fB += lc_fdB));
                    if (null == lc_tColorNew) continue;
                    lc_tColors[lc_iColorCount++] = new ColorPal2ColorRecord(lc_tColorNew, 1);
                }
            }
            for (lc_iI = 0; lc_iI < lc_iColorCount; ++lc_iI) {
                lc_tColorListModel.addElement(lc_tColors[lc_iI]);
            }
        }
    }

    public void exportColorsToClipboard() {
        DefaultListModel lc_tColorListModel = (DefaultListModel)this.jListColors.getModel();
        StringBuffer lc_tOutput = new StringBuffer();
        StringSelection lc_tStringSelection = null;
        ColorPal2ColorRecord lc_tRecord = null;
        String lc_sColorString = null;
        int lc_iLastSep = 0;
        int lc_iLen = 0;
        int lc_iI = 0;
        if (null != lc_tOutput && 0 < (lc_iLen = lc_tColorListModel.getSize())) {
            lc_iLastSep = lc_iLen - 1;
            for (lc_iI = 0; lc_iI < lc_iLen; ++lc_iI) {
                lc_tRecord = (ColorPal2ColorRecord)lc_tColorListModel.elementAt(lc_iI);
                if (null == lc_tRecord || null == lc_tRecord.getColor() || null == (lc_sColorString = lc_tRecord.getColorString())) continue;
                lc_tOutput.append(lc_sColorString.length() > 6 ? lc_sColorString.substring(2) : lc_sColorString);
                if (lc_iI == lc_iLastSep) continue;
                lc_tOutput.append(",");
            }
            lc_tStringSelection = new StringSelection(lc_tOutput.toString());
            if (null != lc_tStringSelection) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(lc_tStringSelection, null);
            }
        }
    }

    private String getLocalizedString(String pa_sKey) {
        return null != this.m_tLocalizedMessages ? this.m_tLocalizedMessages.getString(pa_sKey) : "";
    }

    @Override
    public void mouseClicked(MouseEvent pa_tEvent) {
        int lc_iIndex = -1;
        if (null != pa_tEvent && pa_tEvent.getSource() == this.jListNodes && -1 != (lc_iIndex = this.jListNodes.locationToIndex(pa_tEvent.getPoint())) && lc_iIndex < this.jListNodes.getModel().getSize() && 2 == pa_tEvent.getClickCount() && null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonColor();
        }
    }

    @Override
    public void mouseEntered(MouseEvent pa_tEvent) {
    }

    @Override
    public void mouseExited(MouseEvent pa_tEvent) {
    }

    @Override
    public void mousePressed(MouseEvent pa_tEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent pa_tEvent) {
    }
}

