/*
 * ColorPal2App.java
 * 
 */
package colorpal2;


/**
 * Imports
 * 
 */
import java.awt.Color;
import org.jdesktop.application.Application;
import org.jdesktop.application.SingleFrameApplication;

import java.awt.event.WindowListener;
import java.awt.event.WindowEvent   ;
import javax.swing.JFrame           ;
import javax.swing.JList            ;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.ListSelectionEvent   ;



/**
 * The main class of the application.
 * 
 * @author Ulf Wagemann
 */
public class ColorPal2App extends     SingleFrameApplication 
                          implements  ColorPal2GuiConnector,
                                      WindowListener       ,
                                      ListSelectionListener 
{
 private static ColorPal2View m_tView;
    
    
 
 /**
  * At startup create and show the main frame of the application.
   * 
  */
 @Override protected void startup() 
 {
  if (null != (m_tView = new ColorPal2View((ColorPal2GuiConnector) this, (WindowListener) this, (ListSelectionListener) this)))
  {
   show(m_tView);
   m_tView.checkButtons();
  }
 }

    
    
 /**
  * This method is to initialize the specified window by injecting resources.
  * Windows shown in our application come fully initialized from the GUI
  * builder, so this additional configuration is not needed.
  * 
  */
 @Override protected void configureWindow(java.awt.Window root) 
 {}

    
    
 /**
  * A convenient static getter for the application instance.
  * @return the instance of ColorPal2App
  */
 public static ColorPal2App getApplication() 
 {
  return Application.getInstance(ColorPal2App.class);
 }


 
 /**
  * Main method launching the application.
  * 
  */
  public static void main(String[] args) 
  {
   launch(ColorPal2App.class, args);
  }
 
 

 
 /**
  * WindowListener.windowClosing()
  * 
  * @param pa_tEvent  Event
  */ 
  public void windowClosing(WindowEvent pa_tEvent) 
  {
   Object lc_tWindowObject = null;
  
   if (null != (lc_tWindowObject = pa_tEvent.getSource()))
   {
    if (lc_tWindowObject instanceof JFrame)
    {
     if ((JFrame) lc_tWindowObject == m_tView)   
     {
      m_tView.saveSettings(null);
      m_tView.dispose();
      System.exit(1);
     }
    }
   }
  }

 
 
 /**
  * WindowListener.windowClosed()
  * 
  * @param pa_tEvent  Event
  */ 
  public void windowClosed(WindowEvent pa_tEvent) 
  {}

 
 
 /**
  * WindowListener.windowOpened()
  *
  * As soon as the main window is open, do all the intialization stuff
  *
  * @param pa_tEvent  Event
  */ 
 public void windowOpened(WindowEvent pa_tEvent) 
 {
  m_tView.checkButtons();
 }



 /**
  * WindowListener.windowIconified()
  * 
  * @param pa_tEvent  Event
  */ 
 public void windowIconified(WindowEvent pa_tEvent) 
 {}



 /**
  * WindowListener.windowDeiconified()
  * 
  * @param pa_tEvent  Event
  */ 
 public void windowDeiconified(WindowEvent pa_tEvent) 
 {}



 /**
  * WindowListener.windowActivated()
  * 
  * @param pa_tEvent  Event
  */ 
 public void windowActivated(WindowEvent pa_tEvent) 
 {}



 /**
  * WindowListener.windowDeactivated()
  * 
  * @param pa_tEvent  Event
  */ 
 public void windowDeactivated(WindowEvent pa_tEvent) 
 {}



 /**
  * Handles changing the node selection
  * 
  * @param e 
  */
 public void valueChanged(ListSelectionEvent pa_tEvent) 
 {
  if (null != pa_tEvent && null != m_tView)
  {
   if (false == pa_tEvent.getValueIsAdjusting())
   {
    m_tView.updateCurrentProperties();
    m_tView.checkButtons();
   }
  }
 }

 
 /**
  * Handles clicking the new button besides the color node list
  * 
  */
 public void handleButtonNodesNew()
 {
  if (null != m_tView)
  {
   m_tView.addNode(Color.red, 5); 
   m_tView.checkButtons();
  }
 }

 
 /**
  * Handles clicking the new button besides the color node list
  * 
  */
 public void handleButtonColor()
 {
  if (null != m_tView)
  {
   m_tView.changeCurrentColor(); 
   m_tView.applyProperties();   
   m_tView.checkButtons();
  }
 }


 
 /**
  * Handles changing the steps spinner
  * 
  */
 public void handleSpinnerSteps()
 {
  if (null != m_tView)
  {
   m_tView.applyProperties();
   m_tView.checkButtons();   
  }
 }
 
 
 
 
 /**
  * Handles clicking the clear button besides the color node list
  * 
  */ 
 public void handleButtonNodesClear()
 {
  if (null != m_tView)
  {
   m_tView.clearNodes();
   m_tView.checkButtons(); 
  }
 }
 
 
 
 /**
  * Handles clicking the delete button besides the color node list
  * 
  */ 
 public void handleButtonNodesDelete()
 {
  if (null != m_tView)
  {
   m_tView.deleteNode();
   m_tView.checkButtons(); 
  }
 }
 
 
 
 /**
  * Handles clicking the clone button besides the color node list
  * 
  */ 
 public void handleButtonNodesClone()
 {
  if (null != m_tView)
  {
   m_tView.cloneNode(); 
   m_tView.checkButtons(); 
  }
 }
 
 
 
 /**
  * Handles clicking the first button besides the color node list
  * 
  */ 
 public void handleButtonNodesFirst()
 {
  if (null != m_tView)
  {
   m_tView.moveNodeToTop(); 
   m_tView.checkButtons();    
  }
 }
 
 
 
 /**
  * Handles clicking the first button besides the color node list
  * 
  */ 
 public void handleButtonNodesLast()
 {
  if (null != m_tView)
  {
   m_tView.moveNodeToBottom(); 
   m_tView.checkButtons();    
  }
 }
 
 
 
 /**
  * Handles clicking the up button besides the color node list
  * 
  */ 
 public void handleButtonNodesUp()
 {
  if (null != m_tView)
  {
   m_tView.moveNodeUp(); 
   m_tView.checkButtons();    
  }
 }
 
 
 
 /**
  * Handles clicking the down button besides the color node list
  * 
  */ 
 public void handleButtonNodesDown()
 {
  if (null != m_tView)
  {
   m_tView.moveNodeDown(); 
   m_tView.checkButtons();    
  }
 }
 
 
 
 /**
  * Handles clicking the flip button besides the color node list
  * 
  */ 
 public void handleButtonNodesFlip()
 {
  if (null != m_tView)
  {
   m_tView.flipNodes(); 
   m_tView.checkButtons();    
  }
 }
 
 
 
 /**
  * Handles clicking the load button besides the color node list
  * 
  */ 
 public void handleButtonNodesSave()
 {
  if (null != m_tView) 
  {
   m_tView.saveNodesFile(); 
  }
 }
 
 
 
 /**
  * Handles clicking the save button besides the color node list
  * 
  */ 
 public void handleButtonNodesLoad()
 {
  if (null != m_tView) 
  {
   m_tView.loadNodesFile(); 
   m_tView.checkButtons(); 
  }   
 }
 

 
 /**
  * Handles clicking the clipboard button besides the color node list
  * 
  */ 
 public void handleButtonCopyToClipboard()
 {
  if (null != m_tView) 
  {
   m_tView.exportColorsToClipboard(); 
  }      
 }
  
  
} // eoc
