/*
 * ColorPal2
 * 
 */
package colorpal2;



/**
 * Imports
 * 
 */
import java.awt.Graphics           ;
import java.awt.Color              ;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon    ;




/**
 * Stores color information
 * 
 * @author Ulf Wagemann
 *
 */
public class ColorPal2ColorRecord 
{
 private Color     m_tColor;
 private ImageIcon m_tImage;
 private int       m_iSteps;

 
 /**
  * Constructor. String format: hexstring rrggbb
  * 
  * @param pa_sColor   hexstring rrggbb
  */
 public ColorPal2ColorRecord(String pa_sColor, int pa_iSteps)
 {
  String lc_sTemp = "";
  
  if (null != pa_sColor)
  {
   if (false == pa_sColor.isEmpty())
   {
    if (false == pa_sColor.startsWith("#")) lc_sTemp = "#";
    lc_sTemp += pa_sColor;
    
    m_iSteps = pa_iSteps;
    m_tColor = Color.decode(lc_sTemp); 
   }
  }
  createImage();
 }



 /**
  * Constructor. String format: hexstring rrggbb
  * 
  * @param pa_sColor   hexstring rrggbb
  */
 public ColorPal2ColorRecord(Color pa_tColor, int pa_iSteps)
 {
  if (null != pa_tColor)
  {
   m_iSteps = pa_iSteps;
   m_tColor = new Color(pa_tColor.getRGB()); 
  }
  createImage();
 }
 
 
 
 /**
  * Constructor. String format: hexstring rrggbb
  * 
  * @param pa_sColor   hexstring rrggbb
  */
 public ColorPal2ColorRecord(ColorPal2ColorRecord pa_tObject)
 {
  if (null != pa_tObject && this != pa_tObject)
  {
   m_iSteps = pa_tObject.getSteps();
   m_tColor = new Color(pa_tObject.getColor().getRGB()); 
  }
  createImage();
 }
 
 
 
 /**
  * Checks whether this record equal the given one
  * 
  * @param pa_tRecord    Record to compare to
  */
 public boolean isEqual(ColorPal2ColorRecord pa_tRecord)
 {
  if (null == pa_tRecord           ) return false;
  if (null == pa_tRecord.getColor()) return false;
  
  return (m_tColor.getRGB() == pa_tRecord.getColor().getRGB() && m_iSteps  == pa_tRecord.getSteps());
 }
 
 
 
 /**
  * Creates an image icon using the given colors
  * 
  */
 protected void createImage()
 {
  Graphics      lc_tGraphics = null;
  BufferedImage lc_tImage    = null;
  
  if (null != (lc_tImage = new BufferedImage(100, 20, BufferedImage.TYPE_INT_RGB)))
  {
   if (null != (lc_tGraphics = lc_tImage.getGraphics()))
   {
    //
    // draw background
    //
    lc_tGraphics.setColor(Color.black);
    lc_tGraphics.drawRect(0, 0, 120, 20);

    lc_tGraphics.setColor(m_tColor);
    lc_tGraphics.fillRect(1, 1, 119, 19);
    
     m_tImage = new ImageIcon(lc_tImage);
   }
  }
 }


 
 /**
  * Returns the image icon
  * 
  * @return  ImageIcon
  */
 public ImageIcon getImage() {return m_tImage;}
 
 
 
 /**
  * Returns the color string
  * 
  * @return   color string
  */
 public String getColorString() 
 {
  String lc_sColorString = (null == m_tColor ? null : Integer.toHexString(m_tColor.getRGB()));
  
  if (null != lc_sColorString)
  {
   return (lc_sColorString.length() > 6 ? lc_sColorString.substring(2) : lc_sColorString); 
   
  }
  return null;
 }
 
 

 /**
  * Returns the color
  * 
  * @return    Color
  */
 public Color getColor() {return m_tColor;}
 
 
 
 /**
  * Returns the amount of steps
  * 
  * @return   Amount of steps
  */
 public int getSteps() {return m_iSteps;}
 
 

 /**
  * Returns the amount of steps
  * 
  * @return   Amount of steps
  */
 public void setSteps(int pa_iSteps) 
 {
  if (0 < pa_iSteps && Integer.MAX_VALUE > pa_iSteps)
  {
   m_iSteps = pa_iSteps;
  }
 }
 
 
 
 /**
  * toString() method
  * 
  * @return  Color hex string with a leading #
  */
 @Override
 public String toString() {return getColorString();}
 
 
 
} // eoc
