/*
 * ColorPal2
 * 
 */
package colorpal2;



/**
 * Imports
 * 
 */
import java.awt.Component            ;
import javax.swing.JList             ;
import javax.swing.JLabel            ;
import javax.swing.border.Border     ;
import javax.swing.border.EmptyBorder;
import javax.swing.ListCellRenderer  ;
import javax.swing.SwingConstants    ;


/**
 * Custom ListCellRenderer
 * 
 * @author Ulf Wagemann
 */
public class ColorPal2ListCellRenderer extends JLabel
                                       implements ListCellRenderer 
{
 protected static  Border m_tNoFocusBorder;
 protected static  Border m_tFocusBorder  ; 
  
 
 /**
  * Constructor
  * 
  */
 public ColorPal2ListCellRenderer()
 { 
  super();
  
  m_tNoFocusBorder = new EmptyBorder(5,5,5,5);
  m_tFocusBorder   = new EmptyBorder(5,5,5,5);
  setOpaque(true);
  setBorder(m_tNoFocusBorder);
 } 
 
 
 @Override
 public Component getListCellRendererComponent(JList   pa_tList        ,
                                               Object  pa_tValue       ,
                                               int     pa_iIndex       ,
                                               boolean pa_bIsSelected  ,
                                               boolean pa_bCellHasFocus) 
 {
  ColorPal2ColorRecord lc_tRecord = null;
  
  if (null != pa_tList)
  {
   setBackground(true == pa_bIsSelected ? pa_tList.getSelectionBackground() : pa_tList.getBackground());
   setForeground(true == pa_bIsSelected ? pa_tList.getSelectionForeground() : pa_tList.getForeground());
   setFont(pa_tList.getFont());
  
   setBorder(true == pa_bCellHasFocus ? m_tFocusBorder : m_tNoFocusBorder); // UIManager.getBorder("List.focusCellHighlightBorder")
   setHorizontalTextPosition(SwingConstants.RIGHT );
   setVerticalTextPosition  (SwingConstants.CENTER);
   setIconTextGap(10);
   
   if (null != pa_tValue)
   {
    if (pa_tValue instanceof ColorPal2ColorRecord)
    { 
     if (null != (lc_tRecord = (ColorPal2ColorRecord) pa_tValue))
     {
      setText(lc_tRecord.getColorString());  
      setIcon(lc_tRecord.getImage());
     }
    }
    else
    {
     setText(pa_tValue.toString());
    }
   }
  }
  return this;
 }
 
 
}