/**
 * ColorPal2
 * 
 */
package colorpal2;



/**
 * Imports
 * 
 */
import java.io.File              ;
import java.io.FileInputStream   ;
import java.io.FileOutputStream  ;
import java.io.IOException       ;
import java.util.Properties      ;



/**
 * Stores the program's settings 
 * 
 * @author Ulf Wagemann
 */
public class ColorPal2Settings 
{
 private Properties m_tProperties;  
 private boolean    m_bValid     ; 

 protected final static String COLORPAL2_SETTINGS_FILENAME   = "ColorPal2.prs";
 protected final static String COLORPAL2_SETTINGS_LOADPATH   = "LoadPath"     ;
 protected final static String COLORPAL2_SETTINGS_SAVEPATH   = "SavePath"     ;
 protected final static String COLORPAL2_SETTINGS_COLORNODES = "ColorNodes"   ;
 protected final static String COLORPAL2_SETTINGS_SEPARATOR  = ","            ;
 
 
 /**
  * Constructor. Loads properties file
  * 
  */
 public ColorPal2Settings(boolean pa_bLoad)
 {
  m_tProperties = new Properties();
  m_bValid      = false;
  
  if (true == pa_bLoad) load(null);
 }  
 
 

 /**
  * Returns whether the settings are valid (= loaded)
  * 
  * @return  true if settings are valid, false otherwise
  */
 public boolean isValid() {return m_bValid;}
 
 
 
 /**
  * Loads the properties file as defined in GridLifeConstants
  * 
  * @param pa_sPath  properties file path
  */
 public void load(String pa_sPath)
 {
  File             lc_tPropertiesFile = new File(null != pa_sPath ? pa_sPath : COLORPAL2_SETTINGS_FILENAME);
  FileInputStream  lc_tInputStream    = null;       
        
  if (null != lc_tPropertiesFile && null != m_tProperties)
  {
   if (true == lc_tPropertiesFile.exists()) 
   {
    try
    {
     if (null != (lc_tInputStream = new FileInputStream(lc_tPropertiesFile)))
     {
      m_tProperties.load(lc_tInputStream);    
      lc_tInputStream.close();
      m_bValid = (false == m_tProperties.isEmpty());
     }
    }
    catch (IOException lc_tExcpetion)
    {}
   }
  }
 } 
 
 
 
 
 /**
  * This routine saves the settings for each of the stored JInternalFrames in the properties file
  * 
  * @param pa_sPath  properties file path
  * @param pa_sComment  comment
  */
 public void save(String pa_sPath, String pa_sComment)
 {
  File              lc_tPropertiesFile = new File(null != pa_sPath ? pa_sPath : COLORPAL2_SETTINGS_FILENAME);
  FileOutputStream  lc_tOutputStream   = null;       
        
  if (null != lc_tPropertiesFile && null != m_tProperties)
  {
   try
   {
    if (false == lc_tPropertiesFile.exists()) 
    {
     lc_tPropertiesFile.createNewFile();
    }
    
    if (true == lc_tPropertiesFile.exists()) 
    {
     if (null != (lc_tOutputStream = new FileOutputStream(lc_tPropertiesFile)))
     {
      m_tProperties.store(lc_tOutputStream, pa_sComment);  
      lc_tOutputStream.close();
     }
    }
   }
   catch (IOException lc_tException)
   {}
  }   
 } 
 
 
 
 /**
  * Returns a property value as string
  * 
  * @param pa_sKey   Property key
  * @return          null in case of error or undefined, string otherwise
  */
 private String getPropertyValue(String pa_sKey)
 {
  Object lc_tObject = null;
  String lc_sResult = null;
  
  if (null != m_tProperties & null != pa_sKey)  
  {
   if (null != (lc_tObject = m_tProperties.get(pa_sKey)))
   {
    if (lc_tObject instanceof String) 
    {
     lc_sResult = lc_tObject.toString(); 
    }
   }
  }
  return lc_sResult;   
 }
 
 
 
 /**
  * Returns the value of the LoadPath property
  * 
  * @return   null in case of error or undefined, otherwise path
  */
 public String getLoadPath()
 {
  return getPropertyValue(COLORPAL2_SETTINGS_LOADPATH); 
 }

 
 
 /**
  * Sets the LoadPath property
  * 
  * @param pa_sPath  new value
  */
 public void setLoadPath(String pa_sPath)
 {
  if (null != m_tProperties) m_tProperties.put(COLORPAL2_SETTINGS_LOADPATH, pa_sPath); 
 }


 
 /**
  * Returns the value of the SavePath property
  * 
  * @return   null in case of error or undefined, otherwise path
  */
 public String getSavePath()
 {
  return getPropertyValue(COLORPAL2_SETTINGS_SAVEPATH); 
 }

 
 
 /**
  * Sets the SavePath property
  * 
  * @param pa_sPath  new value
  */
 public void setSavePath(String pa_sPath)
 {
  if (null != m_tProperties) m_tProperties.put(COLORPAL2_SETTINGS_SAVEPATH, pa_sPath); 
 }
 
 
 
 /**
  * Returns the value of the ColorNodes property
  * 
  * @return   null in case of error or undefined, otherwise path
  */
 public String getColorNodes()
 {
  return getPropertyValue(COLORPAL2_SETTINGS_COLORNODES); 
 }

 
 
 /**
  * Sets the ColorNodes property
  * 
  * @param pa_sValue  new value
  */
 public void setColorNodes(String pa_sValue)
 {
  if (null != m_tProperties) m_tProperties.put(COLORPAL2_SETTINGS_COLORNODES, pa_sValue); 
 }
 
}
