/**
 * ColorPal2
 * 
 */
package colorpal2;

import java.io.File             ;
import java.util.StringTokenizer;

import javax.swing.JFileChooser ;
import javax.swing.JOptionPane  ;

import java.awt.Color                       ;
import java.awt.Toolkit                     ;
import java.awt.datatransfer.StringSelection;



/**
 *
 * @author Ulf Wagemann
 */
public class ColorPal2View extends javax.swing.JFrame implements java.awt.event.MouseListener 
{
 private ColorPal2GuiConnector    m_tGuiConnector     ;
 private ColorPal2Settings        m_tSettings         ;
 private java.awt.Color           m_tDefaultBackground;  
 private java.util.ResourceBundle m_tLocalizedMessages;
 private java.util.ResourceBundle  m_tResources;
 
 
 
  /**
  * Constructor
  * 
  * @param pa_tGuiConnector   GuiConnector object
  * @param pa_tListener       WindowListener
  */
  public ColorPal2View(ColorPal2GuiConnector pa_tGuiConnector, java.awt.event.WindowListener pa_tListener,
                       javax.swing.event.ListSelectionListener pa_tListSelectionListener) 
  { 
   m_tGuiConnector          = pa_tGuiConnector; 
   m_tSettings              = new ColorPal2Settings(true);
   m_tLocalizedMessages     = java.util.ResourceBundle.getBundle(ColorPal2Constants.CPA_MESSAGES);

   m_tResources = java.util.ResourceBundle.getBundle(ColorPal2Constants.CPA_FILE_VIEW_RESOURCES);
    
   //
   // work-arounds for following bugs/problems/crap:
   //
   // filechooser does ot provide setting the cancel button txt
   //
   // FUGLY SHIT!
   //
   if (null != m_tResources)
   {
    javax.swing.UIManager.put("FileChooser.cancelButtonText", m_tResources.getString(ColorPal2Constants.CPA_CHOOSER_CANCEL_TEXT));   
   } 
   
   initComponents();
   m_tDefaultBackground = jTextFieldColor.getBackground();
           
   jListColors.setCellRenderer(new ColorPal2ListCellRenderer());
   jListColors.setBackground(java.awt.Color.white);
   
   jListNodes.setCellRenderer(new ColorPal2ListCellRenderer());
   jListNodes.setBackground(java.awt.Color.white);
   
   jScrollPaneColors.setBackground(java.awt.Color.white);   
   jScrollPaneNodes.setBackground(java.awt.Color.white);   
   
   //
   // load properties and initialize ui according to ui
   //
   if (null != m_tSettings)
   {
    if (true == m_tSettings.isValid())
    {
     initBySettings(); 
    }
   }

   jListNodes.addMouseListener((java.awt.event.MouseListener) this);
   addWindowListener(pa_tListener);
   jListNodes.addListSelectionListener(pa_tListSelectionListener);
   
  }

  
  
  /**
   * Initializes the nodes color list  
   */
  private void initBySettings()
  {
   javax.swing.DefaultListModel lc_tListModel = (javax.swing.DefaultListModel) jListNodes.getModel() ;

   String               lc_sColor      = null;
   String               lc_sColorNodes = m_tSettings.getColorNodes(); 
   StringTokenizer      lc_tTokenizer  = new StringTokenizer(lc_sColorNodes, ColorPal2Settings.COLORPAL2_SETTINGS_SEPARATOR);
   ColorPal2ColorRecord lc_tNewValue   = null;
   
   int lc_iLen   = 0;
   int lc_iI     = 0;
   int lc_iSteps = 0;
   int lc_iCount = 0;
   
   if (null != lc_sColorNodes && null != lc_tTokenizer)
   {
    if (0 < (lc_iLen = Integer.valueOf(lc_tTokenizer.nextToken())))
    {
     lc_tListModel.clear();
     
     for (lc_iI = 0; lc_iI < lc_iLen; lc_iI++)
     {
      if (null != (lc_sColor = lc_tTokenizer.nextToken()))
      {
       lc_iSteps =  Integer.valueOf(lc_tTokenizer.nextToken());
       if (null != (lc_tNewValue = new ColorPal2ColorRecord(lc_sColor, lc_iSteps)))
       {
        lc_tListModel.addElement(lc_tNewValue); 
        lc_iCount++;
       }
      }
     }
    }
    
    if (0 < lc_iCount)
    {
     jListNodes.setSelectedIndex(0);
     updateCurrentProperties();
     computeColors();
    }
   }
  }
  
  
  


 /**
  * Checks whether a file already exists
  * 
  * @param pa_sFileName    Filename
  * @return  true, if the file exists, false otherwise
  */
 private boolean existsFile(String pa_sFileName)
 {
  File    lc_tFile   = null ;
  
  if (null != (lc_tFile = new File(pa_sFileName)))
  {
   return (true == lc_tFile.exists()); 
  }
  return false;
 }
 
 
 
 /**
  * Saves a color nodes file
  * 
  */
 public void saveNodesFile()
 {
  boolean           lc_bSave        = true ;
  String            lc_sFileName    = null ;  
  String            lc_sSavePath    = (null != m_tSettings ? m_tSettings.getSavePath() : null);
  JFileChooser      lc_tFileChooser = (null != lc_sSavePath ? new JFileChooser(lc_sSavePath) : new JFileChooser());
  ColorPal2Settings lc_tSettings    = new ColorPal2Settings(false);
  
  Object[] lc_tDialogOptions = {getLocalizedString(ColorPal2Constants.CPA_DIALOG_OPTION_OK), getLocalizedString(ColorPal2Constants.CPA_DIALOG_OPTION_CANCEL)};

  if (null != lc_tFileChooser && null != lc_tSettings)
  {
   lc_tSettings.setColorNodes(getColorNodesString()); 

   lc_tFileChooser.setDialogTitle(getLocalizedString(ColorPal2Constants.CPA_DIALOG_TITLE_SAVE));
   lc_tFileChooser.setApproveButtonText(getLocalizedString(ColorPal2Constants.CPA_DIALOG_OPTION_SAVE));
   lc_tFileChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
   lc_tFileChooser.setAcceptAllFileFilterUsed(false);
   lc_tFileChooser.setMultiSelectionEnabled(false); 
   
   if (JFileChooser.APPROVE_OPTION == lc_tFileChooser.showOpenDialog(this))
   {
    if (null != (lc_sFileName = lc_tFileChooser.getSelectedFile().getAbsolutePath()))
    {
     if (true == existsFile(lc_sFileName))
     {
      lc_bSave = (0 == JOptionPane.showOptionDialog(this, getLocalizedString(ColorPal2Constants.CPA_DIALOG_MESSAGE_OVERWRITE) + " \"" + lc_sFileName + "\" ? <br />", 
                                                    getLocalizedString(ColorPal2Constants.CPA_DIALOG_TITLE_WARNING), JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE, null, 
                                                    lc_tDialogOptions, lc_tDialogOptions[0]));
     }      
     if (true == lc_bSave)
     {    
      lc_tSettings.save(lc_sFileName, ColorPal2Constants.CPA_COMMENT_PALETTE); 
      if (null != m_tSettings) m_tSettings.setSavePath(lc_sFileName);
      JOptionPane.showMessageDialog(this, getLocalizedString(ColorPal2Constants.CPA_DIALOG_MESSAGE_SAVED) + " \"" + 
                                          lc_sFileName + "\"" + getLocalizedString(ColorPal2Constants.CPA_DIALOG_MESSAGE_SAVED2), 
                                          getLocalizedString(ColorPal2Constants.CPA_DIALOG_TITLE_INFORMATION), JOptionPane.INFORMATION_MESSAGE);
     }
    }
   }
  }
 }

 
 
 /**
  * Loads a color nodes file
  * 
  */ 
 public void loadNodesFile()
 {
  String            lc_sFileName    = null ;  
  String            lc_sLoadPath    = (null != m_tSettings ? m_tSettings.getLoadPath() : null);
  JFileChooser      lc_tFileChooser = (null != lc_sLoadPath ? new JFileChooser(lc_sLoadPath) : new JFileChooser());
  ColorPal2Settings lc_tSettings    = new ColorPal2Settings(false);
   
  if (null != lc_tFileChooser && null != lc_tSettings)
  {
   lc_tSettings.setColorNodes(getColorNodesString()); 

   lc_tFileChooser.setDialogTitle(getLocalizedString(ColorPal2Constants.CPA_DIALOG_TITLE_LOAD));
   lc_tFileChooser.setApproveButtonText(getLocalizedString(ColorPal2Constants.CPA_DIALOG_OPTION_LOAD));
   lc_tFileChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
   lc_tFileChooser.setAcceptAllFileFilterUsed(false);
   lc_tFileChooser.setMultiSelectionEnabled(false); 
   
   if (JFileChooser.APPROVE_OPTION == lc_tFileChooser.showOpenDialog(this))
   {
    if (null != (lc_sFileName = lc_tFileChooser.getSelectedFile().getAbsolutePath()))
    {
     if (true == existsFile(lc_sFileName))
     {
      lc_tSettings.load(lc_sFileName); 
      if (true == lc_tSettings.isValid())
      {
       if (null != m_tSettings) 
       {
        m_tSettings.setLoadPath(lc_sFileName);
        m_tSettings.setColorNodes(lc_tSettings.getColorNodes());
        initBySettings();
       }
      }
     }
    }
   }
  }
 }

 
 
  /**
   * Returns a color node string
   * 
   * @return color node string
   */
  private String getColorNodesString()
  {
   StringBuffer                 lc_tColorNodeString = new StringBuffer();
   javax.swing.DefaultListModel lc_tListModel = (javax.swing.DefaultListModel) jListNodes.getModel() ;

   Object               lc_tNodeObject = null;
   ColorPal2ColorRecord lc_tNodeValue  = null;
   
   int lc_iLen   = lc_tListModel.getSize();
   int lc_iI     = 0;
   
   //
   // update color nodes property
   //
   lc_tColorNodeString.append(lc_iLen); 
    
   if (0 < lc_iLen) 
   {
    for (lc_iI = 0; lc_iI < lc_iLen; lc_iI++)
    {
     if (null != (lc_tNodeObject = lc_tListModel.elementAt(lc_iI)))
     {
      if (null != (lc_tNodeValue = (ColorPal2ColorRecord) lc_tNodeObject))
      {
       lc_tColorNodeString.append(ColorPal2Settings.COLORPAL2_SETTINGS_SEPARATOR); 
       lc_tColorNodeString.append(lc_tNodeValue.getColorString());
       lc_tColorNodeString.append(ColorPal2Settings.COLORPAL2_SETTINGS_SEPARATOR); 
       lc_tColorNodeString.append(lc_tNodeValue.getSteps());
      }
     }
    }
   }
   return (null != lc_tColorNodeString ? lc_tColorNodeString.toString() : "");
  }
  
  
  
  /**
   * Saves the current settings to file
   * 
   * @param pa_sPath  file path
   */
  public void saveSettings(String pa_sPath)
  {
   if (null != m_tSettings)
   {
    m_tSettings.setColorNodes(getColorNodesString()); 
    m_tSettings.save(pa_sPath, ColorPal2Constants.CPA_COMMENT_SETTINGS); 
   }
  }
  
  
  
  /**
   * Returns the current property stepping
   * 
   * return   stepping
   */
  public int getSteps() {return ((Integer) jSpinnerStepping.getValue()).intValue();}

  
  
  /**
   * Sets the current stepping to the given value
   * 
   * @param pa_iValue    stepping
   */
  public void setSteps(int pa_iValue) {jSpinnerStepping.setValue(pa_iValue);}
  
  
  
  /**
   * Returns the current property color
   * 
   * @return  Property color
   */
  public java.awt.Color getColor() {return jTextFieldColor.getBackground();}
  
  
  
  /**
   * Returns the current property color
   * 
   * @return  Property color
   */
  public void setColor(java.awt.Color pa_tColor) {jTextFieldColor.setBackground(pa_tColor);}

  
  
  /**
   * Returns the currenr ptoperties as color record
   * 
   * @return color record
   */
  public ColorPal2ColorRecord getCurrentProperties()
  {
   return new ColorPal2ColorRecord(getColor(), getSteps()); 
  }
  
  
  
  /**
   * Updates the properties display according to the node selection
   * 
   */
  public void updateCurrentProperties()
  {
   javax.swing.DefaultListModel lc_tListModel = (javax.swing.DefaultListModel) jListNodes.getModel();

   boolean lc_bHasNodes         = (lc_tListModel.getSize()  > 0);
   boolean lc_bHasNodeSelection = (true == lc_bHasNodes  ? jListNodes.getSelectedIndex()  != -1 : false);
    
   Object               lc_tSelectionObject = null;
   ColorPal2ColorRecord lc_tSelectionValue  = null;
   
   if (true == lc_bHasNodeSelection)
   {
    if (null != (lc_tSelectionObject = jListNodes.getSelectedValue()))
    {
     if (lc_tSelectionObject instanceof ColorPal2ColorRecord) 
     {
      if (null != (lc_tSelectionValue = (ColorPal2ColorRecord) lc_tSelectionObject)) 
      {
       setColor(lc_tSelectionValue.getColor());
       setSteps(lc_tSelectionValue.getSteps());
      }
     }
    }
   }
  }
  
  
  
  /**
   * Adds a new node with the given values to the nodes list
   * 
   * @param pa_tColor new color
   * @param pa_iSteps steps to successor
   */
  public void addNode(java.awt.Color pa_tColor, int pa_iSteps)
  {
   javax.swing.DefaultListModel lc_tListModel = (javax.swing.DefaultListModel) jListNodes.getModel() ;

   int                  lc_iSelectionPos = jListNodes.getSelectedIndex();
   ColorPal2ColorRecord lc_tNewNode      = new ColorPal2ColorRecord(pa_tColor, pa_iSteps);
   
   if (-1 == lc_iSelectionPos) 
   {
    lc_tListModel.addElement(lc_tNewNode);
   }
   else
   {
    lc_tListModel.insertElementAt(lc_tNewNode, lc_iSelectionPos);    
   }
   jListNodes.setSelectedIndex(-1 == lc_iSelectionPos ? 0 : lc_iSelectionPos);
   
   updateCurrentProperties();
   computeColors();
  }
  
  
  
  /**
   * Brings up a color requester and 
   */
  public void changeCurrentColor()
  {
   java.awt.Color lc_tOldColor = getColor();
   java.awt.Color lc_tNewColor = javax.swing.JColorChooser.showDialog(this, getLocalizedString(ColorPal2Constants.CPA_DIALOG_TITLE_COLOR), getColor());
  
   if (lc_tNewColor != null && lc_tOldColor != null)
   {
    if (lc_tNewColor.getRGB() != lc_tOldColor.getRGB())
    {
     setColor(lc_tNewColor);
    }
   }   
  }
  

  
  

  /**
   * Applies the given properties to the current node selection
   * 
   */
  public void applyProperties()
  {
   javax.swing.DefaultListModel lc_tListModel = (javax.swing.DefaultListModel) jListNodes.getModel() ;

   int                  lc_iSelectionPos = jListNodes.getSelectedIndex();
   ColorPal2ColorRecord lc_tNewNode      = getCurrentProperties();
   
   if (-1 != lc_iSelectionPos) 
   {
    lc_tListModel.setElementAt(lc_tNewNode, lc_iSelectionPos);
    computeColors();
   }
  }

  
  
  /**
   * Empties the nodes list and resets the property display
   * 
   */
  public void clearNodes()
  {
   javax.swing.DefaultListModel lc_tNodeModel = (javax.swing.DefaultListModel) jListNodes.getModel()  ;
   javax.swing.DefaultListModel lc_tColorModel = (javax.swing.DefaultListModel) jListColors.getModel();

   lc_tNodeModel.clear();
   lc_tColorModel.clear();
   
   setColor(m_tDefaultBackground);
   setSteps(5);
  }
  
  
  
  /**
   * Deletes the currently selected node and , if possible, selects another one
   * 
   */
  public void deleteNode()
  {
   javax.swing.DefaultListModel lc_tListModel = (javax.swing.DefaultListModel) jListNodes.getModel() ;
   
   int lc_iNewSelectionPos = 0;
   int lc_iSelectionPos    = jListNodes.getSelectedIndex();
   int lc_iSize            = lc_tListModel.getSize();
   
   if (-1 != lc_iSelectionPos)
   {
    lc_tListModel.removeElementAt(lc_iSelectionPos);
    if (0 < (lc_iSize -1)) 
    {
     lc_iNewSelectionPos = lc_iSelectionPos-1;
     if (0 > lc_iNewSelectionPos) lc_iNewSelectionPos = 0;
     
     jListNodes.setSelectedIndex(lc_iNewSelectionPos);
    }
    else
    {
     setColor(m_tDefaultBackground);
     setSteps(5);   
    }
    updateCurrentProperties();    
    computeColors();
   }
  }
  

 
  /**
   * Inserts a clone of the currently selected node before its position, but does not select it
   * 
   */
  public void cloneNode()
  {
   javax.swing.DefaultListModel lc_tListModel = (javax.swing.DefaultListModel) jListNodes.getModel() ;
    
   int lc_iSelectionPos = jListNodes.getSelectedIndex();
   int lc_iInsertPos    = lc_iSelectionPos;
   
   Object               lc_tSelectionObject = null;
   ColorPal2ColorRecord lc_tSelectionValue  = null;
   ColorPal2ColorRecord lc_tCloneValue      = null;
   
   if (-1 != lc_iSelectionPos)
   {
    if (null != (lc_tSelectionObject = jListNodes.getSelectedValue()))
    {
     if (lc_tSelectionObject instanceof ColorPal2ColorRecord) 
     {
      if (null != (lc_tSelectionValue = (ColorPal2ColorRecord) lc_tSelectionObject)) 
      {
       if (null != (lc_tCloneValue = new ColorPal2ColorRecord(lc_tSelectionValue)))
       {
        lc_tListModel.insertElementAt(lc_tSelectionObject, lc_iInsertPos);
        updateCurrentProperties();    
        computeColors();
       }
      }
     }
    }
   }
  }
  
  
  
  /**
   * Moves the currently selected node to the given new index and updates the properties
   * 
   * @param pa_iToIndex    new node position
   */
  private void moveNode(int pa_iToIndex)
  {
   javax.swing.DefaultListModel lc_tListModel = (javax.swing.DefaultListModel) jListNodes.getModel() ;

   int lc_iSelectionPos = jListNodes.getSelectedIndex();

   Object               lc_tSelectionObject = null;
   ColorPal2ColorRecord lc_tSelectionValue  = null;
   ColorPal2ColorRecord lc_tCloneValue     = null;
           
   if (null != (lc_tSelectionObject = jListNodes.getSelectedValue()))
   {
    if (lc_tSelectionObject instanceof ColorPal2ColorRecord) 
    {
     if (null != (lc_tSelectionValue = (ColorPal2ColorRecord) lc_tSelectionObject)) 
     {
      if (null != (lc_tCloneValue = new ColorPal2ColorRecord(lc_tSelectionValue)))
      {
       lc_tListModel.removeElementAt(lc_iSelectionPos);
       lc_tListModel.insertElementAt(lc_tCloneValue, pa_iToIndex);
       jListNodes.setSelectedIndex(pa_iToIndex);
       updateCurrentProperties(); 
       computeColors();
      }
     }
    }
   }          
  }
  
  
  
  /**
   * Moves the currently selected node one position to the top, if possible
   * 
   */
  public void moveNodeToTop()
  {
   int lc_iSelectionPos = jListNodes.getSelectedIndex();

   if (0 < lc_iSelectionPos)
   {
    moveNode(0);
   }      
  }
  
  
  
  /**
   * Moves the currently selected node one position up, if possible
   * 
   */
  public void moveNodeUp()
  {
   int lc_iSelectionPos = jListNodes.getSelectedIndex();
   
   if (0 < lc_iSelectionPos)
   {
    moveNode(lc_iSelectionPos-1);
   }      
  }
  
  
  
  /**
   * Moves the currently selected node one position down, if possible
   * 
   */
  public void moveNodeDown()
  {
   javax.swing.DefaultListModel lc_tListModel = (javax.swing.DefaultListModel) jListNodes.getModel() ;
    
   int lc_iSelectionPos = jListNodes.getSelectedIndex();
   int lc_iSize         = lc_tListModel.getSize() -1;
   
   if (lc_iSize > lc_iSelectionPos)
   {
    moveNode(lc_iSelectionPos+1);
   }      
  }

  
  
  /**
   * Moves the currently selected node one position to the top, if possible
   * 
   */
  public void moveNodeToBottom()
  {
   javax.swing.DefaultListModel lc_tListModel = (javax.swing.DefaultListModel) jListNodes.getModel();

   int lc_iSelectionPos = jListNodes.getSelectedIndex();
   int lc_iSize         = lc_tListModel.getSize() -1;

   if (lc_iSize > lc_iSelectionPos)
   {
    moveNode(lc_iSize);
   }      
  }
  
  
  
  /**
   * Reverses the node order
   * 
   */
  public void flipNodes()
  {
   javax.swing.DefaultListModel lc_tListModel = (javax.swing.DefaultListModel) jListNodes.getModel();

   int lc_iSelectionPos = jListNodes.getSelectedIndex();
   int lc_iSize         = lc_tListModel.getSize()      ;
   int lc_iI            = 0;

   ColorPal2ColorRecord lc_tOldValue  = null;
   ColorPal2ColorRecord lc_tNewValue  = null;
   
   for (lc_iI = lc_iSize-1 ; lc_iI >= 0; lc_iI--)
   {
    if (null != (lc_tOldValue = (ColorPal2ColorRecord) lc_tListModel.elementAt(lc_iI)))
    {
     if (null != (lc_tNewValue = new ColorPal2ColorRecord(lc_tOldValue)))
     {
      lc_tListModel.addElement(lc_tNewValue); 
     }
    }      
   }
   lc_tListModel.removeRange(0, lc_iSize-1);
   jListNodes.setSelectedIndex(lc_iSelectionPos);
   updateCurrentProperties();  
   computeColors();
  }
  
  
  
  /**
   * Based on current settings, buttons are aneabled or disabled
   * 
   */
  public void checkButtons()
  {
   int lc_iSelectedNodeIndex  = jListNodes.getSelectedIndex();
   
   int lc_iColorAmount = jListColors.getModel().getSize();
   int lc_iNodeAmount  = jListNodes.getModel().getSize() ;
   
   boolean lc_bHasColors         = (lc_iColorAmount > 0);
   boolean lc_bHasNodes          = (lc_iNodeAmount  > 0);   
   boolean lc_bHasNodeSelection  = (true == lc_bHasNodes  ?  (lc_iSelectedNodeIndex  != -1) : false);
   
   jButtonNodesSave.setEnabled (lc_bHasNodes);
   jButtonNodesFlip.setEnabled (lc_bHasNodes && 1 < lc_iNodeAmount);
   jButtonNodesClear.setEnabled(lc_bHasNodes);
   
   jButtonNodesUp.setEnabled    (lc_bHasNodeSelection && lc_iSelectedNodeIndex > 0                  );
   jButtonNodesDown.setEnabled  (lc_bHasNodeSelection && lc_iSelectedNodeIndex < (lc_iNodeAmount -1));
   jButtonNodesFirst.setEnabled (lc_bHasNodeSelection && lc_iSelectedNodeIndex > 0                  );
   jButtonNodesLast.setEnabled  (lc_bHasNodeSelection && lc_iSelectedNodeIndex < (lc_iNodeAmount -1));
   
   jButtonNodesDelete.setEnabled(lc_bHasNodeSelection);
   jButtonNodesClone.setEnabled (lc_bHasNodeSelection);
   jButtonColor.setEnabled      (lc_bHasNodeSelection);
   jSpinnerStepping.setEnabled  (lc_bHasNodeSelection);

   jButtonClipboard.setEnabled(lc_bHasColors);
   
   jButtonNodesLoad.setEnabled(true);
   jButtonNodesNew.setEnabled (true);
  }
  
  
  
  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanelColors = new javax.swing.JPanel();
        jScrollPaneColors = new javax.swing.JScrollPane();
        jListColors = new javax.swing.JList();
        jButtonClipboard = new javax.swing.JButton();
        jPanelNodes = new javax.swing.JPanel();
        jScrollPaneNodes = new javax.swing.JScrollPane();
        jListNodes = new javax.swing.JList();
        jPanelProperties = new javax.swing.JPanel();
        jButtonColor = new javax.swing.JButton();
        jTextFieldColor = new javax.swing.JTextField();
        jSpinnerStepping = new javax.swing.JSpinner();
        jLabelSteps = new javax.swing.JLabel();
        jButtonNodesFirst = new javax.swing.JButton();
        jButtonNodesUp = new javax.swing.JButton();
        jButtonNodesDown = new javax.swing.JButton();
        jButtonNodesLast = new javax.swing.JButton();
        jButtonNodesDelete = new javax.swing.JButton();
        jButtonNodesClone = new javax.swing.JButton();
        jButtonNodesLoad = new javax.swing.JButton();
        jButtonNodesSave = new javax.swing.JButton();
        jButtonNodesClear = new javax.swing.JButton();
        jButtonNodesFlip = new javax.swing.JButton();
        jButtonNodesNew = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("colorpal2/resources/ColorPal2View"); // NOI18N
        setTitle(bundle.getString("Form.title")); // NOI18N
        setName("Form"); // NOI18N

        jPanelColors.setBorder(javax.swing.BorderFactory.createTitledBorder(bundle.getString("jPanelColors.border.title"))); // NOI18N
        jPanelColors.setName("jPanelColors"); // NOI18N

        org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(colorpal2.ColorPal2App.class).getContext().getResourceMap(ColorPal2View.class);
        jScrollPaneColors.setBackground(resourceMap.getColor("jScrollPaneColors.background")); // NOI18N
        jScrollPaneColors.setName("jScrollPaneColors"); // NOI18N

        jListColors.setBackground(new java.awt.Color(Integer.valueOf(bundle.getString("jList.background"), 16)));
        jListColors.setForeground(new java.awt.Color(Integer.valueOf(bundle.getString("jList.foreground"), 16)));
        jListColors.setModel(new javax.swing.DefaultListModel());
        jListColors.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        jListColors.setName("jListColors"); // NOI18N
        jListColors.setSelectionBackground(new java.awt.Color(Integer.valueOf(bundle.getString("jList.selectionBackground"), 16)));
        jListColors.setSelectionForeground(new java.awt.Color(Integer.valueOf(bundle.getString("jList.selectionForeground"), 16)));
        jScrollPaneColors.setViewportView(jListColors);

        jButtonClipboard.setText(bundle.getString("jButtonClipboard.text")); // NOI18N
        jButtonClipboard.setToolTipText(bundle.getString("jButtonClipboard.toolTipText")); // NOI18N
        jButtonClipboard.setName("jButtonClipboard"); // NOI18N
        jButtonClipboard.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                actionPerformed_Button_Clipboard(evt);
            }
        });

        javax.swing.GroupLayout jPanelColorsLayout = new javax.swing.GroupLayout(jPanelColors);
        jPanelColors.setLayout(jPanelColorsLayout);
        jPanelColorsLayout.setHorizontalGroup(
            jPanelColorsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanelColorsLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanelColorsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jScrollPaneColors, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 197, Short.MAX_VALUE)
                    .addComponent(jButtonClipboard, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 197, Short.MAX_VALUE))
                .addContainerGap())
        );
        jPanelColorsLayout.setVerticalGroup(
            jPanelColorsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanelColorsLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPaneColors, javax.swing.GroupLayout.DEFAULT_SIZE, 495, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jButtonClipboard)
                .addContainerGap())
        );

        jPanelNodes.setBorder(javax.swing.BorderFactory.createTitledBorder(bundle.getString("jPanelNodes.border.title"))); // NOI18N
        jPanelNodes.setName("jPanelNodes"); // NOI18N

        jScrollPaneNodes.setBackground(resourceMap.getColor("jScrollPaneNodes.background")); // NOI18N
        jScrollPaneNodes.setName("jScrollPaneNodes"); // NOI18N

        jListNodes.setBackground(new java.awt.Color(Integer.valueOf(bundle.getString("jList.background"), 16)));
        jListNodes.setForeground(new java.awt.Color(Integer.valueOf(bundle.getString("jList.foreground"), 16)));
        jListNodes.setModel(new javax.swing.DefaultListModel());
        jListNodes.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        jListNodes.setName("jListNodes"); // NOI18N
        jListNodes.setSelectionBackground(new java.awt.Color(Integer.valueOf(bundle.getString("jList.selectionBackground"), 16)));
        jListNodes.setSelectionForeground(new java.awt.Color(Integer.valueOf(bundle.getString("jList.selectionForeground"), 16)));
        jScrollPaneNodes.setViewportView(jListNodes);

        jPanelProperties.setBorder(javax.swing.BorderFactory.createTitledBorder(bundle.getString("jPanelProperties.border.title"))); // NOI18N
        jPanelProperties.setName("jPanelProperties"); // NOI18N

        jButtonColor.setText(bundle.getString("jButtonColor.text")); // NOI18N
        jButtonColor.setToolTipText(bundle.getString("jButtonColor.toolTipText")); // NOI18N
        jButtonColor.setName("jButtonColor"); // NOI18N
        jButtonColor.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                actionPerformed_Button_Color(evt);
            }
        });

        jTextFieldColor.setEditable(false);
        jTextFieldColor.setText(bundle.getString("jTextFieldColor.text")); // NOI18N
        jTextFieldColor.setName("jTextFieldColor"); // NOI18N

        jSpinnerStepping.setModel(new javax.swing.SpinnerNumberModel(1, 1, 256, 1));
        jSpinnerStepping.setName("jSpinnerStepping"); // NOI18N
        jSpinnerStepping.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                stateChanged_Spinner_Steps(evt);
            }
        });

        jLabelSteps.setText(bundle.getString("jLabelSteps.text")); // NOI18N

        javax.swing.GroupLayout jPanelPropertiesLayout = new javax.swing.GroupLayout(jPanelProperties);
        jPanelProperties.setLayout(jPanelPropertiesLayout);
        jPanelPropertiesLayout.setHorizontalGroup(
            jPanelPropertiesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelPropertiesLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jButtonColor, javax.swing.GroupLayout.PREFERRED_SIZE, 76, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jTextFieldColor, javax.swing.GroupLayout.DEFAULT_SIZE, 101, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabelSteps, javax.swing.GroupLayout.PREFERRED_SIZE, 33, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jSpinnerStepping, javax.swing.GroupLayout.PREFERRED_SIZE, 56, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        jPanelPropertiesLayout.setVerticalGroup(
            jPanelPropertiesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelPropertiesLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanelPropertiesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonColor)
                    .addComponent(jTextFieldColor, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jSpinnerStepping, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabelSteps))
                .addContainerGap())
        );

        jPanelPropertiesLayout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {jButtonColor, jLabelSteps, jSpinnerStepping, jTextFieldColor});

        jButtonNodesFirst.setIcon(resourceMap.getIcon("jButtonNodesFirst.icon")); // NOI18N
        jButtonNodesFirst.setText(bundle.getString("jButtonNodesFirst.text")); // NOI18N
        jButtonNodesFirst.setToolTipText(bundle.getString("jButtonNodesFirst.toolTipText")); // NOI18N
        jButtonNodesFirst.setName("jButtonNodesFirst"); // NOI18N
        jButtonNodesFirst.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                actionPerformed_Button_NodesFirst(evt);
            }
        });

        jButtonNodesUp.setIcon(resourceMap.getIcon("jButtonNodesUp.icon")); // NOI18N
        jButtonNodesUp.setText(bundle.getString("jButtonNodesUp.text")); // NOI18N
        jButtonNodesUp.setToolTipText(bundle.getString("jButtonNodesUp.toolTipText")); // NOI18N
        jButtonNodesUp.setName("jButtonNodesUp"); // NOI18N
        jButtonNodesUp.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                actionPerformed_Button_NodesUp(evt);
            }
        });

        jButtonNodesDown.setIcon(resourceMap.getIcon("jButtonNodesDown.icon")); // NOI18N
        jButtonNodesDown.setText(bundle.getString("jButtonNodesDown.text")); // NOI18N
        jButtonNodesDown.setToolTipText(bundle.getString("jButtonNodesDown.toolTipText")); // NOI18N
        jButtonNodesDown.setName("jButtonNodesDown"); // NOI18N
        jButtonNodesDown.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                actionPerformed_Button_NodesDown(evt);
            }
        });

        jButtonNodesLast.setIcon(resourceMap.getIcon("jButtonNodesLast.icon")); // NOI18N
        jButtonNodesLast.setText(bundle.getString("jButtonNodesLast.text")); // NOI18N
        jButtonNodesLast.setToolTipText(bundle.getString("jButtonNodesLast.toolTipText")); // NOI18N
        jButtonNodesLast.setName("jButtonNodesLast"); // NOI18N
        jButtonNodesLast.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                actionPerformed_Button_NodesLast(evt);
            }
        });

        jButtonNodesDelete.setIcon(resourceMap.getIcon("jButtonNodesDelete.icon")); // NOI18N
        jButtonNodesDelete.setText(bundle.getString("jButtonNodesDelete.text")); // NOI18N
        jButtonNodesDelete.setToolTipText(bundle.getString("jButtonNodesDelete.toolTipText")); // NOI18N
        jButtonNodesDelete.setName("jButtonNodesDelete"); // NOI18N
        jButtonNodesDelete.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                actionPerformed_Button_NodesDelete(evt);
            }
        });

        jButtonNodesClone.setIcon(resourceMap.getIcon("jButtonNodesClone.icon")); // NOI18N
        jButtonNodesClone.setText(bundle.getString("jButtonNodesClone.text")); // NOI18N
        jButtonNodesClone.setToolTipText(bundle.getString("jButtonNodesClone.toolTipText")); // NOI18N
        jButtonNodesClone.setName("jButtonNodesClone"); // NOI18N
        jButtonNodesClone.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                actionPerformed_Button_NodesClone(evt);
            }
        });

        jButtonNodesLoad.setIcon(resourceMap.getIcon("jButtonNodesLoad.icon")); // NOI18N
        jButtonNodesLoad.setText(bundle.getString("jButtonNodesLoad.text")); // NOI18N
        jButtonNodesLoad.setToolTipText(bundle.getString("jButtonNodesLoad.toolTipText")); // NOI18N
        jButtonNodesLoad.setName("jButtonNodesLoad"); // NOI18N
        jButtonNodesLoad.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                actionPerformed_Button_NodesLoad(evt);
            }
        });

        jButtonNodesSave.setIcon(resourceMap.getIcon("jButtonNodesSave.icon")); // NOI18N
        jButtonNodesSave.setText(bundle.getString("jButtonNodesSave.text")); // NOI18N
        jButtonNodesSave.setToolTipText(bundle.getString("jButtonNodesSave.toolTipText")); // NOI18N
        jButtonNodesSave.setName("jButtonNodesSave"); // NOI18N
        jButtonNodesSave.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                actionPerformed_Button_NodesSave(evt);
            }
        });

        jButtonNodesClear.setIcon(resourceMap.getIcon("jButtonNodesClear.icon")); // NOI18N
        jButtonNodesClear.setText(bundle.getString("jButtonNodesClear.text")); // NOI18N
        jButtonNodesClear.setToolTipText(bundle.getString("jButtonNodesClear.toolTipText")); // NOI18N
        jButtonNodesClear.setName("jButtonNodesClear"); // NOI18N
        jButtonNodesClear.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                actionPerformed_Button_NodesClear(evt);
            }
        });

        jButtonNodesFlip.setIcon(resourceMap.getIcon("jButtonNodesFlip.icon")); // NOI18N
        jButtonNodesFlip.setText(bundle.getString("jButtonNodesFlip.text")); // NOI18N
        jButtonNodesFlip.setToolTipText(bundle.getString("jButtonNodesFlip.toolTipText")); // NOI18N
        jButtonNodesFlip.setName("jButtonNodesFlip"); // NOI18N
        jButtonNodesFlip.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                actionPerformed_Button_NodesFlip(evt);
            }
        });

        jButtonNodesNew.setIcon(resourceMap.getIcon("jButtonNodesNew.icon")); // NOI18N
        jButtonNodesNew.setText(bundle.getString("jButtonNodesNew.text")); // NOI18N
        jButtonNodesNew.setToolTipText(bundle.getString("jButtonNodesNew.toolTipText")); // NOI18N
        jButtonNodesNew.setName("jButtonNodesNew"); // NOI18N
        jButtonNodesNew.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                actionPerformed_Button_NodesNew(evt);
            }
        });

        javax.swing.GroupLayout jPanelNodesLayout = new javax.swing.GroupLayout(jPanelNodes);
        jPanelNodes.setLayout(jPanelNodesLayout);
        jPanelNodesLayout.setHorizontalGroup(
            jPanelNodesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelNodesLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanelNodesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanelNodesLayout.createSequentialGroup()
                        .addComponent(jScrollPaneNodes, javax.swing.GroupLayout.DEFAULT_SIZE, 275, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanelNodesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addGroup(jPanelNodesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                                .addComponent(jButtonNodesLast, 0, 0, Short.MAX_VALUE)
                                .addComponent(jButtonNodesDown, 0, 0, Short.MAX_VALUE)
                                .addComponent(jButtonNodesUp, 0, 0, Short.MAX_VALUE)
                                .addComponent(jButtonNodesFirst, javax.swing.GroupLayout.PREFERRED_SIZE, 31, Short.MAX_VALUE))
                            .addComponent(jButtonNodesFlip, 0, 0, Short.MAX_VALUE)
                            .addGroup(jPanelNodesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                                .addComponent(jButtonNodesClear, 0, 0, Short.MAX_VALUE)
                                .addComponent(jButtonNodesSave, 0, 0, Short.MAX_VALUE)
                                .addComponent(jButtonNodesLoad, 0, 0, Short.MAX_VALUE)
                                .addComponent(jButtonNodesNew, 0, 0, Short.MAX_VALUE)
                                .addComponent(jButtonNodesClone, 0, 0, Short.MAX_VALUE)
                                .addComponent(jButtonNodesDelete, javax.swing.GroupLayout.PREFERRED_SIZE, 0, javax.swing.GroupLayout.PREFERRED_SIZE))))
                    .addComponent(jPanelProperties, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );

        jPanelNodesLayout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {jButtonNodesClear, jButtonNodesClone, jButtonNodesDelete, jButtonNodesDown, jButtonNodesFirst, jButtonNodesFlip, jButtonNodesLast, jButtonNodesLoad, jButtonNodesNew, jButtonNodesSave, jButtonNodesUp});

        jPanelNodesLayout.setVerticalGroup(
            jPanelNodesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelNodesLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanelNodesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanelNodesLayout.createSequentialGroup()
                        .addComponent(jButtonNodesFirst)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonNodesUp)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonNodesDown)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonNodesLast)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonNodesFlip)
                        .addGap(18, 18, 18)
                        .addComponent(jButtonNodesDelete)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonNodesClone)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonNodesNew)
                        .addGap(18, 18, 18)
                        .addComponent(jButtonNodesLoad)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonNodesSave)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonNodesClear))
                    .addComponent(jScrollPaneNodes, javax.swing.GroupLayout.DEFAULT_SIZE, 450, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jPanelProperties, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        jPanelNodesLayout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {jButtonNodesClear, jButtonNodesClone, jButtonNodesDelete, jButtonNodesDown, jButtonNodesFirst, jButtonNodesFlip, jButtonNodesLast, jButtonNodesLoad, jButtonNodesNew, jButtonNodesSave, jButtonNodesUp});

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanelColors, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jPanelNodes, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jPanelNodes, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanelColors, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

private void actionPerformed_Button_NodesNew(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_actionPerformed_Button_NodesNew
// TODO add your handling code here:
if (null != m_tGuiConnector) m_tGuiConnector.handleButtonNodesNew();  
}//GEN-LAST:event_actionPerformed_Button_NodesNew

private void actionPerformed_Button_Color(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_actionPerformed_Button_Color
// TODO add your handling code here:
if (null != m_tGuiConnector) m_tGuiConnector.handleButtonColor();  
}//GEN-LAST:event_actionPerformed_Button_Color

private void stateChanged_Spinner_Steps(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_stateChanged_Spinner_Steps
// TODO add your handling code here:
if (null != m_tGuiConnector) m_tGuiConnector.handleSpinnerSteps();  
}//GEN-LAST:event_stateChanged_Spinner_Steps

private void actionPerformed_Button_NodesClear(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_actionPerformed_Button_NodesClear
// TODO add your handling code here:
if (null != m_tGuiConnector) m_tGuiConnector.handleButtonNodesClear();  
}//GEN-LAST:event_actionPerformed_Button_NodesClear

private void actionPerformed_Button_NodesDelete(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_actionPerformed_Button_NodesDelete
// TODO add your handling code here:
if (null != m_tGuiConnector) m_tGuiConnector.handleButtonNodesDelete();  
}//GEN-LAST:event_actionPerformed_Button_NodesDelete

private void actionPerformed_Button_NodesClone(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_actionPerformed_Button_NodesClone
// TODO add your handling code here:
if (null != m_tGuiConnector) m_tGuiConnector.handleButtonNodesClone();  
}//GEN-LAST:event_actionPerformed_Button_NodesClone

private void actionPerformed_Button_NodesFirst(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_actionPerformed_Button_NodesFirst
// TODO add your handling code here:
if (null != m_tGuiConnector) m_tGuiConnector.handleButtonNodesFirst();  
}//GEN-LAST:event_actionPerformed_Button_NodesFirst

private void actionPerformed_Button_NodesLast(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_actionPerformed_Button_NodesLast
// TODO add your handling code here:
if (null != m_tGuiConnector) m_tGuiConnector.handleButtonNodesLast();  
}//GEN-LAST:event_actionPerformed_Button_NodesLast

private void actionPerformed_Button_NodesUp(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_actionPerformed_Button_NodesUp
// TODO add your handling code here:
if (null != m_tGuiConnector) m_tGuiConnector.handleButtonNodesUp();  
}//GEN-LAST:event_actionPerformed_Button_NodesUp

private void actionPerformed_Button_NodesDown(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_actionPerformed_Button_NodesDown
// TODO add your handling code here:
if (null != m_tGuiConnector) m_tGuiConnector.handleButtonNodesDown();  
}//GEN-LAST:event_actionPerformed_Button_NodesDown

private void actionPerformed_Button_NodesFlip(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_actionPerformed_Button_NodesFlip
// TODO add your handling code here:
if (null != m_tGuiConnector) m_tGuiConnector.handleButtonNodesFlip();  
}//GEN-LAST:event_actionPerformed_Button_NodesFlip

private void actionPerformed_Button_NodesLoad(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_actionPerformed_Button_NodesLoad
// TODO add your handling code here:
if (null != m_tGuiConnector) m_tGuiConnector.handleButtonNodesLoad();  
}//GEN-LAST:event_actionPerformed_Button_NodesLoad

private void actionPerformed_Button_NodesSave(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_actionPerformed_Button_NodesSave
// TODO add your handling code here:
if (null != m_tGuiConnector) m_tGuiConnector.handleButtonNodesSave();  
}//GEN-LAST:event_actionPerformed_Button_NodesSave

private void actionPerformed_Button_Clipboard(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_actionPerformed_Button_Clipboard
// TODO add your handling code here:
if (null != m_tGuiConnector) m_tGuiConnector.handleButtonCopyToClipboard();  
}//GEN-LAST:event_actionPerformed_Button_Clipboard


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonClipboard;
    private javax.swing.JButton jButtonColor;
    private javax.swing.JButton jButtonNodesClear;
    private javax.swing.JButton jButtonNodesClone;
    private javax.swing.JButton jButtonNodesDelete;
    private javax.swing.JButton jButtonNodesDown;
    private javax.swing.JButton jButtonNodesFirst;
    private javax.swing.JButton jButtonNodesFlip;
    private javax.swing.JButton jButtonNodesLast;
    private javax.swing.JButton jButtonNodesLoad;
    private javax.swing.JButton jButtonNodesNew;
    private javax.swing.JButton jButtonNodesSave;
    private javax.swing.JButton jButtonNodesUp;
    private javax.swing.JLabel jLabelSteps;
    private javax.swing.JList jListColors;
    private javax.swing.JList jListNodes;
    private javax.swing.JPanel jPanelColors;
    private javax.swing.JPanel jPanelNodes;
    private javax.swing.JPanel jPanelProperties;
    private javax.swing.JScrollPane jScrollPaneColors;
    private javax.swing.JScrollPane jScrollPaneNodes;
    private javax.swing.JSpinner jSpinnerStepping;
    private javax.swing.JTextField jTextFieldColor;
    // End of variables declaration//GEN-END:variables
 

  
  public javax.swing.JList getColorList() {return jListColors;}
  
  
  public javax.swing.JList getNodeList() {return jListNodes;}
  
  
  
 /**
  * Computes the total amount of colors created by the current node list.
  *´Keep in mind: 
  * a) 1 step means we will immediately have the next color without any levels between, 2 steps means 1 level between, ...
  * b) The steps of the last entry are ignored since it has no followers.
  * 
  * @return  totla amount of colors
  */
 private int getTotalAmountOfColors()
 {
  javax.swing.DefaultListModel lc_tListModel = (javax.swing.DefaultListModel) jListNodes.getModel() ;

  int lc_iSize  = lc_tListModel.getSize();
  int lc_iLast  = lc_iSize-1;
  int lc_iTotal = lc_iSize;
  int lc_iI     = 0;

  ColorPal2ColorRecord lc_tNodeValue  = null;
   
  for (lc_iI = 0 ; lc_iI < lc_iSize; lc_iI++)
  {
   if (null != (lc_tNodeValue = (ColorPal2ColorRecord) lc_tListModel.elementAt(lc_iI)))
   {
    if (lc_iI != lc_iLast) // b)
    {
     lc_iTotal += (lc_tNodeValue.getSteps()-1); // a)
    }
   }
  }
  return lc_iTotal;
 }
  
 
 
 /**
  * Computes the list of colors created by the current node settings, and displays
  * them in the color list
  */
 public void computeColors()
 {
  javax.swing.DefaultListModel lc_tColorListModel = (javax.swing.DefaultListModel) jListColors.getModel();
  javax.swing.DefaultListModel lc_tNodeListModel  = (javax.swing.DefaultListModel) jListNodes.getModel() ;
  
  ColorPal2ColorRecord         lc_tNodeValueFrom  = null;
  ColorPal2ColorRecord         lc_tNodeValueTo    = null;
  ColorPal2ColorRecord[]       lc_tColors         = null;
  
  Color lc_tColorFrom = null;
  Color lc_tColorTo   = null;
  Color lc_tColorNew  = null;
  
  int lc_iSize       = lc_tNodeListModel.getSize();
  int lc_iLast       = lc_iSize-1;
  int lc_iTotal      = getTotalAmountOfColors();
  int lc_iI          = 0;
  int lc_iJ          = 0;
  int lc_iColorCount = 0; 
  int lc_iSteps      = 0;
  
  float lc_fR      = 0;
  float lc_fG      = 0;
  float lc_fB      = 0;
  
  float lc_fdR     = 0;
  float lc_fdG     = 0;
  float lc_fdB     = 0;

  if (0 < lc_iSize)
  {
   if (null != (lc_tColors = new ColorPal2ColorRecord[lc_iTotal]))
   {
    lc_tColorListModel.clear();
    
    //
    // iterate over nodes
    //
    for (lc_iI = 0 ; lc_iI < lc_iSize; lc_iI++) 
    {
     if (null != (lc_tNodeValueFrom = (ColorPal2ColorRecord) lc_tNodeListModel.elementAt(lc_iI)))
     {
      lc_tColorFrom = lc_tNodeValueFrom.getColor();
      lc_iSteps     = lc_tNodeValueFrom.getSteps();
      lc_fR         = lc_tColorFrom.getRed()      ;
      lc_fG         = lc_tColorFrom.getGreen()    ;
      lc_fB         = lc_tColorFrom.getBlue()     ;
      
      //
      // store start color
      //
      lc_tColors[lc_iColorCount++] = new ColorPal2ColorRecord(lc_tColorFrom, 1);
              
      //
      // no further computation when the last entry is reached
      //
      if (lc_iI < lc_iLast)
      {
       if (null != (lc_tNodeValueTo = (ColorPal2ColorRecord) lc_tNodeListModel.elementAt(lc_iI+1)))
       {
        lc_tColorTo = lc_tNodeValueTo.getColor(); 
        lc_fdR      = (lc_tColorTo.getRed()   - lc_fR) / (lc_iSteps);
        lc_fdG      = (lc_tColorTo.getGreen() - lc_fG) / (lc_iSteps);
        lc_fdB      = (lc_tColorTo.getBlue()  - lc_fB) / (lc_iSteps);
 
        //
        // create "between" colors
        //
        for (lc_iJ = 0; lc_iJ < lc_iSteps-1; lc_iJ++)
        {
         lc_fR += lc_fdR;
         lc_fG += lc_fdG;
         lc_fB += lc_fdB;
         if (null != (lc_tColorNew = new Color((int) lc_fR, (int) lc_fG, (int) lc_fB))) 
         {
          lc_tColors[lc_iColorCount++] = new ColorPal2ColorRecord(lc_tColorNew, 1);
         }
        } // for
       }
      }
     }
    } // for
    
    for (lc_iI = 0; lc_iI < lc_iColorCount; lc_iI++)
    {
     lc_tColorListModel.addElement(lc_tColors[lc_iI]);
    }
   }
  }
 }
 
 
 
 /**
  * Exports data to clipboard
  * 
  */
 public void exportColorsToClipboard()
 {
  javax.swing.DefaultListModel lc_tColorListModel = (javax.swing.DefaultListModel) jListColors.getModel();
   
  StringBuffer         lc_tOutput          = new StringBuffer();
  StringSelection      lc_tStringSelection = null              ;  
  ColorPal2ColorRecord lc_tRecord          = null              ;
  String               lc_sColorString     = null              ;
  
  int lc_iLastSep = 0;
  int lc_iLen     = 0;
  int lc_iI       = 0;
  
  if (null != lc_tOutput)
  {
   if (0 < (lc_iLen = lc_tColorListModel.getSize())) 
   {
    lc_iLastSep = lc_iLen -1;
     
    for (lc_iI = 0; lc_iI < lc_iLen; lc_iI++)
    {
     if (null != (lc_tRecord = (ColorPal2ColorRecord) lc_tColorListModel.elementAt(lc_iI)))
     {
      if (null != lc_tRecord.getColor())
      {
       if (null != (lc_sColorString = lc_tRecord.getColorString()))
       {
        lc_tOutput.append((lc_sColorString.length() > 6) ? lc_sColorString.substring(2) : lc_sColorString); 
        if (lc_iI != lc_iLastSep)
        {
         lc_tOutput.append(","); 
        }
       }
      }
     }
    }
    
    if (null != (lc_tStringSelection = new StringSelection(lc_tOutput.toString())))
    {
     Toolkit.getDefaultToolkit().getSystemClipboard().setContents(lc_tStringSelection, null);
    }
   }
  }  
 }
 

  /**
  * Returns the localized string for the given key
  * 
  * @param pa_sKey   key
  * @return  localized string
  */
 private String getLocalizedString(String pa_sKey) 
 {
  return (null != m_tLocalizedMessages ? m_tLocalizedMessages.getString(pa_sKey) : ""); 
 }

 
 
 
 /**
  * MouseListener.mouseClicked
  * 
  * opens the color requester 
  * 
  * @param pa_tEvent    mouse event
  */
 public void mouseClicked(java.awt.event.MouseEvent pa_tEvent)
 {
  int lc_iIndex = -1;
  
  if (null != pa_tEvent)
  {
   if (pa_tEvent.getSource() == jListNodes)
   {
    if (-1 != (lc_iIndex = jListNodes.locationToIndex(pa_tEvent.getPoint())))
    {
     if (lc_iIndex < jListNodes.getModel().getSize())
     {
      if (2 == pa_tEvent.getClickCount())
      {
       if (null != m_tGuiConnector) m_tGuiConnector.handleButtonColor();  
      }
     }
    }
   }
  }
 }
 
 

 /**
  * MouseListener.mouseEntered
     * 
  * @param pa_tEvent    mouse event
  */ 
 public void mouseEntered(java.awt.event.MouseEvent pa_tEvent) {}
 
 
 
 /**
  * MouseListener.mouseExited
     * 
  * @param pa_tEvent    mouse event
  */
 public void mouseExited(java.awt.event.MouseEvent pa_tEvent) {}

 
 
 /**
  * MouseListener.mousePressed. We catch this event from table headers (!) to store the currently active savegame selection
  * for later restoring. This event indicates that a sort process is about to begin, so before that sort, we retrieve the 
  * list of selections and store it. After the sort is finished, we restore this selection.
  * 
  * @param pa_tEvent    mouse event
  */
 public void mousePressed(java.awt.event.MouseEvent pa_tEvent) {}

 
 
 /**
  * MouseListener.mouseReleased. Handles list selections and table selections done by the user via mouse.
  * 
  * @param pa_tEvent    mouse event
  */
 public void mouseReleased(java.awt.event.MouseEvent pa_tEvent) {} 
}


