/**
 * FileSafe
 * 
 */ 
package filesafe;

/**
 * Password dialog
 * 
 * @author Gaming  Ulf Wagemann
 */
public class FileSafePasswordDialog extends javax.swing.JDialog 
                                implements java.awt.event.ActionListener,
                                           javax.swing.event.DocumentListener
{
 private int m_iButtonPressed;

 
 
 /**
  * Constructor
  * 
  * @param pa_tParent  parent JFrame
  * @param pa_bModal   true for modal, false for non-modal 
  */
  public FileSafePasswordDialog(java.awt.Frame pa_tParent, boolean pa_bModal) 
  {
   super(pa_tParent, pa_bModal);
   initComponents();
   centerOnParentView(pa_tParent);
   
   //
   // add our own button event handlers
   //
   jButtonPasswordCancel.addActionListener((java.awt.event.ActionListener) this);
   jButtonPasswordOk.addActionListener ((java.awt.event.ActionListener) this);
   
   //
   // add event handlers to text fields
   //
   jPasswordFieldEnter.setDocument(new FileSafeTextDocument());
   jPasswordFieldEnter.getDocument().addDocumentListener((javax.swing.event.DocumentListener) this);

   m_iButtonPressed = 0;
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabelPassword = new javax.swing.JLabel();
        jPasswordFieldEnter = new javax.swing.JPasswordField();
        jButtonPasswordOk = new javax.swing.JButton();
        jButtonPasswordCancel = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("filesafe/resources/FileSafePasswordDialog"); // NOI18N
        setTitle(bundle.getString("Form.title")); // NOI18N
        setAlwaysOnTop(true);
        setModal(true);
        setName("Form"); // NOI18N

        jLabelPassword.setText(bundle.getString("jLabelPassword.text")); // NOI18N
        jLabelPassword.setName("jLabelPassword"); // NOI18N

        jPasswordFieldEnter.setText(bundle.getString("jPasswordFieldEnter.text")); // NOI18N
        jPasswordFieldEnter.setName("jPasswordFieldEnter"); // NOI18N

        jButtonPasswordOk.setText(bundle.getString("jButtonPasswordOk.text")); // NOI18N
        jButtonPasswordOk.setEnabled(false);
        jButtonPasswordOk.setName("jButtonPasswordOk"); // NOI18N

        jButtonPasswordCancel.setText(bundle.getString("jButtonPasswordCancel.text")); // NOI18N
        jButtonPasswordCancel.setName("jButtonPasswordCancel"); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabelPassword)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addComponent(jButtonPasswordCancel, javax.swing.GroupLayout.PREFERRED_SIZE, 75, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonPasswordOk, javax.swing.GroupLayout.PREFERRED_SIZE, 81, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(jPasswordFieldEnter, javax.swing.GroupLayout.DEFAULT_SIZE, 168, Short.MAX_VALUE))
                .addContainerGap())
        );

        layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {jButtonPasswordCancel, jButtonPasswordOk});

        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabelPassword)
                    .addComponent(jPasswordFieldEnter, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonPasswordOk)
                    .addComponent(jButtonPasswordCancel))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        layout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {jButtonPasswordCancel, jButtonPasswordOk, jLabelPassword, jPasswordFieldEnter});

        pack();
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonPasswordCancel;
    private javax.swing.JButton jButtonPasswordOk;
    private javax.swing.JLabel jLabelPassword;
    private javax.swing.JPasswordField jPasswordFieldEnter;
    // End of variables declaration//GEN-END:variables


 /**
  * ActionListener method to catch buttons. Hide the dialog and store button.
     * 
  * @param pa_tEvent   button event 
  */  
  public void actionPerformed(java.awt.event.ActionEvent pa_tEvent) 
  {
   if (null != pa_tEvent)
   {
    if (pa_tEvent.getSource() == jButtonPasswordCancel) 
    {
     m_iButtonPressed = -1; 
    }
    else if (pa_tEvent.getSource() == jButtonPasswordOk)
    {
     m_iButtonPressed = 1;  
    }
    this.setVisible(false);
   }
  }
  
  
  
 /**
  * Handles a change-event any text-field. The Ok button gets enabled as soon
  * as text-length is greater than KSA_MIN_LENGTH chars and both texts are equal.
  * 
  * @param pa_tEvent 
  */
  public void changedUpdate(javax.swing.event.DocumentEvent pa_tEvent) 
  {
   checkOkButton();
  }
  
  
 /**
  * Handles a remove-event any text-field. The Ok button gets enabled as soon
  * as text-length is greater than KSA_MIN_LENGTH chars and both texts are equal.
  * 
  * @param pa_tEvent 
  */
  public void removeUpdate(javax.swing.event.DocumentEvent pa_tEvent) 
  {
   checkOkButton();
  }

  
 /**
  * Handles an insert-event any text-field. The Ok button gets enabled as soon
  * as text-length is greater than KSA_MIN_LENGTH chars and both texts are equal.
  * 
  * @param pa_tEvent 
  */
  public void insertUpdate(javax.swing.event.DocumentEvent pa_tEvent) 
  {
   checkOkButton();
  }

  
  
  /**
   * Enables or disables the Ok button according to text input
   * 
   */  
  private void checkOkButton()
  {
   String  lc_sPw1     = getPassword();
   boolean lc_bEnabled = false;
   
   if (null != lc_sPw1)
   {
    lc_bEnabled = (lc_sPw1.length() >= 1); 
   }
   jButtonPasswordOk.setEnabled(lc_bEnabled);
  }
 
  
  
  /**
   * Centers the dialof view on the parent view
   * 
   * @param pa_tParent   parent JFrame
   */
  private void centerOnParentView(java.awt.Frame pa_tParent)
  {
   java.awt.Rectangle lc_tBounds      = pa_tParent.getBounds();
   java.awt.Dimension lc_tSize        = getSize();
   java.awt.Point     lc_tNewLocation = new java.awt.Point();
   
   if (null != lc_tBounds && null != lc_tSize && null != lc_tNewLocation)
   {
    lc_tNewLocation.x = lc_tBounds.x + (lc_tBounds.width /2) - (lc_tSize.width /2); 
    lc_tNewLocation.y = lc_tBounds.y + (lc_tBounds.height/2) - (lc_tSize.height/2); 
   
    if (0 > lc_tNewLocation.x) lc_tNewLocation.x = 0;
    if (0 > lc_tNewLocation.y) lc_tNewLocation.y = 0;
    
    setLocation(lc_tNewLocation);
   }
  }
  
  
  
  /**
   * Returns the pressed button
   * 
   * @return   -1 in case of cancel, 1 in case of ok
   */
  public int getButtonPressed() {return m_iButtonPressed;};
  
  
  
  /**
   * Returns the password
   * 
   * @return 
   */
  public String getPassword() 
  {
   char[] lc_tChars = jPasswordFieldEnter.getPassword();
   return (null != lc_tChars ? new String(lc_tChars) : null);
  }
}
