/**
 * FileSafe
 * 
 */
package filesafe;



/**
 * GUI
 *
 * @author Ulf Wagemann
 */
public class FileSafeView extends javax.swing.JFrame 
                          implements javax.swing.event.ListSelectionListener
{
 private FileSafeGuiConnector m_tGuiConnector;
 private boolean              m_bGuiLocked   ;
 private java.util.ResourceBundle  m_tResources;
 
 
 /** 
  * Constructor
  *
  */
  public FileSafeView(FileSafeGuiConnector pa_tGuiConnector,  java.awt.event.WindowListener pa_tListener) 
  {
    m_tResources = java.util.ResourceBundle.getBundle(FileSafeConstants.FSA_FILE_VIEW_RESOURCES);
    
   //
   // work-arounds for following bugs/problems/crap:
   //
   // progress bar does not offer support for setting colors
   // filechooser does ot provide setting the cancel button txt
   //
   // FUGLY SHIT!
   //
   if (null != m_tResources)
   {
    javax.swing.UIManager.put("ProgressBar.background"         , new java.awt.Color(Integer.valueOf((m_tResources.getString(FileSafeConstants.FSA_FUGLY_BACKGROUND         )), 16))); //colour of the background
    javax.swing.UIManager.put("ProgressBar.foreground"         , new java.awt.Color(Integer.valueOf((m_tResources.getString(FileSafeConstants.FSA_FUGLY_FOREGROUND         )), 16))); //colour of progress bar
    javax.swing.UIManager.put("ProgressBar.selectionBackground", new java.awt.Color(Integer.valueOf((m_tResources.getString(FileSafeConstants.FSA_FUGLY_SELECTED_BACKGROUND)), 16))); //colour of percentage counter on black background
    javax.swing.UIManager.put("ProgressBar.selectionForeground", new java.awt.Color(Integer.valueOf((m_tResources.getString(FileSafeConstants.FSA_FUGLY_SELECTED_FOREGROUND)), 16))); //colour of precentage counter on red background
    javax.swing.UIManager.put("FileChooser.cancelButtonText", m_tResources.getString(FileSafeConstants.FSA_CHOOSER_CANCEL_TEXT));   
   } 

   initComponents();
   m_bGuiLocked = false;
   
   jListDecrypt.setModel(new FileSafeListModel());
   jListDecrypt.setCellRenderer(new FileSafeListCellRenderer());
   jListDecrypt.addListSelectionListener((javax.swing.event.ListSelectionListener) this);
   
   jListEncrypt.setModel(new FileSafeListModel());
   jListEncrypt.setCellRenderer(new FileSafeListCellRenderer());
   jListEncrypt.addListSelectionListener((javax.swing.event.ListSelectionListener) this);
   
   jTextAreaLog.setFont(jButtonDecryptAdd.getFont());
   m_tGuiConnector = pa_tGuiConnector;
   addWindowListener(pa_tListener);
  }

  
  
  /**
   * Handles a list selection
   * 
   * @param pa_tEvent 
   */
  public void valueChanged(javax.swing.event.ListSelectionEvent pa_tEvent)
  {
   if (null != pa_tEvent  && false == pa_tEvent.getValueIsAdjusting())
   {
    checkButtons();
   }
  }
 
  
 
  /**
   * Enables or disables the GUI
   * 
   * @param pa_bLock   true = lock, false = unlock
   * @return 
   */
  public void lockGui(boolean pa_bLock)
  {
   m_bGuiLocked = pa_bLock;
   checkButtons();
  }
  
  
  
  /**
   * Sets the encryption destination path
   * 
   * @param pa_sPath   path
   */
  public void setEncryptDestination(String pa_sPath)
  {
   jTextFieldEncryptDestination.setText(pa_sPath); 
   checkButtons();
  }
  
  
  
  /**
   * Returns the encrpyt destination dir
   * 
   * @return  encrypt destination dir
   */
  public String getEncryptDestination() {return jTextFieldEncryptDestination.getText();}
  
  
  
  
  /**
   * Sets the decryption destination path
   * 
   * @param pa_sPath   path
   */
  public void setDecryptDestination(String pa_sPath)
  {
   jTextFieldDecryptDestination.setText(pa_sPath); 
   checkButtons();
  }
  
  
  
  /**
   * Returns the decrpyt destination dir
   * 
   * @return  decrypt destination dir
   */
  public String getDecryptDestination() {return jTextFieldDecryptDestination.getText();}
  

  
  /**
   * Clears the encryption list
   * 
   */
  public void clearEncryptList()
  {
   FileSafeListModel lc_tModel = (FileSafeListModel) jListEncrypt.getModel();
   
   if (null != lc_tModel)
   {
    lc_tModel.clear(); 
    checkButtons();
   }    
  }
  
  
  
  /**
   * Clears the decryption list
   * 
   */
  public void clearDecryptList()
  {
   FileSafeListModel lc_tModel = (FileSafeListModel) jListDecrypt.getModel();
   
   if (null != lc_tModel)
   {
    lc_tModel.clear(); 
    checkButtons();
   }    
  }
  
  
  
  /**
   * Clears the log view
   * 
   */
  public final void clearLog()
  {
   jTextAreaLog.setText("");
   checkButtons();
  }
  
  
  
  /**
   * Adds a message to the log
   * 
   * @param pa_sMessage    message
   */
  public final void addLogMessage(String pa_sMessage)
  {
   jTextAreaLog.append(pa_sMessage + "\n"); 
  }
  
  
  
  /**
   * Returns the contents of the log textarea
   * 
   * @return    text
   */
  public final String getLog()
  {
   return jTextAreaLog.getText(); 
  }
  
  
  
  /**
   * Returns the selected list entry of the encrypt list
   * 
   * @return   selected entry, may be null
   */
  public String getSelectedDecryptListEntry()
  {
   int lc_iPos = jListDecrypt.getSelectedIndex();   
   return (-1 != lc_iPos ? (String) jListDecrypt.getSelectedValue() : null);
  }
  
  
  
  /**
   * Returns the selected list entry of the encrypt list
   * 
   * @return   selected entry, may be null
   */
  public String getSelectedEncryptListEntry()
  {
   int lc_iPos = jListEncrypt.getSelectedIndex();   
   return (-1 != lc_iPos ? (String) jListEncrypt.getSelectedValue() : null);
  }
  
  
  
  /**
   * Deletes the selected list entry of the encrypt list
   * 
   */
  public void removeSelectedEncryptListEntry()
  {
   int lc_iPos     = jListEncrypt.getSelectedIndex(); 
   int lc_iNewSize = 0;
   
   FileSafeListModel lc_tModel = (FileSafeListModel) jListEncrypt.getModel();

   if (-1 != lc_iPos)
   {
    if (null != lc_tModel)
    {
     lc_tModel.removeElement(getSelectedEncryptListEntry());
     jListEncrypt.clearSelection();
     
     if (0 < (lc_iNewSize = lc_tModel.getSize()))
     {
      if (lc_iPos >= lc_iNewSize)
      {
       lc_iPos = lc_iNewSize-1;
      }
      jListEncrypt.setSelectedIndex(lc_iPos);
     }
    }
   }
   checkButtons();
  }
  
  
  
  /**
   * Deletes the selected list entry of the encrypt list
   * 
   */
  public void removeSelectedDecryptListEntry()
  {
   int lc_iPos     = jListDecrypt.getSelectedIndex(); 
   int lc_iNewSize = 0;
   
   FileSafeListModel lc_tModel = (FileSafeListModel) jListDecrypt.getModel();

   if (-1 != lc_iPos)
   {
    if (null != lc_tModel)
    {
     lc_tModel.removeElement(getSelectedDecryptListEntry());
     jListDecrypt.clearSelection();
     
     if (0 < (lc_iNewSize = lc_tModel.getSize()))
     {
      if (lc_iPos >= lc_iNewSize)
      {
       lc_iPos = lc_iNewSize-1;
      }
      jListDecrypt.setSelectedIndex(lc_iPos);
     }
    }
   }
   checkButtons();
  }
  
  
  
  /**
   * Adds a new filename to the encrypt list
   * 
   * @param pa_sFileName   filename to add
   */
  public void addEncryptListEntry(String pa_sFileName)
  {
   FileSafeListModel lc_tModel = (FileSafeListModel) jListEncrypt.getModel();

   if (null != lc_tModel)
   {
    //
    // since only the label is considered by the comparable interface of KeySafeEntry,
    // we can safely delete any eventually existing object with the same label
    //
    lc_tModel.removeElement(pa_sFileName);
    lc_tModel.add(pa_sFileName);
   }
  }
  
  

  /**
   * Adds a new filename to the encrypt list
   * 
   * @param pa_sFileName   filename to add
   */
  public void addDecryptListEntry(String pa_sFileName)
  {
   FileSafeListModel lc_tModel = (FileSafeListModel) jListDecrypt.getModel();

   if (null != lc_tModel)
   {
    //
    // since only the label is considered by the comparable interface of KeySafeEntry,
    // we can safely delete any eventually existing object with the same label
    //
    lc_tModel.removeElement(pa_sFileName);
    lc_tModel.add(pa_sFileName);
   }
  }
  

  /**
   * Retrieves the array of files to decrypt
   * 
   * @return 
   */
  public Object[] getDecryptFiles()
  {
   FileSafeListModel lc_tModel = (FileSafeListModel) jListDecrypt.getModel();

   if (null != lc_tModel)
   {
    return lc_tModel.elements();
   }
   return null;
  }
  
  
  
  /**
   * Retrieves the array of files to decrypt
   * 
   * @return 
   */
  public Object[] getEncryptFiles()
  {
   FileSafeListModel lc_tModel = (FileSafeListModel) jListEncrypt.getModel();

   if (null != lc_tModel)
   {
    return lc_tModel.elements();
   }
   return null;
  }

  
  
  
  /**
   * Initializes the current progress bar with the given maximum value and resets its display
   * 
   * @param pa_iMaxValue  maximum value
   */
  public void initCurrentProgress(int pa_iMaxValue)
  {
   final int lc_iFugly = pa_iMaxValue;
  
   javax.swing.SwingUtilities.invokeLater(new Runnable()
   {
    public void run() 
    { 
     jProgressBarTotal.setValue(lc_iFugly);
    }
   });       
   jProgressBarCurrent.setMinimum(0); 
   jProgressBarCurrent.setMaximum(lc_iFugly);
   jProgressBarCurrent.setValue(0);
  }
  
  

  /**
   * Initializes the total progress bar with the given maximum value and resets its display
   * 
   * @param pa_iMaxValue  maximum value
   */
  public void initTotalProgress(int pa_iMaxValue)
  {
   final int lc_iFugly = pa_iMaxValue;
  
   javax.swing.SwingUtilities.invokeLater(new Runnable()
   {
    public void run() 
    { 
     jProgressBarTotal.setMinimum(0); 
     jProgressBarTotal.setMaximum(lc_iFugly);
     jProgressBarTotal.setValue(0);
    }
   });       
  }

  
  
  /**
   * Sets the current progress to the given value
   * 
   * @param pa_iValue    progress value
   */
  public void setCurrentProgress(int pa_iValue) 
  {
   final int lc_iFugly = pa_iValue;
  
   javax.swing.SwingUtilities.invokeLater(new Runnable()
   {
    public void run() 
    { 
     jProgressBarCurrent.setValue(lc_iFugly);
    }
   });       
  }
  
  
 
  /**
   * Resets the progress display
   * 
   */
  public void resetProgress()
  {
   javax.swing.SwingUtilities.invokeLater(new Runnable()
   {
    public void run() 
    { 
     setCurrentProgress(0);
     setTotalProgress(0);
   
     setCurrentFile          ("");
     setProgressModeString   ("");
     setProgressTotalString  ("");
     setProgressCurrentString("");
    }
   });       
  }
  
  

  /**
   * Sets the total progress to the given value
   * 
   * @param pa_iValue    progress value
   */
  public void setTotalProgress(int pa_iValue) 
  {
   final int lc_iFugly = pa_iValue;
  
   javax.swing.SwingUtilities.invokeLater(new Runnable()
   {
    public void run() 
    { 
     jProgressBarTotal.setValue(lc_iFugly);
    }
   });       
  }
  
  
  /**
   * Sets the curreent file to the given value
   * 
   * @param pa_sFile  file name
   */
  public void setCurrentFile(String pa_sFile)
  {
   jTextFieldProgressFile.setText(pa_sFile); 
  }
  
  
  
  /**
   * Sets the progress mode
   * 
   * @param pa_sMode 
   */
  public void setProgressModeString(String pa_sMode)  
  {
   jTextFieldProgressMode.setText(pa_sMode);  
  }
  
  
  
  /**
   * Sets the total progress
   * 
   * @param pa_sTotal 
   */
  public void setProgressTotalString(String pa_sTotal)
  {
   jTextFieldProgressTotal.setText(pa_sTotal);  
  }
  

  
  /**
   * Sets the current progress
   * 
   * @param pa_sCurrent 
   */
  public void setProgressCurrentString(String pa_sCurrent)
  {
   jTextFieldProgressCurrent.setText(pa_sCurrent); 
  }
  
  
  
  /**
   * Enables and disabled buttons according to data
   * 
   */
  public void checkButtons()
  {
   FileSafeListModel lc_tModelEncrypt = (FileSafeListModel) jListEncrypt.getModel();
   FileSafeListModel lc_tModelDecrypt = (FileSafeListModel) jListDecrypt.getModel();
   
   String lc_sEncryptDestination = jTextFieldEncryptDestination.getText();
   String lc_sDecryptDestination = jTextFieldDecryptDestination.getText();
   String lc_sLog                = jTextAreaLog.getText();
   
   boolean lc_bHasEncryptDestination = (null != lc_sEncryptDestination && false == lc_sEncryptDestination.isEmpty());
   boolean lc_bHasDecryptDestination = (null != lc_sDecryptDestination && false == lc_sDecryptDestination.isEmpty());
   boolean lc_bHasLog                = (null != lc_sLog                && false == lc_sLog.isEmpty()               );
   
   boolean lc_bHasEncryptFiles = (null != lc_tModelEncrypt ? (0 < lc_tModelEncrypt.getSize()) : false);
   boolean lc_bHasDecryptFiles = (null != lc_tModelDecrypt ? (0 < lc_tModelDecrypt.getSize()) : false);

   boolean lc_bHasEncryptSelection = (-1 != jListEncrypt.getSelectedIndex());
   boolean lc_bHasDecryptSelection = (-1 != jListDecrypt.getSelectedIndex());
   
   jButtonDecryptAdd.setEnabled              (false == m_bGuiLocked);
   jButtonEncryptAdd.setEnabled              (false == m_bGuiLocked);
   jButtonDecryptClear.setEnabled            (false == m_bGuiLocked && true == lc_bHasDecryptFiles);
   jButtonEncryptClear.setEnabled            (false == m_bGuiLocked && true == lc_bHasEncryptFiles);
   
   jButtonDecryptRemove.setEnabled           (false == m_bGuiLocked && true == lc_bHasDecryptSelection && true == lc_bHasDecryptFiles);
   jButtonEncryptRemove.setEnabled           (false == m_bGuiLocked && true == lc_bHasEncryptSelection && true == lc_bHasEncryptFiles);

   jButtonDecryptSelectDestination.setEnabled(false == m_bGuiLocked);
   jButtonEncryptSelectDestination.setEnabled(false == m_bGuiLocked);
   
   jButtonLogCopy.setEnabled                 (false == m_bGuiLocked && true == lc_bHasLog);
   jButtonProgressCancel.setEnabled          (true  == m_bGuiLocked);
   jButtonProgressStart.setEnabled           (false == m_bGuiLocked && 
                                              ((true == lc_bHasEncryptDestination && true == lc_bHasEncryptFiles) ||
                                               (true == lc_bHasDecryptDestination && true == lc_bHasDecryptFiles) ));
  }
  
  
  
  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanelProgress = new javax.swing.JPanel();
        jLabelProgressCurrent = new javax.swing.JLabel();
        jLabelProgressTotal = new javax.swing.JLabel();
        jProgressBarCurrent = new javax.swing.JProgressBar();
        jProgressBarTotal = new javax.swing.JProgressBar();
        jButtonProgressCancel = new javax.swing.JButton();
        jButtonProgressStart = new javax.swing.JButton();
        jTextFieldProgressCurrent = new javax.swing.JTextField();
        jTextFieldProgressTotal = new javax.swing.JTextField();
        jLabelProgressFile = new javax.swing.JLabel();
        jTextFieldProgressFile = new javax.swing.JTextField();
        jTextFieldProgressMode = new javax.swing.JTextField();
        jTabbedPaneFiles = new javax.swing.JTabbedPane();
        jPanelEncrypt = new javax.swing.JPanel();
        jScrollPaneEncrypt = new javax.swing.JScrollPane();
        jListEncrypt = new javax.swing.JList();
        jLabelEncryptDestination = new javax.swing.JLabel();
        jTextFieldEncryptDestination = new javax.swing.JTextField();
        jButtonEncryptAdd = new javax.swing.JButton();
        jButtonEncryptRemove = new javax.swing.JButton();
        jButtonEncryptClear = new javax.swing.JButton();
        jButtonEncryptSelectDestination = new javax.swing.JButton();
        jPanelDecrypt = new javax.swing.JPanel();
        jScrollPaneDecrypt = new javax.swing.JScrollPane();
        jListDecrypt = new javax.swing.JList();
        jLabelDecryptDestination = new javax.swing.JLabel();
        jButtonDecryptAdd = new javax.swing.JButton();
        jButtonDecryptRemove = new javax.swing.JButton();
        jButtonDecryptClear = new javax.swing.JButton();
        jButtonDecryptSelectDestination = new javax.swing.JButton();
        jTextFieldDecryptDestination = new javax.swing.JTextField();
        jPanelLog = new javax.swing.JPanel();
        jScrollPaneLog = new javax.swing.JScrollPane();
        jTextAreaLog = new javax.swing.JTextArea();
        jButtonLogCopy = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("filesafe/resources/FileSafeView"); // NOI18N
        setTitle(bundle.getString("Form.title")); // NOI18N
        setName("Form"); // NOI18N

        jPanelProgress.setBorder(javax.swing.BorderFactory.createTitledBorder(bundle.getString("jPanelProgress.border.title"))); // NOI18N
        jPanelProgress.setName("jPanelProgress"); // NOI18N

        jLabelProgressCurrent.setLabelFor(jProgressBarCurrent);
        jLabelProgressCurrent.setText(bundle.getString("jLabelProgressCurrent.text")); // NOI18N
        jLabelProgressCurrent.setName("jLabelProgressCurrent"); // NOI18N

        jLabelProgressTotal.setLabelFor(jProgressBarTotal);
        jLabelProgressTotal.setText(bundle.getString("jLabelProgressTotal.text")); // NOI18N
        jLabelProgressTotal.setName("jLabelProgressTotal"); // NOI18N

        jProgressBarCurrent.setName("jProgressBarCurrent"); // NOI18N
        jProgressBarCurrent.setStringPainted(true);

        jProgressBarTotal.setName("jProgressBarTotal"); // NOI18N
        jProgressBarTotal.setStringPainted(true);

        jButtonProgressCancel.setText(bundle.getString("jButtonProgressCancel.text")); // NOI18N
        jButtonProgressCancel.setEnabled(false);
        jButtonProgressCancel.setName("jButtonProgressCancel"); // NOI18N
        jButtonProgressCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                actionPerformedButtonCancel(evt);
            }
        });

        jButtonProgressStart.setText(bundle.getString("jButtonProgressStart.text")); // NOI18N
        jButtonProgressStart.setEnabled(false);
        jButtonProgressStart.setName("jButtonProgressStart"); // NOI18N
        jButtonProgressStart.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                actionPerformedButtonStart(evt);
            }
        });

        jTextFieldProgressCurrent.setEditable(false);
        jTextFieldProgressCurrent.setText(bundle.getString("jTextFieldProgressCurrent.text")); // NOI18N
        jTextFieldProgressCurrent.setName("jTextFieldProgressCurrent"); // NOI18N

        jTextFieldProgressTotal.setEditable(false);
        jTextFieldProgressTotal.setText(bundle.getString("jTextFieldProgressTotal.text")); // NOI18N
        jTextFieldProgressTotal.setName("jTextFieldProgressTotal"); // NOI18N

        jLabelProgressFile.setText(bundle.getString("jLabelProgressFile.text")); // NOI18N
        jLabelProgressFile.setName("jLabelProgressFile"); // NOI18N

        jTextFieldProgressFile.setEditable(false);
        jTextFieldProgressFile.setText(bundle.getString("jTextFieldProgressFile.text")); // NOI18N
        jTextFieldProgressFile.setName("jTextFieldProgressFile"); // NOI18N

        jTextFieldProgressMode.setEditable(false);
        jTextFieldProgressMode.setText(bundle.getString("jTextFieldProgressMode.text")); // NOI18N
        jTextFieldProgressMode.setName("jTextFieldProgressMode"); // NOI18N

        javax.swing.GroupLayout jPanelProgressLayout = new javax.swing.GroupLayout(jPanelProgress);
        jPanelProgress.setLayout(jPanelProgressLayout);
        jPanelProgressLayout.setHorizontalGroup(
            jPanelProgressLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelProgressLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanelProgressLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanelProgressLayout.createSequentialGroup()
                        .addComponent(jLabelProgressFile)
                        .addGap(18, 18, 18)
                        .addComponent(jTextFieldProgressFile, javax.swing.GroupLayout.DEFAULT_SIZE, 325, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextFieldProgressMode, javax.swing.GroupLayout.PREFERRED_SIZE, 36, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanelProgressLayout.createSequentialGroup()
                        .addComponent(jButtonProgressStart)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonProgressCancel))
                    .addGroup(jPanelProgressLayout.createSequentialGroup()
                        .addGroup(jPanelProgressLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanelProgressLayout.createSequentialGroup()
                                .addComponent(jLabelProgressTotal)
                                .addGap(18, 18, 18)
                                .addComponent(jProgressBarTotal, javax.swing.GroupLayout.DEFAULT_SIZE, 325, Short.MAX_VALUE))
                            .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanelProgressLayout.createSequentialGroup()
                                .addComponent(jLabelProgressCurrent)
                                .addGap(18, 18, 18)
                                .addComponent(jProgressBarCurrent, javax.swing.GroupLayout.DEFAULT_SIZE, 325, Short.MAX_VALUE)))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanelProgressLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(jTextFieldProgressCurrent, javax.swing.GroupLayout.PREFERRED_SIZE, 36, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jTextFieldProgressTotal, javax.swing.GroupLayout.PREFERRED_SIZE, 36, javax.swing.GroupLayout.PREFERRED_SIZE))))
                .addContainerGap())
        );

        jPanelProgressLayout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {jLabelProgressCurrent, jLabelProgressFile, jLabelProgressTotal});

        jPanelProgressLayout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {jButtonProgressCancel, jButtonProgressStart});

        jPanelProgressLayout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {jTextFieldProgressCurrent, jTextFieldProgressMode, jTextFieldProgressTotal});

        jPanelProgressLayout.setVerticalGroup(
            jPanelProgressLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelProgressLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanelProgressLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabelProgressFile)
                    .addComponent(jTextFieldProgressFile, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jTextFieldProgressMode, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelProgressLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabelProgressCurrent)
                    .addGroup(jPanelProgressLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jProgressBarCurrent, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldProgressCurrent, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelProgressLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabelProgressTotal)
                    .addGroup(jPanelProgressLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jProgressBarTotal, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jTextFieldProgressTotal, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addGap(18, 18, 18)
                .addGroup(jPanelProgressLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonProgressCancel)
                    .addComponent(jButtonProgressStart))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanelProgressLayout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {jLabelProgressCurrent, jLabelProgressFile, jLabelProgressTotal, jProgressBarCurrent, jProgressBarTotal, jTextFieldProgressCurrent, jTextFieldProgressFile, jTextFieldProgressMode, jTextFieldProgressTotal});

        jPanelProgressLayout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {jButtonProgressCancel, jButtonProgressStart});

        jTabbedPaneFiles.setName("jTabbedPaneFiles"); // NOI18N

        jPanelEncrypt.setName("jPanelEncrypt"); // NOI18N

        jScrollPaneEncrypt.setName("jScrollPaneEncrypt"); // NOI18N

        jListEncrypt.setBackground(new java.awt.Color(Integer.valueOf(bundle.getString("jList.background"), 16)));
        jListEncrypt.setForeground(new java.awt.Color(Integer.valueOf(bundle.getString("jList.foreground"), 16)));
        jListEncrypt.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        jListEncrypt.setName("jListEncrypt"); // NOI18N
        jListEncrypt.setSelectionBackground(new java.awt.Color(Integer.valueOf(bundle.getString("jList.selectionBackground"), 16)));
        jListEncrypt.setSelectionForeground(new java.awt.Color(Integer.valueOf(bundle.getString("jList.selectionForeground"), 16)));
        jScrollPaneEncrypt.setViewportView(jListEncrypt);

        jLabelEncryptDestination.setLabelFor(jTextFieldEncryptDestination);
        jLabelEncryptDestination.setText(bundle.getString("jLabelEncryptDestination.text")); // NOI18N
        jLabelEncryptDestination.setName("jLabelEncryptDestination"); // NOI18N

        jTextFieldEncryptDestination.setEditable(false);
        jTextFieldEncryptDestination.setText(bundle.getString("jTextFieldEncryptDestination.text")); // NOI18N
        jTextFieldEncryptDestination.setName("jTextFieldEncryptDestination"); // NOI18N

        jButtonEncryptAdd.setText(bundle.getString("jButtonEncryptAdd.text")); // NOI18N
        jButtonEncryptAdd.setName("jButtonEncryptAdd"); // NOI18N
        jButtonEncryptAdd.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                actionPerformedButtonEncryptAdd(evt);
            }
        });

        jButtonEncryptRemove.setText(bundle.getString("jButtonEncryptRemove.text")); // NOI18N
        jButtonEncryptRemove.setEnabled(false);
        jButtonEncryptRemove.setName("jButtonEncryptRemove"); // NOI18N
        jButtonEncryptRemove.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                actionPerformedButtonEncryptRemove(evt);
            }
        });

        jButtonEncryptClear.setText(bundle.getString("jButtonEncryptClear.text")); // NOI18N
        jButtonEncryptClear.setEnabled(false);
        jButtonEncryptClear.setName("jButtonEncryptClear"); // NOI18N
        jButtonEncryptClear.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                actionPerformedButtonEncryptClear(evt);
            }
        });

        jButtonEncryptSelectDestination.setText(bundle.getString("jButtonEncryptSelectDestination.text")); // NOI18N
        jButtonEncryptSelectDestination.setName("jButtonEncryptSelectDestination"); // NOI18N
        jButtonEncryptSelectDestination.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                actionPerformedButtonEncryptSelectDestination(evt);
            }
        });

        javax.swing.GroupLayout jPanelEncryptLayout = new javax.swing.GroupLayout(jPanelEncrypt);
        jPanelEncrypt.setLayout(jPanelEncryptLayout);
        jPanelEncryptLayout.setHorizontalGroup(
            jPanelEncryptLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelEncryptLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanelEncryptLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanelEncryptLayout.createSequentialGroup()
                        .addComponent(jLabelEncryptDestination)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextFieldEncryptDestination, javax.swing.GroupLayout.DEFAULT_SIZE, 280, Short.MAX_VALUE))
                    .addComponent(jScrollPaneEncrypt, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 338, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelEncryptLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jButtonEncryptSelectDestination, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jButtonEncryptClear, javax.swing.GroupLayout.DEFAULT_SIZE, 85, Short.MAX_VALUE)
                    .addComponent(jButtonEncryptAdd, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 85, Short.MAX_VALUE)
                    .addComponent(jButtonEncryptRemove, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 85, Short.MAX_VALUE))
                .addContainerGap())
        );

        jPanelEncryptLayout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {jButtonEncryptAdd, jButtonEncryptClear, jButtonEncryptRemove, jButtonEncryptSelectDestination});

        jPanelEncryptLayout.setVerticalGroup(
            jPanelEncryptLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanelEncryptLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanelEncryptLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPaneEncrypt, javax.swing.GroupLayout.DEFAULT_SIZE, 212, Short.MAX_VALUE)
                    .addGroup(jPanelEncryptLayout.createSequentialGroup()
                        .addComponent(jButtonEncryptAdd)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonEncryptRemove)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonEncryptClear)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanelEncryptLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jLabelEncryptDestination)
                    .addGroup(jPanelEncryptLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jTextFieldEncryptDestination, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jButtonEncryptSelectDestination)))
                .addContainerGap())
        );

        jPanelEncryptLayout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {jButtonEncryptAdd, jButtonEncryptClear, jButtonEncryptRemove, jButtonEncryptSelectDestination, jLabelEncryptDestination, jTextFieldEncryptDestination});

        jTabbedPaneFiles.addTab(bundle.getString("jPanelEncrypt.TabConstraints.tabTitle"), jPanelEncrypt); // NOI18N

        jPanelDecrypt.setName("jPanelDecrypt"); // NOI18N

        jScrollPaneDecrypt.setName("jScrollPaneDecrypt"); // NOI18N

        jListDecrypt.setBackground(new java.awt.Color(Integer.valueOf(bundle.getString("jList.background"), 16)));
        jListDecrypt.setForeground(new java.awt.Color(Integer.valueOf(bundle.getString("jList.foreground"), 16)));
        jListDecrypt.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        jListDecrypt.setName("jListDecrypt"); // NOI18N
        jListDecrypt.setSelectionBackground(new java.awt.Color(Integer.valueOf(bundle.getString("jList.selectionBackground"), 16)));
        jListDecrypt.setSelectionForeground(new java.awt.Color(Integer.valueOf(bundle.getString("jList.selectionForeground"), 16)));
        jScrollPaneDecrypt.setViewportView(jListDecrypt);

        jLabelDecryptDestination.setText(bundle.getString("jLabelDecryptDestination.text")); // NOI18N
        jLabelDecryptDestination.setName("jLabelDecryptDestination"); // NOI18N

        jButtonDecryptAdd.setText(bundle.getString("jButtonDecryptAdd.text")); // NOI18N
        jButtonDecryptAdd.setName("jButtonDecryptAdd"); // NOI18N
        jButtonDecryptAdd.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                actionPerformedButtonDecryptAdd(evt);
            }
        });

        jButtonDecryptRemove.setText(bundle.getString("jButtonDecryptRemove.text")); // NOI18N
        jButtonDecryptRemove.setEnabled(false);
        jButtonDecryptRemove.setName("jButtonDecryptRemove"); // NOI18N
        jButtonDecryptRemove.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                actionPerformedButtonDecryptRemove(evt);
            }
        });

        jButtonDecryptClear.setText(bundle.getString("jButtonDecryptClear.text")); // NOI18N
        jButtonDecryptClear.setEnabled(false);
        jButtonDecryptClear.setName("jButtonDecryptClear"); // NOI18N
        jButtonDecryptClear.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                actionPerformedButtonDecryptClear(evt);
            }
        });

        jButtonDecryptSelectDestination.setText(bundle.getString("jButtonDecryptSelectDestination.text")); // NOI18N
        jButtonDecryptSelectDestination.setName("jButtonDecryptSelectDestination"); // NOI18N
        jButtonDecryptSelectDestination.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                actionPerformedButtonDecryptSelectDestination(evt);
            }
        });

        jTextFieldDecryptDestination.setEditable(false);
        jTextFieldDecryptDestination.setText(bundle.getString("jTextFieldDecryptDestination.text")); // NOI18N
        jTextFieldDecryptDestination.setName("jTextFieldDecryptDestination"); // NOI18N

        javax.swing.GroupLayout jPanelDecryptLayout = new javax.swing.GroupLayout(jPanelDecrypt);
        jPanelDecrypt.setLayout(jPanelDecryptLayout);
        jPanelDecryptLayout.setHorizontalGroup(
            jPanelDecryptLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelDecryptLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanelDecryptLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanelDecryptLayout.createSequentialGroup()
                        .addComponent(jLabelDecryptDestination)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextFieldDecryptDestination, javax.swing.GroupLayout.DEFAULT_SIZE, 276, Short.MAX_VALUE))
                    .addComponent(jScrollPaneDecrypt, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 334, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelDecryptLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(jPanelDecryptLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                        .addComponent(jButtonDecryptRemove, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(jButtonDecryptClear, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(jButtonDecryptAdd, javax.swing.GroupLayout.PREFERRED_SIZE, 89, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(jButtonDecryptSelectDestination, javax.swing.GroupLayout.PREFERRED_SIZE, 81, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );

        jPanelDecryptLayout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {jButtonDecryptAdd, jButtonDecryptClear, jButtonDecryptRemove, jButtonDecryptSelectDestination});

        jPanelDecryptLayout.setVerticalGroup(
            jPanelDecryptLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelDecryptLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanelDecryptLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanelDecryptLayout.createSequentialGroup()
                        .addComponent(jButtonDecryptAdd)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonDecryptRemove)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonDecryptClear))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanelDecryptLayout.createSequentialGroup()
                        .addComponent(jScrollPaneDecrypt, javax.swing.GroupLayout.DEFAULT_SIZE, 212, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addGroup(jPanelDecryptLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabelDecryptDestination)
                            .addComponent(jTextFieldDecryptDestination, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jButtonDecryptSelectDestination))))
                .addContainerGap())
        );

        jPanelDecryptLayout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {jButtonDecryptAdd, jButtonDecryptClear, jButtonDecryptRemove, jButtonDecryptSelectDestination, jLabelDecryptDestination, jTextFieldDecryptDestination});

        jTabbedPaneFiles.addTab(bundle.getString("jPanelDecrypt.TabConstraints.tabTitle"), jPanelDecrypt); // NOI18N

        jPanelLog.setName("jPanelLog"); // NOI18N

        jScrollPaneLog.setName("jScrollPaneLog"); // NOI18N

        jTextAreaLog.setColumns(20);
        jTextAreaLog.setEditable(false);
        jTextAreaLog.setRows(5);
        jTextAreaLog.setName("jTextAreaLog"); // NOI18N
        jScrollPaneLog.setViewportView(jTextAreaLog);

        jButtonLogCopy.setText(bundle.getString("jButtonLogCopy.text")); // NOI18N
        jButtonLogCopy.setEnabled(false);
        jButtonLogCopy.setName("jButtonLogCopy"); // NOI18N
        jButtonLogCopy.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                actionPerformedButtonCopyToClipboard(evt);
            }
        });

        javax.swing.GroupLayout jPanelLogLayout = new javax.swing.GroupLayout(jPanelLog);
        jPanelLog.setLayout(jPanelLogLayout);
        jPanelLogLayout.setHorizontalGroup(
            jPanelLogLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanelLogLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanelLogLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jButtonLogCopy, javax.swing.GroupLayout.PREFERRED_SIZE, 141, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jScrollPaneLog, javax.swing.GroupLayout.DEFAULT_SIZE, 429, Short.MAX_VALUE))
                .addContainerGap())
        );
        jPanelLogLayout.setVerticalGroup(
            jPanelLogLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanelLogLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPaneLog, javax.swing.GroupLayout.DEFAULT_SIZE, 217, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jButtonLogCopy)
                .addContainerGap())
        );

        jTabbedPaneFiles.addTab(bundle.getString("jPanelLog.TabConstraints.tabTitle"), jPanelLog); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jPanelProgress, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jTabbedPaneFiles, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 454, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jTabbedPaneFiles, javax.swing.GroupLayout.DEFAULT_SIZE, 296, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanelProgress, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

  private void actionPerformedButtonEncryptAdd(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_actionPerformedButtonEncryptAdd
    if (null != m_tGuiConnector) m_tGuiConnector.handleButtonEncryptAdd();
  }//GEN-LAST:event_actionPerformedButtonEncryptAdd

  private void actionPerformedButtonEncryptRemove(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_actionPerformedButtonEncryptRemove
    if (null != m_tGuiConnector) m_tGuiConnector.handleButtonEncryptRemove();
  }//GEN-LAST:event_actionPerformedButtonEncryptRemove

  private void actionPerformedButtonEncryptClear(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_actionPerformedButtonEncryptClear
    if (null != m_tGuiConnector) m_tGuiConnector.handleButtonEncryptClear();
  }//GEN-LAST:event_actionPerformedButtonEncryptClear

  private void actionPerformedButtonEncryptSelectDestination(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_actionPerformedButtonEncryptSelectDestination
    if (null != m_tGuiConnector) m_tGuiConnector.handleButtonEncryptSelectDestination();
  }//GEN-LAST:event_actionPerformedButtonEncryptSelectDestination

  private void actionPerformedButtonDecryptAdd(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_actionPerformedButtonDecryptAdd
    if (null != m_tGuiConnector) m_tGuiConnector.handleButtonDecryptAdd();
  }//GEN-LAST:event_actionPerformedButtonDecryptAdd

  private void actionPerformedButtonDecryptRemove(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_actionPerformedButtonDecryptRemove
    if (null != m_tGuiConnector) m_tGuiConnector.handleButtonDecryptRemove();
  }//GEN-LAST:event_actionPerformedButtonDecryptRemove

  private void actionPerformedButtonDecryptClear(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_actionPerformedButtonDecryptClear
    if (null != m_tGuiConnector) m_tGuiConnector.handleButtonDecryptClear();
  }//GEN-LAST:event_actionPerformedButtonDecryptClear

  private void actionPerformedButtonDecryptSelectDestination(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_actionPerformedButtonDecryptSelectDestination
    if (null != m_tGuiConnector) m_tGuiConnector.handleButtonDecryptSelectDestination();
  }//GEN-LAST:event_actionPerformedButtonDecryptSelectDestination

  private void actionPerformedButtonStart(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_actionPerformedButtonStart
    if (null != m_tGuiConnector) m_tGuiConnector.handleButtonStart();
  }//GEN-LAST:event_actionPerformedButtonStart

  private void actionPerformedButtonCancel(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_actionPerformedButtonCancel
    if (null != m_tGuiConnector) m_tGuiConnector.handleButtonCancel();
  }//GEN-LAST:event_actionPerformedButtonCancel

  private void actionPerformedButtonCopyToClipboard(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_actionPerformedButtonCopyToClipboard
    if (null != m_tGuiConnector) m_tGuiConnector.handleButtonCopyToClipboard();    // TODO add your handling code here:
  }//GEN-LAST:event_actionPerformedButtonCopyToClipboard

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonDecryptAdd;
    private javax.swing.JButton jButtonDecryptClear;
    private javax.swing.JButton jButtonDecryptRemove;
    private javax.swing.JButton jButtonDecryptSelectDestination;
    private javax.swing.JButton jButtonEncryptAdd;
    private javax.swing.JButton jButtonEncryptClear;
    private javax.swing.JButton jButtonEncryptRemove;
    private javax.swing.JButton jButtonEncryptSelectDestination;
    private javax.swing.JButton jButtonLogCopy;
    private javax.swing.JButton jButtonProgressCancel;
    private javax.swing.JButton jButtonProgressStart;
    private javax.swing.JLabel jLabelDecryptDestination;
    private javax.swing.JLabel jLabelEncryptDestination;
    private javax.swing.JLabel jLabelProgressCurrent;
    private javax.swing.JLabel jLabelProgressFile;
    private javax.swing.JLabel jLabelProgressTotal;
    private javax.swing.JList jListDecrypt;
    private javax.swing.JList jListEncrypt;
    private javax.swing.JPanel jPanelDecrypt;
    private javax.swing.JPanel jPanelEncrypt;
    private javax.swing.JPanel jPanelLog;
    private javax.swing.JPanel jPanelProgress;
    private javax.swing.JProgressBar jProgressBarCurrent;
    private javax.swing.JProgressBar jProgressBarTotal;
    private javax.swing.JScrollPane jScrollPaneDecrypt;
    private javax.swing.JScrollPane jScrollPaneEncrypt;
    private javax.swing.JScrollPane jScrollPaneLog;
    private javax.swing.JTabbedPane jTabbedPaneFiles;
    private javax.swing.JTextArea jTextAreaLog;
    private javax.swing.JTextField jTextFieldDecryptDestination;
    private javax.swing.JTextField jTextFieldEncryptDestination;
    private javax.swing.JTextField jTextFieldProgressCurrent;
    private javax.swing.JTextField jTextFieldProgressFile;
    private javax.swing.JTextField jTextFieldProgressMode;
    private javax.swing.JTextField jTextFieldProgressTotal;
    // End of variables declaration//GEN-END:variables
}
