/*
 * KeySafe
 * 
 * A simple password safe.
 * 
 */
package keysafe;


/**
 * Imports
 * 
 */
import java.text.Collator;
import java.util.Locale  ;



/**
 * Data container for a single entry
 * 
 * @author Ulf Wagemann
 */
public class KeySafeEntry implements Comparable<KeySafeEntry>
{
 private String m_sLabel   ; 
 private String m_sUser    ;
 private String m_sPassword;
 
 
 
 /**
  * Constructor
  * 
  * @param pa_sLabel     label to display in list
  * @param pa_sUser      user name
  * @param pa_sPassword  password
  */
 public KeySafeEntry(String pa_sLabel, String pa_sUser, String pa_sPassword)
 {
  m_sLabel     = pa_sLabel  ;
  m_sUser      = pa_sUser   ; 
  m_sPassword = pa_sPassword;
 }
 
 
 
 /**
  * Constructor
  * 
  * @param pa_tEntry     entry to copy
  */
 public KeySafeEntry(KeySafeEntry pa_tEntry)
 {
  if (null != pa_tEntry)
  {
   m_sLabel     = pa_tEntry.getLabel()   ;
   m_sUser      = pa_tEntry.getUser()    ; 
   m_sPassword  = pa_tEntry.getPassword();
  }
  else
  {
   m_sLabel    = null;
   m_sUser     = null;
   m_sPassword = null;
  }
 }
 
 
 
 /**
  * Sets the label
  * 
  * @param pa_sLabel   label
  */
 public void setLabel(String pa_sLabel) {m_sLabel = pa_sLabel;}

 
 
 /**
  * Sets the user
  * 
  * @param pa_sUser   user
  */
 public void setUser(String pa_sUser) {m_sUser = pa_sUser;}

 
 
 /**
  * Sets the password
  * 
  * @param pa_sPassword   password
  */
 public void setPassword(String pa_sPassword) {m_sPassword = pa_sPassword;} 
 
 
 
 /**
  * Returns the label
  * 
  * @return label
  */
 public String getLabel() {return m_sLabel;}

 
 
 /**
  * Returns the user
  * 
  * @return user
  */
 public String getUser() {return m_sUser;}
 
 
 
 /**
  * Returns the password
  * 
  * @return password
  */
 public String getPassword() {return m_sPassword;}

 
 /**
  * Comparable.compareTo
  * 
  * @param o
  * @return 
  */
  public int compareTo(KeySafeEntry pa_tEntry) 
  {
   Collator lc_tCollator = Collator.getInstance(Locale.getDefault()); 
   
   if (null != lc_tCollator)
   {
    lc_tCollator.setStrength(Collator.IDENTICAL); 
    return lc_tCollator.compare(getLabel(), pa_tEntry.getLabel());   
   }
   else
   {
    if (null == pa_tEntry)
    {
     return 1;
    }
    else
    {
     return getLabel().compareTo(pa_tEntry.getLabel()); 
    }
   }
  }
 
 
  
  /**
   * Tests whether all data is identical 
   * 
   * @param pa_tEntry   object to compare
   * @return  true, if all stuff is identical, false otherwise
   */
  public boolean isEqual(KeySafeEntry pa_tEntry)
  {
   Collator lc_tCollator = Collator.getInstance(Locale.getDefault()); 
   boolean  lc_bEqual    = false;
   
   if (null != pa_tEntry)
   {
    if (null != lc_tCollator)
    {
     lc_tCollator.setStrength(Collator.IDENTICAL); 
     
     lc_bEqual  = true;
     lc_bEqual &= (0 == lc_tCollator.compare(getLabel()   , pa_tEntry.getLabel())   );
     lc_bEqual &= (0 == lc_tCollator.compare(getUser()    , pa_tEntry.getUser())    );
     lc_bEqual &= (0 == lc_tCollator.compare(getPassword(), pa_tEntry.getPassword()));
    }  
   }
   return lc_bEqual;
  }
  
} // eoc
