/**
 * KeySafe
 * 
 * A simple password safe.
 * 
 */
package keysafe;



/**
 * Entry dialog
 * 
 * @author Ulf Wagemann
 */
public class KeySafeEntryDialog extends    javax.swing.JDialog 
                              implements java.awt.event.ActionListener,
                                         javax.swing.event.DocumentListener
{
 private int m_iButtonPressed;
 
 
 
 /**
  * Constructor
  * 
  * @param pa_tParent  parent JFrame
  * @param pa_bModal   true for modal, false for non-modal 
  */
  public KeySafeEntryDialog(java.awt.Frame pa_tParent, boolean pa_bModal) 
  {
   super(pa_tParent, pa_bModal);
   initComponents();
   centerOnParentView(pa_tParent);
   
   //
   // add our own button event handlers
   //
   jButtonCancel.addActionListener((java.awt.event.ActionListener) this);
   jButtonOk.addActionListener    ((java.awt.event.ActionListener) this);
   
   //
   // add event handlers to text fields
   //
   jTextFieldLabel.setDocument(new KeySafeTextDocument());
   jTextFieldLabel.getDocument().addDocumentListener((javax.swing.event.DocumentListener) this);

   jTextFieldUser.setDocument(new KeySafeTextDocument());
   jTextFieldUser.getDocument().addDocumentListener((javax.swing.event.DocumentListener) this);
   
   jTextFieldPassword.setDocument(new KeySafeTextDocument());
   jTextFieldPassword.getDocument().addDocumentListener((javax.swing.event.DocumentListener) this);
   
   m_iButtonPressed = 0;
  }

  
  
  /**
   * Sets data according to the given object
   * 
   * @param pa_tRecord   data
   */
  public void setData(KeySafeEntry pa_tRecord)
  {
   if (null != pa_tRecord) 
   {
    jTextFieldLabel.setText(pa_tRecord.getLabel());
    jTextFieldUser.setText(pa_tRecord.getUser());
    jTextFieldPassword.setText(pa_tRecord.getPassword());
   }
  }
  
  
  
  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabelLabel = new javax.swing.JLabel();
        jButtonCancel = new javax.swing.JButton();
        jButtonOk = new javax.swing.JButton();
        jLabelPassword = new javax.swing.JLabel();
        jTextFieldLabel = new javax.swing.JTextField();
        jTextFieldPassword = new javax.swing.JTextField();
        jLabelUser = new javax.swing.JLabel();
        jTextFieldUser = new javax.swing.JTextField();

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("keysafe/resources/KeySafeEntryDialog"); // NOI18N
        setTitle(bundle.getString("Form.title")); // NOI18N
        setAlwaysOnTop(true);
        setModal(true);
        setName("Form"); // NOI18N

        jLabelLabel.setText(bundle.getString("jLabelLabel.text")); // NOI18N
        jLabelLabel.setName("jLabelLabel"); // NOI18N

        jButtonCancel.setText(bundle.getString("jButtonCancel.text")); // NOI18N
        jButtonCancel.setName("jButtonCancel"); // NOI18N

        jButtonOk.setText(bundle.getString("jButtonOk.text")); // NOI18N
        jButtonOk.setEnabled(false);
        jButtonOk.setName("jButtonOk"); // NOI18N

        jLabelPassword.setText(bundle.getString("jLabelPassword.text")); // NOI18N
        jLabelPassword.setName("jLabelPassword"); // NOI18N

        jTextFieldLabel.setText(bundle.getString("jTextFieldLabel.text")); // NOI18N
        jTextFieldLabel.setName("jTextFieldLabel"); // NOI18N

        jTextFieldPassword.setText(bundle.getString("jTextFieldPassword.text")); // NOI18N
        jTextFieldPassword.setName("jTextFieldPassword"); // NOI18N

        jLabelUser.setText(bundle.getString("jLabelUser.text")); // NOI18N
        jLabelUser.setName("jLabelUser"); // NOI18N

        java.util.ResourceBundle bundle1 = java.util.ResourceBundle.getBundle("keysafe/resources/KeySafeSetupDialog"); // NOI18N
        jTextFieldUser.setText(bundle1.getString("jTextFieldUser.text")); // NOI18N
        jTextFieldUser.setName("jTextFieldUser"); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabelUser, javax.swing.GroupLayout.PREFERRED_SIZE, 62, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabelPassword, javax.swing.GroupLayout.PREFERRED_SIZE, 54, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabelLabel))
                        .addGap(20, 20, 20)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jTextFieldLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 227, Short.MAX_VALUE)
                            .addComponent(jTextFieldUser, javax.swing.GroupLayout.DEFAULT_SIZE, 227, Short.MAX_VALUE)
                            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                                .addComponent(jButtonCancel, javax.swing.GroupLayout.DEFAULT_SIZE, 110, Short.MAX_VALUE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jButtonOk, javax.swing.GroupLayout.DEFAULT_SIZE, 111, Short.MAX_VALUE))
                            .addComponent(jTextFieldPassword, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 227, Short.MAX_VALUE))))
                .addContainerGap())
        );

        layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {jLabelLabel, jLabelPassword, jLabelUser});

        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabelLabel)
                    .addComponent(jTextFieldLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabelUser)
                    .addComponent(jTextFieldUser, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabelPassword)
                    .addComponent(jTextFieldPassword, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, Short.MAX_VALUE)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonCancel)
                    .addComponent(jButtonOk))
                .addContainerGap())
        );

        layout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {jButtonCancel, jButtonOk, jLabelLabel, jLabelPassword, jLabelUser, jTextFieldLabel, jTextFieldPassword, jTextFieldUser});

        pack();
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonCancel;
    private javax.swing.JButton jButtonOk;
    private javax.swing.JLabel jLabelLabel;
    private javax.swing.JLabel jLabelPassword;
    private javax.swing.JLabel jLabelUser;
    private javax.swing.JTextField jTextFieldLabel;
    private javax.swing.JTextField jTextFieldPassword;
    private javax.swing.JTextField jTextFieldUser;
    // End of variables declaration//GEN-END:variables


 /**
  * ActionListener method to catch buttons. Hide the dialog and store button.
     * 
  * @param pa_tEvent   button event 
  */  
  public void actionPerformed(java.awt.event.ActionEvent pa_tEvent) 
  {
   if (null != pa_tEvent)
   {
    if (pa_tEvent.getSource() == jButtonCancel) 
    {
     m_iButtonPressed = -1; 
    }
    else if (pa_tEvent.getSource() == jButtonOk)
    {
     m_iButtonPressed = 1;  
    }
    this.setVisible(false);
   }
  }
  
  
  
 /**
  * Handles a change-event any text-field. The Ok button gets enabled as soon
  * as text-length is greater than KSA_MIN_LENGTH chars and both texts are equal.
  * 
  * @param pa_tEvent   document event
  */ 
  public void changedUpdate(javax.swing.event.DocumentEvent pa_tEvent) 
  {
   checkOkButton();
  }
  
  
 /**
  * Handles a remove-event any text-field. The Ok button gets enabled as soon
  * as text-length is greater than KSA_MIN_LENGTH chars and both texts are equal.
  * 
  * @param pa_tEvent document event
  */
  public void removeUpdate(javax.swing.event.DocumentEvent pa_tEvent) 
  {
   checkOkButton();
  }

  
 /**
  * Handles an insert-event any text-field. The Ok button gets enabled as soon
  * as text-length is greater than KSA_MIN_LENGTH chars and both texts are equal.
  * 
  * @param pa_tEvent document event
  */
  public void insertUpdate(javax.swing.event.DocumentEvent pa_tEvent) 
  {
   checkOkButton();
  }

  
  
  /**
   * Enables or disables the Ok button according to text input
   * 
   */  
  private void checkOkButton()
  {
   String  lc_sPassword = jTextFieldPassword.getText();
   String  lc_sLabel    = jTextFieldLabel.getText()   ;
   String  lc_sUser     = jTextFieldUser.getText()    ;
   boolean lc_bEnabled  = false;
   
   if (null != lc_sPassword && null != lc_sLabel && null != lc_sUser)
   {
    lc_bEnabled = (lc_sLabel.length() >= 1 && lc_sUser.length() >= 1 && lc_sPassword.length() >= KeySafeConstants.KSA_MIN_LENGTH); 
   }
   jButtonOk.setEnabled(lc_bEnabled);
  }
 
  
  
  /**
   * Centers the dialof view on the parent view
   * 
   * @param pa_tParent   parent JFrame
   */
  private void centerOnParentView(java.awt.Frame pa_tParent)
  {
   java.awt.Rectangle lc_tBounds      = (null != pa_tParent ? pa_tParent.getBounds() : null);
   java.awt.Dimension lc_tSize        = getSize();
   java.awt.Point     lc_tNewLocation = new java.awt.Point();
   
   if (null != lc_tBounds && null != lc_tSize && null != lc_tNewLocation)
   {
    lc_tNewLocation.x = lc_tBounds.x + (lc_tBounds.width /2) - (lc_tSize.width /2); 
    lc_tNewLocation.y = lc_tBounds.y + (lc_tBounds.height/2) - (lc_tSize.height/2); 
   
    if (0 > lc_tNewLocation.x) lc_tNewLocation.x = 0;
    if (0 > lc_tNewLocation.y) lc_tNewLocation.y = 0;
    
    setLocation(lc_tNewLocation);
   }
  }
  
  
  
  /**
   * Returns the pressed button
   * 
   * @return   -1 in case of cancel, 1 in case of ok
   */
  public int getButtonPressed() {return m_iButtonPressed;};
  
  
  
  /**
   * Returns the password
   * 
   * @return password
   */
  public String getPassword() {return jTextFieldPassword.getText();};


  
  /**
   * Returns the label
   * 
   * @return label
   */
  public String getLabel() {return jTextFieldLabel.getText();};


  /**
   * Returns the user
   * 
   * @return user
   */
  public String getUser() {return jTextFieldUser.getText();};
}
