/**
 * KeySafe
 * 
 * A simple password safe.
 * 
 */
package keysafe;



/**
 * Imports
 * 
 */
import java.util.SortedSet ;
import java.util.TreeSet   ;
import java.util.Collection;
import java.util.Arrays    ;
import java.util.Iterator  ;
import javax.swing.AbstractListModel;



/**
 * Sorted list model based on SortedTree
 * 
 * @author Ulf Wagemann
 */
public class KeySafeListModel extends AbstractListModel 
{
 SortedSet<Object> m_tModel;

 
 
 /**
  * Constructor
  * 
  */
  public KeySafeListModel() 
  {
   m_tModel = new TreeSet<Object>();
  }

  
  /**
   * Returns the model's size
   * 
   * @return   size, may be 0
   */
  public int getSize() 
  {
   return (null != m_tModel ? m_tModel.size() : 0);
  }

  
  
  /**
   * Returns the element at the given position
   * 
   * @param pa_iIndex   position
   * @return object, may be null
   */
  public Object getElementAt(int pa_iIndex) 
  {
   if (null != m_tModel) 
   {
    if (0 <= pa_iIndex && pa_iIndex <= (m_tModel.size()-1))
    {
     return m_tModel.toArray()[pa_iIndex]; 
    }
   }
   return null;
  }


  
  /**
   * Returns an array of elements
   * 
   * @return   array of elements, may be null
   */
  public Object[] elements()
  {
   if (null != m_tModel) 
   {
    return (0 < m_tModel.size() ? m_tModel.toArray() : null); 
   }
   return null;
  }
  
  
  
  /**
   * Adds an element
   * 
   * @param pa_tElement new element
   */
  public void add(Object pa_tElement) 
  {
   if (null != m_tModel)
   {
    if (m_tModel.add(pa_tElement)) 
    {
     fireContentsChanged(this, 0, getSize());
    }
   }
  }
  
  
  
  /**
   * Adds all given elements
   * 
   * @param pa_tElements new elements
   */
  public void addAll(Object pa_tElements[]) 
  {
   Collection<Object> lc_tCollection = null;
   
   if (null != m_tModel && null != pa_tElements)
   {
    if (null != (lc_tCollection = Arrays.asList(pa_tElements)))
    {
     m_tModel.addAll(lc_tCollection);
     fireContentsChanged(this, 0, getSize());
    }
   }
  }

  
  
  /**
   * Clears the model
   * 
   */
  public void clear() 
  {
   if (null != m_tModel)
   {
    m_tModel.clear();
    fireContentsChanged(this, 0, getSize());
   }
  }

  
  
  /**
   * Tests whether the given object is element of the model
   * 
   * @param pa_tElement  element to test
   * @return false, if the object is not part of the model, true otherwise
   */
  public boolean contains(Object pa_tElement) 
  {
   return (null != m_tModel ? m_tModel.contains(pa_tElement) : false);
  }

  
  
  /**
   * Returns the first element
   * 
   * @return first element, may be null
   */
  public Object firstElement() 
  {
   return (null != m_tModel ?  m_tModel.first() : null);
  }

  
  
  /**
   * Returns the last element
   * 
   * @return last element, may be null
   */
  public Object lastElement() 
  {
   return (null != m_tModel ?  m_tModel.last() : null);
  }

  
  
  /**
   * Returns the iterator
   * 
   * @return  iterator, may be null
   */
  public Iterator iterator() 
  {
   return (null != m_tModel ? m_tModel.iterator() : null);
  }


  
  /**
   * Removes the given element
   * 
   * @param pa_tElement  element to remove
   * @return true, if the element could be removed, false otherwise
   */
  public boolean removeElement(Object pa_tElement) 
  {
   boolean lc_bRemoved = false;
   
   if (null != m_tModel && null != pa_tElement)
   {
    if (true == (lc_bRemoved =  m_tModel.remove(pa_tElement)))
    {
     fireContentsChanged(this, 0, getSize());      
    }
   }
   return lc_bRemoved;
  }
  
  
}

  

