/*
 * Decompiled with CFR 0.152.
 */
package md5droplet;

import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import md5droplet.MD5dropletGuiConnector;
import md5droplet.MD5dropletRecord;
import md5droplet.MD5dropletView;
import org.jdesktop.application.Application;
import org.jdesktop.application.SingleFrameApplication;

public class MD5dropletApp
extends SingleFrameApplication
implements DropTargetListener,
MD5dropletGuiConnector,
WindowListener {
    private MD5dropletView m_tView;
    private DropTarget m_tDropTarget;
    private MDdropletFileWorker m_tWorkerThread;

    @Override
    protected void startup() {
        this.m_tView = new MD5dropletView(this, this);
        if (null != this.m_tView) {
            this.show(this.m_tView);
            this.m_tDropTarget = new DropTarget(this.m_tView.getDropZone(), this);
            this.m_tWorkerThread = null;
        }
    }

    @Override
    protected void configureWindow(Window root) {
    }

    public static MD5dropletApp getApplication() {
        return Application.getInstance(MD5dropletApp.class);
    }

    public static void main(String[] args) {
        MD5dropletApp.launch(MD5dropletApp.class, args);
    }

    @Override
    public void dragEnter(DropTargetDragEvent pa_tEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent pa_tEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent pa_tEvent) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent pa_tEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent pa_tEvent) {
        this.m_tWorkerThread = new MDdropletFileWorker();
        if (null != this.m_tWorkerThread) {
            this.m_tView.checkButtons(true);
            this.m_tDropTarget.setActive(false);
            this.m_tWorkerThread.init(pa_tEvent);
            this.m_tWorkerThread.execute();
        }
    }

    public final void handleWorkerThreadFinished() {
        this.m_tDropTarget.setActive(true);
        this.m_tView.checkButtons(false);
        this.m_tView.resetProgress();
    }

    @Override
    public void windowClosing(WindowEvent pa_tEvent) {
        Object lc_tWindowObject = null;
        lc_tWindowObject = pa_tEvent.getSource();
        if (null != lc_tWindowObject && lc_tWindowObject instanceof JFrame && (JFrame)lc_tWindowObject == this.m_tView) {
            this.m_tView.dispose();
            System.exit(1);
        }
    }

    @Override
    public void windowClosed(WindowEvent pa_tEvent) {
    }

    @Override
    public void windowOpened(WindowEvent pa_tEvent) {
    }

    @Override
    public void windowIconified(WindowEvent pa_tEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent pa_tEvent) {
    }

    @Override
    public void windowActivated(WindowEvent pa_tEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent pa_tEvent) {
    }

    @Override
    public void handleListSelection(ListSelectionEvent pa_tEvent) {
        if (null != pa_tEvent && !pa_tEvent.getValueIsAdjusting()) {
            this.m_tView.setSelectedMD5();
        }
    }

    @Override
    public void handleButtonCancel() {
        if (null != this.m_tWorkerThread) {
            this.m_tWorkerThread.cancel(true);
        }
    }

    class MDdropletFileWorker
    extends SwingWorker {
        private ArrayList<String> m_tFiles = new ArrayList();

        MDdropletFileWorker() {
            MD5dropletApp.this.m_tWorkerThread = null;
        }

        public void init(DropTargetDropEvent pa_tEvent) {
            Transferable lc_tTransferable = null;
            DataFlavor[] lc_tDataFlavors = null;
            List lc_tFileNames = null;
            String lc_sFileName = null;
            int lc_iLength = 0;
            int lc_iFiles = 0;
            int lc_iJ = 0;
            if (null != pa_tEvent) {
                block6: {
                    try {
                        lc_tTransferable = pa_tEvent.getTransferable();
                        if (null == lc_tTransferable || null == (lc_tDataFlavors = lc_tTransferable.getTransferDataFlavors()) || 0 >= (lc_iLength = lc_tDataFlavors.length)) break block6;
                        MD5dropletApp.this.m_tView.reset();
                        this.m_tFiles.clear();
                        for (int lc_iI = 0; lc_iLength > lc_iI; ++lc_iI) {
                            if (lc_tDataFlavors[lc_iI].isFlavorJavaFileListType()) {
                                pa_tEvent.acceptDrop(3);
                                lc_tFileNames = (List)lc_tTransferable.getTransferData(lc_tDataFlavors[lc_iI]);
                                if (null == lc_tFileNames || 0 >= (lc_iFiles = lc_tFileNames.size())) continue;
                                for (lc_iJ = 0; lc_iJ < lc_iFiles; ++lc_iJ) {
                                    lc_sFileName = lc_tFileNames.get(lc_iJ).toString();
                                    if (null == lc_sFileName) continue;
                                    this.m_tFiles.add(lc_sFileName);
                                }
                                continue;
                            }
                            pa_tEvent.rejectDrop();
                        }
                    }
                    catch (Exception lc_tException) {
                        // empty catch block
                    }
                }
                pa_tEvent.dropComplete(true);
            }
        }

        @Override
        protected void done() {
            MD5dropletApp.this.handleWorkerThreadFinished();
        }

        public Object doInBackground() {
            File lc_tFile = null;
            int lc_iCount = 0;
            int lc_iSize = this.m_tFiles.size();
            String lc_sCheckSum = null;
            if (0 < lc_iSize) {
                Collections.sort(this.m_tFiles, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return o1.compareTo(o2);
                    }
                });
                MD5dropletApp.this.m_tView.initTotalProgress(lc_iSize);
                for (String lc_sFileName : this.m_tFiles) {
                    if (this.isCancelled()) break;
                    lc_tFile = new File(lc_sFileName);
                    if (null == lc_tFile) continue;
                    if (lc_tFile.isFile()) {
                        MD5dropletApp.this.m_tView.setCurrentFile(lc_sFileName);
                        MD5dropletApp.this.m_tView.initCurrentProgress((int)lc_tFile.length());
                        lc_sCheckSum = this.getMD5Checksum(lc_sFileName);
                        if (null != lc_sCheckSum) {
                            MD5dropletApp.this.m_tView.addListEntry(new MD5dropletRecord(lc_sFileName, lc_sCheckSum));
                        }
                    }
                    if (this.isCancelled()) continue;
                    MD5dropletApp.this.m_tView.setTotalProgress(++lc_iCount);
                }
            }
            return null;
        }

        private String getMD5Checksum(String pa_sFilename) {
            byte[] lc_tBytes = this.createChecksum(pa_sFilename);
            String lc_sResult = "";
            int lc_iI = 0;
            int lc_iLen = 0;
            if (null != lc_tBytes) {
                lc_iLen = lc_tBytes.length;
                for (lc_iI = 0; lc_iI < lc_iLen; ++lc_iI) {
                    if (this.isCancelled()) {
                        return null;
                    }
                    lc_sResult = lc_sResult + Integer.toString((lc_tBytes[lc_iI] & 0xFF) + 256, 16).substring(1);
                }
            }
            return lc_sResult;
        }

        private byte[] createChecksum(String pa_sFilename) {
            FileInputStream lc_tStream = null;
            int lc_iBytes = 0;
            int lc_iBytesTotal = 0;
            byte[] lc_tBuffer = new byte[262144];
            MessageDigest lc_tDigest = null;
            try {
                lc_tDigest = MessageDigest.getInstance("MD5");
                if (null != lc_tDigest && null != (lc_tStream = new FileInputStream(pa_sFilename))) {
                    do {
                        lc_iBytes = ((InputStream)lc_tStream).read(lc_tBuffer);
                        lc_iBytesTotal += lc_iBytes;
                        if (!this.isCancelled()) {
                            MD5dropletApp.this.m_tView.setCurrentProgress(lc_iBytesTotal);
                        }
                        if (0 >= lc_iBytes) continue;
                        lc_tDigest.update(lc_tBuffer, 0, lc_iBytes);
                    } while (lc_iBytes != -1 && !this.isCancelled());
                    ((InputStream)lc_tStream).close();
                }
            }
            catch (Exception lc_tException) {
                // empty catch block
            }
            return null != lc_tDigest ? lc_tDigest.digest() : null;
        }
    }
}

