/**
 * MD5droplet
 * 
 */
package md5droplet;


/**
 * Imports
 * 
 */
import org.jdesktop.application.Application;
import org.jdesktop.application.SingleFrameApplication;

import java.awt.dnd.DnDConstants       ;
import java.awt.dnd.DropTarget         ;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetListener ;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent    ;
import java.awt.event.WindowListener   ;
import java.awt.event.WindowEvent      ;

import java.awt.datatransfer.Transferable; 
import java.awt.datatransfer.DataFlavor  ; 

import java.io.InputStream    ;
import java.io.FileInputStream;
import java.io.File           ;

import java.util.List       ;
import java.util.ArrayList  ;
import java.util.Collections;
import java.util.Comparator ;

import java.security.MessageDigest         ;
import javax.swing.event.ListSelectionEvent;
import javax.swing.JFrame                  ; 
import javax.swing.SwingWorker             ;



/**
 * The main class of the application.
 * 
 * @author Ulf Wagemann
 */
public class MD5dropletApp extends    SingleFrameApplication 
                           implements DropTargetListener    ,
                                      MD5dropletGuiConnector,
                                      WindowListener
{
 /**
  * Internal class needed to update the progress bars properly ---------------------------------------------------------
  * 
  * @author Ulf Wagemann
  */
 class MDdropletFileWorker extends SwingWorker
 {
  private ArrayList<String>    m_tFiles; 
  
  
  /**
   * Constructor
   * 
   */
  MDdropletFileWorker()
  {
   super();
   m_tFiles = new ArrayList<String>();
   m_tWorkerThread = null;
  }
  
  
  
  /**
   * Stores the DropTargetEvent to process. Since the vent may be destroyed when this method gets called
   * much later in the event dispatching processing, we retrieve any filename possible as soon as the event
   * arrived and store these filenames for later usage.
   * 
   * @param pa_tEvent  event
   */
  public void init(DropTargetDropEvent pa_tEvent)
  {
   Transferable lc_tTransferable    = null;
   DataFlavor[] lc_tDataFlavors     = null;
   List         lc_tFileNames       = null;
   String       lc_sFileName        = null;
  
   int lc_iLength = 0;
   int lc_iFiles  = 0;
   int lc_iI      = 0;
   int lc_iJ      = 0;
  
   if (null != pa_tEvent)
   {
    try 
    {
     if (null != (lc_tTransferable = pa_tEvent.getTransferable()))
     {
      if (null != (lc_tDataFlavors = lc_tTransferable.getTransferDataFlavors()))
      {
       if (0 < (lc_iLength = lc_tDataFlavors.length)) 
       {
        //
        // reset display and sort file names
        //
        m_tView.reset();
        m_tFiles.clear();

        while (lc_iLength > lc_iI)
        {
         if (lc_tDataFlavors[lc_iI].isFlavorJavaFileListType()) 
         {   
          pa_tEvent.acceptDrop(DnDConstants.ACTION_COPY_OR_MOVE);
         
          // And add the list of file names to our text area
          if (null != (lc_tFileNames = (java.util.List)lc_tTransferable.getTransferData(lc_tDataFlavors[lc_iI])))
          {
           if (0 < (lc_iFiles =  lc_tFileNames.size()))
           {
            for (lc_iJ = 0; lc_iJ < lc_iFiles; lc_iJ++) 
            {
             if (null != (lc_sFileName = lc_tFileNames.get(lc_iJ).toString()))
             {
              m_tFiles.add(lc_sFileName); 
             }
            } // for
           }
          }         
         }
         else
         {
          pa_tEvent.rejectDrop();                      
         }
         lc_iI++;
        } // while
       }
      }
     }
    }
    catch (Exception lc_tException) 
    {}
   
  
    //
    // finish d&d event
    //
    pa_tEvent.dropComplete(true);  
   }
  }
  
  
  
  /**
   * When we'r done, we notify the main thread about this
   * 
   */
  @Override
  protected void done()
  {
   handleWorkerThreadFinished();
  }
  
  
  
  /**
   * This is where the lengthy stuff happens
   * 
   * @return null
   */
  public Object doInBackground() 
  {
   File                        lc_tFile            = null;
   int                         lc_iCount           = 0   ;
   int                         lc_iSize            = m_tFiles.size();
   String                      lc_sCheckSum        = null;
   
   if (0 < lc_iSize)
   {
    java.util.Collections.sort(m_tFiles, new Comparator<String>() 
                               {
                                public int compare(String o1, String o2)
                                { 
                                 return o1.compareTo(o2);
                                }
                               }); 

    m_tView.initTotalProgress(lc_iSize);
    
    //
    // iterate over every file
    //
    for (String lc_sFileName : m_tFiles)
    {
     //
     // check for interruption
     //
     if (true == isCancelled())
     {
      break;
     } 
      
     if (null != (lc_tFile = new File(lc_sFileName)))
     {
      if (true == lc_tFile.isFile())
      {
       m_tView.setCurrentFile(lc_sFileName);
       m_tView.initCurrentProgress((int) lc_tFile.length());
               
       if (null != (lc_sCheckSum = getMD5Checksum(lc_sFileName)))
       {
        m_tView.addListEntry(new MD5dropletRecord(lc_sFileName, lc_sCheckSum));
       }
      }
      if (false == isCancelled()) m_tView.setTotalProgress(++lc_iCount);
     }
    } // for
   }
   return null;
  }
  
  
  
  
 /**
  * Computes ab MD5 checksum for a file
  * 
  * @param pa_sFilename filename
  * @return md5 checksum
  */
 private String getMD5Checksum(String pa_sFilename) 
 {
  byte[] lc_tBytes  = createChecksum(pa_sFilename);
  String lc_sResult = "";
   
  int lc_iI   = 0;
  int lc_iLen = 0;
   
  if (null != lc_tBytes)
  {
   lc_iLen = lc_tBytes.length; 
   
   for (lc_iI = 0; lc_iI < lc_iLen; lc_iI++) 
   {
    //
    // check for interruption
    //
    if (true == isCancelled()) {return null;}

    lc_sResult += Integer.toString((lc_tBytes[lc_iI] & 0xff ) + 0x100, 16).substring(1);
   }
  }
  return lc_sResult;
 }
 
 
 
 /**
  * Creates a MD5 checksum
  * 
  * @param pa_sFilename filename
  * @return byte array
  */
 private byte[] createChecksum(String pa_sFilename)
 {
  InputStream   lc_tStream = null;
  int           lc_iBytes  = 0   ;
  int           lc_iBytesTotal  = 0   ;
  byte[]        lc_tBuffer = new byte[262144];
  MessageDigest lc_tDigest = null;
  
  try
  {
   if (null != (lc_tDigest = MessageDigest.getInstance("MD5"))) 
   {
    if ( null !=(lc_tStream = new FileInputStream(pa_sFilename)))
    {
     do 
     {
      lc_iBytes       = lc_tStream.read(lc_tBuffer);
      lc_iBytesTotal += lc_iBytes;      
      if (false == isCancelled()) m_tView.setCurrentProgress(lc_iBytesTotal);
      
      if (0 < lc_iBytes) 
      {
       lc_tDigest.update(lc_tBuffer, 0, lc_iBytes);
      }
     } 
     while (lc_iBytes != -1 && false == isCancelled());  // check for interruption
     lc_tStream.close();
    }
   }
  }
  catch (Exception lc_tException)
  {}
  return (null != lc_tDigest ? lc_tDigest.digest() : null);
 }
 } // end of inner class MDdropletFileWorker ---------------------------------------------------------------------------
 
 
 
 
 private  MD5dropletView      m_tView      ;
 private  DropTarget          m_tDropTarget;
 private MDdropletFileWorker  m_tWorkerThread;
 
 
 /**
  * At startup create and show the main frame of the application.
  * 
  */
 @Override protected void startup() 
 {
  if (null != (m_tView = new MD5dropletView((MD5dropletGuiConnector) this, (WindowListener) this)))
  {
   show(m_tView);
   m_tDropTarget = new DropTarget(m_tView.getDropZone(), this);
   m_tWorkerThread = null;
  }
 }

 
 
 /**
  * This method is to initialize the specified window by injecting resources.
  * Windows shown in our application come fully initialized from the GUI
  * builder, so this additional configuration is not needed.
  */
 @Override protected void configureWindow(java.awt.Window root) {}

    
    
 /**
  * A convenient static getter for the application instance.
  * @return the instance of MD5dropletApp
  */
 public static MD5dropletApp getApplication() {return Application.getInstance(MD5dropletApp.class);}

    
    
 /**
  * Main method launching the application.
  */
 public static void main(String[] args) {launch(MD5dropletApp.class, args);}
 
 
 
 /**
  * DropTargetListener.dragEnter
  * 
  * @param pa_tEvent 
  */
 public void dragEnter(DropTargetDragEvent pa_tEvent) {}

 
 
 /**
  * DropTargetListener.dragExit
  * 
  * @param pa_tEvent 
  */
 public void dragExit(DropTargetEvent pa_tEvent) {}

 
 
 /**
  * DropTargetListener.dragOver
  * 
  * @param pa_tEvent 
  */
 public void dragOver(DropTargetDragEvent pa_tEvent) {}

 
 
 /**
  * DropTargetListener.dropActionChanged
  * 
  * @param pa_tEvent 
  */
 public void dropActionChanged(DropTargetDragEvent pa_tEvent) {}
 
 
 
 /**
  * DropTargetListener.drop
  * 
  * @param pa_tEvent 
  */
 public void drop(DropTargetDropEvent pa_tEvent) 
 {
  if (null != (m_tWorkerThread =  new MDdropletFileWorker()))
  {
   m_tView.checkButtons(true);
   m_tDropTarget.setActive(false);
   m_tWorkerThread.init(pa_tEvent); 
   m_tWorkerThread.execute(); 
  }
 }
 
 
 
  /**
  * Handles termination of worker thread
  * 
  */
 public final void handleWorkerThreadFinished()
 {
  m_tDropTarget.setActive(true);
  m_tView.checkButtons(false);
  m_tView.resetProgress();
 }
 
 
 
 /**
  * WindowListener.windowClosing()
  * 
  * @param pa_tEvent  Event
  */ 
  public void windowClosing(WindowEvent pa_tEvent) 
  {
   Object lc_tWindowObject = null;
  
   if (null != (lc_tWindowObject = pa_tEvent.getSource()))
   {
    if (lc_tWindowObject instanceof JFrame)
    {
     if ((JFrame) lc_tWindowObject == m_tView)   
     {
      m_tView.dispose();
      System.exit(1);
     }
    }
   }
  }

 
 
 /**
  * WindowListener.windowClosed()
  * 
  * @param pa_tEvent  Event
  */ 
  public void windowClosed(WindowEvent pa_tEvent) 
  {}

 
 
 /**
  * WindowListener.windowOpened()
  *
  * As soon as the main window is open, do all the intialization stuff
  *
  * @param pa_tEvent  Event
  */ 
 public void windowOpened(WindowEvent pa_tEvent) 
 {}



 /**
  * WindowListener.windowIconified()
  * 
  * @param pa_tEvent  Event
  */ 
 public void windowIconified(WindowEvent pa_tEvent) 
 {}



 /**
  * WindowListener.windowDeiconified()
  * 
  * @param pa_tEvent  Event
  */ 
 public void windowDeiconified(WindowEvent pa_tEvent) 
 {}



 /**
  * WindowListener.windowActivated()
  * 
  * @param pa_tEvent  Event
  */ 
 public void windowActivated(WindowEvent pa_tEvent) 
 {}



 /**
  * WindowListener.windowDeactivated()
  * 
  * @param pa_tEvent  Event
  */ 
 public void windowDeactivated(WindowEvent pa_tEvent) 
 {}


 
 
 
 /**
  * Handles a list selection
  * 
  * @param pa_tEvent 
  */
 public void handleListSelection(ListSelectionEvent pa_tEvent)
 {
  if (null != pa_tEvent)
  {
   if (false == pa_tEvent.getValueIsAdjusting())
   {
    m_tView.setSelectedMD5();
   }
  }
 }
 

 
 /**
  * Handles clicking the cancle button
  * 
  */
 public void handleButtonCancel()
 {
  if (null != m_tWorkerThread) {m_tWorkerThread.cancel(true);}
 }
 
} // eoc
