/**
 * MD5droplet
 * 
 */
package md5droplet;



/**
 * Imports
 * 
 */
import java.awt.Component            ;
import javax.swing.JList             ;
import javax.swing.JLabel            ;
import javax.swing.border.Border     ;
import javax.swing.border.EmptyBorder;
import javax.swing.ListCellRenderer  ;
import javax.swing.SwingConstants    ;




/**
 * Custom ListCellRenderer
 * 
 * @author Ulf Wagemann
 */
public class MD5dropletListCellRenderer extends JLabel
                                        implements ListCellRenderer 
{
 protected static Border m_tNoFocusBorder;
 protected static Border m_tFocusBorder  ; 
  
 
 /**
  * Constructor
  * 
  */
 public MD5dropletListCellRenderer()
 { 
  super();
  
  m_tNoFocusBorder = new EmptyBorder(5,5,5,5);
  m_tFocusBorder   = new EmptyBorder(5,5,5,5);
  
  setOpaque(true);
  setBorder(m_tNoFocusBorder);
 }
 
 
 
 @Override
 public Component getListCellRendererComponent(JList   pa_tList        ,
                                               Object  pa_tValue       ,
                                               int     pa_iIndex       ,
                                               boolean pa_bIsSelected  ,
                                               boolean pa_bCellHasFocus) 
 {
  MD5dropletRecord lc_tRecord = null;
  
  if (null != pa_tList)
  {
   setBackground(true == pa_bIsSelected ? pa_tList.getSelectionBackground() : pa_tList.getBackground());
   setForeground(true == pa_bIsSelected ? pa_tList.getSelectionForeground() : pa_tList.getForeground());
   setFont(pa_tList.getFont());
  
   setBorder(true == pa_bCellHasFocus ? m_tFocusBorder : m_tNoFocusBorder); // UIManager.getBorder("List.focusCellHighlightBorder")
   setHorizontalTextPosition(SwingConstants.RIGHT );
   setVerticalTextPosition  (SwingConstants.CENTER);
   
   if (pa_tValue instanceof MD5dropletRecord)
   { 
    if (null != (lc_tRecord = (MD5dropletRecord) pa_tValue))
    {
     setText(lc_tRecord.getFileName());  
    }
   }
   else
   {
    setText(pa_tValue.toString());
   }
  }
  return this;
 }

 
}
