/**
 * MD5droplet
 * 
 */
package md5droplet;


/**
 * UI
 * 
 * @author Ulf Wagemann
 */
public class MD5dropletView extends javax.swing.JFrame 
{
 private MD5dropletGuiConnector m_tGuiConnector;
 private java.util.ResourceBundle  m_tResources;

 
  /** 
   * Constructor
   *
   * @param  pa_tGuiConnector    GUI connection object
   * @param  pa_tWindowListener  WindowListener object
   */
  public MD5dropletView(MD5dropletGuiConnector pa_tGuiConnector, java.awt.event.WindowListener pa_tWindowListener) 
  {
    m_tResources = java.util.ResourceBundle.getBundle(MD5dropletConstants.MD5_FILE_VIEW_RESOURCES);
    
   //
   // work-arounds for following bugs/problems/crap:
   //
   // progress bar does not offer support for setting colors
   //
   // FUGLY SHIT!
   //
  if (null != m_tResources)
  {
   javax.swing.UIManager.put("ProgressBar.background"         , new java.awt.Color(Integer.valueOf((m_tResources.getString(MD5dropletConstants.MD5_FUGLY_BACKGROUND         )), 16))); //colour of the background
   javax.swing.UIManager.put("ProgressBar.foreground"         , new java.awt.Color(Integer.valueOf((m_tResources.getString(MD5dropletConstants.MD5_FUGLY_FOREGROUND         )), 16))); //colour of progress bar
   javax.swing.UIManager.put("ProgressBar.selectionBackground", new java.awt.Color(Integer.valueOf((m_tResources.getString(MD5dropletConstants.MD5_FUGLY_SELECTED_BACKGROUND)), 16))); //colour of percentage counter on black background
   javax.swing.UIManager.put("ProgressBar.selectionForeground", new java.awt.Color(Integer.valueOf((m_tResources.getString(MD5dropletConstants.MD5_FUGLY_SELECTED_FOREGROUND)), 16))); //colour of precentage counter on red background
  } 
  initComponents();
  m_tGuiConnector = pa_tGuiConnector;
  jListMD5.setModel(new javax.swing.DefaultListModel());
  jListMD5.setCellRenderer(new MD5dropletListCellRenderer());
   
  jProgressBarCurrentFile.setIndeterminate(false);
  jProgressBarCurrentFile.setStringPainted(true);
   
  jProgressBarTotal.setIndeterminate(false);
  jProgressBarTotal.setStringPainted(true);
   
  addWindowListener(pa_tWindowListener);
 }

  
   
  /**
   * Returns the drop zone object
   * 
   * @return   drop zone object
   */
  public javax.swing.JPanel getDropZone() {return jPanelDropZone;}
  
  
  
  /**
   * Sets the MD5 to the given value
   * 
   * @param pa_sValue   MD5 value
   */
  public void setMD5(String pa_sValue) {jTextFieldMD5.setText(pa_sValue);}
  
  
  
  /**
   * Sets the current file to the given string
   * 
   * @param pa_sValue  Filename
   */
  public void setCurrentFile(String pa_sValue) {jTextFieldCurrentFile.setText(pa_sValue);}
  
  
  
  /**
   * Initializes the current progress bar with the given maximum value and resets its display
   * 
   * @param pa_iMaxValue  maximum value
   */
  public void initCurrentProgress(int pa_iMaxValue)
  {
   final int lc_iFugly = pa_iMaxValue;
  
   javax.swing.SwingUtilities.invokeLater(new Runnable()
   {
    public void run() 
    { 
     jProgressBarCurrentFile.setMinimum(0); 
     jProgressBarCurrentFile.setMaximum(lc_iFugly);
     jProgressBarCurrentFile.setValue(0);
    }
   });        
    
  }
  
  

  /**
   * Initializes the total progress bar with the given maximum value and resets its display
   * 
   * @param pa_iMaxValue  maximum value
   */
  public void initTotalProgress(int pa_iMaxValue)
  {
   final int lc_iFugly = pa_iMaxValue;
  
   javax.swing.SwingUtilities.invokeLater(new Runnable()
   {
    public void run() 
    { 
     jProgressBarTotal.setMinimum(0); 
     jProgressBarTotal.setMaximum(lc_iFugly);
     jProgressBarTotal.setValue(0);
    }
   });        
    
  }

  
  
  /**
   * Sets the current progress to the given value
   * 
   * @param pa_iValue    progress value
   */
  public void setCurrentProgress(int pa_iValue) 
  {
   final int lc_iFugly = pa_iValue;
  
   javax.swing.SwingUtilities.invokeLater(new Runnable()
   {
    public void run() 
    { 
     jProgressBarCurrentFile.setValue(lc_iFugly);
    }
   });        
    
  }
  
  
  
  
  /**
   * Sets the total progress to the given value
   * 
   * @param pa_iValue    progress value
   */
  public void setTotalProgress(int pa_iValue) 
  {
   final int lc_iFugly = pa_iValue;
  
   javax.swing.SwingUtilities.invokeLater(new Runnable()
   {
    public void run() 
    { 
     jProgressBarTotal.setValue(lc_iFugly);
    }
   });        
    
  }
  
  
  
  /**
   * Resets the progress display
   * 
   */
  public void resetProgress()
  {
   javax.swing.SwingUtilities.invokeLater(new Runnable()
   {
    public void run() 
    { 
     setCurrentFile("");
     setCurrentProgress(0);
     setTotalProgress(0);
    }
   });        
   
  }
  
  
  
  /**
   * Resets anything
   * 
   * @param pa_iValue    progress value
   */
  public void reset()
  {
   javax.swing.DefaultListModel lc_tModel = (javax.swing.DefaultListModel) jListMD5.getModel();

   if (null != lc_tModel)
   {
    lc_tModel.clear(); 
   }

   javax.swing.SwingUtilities.invokeLater(new Runnable()
   {
    public void run() 
    { 
     resetProgress();
    }
   });        
  }
  
  
  
  /**
   * Returns the name of the selected palette
   * 
   * @return   Palette name
   */
  public void setSelectedMD5()
  {
   MD5dropletRecord lc_tRecord = (MD5dropletRecord) jListMD5.getSelectedValue();
   setMD5(null != lc_tRecord ? lc_tRecord.getMD5() : "");
  }
  
  
  /**
   * Adds a new record to the list
   * 
   * @param pa_tRecord   record to add
   */
  public void addListEntry(MD5dropletRecord pa_tRecord)
  {
   javax.swing.DefaultListModel lc_tModel = (javax.swing.DefaultListModel) jListMD5.getModel();
   int lc_iOldIndex = jListMD5.getSelectedIndex();
   
   if (null != lc_tModel)
   {
    lc_tModel.addElement(pa_tRecord); 
    
    if (0 > lc_iOldIndex)
    {
     jListMD5.setSelectedIndex(0);      
    }
   }
  }
  
  
  
  /**
   * Enables or disables buttons
   * 
   * @param pa_bIsWorking 
   */
  public void checkButtons(boolean pa_bIsWorking)
  { 
   jButtonCancel.setEnabled(pa_bIsWorking); 
  }
  
  
  
  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanelDropZone = new javax.swing.JPanel();
        jPanelMD5 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jListMD5 = new javax.swing.JList();
        jLabelMD5 = new javax.swing.JLabel();
        jTextFieldMD5 = new javax.swing.JTextField();
        jPanelProcessing = new javax.swing.JPanel();
        jLabelProgress = new javax.swing.JLabel();
        jTextFieldCurrentFile = new javax.swing.JTextField();
        jProgressBarTotal = new javax.swing.JProgressBar();
        jProgressBarCurrentFile = new javax.swing.JProgressBar();
        jButtonCancel = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("md5droplet/resources/MD5dropletView"); // NOI18N
        setTitle(bundle.getString("Form.title")); // NOI18N
        setName("Form"); // NOI18N

        org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(md5droplet.MD5dropletApp.class).getContext().getResourceMap(MD5dropletView.class);
        jPanelDropZone.setBackground(resourceMap.getColor("jPanelDropZone.background")); // NOI18N
        jPanelDropZone.setBorder(javax.swing.BorderFactory.createTitledBorder(null, bundle.getString("jPanelDropZone.border.title"), javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, null, new java.awt.Color(Integer.valueOf(bundle.getString("dropzoneHeader.foreground"), 16)))); // NOI18N
        jPanelDropZone.setName("jPanelDropZone"); // NOI18N

        javax.swing.GroupLayout jPanelDropZoneLayout = new javax.swing.GroupLayout(jPanelDropZone);
        jPanelDropZone.setLayout(jPanelDropZoneLayout);
        jPanelDropZoneLayout.setHorizontalGroup(
            jPanelDropZoneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 129, Short.MAX_VALUE)
        );
        jPanelDropZoneLayout.setVerticalGroup(
            jPanelDropZoneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 251, Short.MAX_VALUE)
        );

        jPanelMD5.setBorder(javax.swing.BorderFactory.createTitledBorder(bundle.getString("jPanelMD5.border.title"))); // NOI18N
        jPanelMD5.setName("jPanelMD5"); // NOI18N

        jScrollPane1.setName("jScrollPane1"); // NOI18N

        jListMD5.setBackground(new java.awt.Color(Integer.valueOf(bundle.getString("jList.background"), 16)));
        jListMD5.setForeground(new java.awt.Color(Integer.valueOf(bundle.getString("jList.foreground"), 16)));
        jListMD5.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        jListMD5.setName("jListMD5"); // NOI18N
        jListMD5.setSelectionBackground(new java.awt.Color(Integer.valueOf(bundle.getString("jList.selectionBackground"), 16)));
        jListMD5.setSelectionForeground(new java.awt.Color(Integer.valueOf(bundle.getString("jList.selectionForeground"), 16)));
        jListMD5.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                handleListSelection(evt);
            }
        });
        jScrollPane1.setViewportView(jListMD5);

        jLabelMD5.setLabelFor(jTextFieldMD5);
        jLabelMD5.setText(bundle.getString("jLabelMD5.text")); // NOI18N
        jLabelMD5.setName("jLabelMD5"); // NOI18N

        jTextFieldMD5.setEditable(false);
        jTextFieldMD5.setText(bundle.getString("jTextFieldMD5.text")); // NOI18N
        jTextFieldMD5.setName("jTextFieldMD5"); // NOI18N

        javax.swing.GroupLayout jPanelMD5Layout = new javax.swing.GroupLayout(jPanelMD5);
        jPanelMD5.setLayout(jPanelMD5Layout);
        jPanelMD5Layout.setHorizontalGroup(
            jPanelMD5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanelMD5Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanelMD5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 217, Short.MAX_VALUE)
                    .addGroup(jPanelMD5Layout.createSequentialGroup()
                        .addComponent(jLabelMD5)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextFieldMD5, javax.swing.GroupLayout.DEFAULT_SIZE, 192, Short.MAX_VALUE)))
                .addContainerGap())
        );
        jPanelMD5Layout.setVerticalGroup(
            jPanelMD5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanelMD5Layout.createSequentialGroup()
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 209, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanelMD5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabelMD5)
                    .addComponent(jTextFieldMD5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );

        jPanelProcessing.setBorder(javax.swing.BorderFactory.createTitledBorder(bundle.getString("jPanelProcessing.border.title"))); // NOI18N
        jPanelProcessing.setName("jPanelProcessing"); // NOI18N

        jLabelProgress.setText(bundle.getString("jLabelProgress.text")); // NOI18N
        jLabelProgress.setName("jLabelProgress"); // NOI18N

        jTextFieldCurrentFile.setEditable(false);
        jTextFieldCurrentFile.setText(bundle.getString("jTextFieldCurrentFile.text")); // NOI18N
        jTextFieldCurrentFile.setName("jTextFieldCurrentFile"); // NOI18N

        jProgressBarTotal.setName("jProgressBarTotal"); // NOI18N

        jProgressBarCurrentFile.setName("jProgressBarCurrentFile"); // NOI18N

        jButtonCancel.setText(bundle.getString("jButtonCancel.text")); // NOI18N
        jButtonCancel.setEnabled(false);
        jButtonCancel.setName("jButtonCancel"); // NOI18N
        jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                actionPerformedButtonCancel(evt);
            }
        });

        javax.swing.GroupLayout jPanelProcessingLayout = new javax.swing.GroupLayout(jPanelProcessing);
        jPanelProcessing.setLayout(jPanelProcessingLayout);
        jPanelProcessingLayout.setHorizontalGroup(
            jPanelProcessingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelProcessingLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanelProcessingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanelProcessingLayout.createSequentialGroup()
                        .addGroup(jPanelProcessingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabelProgress, javax.swing.GroupLayout.DEFAULT_SIZE, 215, Short.MAX_VALUE)
                            .addComponent(jTextFieldCurrentFile, javax.swing.GroupLayout.DEFAULT_SIZE, 215, Short.MAX_VALUE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanelProcessingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                            .addComponent(jProgressBarCurrentFile, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jProgressBarTotal, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                    .addComponent(jButtonCancel, javax.swing.GroupLayout.Alignment.TRAILING))
                .addContainerGap())
        );
        jPanelProcessingLayout.setVerticalGroup(
            jPanelProcessingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelProcessingLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanelProcessingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jProgressBarTotal, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabelProgress))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelProcessingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jProgressBarCurrentFile, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jTextFieldCurrentFile, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addComponent(jButtonCancel)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanelProcessingLayout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {jButtonCancel, jLabelProgress, jProgressBarCurrentFile, jProgressBarTotal, jTextFieldCurrentFile});

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jPanelProcessing, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jPanelMD5, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addGap(9, 9, 9)
                        .addComponent(jPanelDropZone, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanelDropZone, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanelMD5, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jPanelProcessing, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

  private void handleListSelection(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_handleListSelection
  if (null != m_tGuiConnector) m_tGuiConnector.handleListSelection(evt);
  }//GEN-LAST:event_handleListSelection

  private void actionPerformedButtonCancel(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_actionPerformedButtonCancel
  if (null != m_tGuiConnector) m_tGuiConnector.handleButtonCancel();
  }//GEN-LAST:event_actionPerformedButtonCancel

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonCancel;
    private javax.swing.JLabel jLabelMD5;
    private javax.swing.JLabel jLabelProgress;
    private javax.swing.JList jListMD5;
    private javax.swing.JPanel jPanelDropZone;
    private javax.swing.JPanel jPanelMD5;
    private javax.swing.JPanel jPanelProcessing;
    private javax.swing.JProgressBar jProgressBarCurrentFile;
    private javax.swing.JProgressBar jProgressBarTotal;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextField jTextFieldCurrentFile;
    private javax.swing.JTextField jTextFieldMD5;
    // End of variables declaration//GEN-END:variables
}
