/*
 * Decompiled with CFR 0.152.
 */
package numberconverter;

import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.math.BigInteger;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import numberconverter.NumberConverterGuiConnector;
import numberconverter.NumberConverterTool;
import numberconverter.NumberConverterView;
import org.jdesktop.application.Application;
import org.jdesktop.application.SingleFrameApplication;

public class NumberConverterApp
extends SingleFrameApplication
implements NumberConverterGuiConnector,
WindowListener {
    private NumberConverterView m_tView;
    private BigInteger m_tValue;

    @Override
    protected void startup() {
        this.m_tValue = BigInteger.ZERO;
        this.m_tView = new NumberConverterView(this, this);
        if (null != this.m_tView) {
            this.show(this.m_tView);
        }
    }

    @Override
    protected void configureWindow(Window root) {
    }

    public static NumberConverterApp getApplication() {
        return Application.getInstance(NumberConverterApp.class);
    }

    public static void main(String[] pa_tArgs) {
        NumberConverterApp.launch(NumberConverterApp.class, pa_tArgs);
    }

    @Override
    public void windowClosing(WindowEvent pa_tEvent) {
        Object lc_tWindowObject = null;
        lc_tWindowObject = pa_tEvent.getSource();
        if (null != lc_tWindowObject && lc_tWindowObject instanceof JFrame && (JFrame)lc_tWindowObject == this.m_tView) {
            this.m_tView.dispose();
            System.exit(1);
        }
    }

    @Override
    public void windowClosed(WindowEvent pa_tEvent) {
    }

    @Override
    public void windowOpened(WindowEvent pa_tEvent) {
        Object lc_tWindowObject = null;
        lc_tWindowObject = pa_tEvent.getSource();
        if (null != lc_tWindowObject && lc_tWindowObject instanceof JFrame && (JFrame)lc_tWindowObject == this.m_tView) {
            this.m_tView.setValidInputString(NumberConverterTool.getValidInputDisplayString(this.m_tView.getCustomBase()));
            this.m_tView.setBase(Integer.toString(this.m_tView.getCustomBase()));
            this.displayValues(-1);
        }
    }

    @Override
    public void windowIconified(WindowEvent pa_tEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent pa_tEvent) {
    }

    @Override
    public void windowActivated(WindowEvent pa_tEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent pa_tEvent) {
    }

    @Override
    public void handleSliderChanged(ChangeEvent pa_tEvent) {
        int lc_iBase = 0;
        if (null != pa_tEvent) {
            lc_iBase = this.m_tView.getCustomBase();
            this.m_tView.setBase(Integer.toString(lc_iBase));
            this.m_tView.setCustomFormatter(NumberConverterTool.createCustomRegexPattern(this.m_tView.getCustomBase()));
            this.m_tView.setCustomString(NumberConverterTool.computeString(this.m_tValue, this.m_tView.getCustomBase()));
            this.m_tView.setValidInputString(NumberConverterTool.getValidInputDisplayString(lc_iBase));
        }
    }

    @Override
    public void handleButtonClear() {
        this.m_tValue = BigInteger.ZERO;
        this.displayValues(-1);
    }

    @Override
    public void handleFormattedTextFieldChanged(int pa_iNum) {
        int lc_iBase = 0;
        String lc_sNewValue = null;
        switch (pa_iNum) {
            case 0: {
                lc_sNewValue = this.m_tView.getBinaryString();
                lc_iBase = 2;
                break;
            }
            case 2: {
                lc_sNewValue = this.m_tView.getOctalString();
                lc_iBase = 8;
                break;
            }
            case 1: {
                lc_sNewValue = this.m_tView.getDecimalString();
                lc_iBase = 10;
                break;
            }
            case 3: {
                lc_sNewValue = this.m_tView.getHexadecimalString();
                lc_iBase = 16;
                break;
            }
            default: {
                lc_sNewValue = this.m_tView.getCustomString();
                lc_iBase = this.m_tView.getCustomBase();
            }
        }
        this.m_tValue = BigInteger.ZERO;
        if (null != lc_sNewValue && !lc_sNewValue.isEmpty()) {
            this.m_tValue = new BigInteger(lc_sNewValue, lc_iBase);
        }
        this.displayValues(pa_iNum);
    }

    private void displayValues(int pa_iLeaveOut) {
        if (0 != pa_iLeaveOut) {
            this.m_tView.setBinaryString(NumberConverterTool.computeString(this.m_tValue, 2));
        }
        if (2 != pa_iLeaveOut) {
            this.m_tView.setOctalString(NumberConverterTool.computeString(this.m_tValue, 8));
        }
        if (1 != pa_iLeaveOut) {
            this.m_tView.setDecimalString(NumberConverterTool.computeString(this.m_tValue, 10));
        }
        if (3 != pa_iLeaveOut) {
            this.m_tView.setHexadecimalString(NumberConverterTool.computeString(this.m_tValue, 16));
        }
        if (4 != pa_iLeaveOut) {
            this.m_tView.setCustomString(NumberConverterTool.computeString(this.m_tValue, this.m_tView.getCustomBase()));
        }
    }
}

