/*
 * Decompiled with CFR 0.152.
 */
package numberconverter;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultFormatterFactory;
import numberconverter.NumberConverterGuiConnector;
import numberconverter.NumberConverterTextfieldFormatter;

public class NumberConverterView
extends JFrame
implements ChangeListener {
    public static final int INPUT_NONE = -1;
    public static final int INPUT_BINARY = 0;
    public static final int INPUT_DECIMAL = 1;
    public static final int INPUT_OCTAL = 2;
    public static final int INPUT_HEXADECIMAL = 3;
    public static final int INPUT_CUSTOM = 4;
    private NumberConverterGuiConnector m_tGuiConnector;
    private JButton jButtonClear;
    private JFormattedTextField jFormattedTextFieldBinary;
    private JFormattedTextField jFormattedTextFieldCustomValue;
    private JFormattedTextField jFormattedTextFieldDecimal;
    private JFormattedTextField jFormattedTextFieldHexadecimal;
    private JFormattedTextField jFormattedTextFieldOctal;
    private JLabel jLabelBase;
    private JLabel jLabelBinary;
    private JLabel jLabelCustomValue;
    private JLabel jLabelDecimal;
    private JLabel jLabelHexadecimal;
    private JLabel jLabelOctal;
    private JLabel jLabelValidInput;
    private JPanel jPanelCustomBase;
    private JSlider jSliderCustomBase;
    private JTextField jTextFieldBase;
    private JTextField jTextFieldValidInput;

    public NumberConverterView(NumberConverterGuiConnector pa_tGuiConnector, WindowListener pa_tWindowListener) {
        this.m_tGuiConnector = pa_tGuiConnector;
        this.initComponents();
        this.jFormattedTextFieldBinary.setFormatterFactory(new DefaultFormatterFactory(new NumberConverterTextfieldFormatter(Pattern.compile("[0-1]*"))));
        this.jFormattedTextFieldOctal.setFormatterFactory(new DefaultFormatterFactory(new NumberConverterTextfieldFormatter(Pattern.compile("[0-7]*"))));
        this.jFormattedTextFieldDecimal.setFormatterFactory(new DefaultFormatterFactory(new NumberConverterTextfieldFormatter(Pattern.compile("[0-9]*"))));
        this.jFormattedTextFieldHexadecimal.setFormatterFactory(new DefaultFormatterFactory(new NumberConverterTextfieldFormatter(Pattern.compile("[[0-9]*[A-F]*]*"))));
        this.jFormattedTextFieldCustomValue.setFormatterFactory(new DefaultFormatterFactory(new NumberConverterTextfieldFormatter(Pattern.compile("[0-1]*"))));
        this.jSliderCustomBase.addChangeListener(this);
        this.addWindowListener(pa_tWindowListener);
    }

    public final int getCustomBase() {
        return this.jSliderCustomBase.getValue();
    }

    public final String getBinaryString() {
        return this.jFormattedTextFieldBinary.getText();
    }

    public final String getOctalString() {
        return this.jFormattedTextFieldOctal.getText();
    }

    public final String getDecimalString() {
        return this.jFormattedTextFieldDecimal.getText();
    }

    public final String getHexadecimalString() {
        return this.jFormattedTextFieldHexadecimal.getText();
    }

    public final String getCustomString() {
        return this.jFormattedTextFieldCustomValue.getText();
    }

    public final void setValidInputString(String pa_sString) {
        this.jTextFieldValidInput.setText(pa_sString);
    }

    public final void setBinaryString(String pa_sString) {
        this.jFormattedTextFieldBinary.setText(pa_sString);
    }

    public final void setOctalString(String pa_sString) {
        this.jFormattedTextFieldOctal.setText(pa_sString);
    }

    public final void setDecimalString(String pa_sString) {
        this.jFormattedTextFieldDecimal.setText(pa_sString);
    }

    public final void setHexadecimalString(String pa_sString) {
        this.jFormattedTextFieldHexadecimal.setText(pa_sString);
    }

    public final void setCustomString(String pa_sString) {
        this.jFormattedTextFieldCustomValue.setText(pa_sString);
    }

    public final void setCustomFormatter(Pattern pa_tPattern) {
        if (null != pa_tPattern) {
            this.jFormattedTextFieldCustomValue.setFormatterFactory(new DefaultFormatterFactory(new NumberConverterTextfieldFormatter(pa_tPattern)));
        }
    }

    public final void setBase(String pa_sValue) {
        this.jTextFieldBase.setText(pa_sValue);
    }

    private void initComponents() {
        this.jLabelBinary = new JLabel();
        this.jLabelDecimal = new JLabel();
        this.jLabelOctal = new JLabel();
        this.jFormattedTextFieldBinary = new JFormattedTextField();
        this.jFormattedTextFieldDecimal = new JFormattedTextField();
        this.jPanelCustomBase = new JPanel();
        this.jSliderCustomBase = new JSlider();
        this.jLabelValidInput = new JLabel();
        this.jTextFieldValidInput = new JTextField();
        this.jLabelCustomValue = new JLabel();
        this.jFormattedTextFieldCustomValue = new JFormattedTextField();
        this.jLabelBase = new JLabel();
        this.jTextFieldBase = new JTextField();
        this.jButtonClear = new JButton();
        this.jFormattedTextFieldOctal = new JFormattedTextField();
        this.jLabelHexadecimal = new JLabel();
        this.jFormattedTextFieldHexadecimal = new JFormattedTextField();
        this.setDefaultCloseOperation(0);
        ResourceBundle bundle = ResourceBundle.getBundle("numberconverter/resources/NumberConverterView");
        this.setTitle(bundle.getString("Form.title"));
        this.setName("Form");
        this.jLabelBinary.setLabelFor(this.jFormattedTextFieldBinary);
        this.jLabelBinary.setText(bundle.getString("jLabelBinary.text"));
        this.jLabelBinary.setName("jLabelBinary");
        this.jLabelDecimal.setLabelFor(this.jFormattedTextFieldDecimal);
        this.jLabelDecimal.setText(bundle.getString("jLabelDecimal.text"));
        this.jLabelDecimal.setName("jLabelDecimal");
        this.jLabelOctal.setLabelFor(this.jFormattedTextFieldOctal);
        this.jLabelOctal.setText(bundle.getString("jLabelOctal.text"));
        this.jLabelOctal.setName("jLabelOctal");
        this.jFormattedTextFieldBinary.setText(bundle.getString("jFormattedTextFieldBinary.text"));
        this.jFormattedTextFieldBinary.setName("jFormattedTextFieldBinary");
        this.jFormattedTextFieldBinary.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                NumberConverterView.this.keyReleasedBinary(evt);
            }
        });
        this.jFormattedTextFieldDecimal.setText(bundle.getString("jFormattedTextFieldDecimal.text"));
        this.jFormattedTextFieldDecimal.setName("jFormattedTextFieldDecimal");
        this.jFormattedTextFieldDecimal.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                NumberConverterView.this.keyReleasedDecimal(evt);
            }
        });
        this.jPanelCustomBase.setBorder(BorderFactory.createTitledBorder(bundle.getString("jPanelCustomBase.border.title")));
        this.jPanelCustomBase.setName("jPanelCustomBase");
        this.jSliderCustomBase.setMajorTickSpacing(4);
        this.jSliderCustomBase.setMaximum(36);
        this.jSliderCustomBase.setMinimum(2);
        this.jSliderCustomBase.setMinorTickSpacing(1);
        this.jSliderCustomBase.setPaintLabels(true);
        this.jSliderCustomBase.setPaintTicks(true);
        this.jSliderCustomBase.setSnapToTicks(true);
        this.jSliderCustomBase.setValue(2);
        this.jSliderCustomBase.setName("jSliderCustomBase");
        this.jLabelValidInput.setText(bundle.getString("jLabelValidInput.text"));
        this.jLabelValidInput.setName("jLabelValidInput");
        this.jTextFieldValidInput.setEditable(false);
        this.jTextFieldValidInput.setText(bundle.getString("jTextFieldValidInput.text"));
        this.jTextFieldValidInput.setName("jTextFieldValidInput");
        this.jLabelCustomValue.setText(bundle.getString("jLabelCustomValue.text"));
        this.jLabelCustomValue.setName("jLabelCustomValue");
        this.jFormattedTextFieldCustomValue.setText(bundle.getString("jFormattedTextFieldCustomValue.text"));
        this.jFormattedTextFieldCustomValue.setName("jFormattedTextFieldCustomValue");
        this.jFormattedTextFieldCustomValue.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                NumberConverterView.this.keyReleasedCustom(evt);
            }
        });
        this.jLabelBase.setText(bundle.getString("jLabelBase.text"));
        this.jLabelBase.setName("jLabelBase");
        this.jTextFieldBase.setEditable(false);
        this.jTextFieldBase.setText(bundle.getString("jTextFieldBase.text"));
        this.jTextFieldBase.setName("jTextFieldBase");
        GroupLayout jPanelCustomBaseLayout = new GroupLayout(this.jPanelCustomBase);
        this.jPanelCustomBase.setLayout(jPanelCustomBaseLayout);
        jPanelCustomBaseLayout.setHorizontalGroup(jPanelCustomBaseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelCustomBaseLayout.createSequentialGroup().addContainerGap().addGroup(jPanelCustomBaseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSliderCustomBase, -1, 348, Short.MAX_VALUE).addGroup(jPanelCustomBaseLayout.createSequentialGroup().addComponent(this.jLabelCustomValue).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jFormattedTextFieldCustomValue, -1, 273, Short.MAX_VALUE)).addGroup(jPanelCustomBaseLayout.createSequentialGroup().addComponent(this.jLabelValidInput).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTextFieldValidInput, -1, 183, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jLabelBase).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTextFieldBase, -2, 39, -2))).addContainerGap()));
        jPanelCustomBaseLayout.linkSize(0, this.jLabelCustomValue, this.jLabelValidInput);
        jPanelCustomBaseLayout.setVerticalGroup(jPanelCustomBaseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelCustomBaseLayout.createSequentialGroup().addContainerGap().addComponent(this.jSliderCustomBase, -2, -1, -2).addGap(18, 18, 18).addGroup(jPanelCustomBaseLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelValidInput).addComponent(this.jTextFieldValidInput, -2, -1, -2).addComponent(this.jTextFieldBase, -2, -1, -2).addComponent(this.jLabelBase)).addGap(18, 18, 18).addGroup(jPanelCustomBaseLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelCustomValue).addComponent(this.jFormattedTextFieldCustomValue, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelCustomBaseLayout.linkSize(1, this.jFormattedTextFieldCustomValue, this.jLabelCustomValue, this.jLabelValidInput, this.jTextFieldValidInput);
        this.jButtonClear.setText(bundle.getString("jButtonClear.text"));
        this.jButtonClear.setName("jButtonClear");
        this.jButtonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NumberConverterView.this.actionPerformedButtonClear(evt);
            }
        });
        this.jFormattedTextFieldOctal.setText(bundle.getString("jFormattedTextFieldOctal.text"));
        this.jFormattedTextFieldOctal.setName("jFormattedTextFieldOctal");
        this.jFormattedTextFieldOctal.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                NumberConverterView.this.keyReleasedOctal(evt);
            }
        });
        this.jLabelHexadecimal.setLabelFor(this.jFormattedTextFieldHexadecimal);
        this.jLabelHexadecimal.setText(bundle.getString("jLabelHexadecimal.text"));
        this.jLabelHexadecimal.setName("jLabelHexadecimal");
        this.jFormattedTextFieldHexadecimal.setText(bundle.getString("jFormattedTextFieldHexadecimal.text"));
        this.jFormattedTextFieldHexadecimal.setName("jFormattedTextFieldHexadecimal");
        this.jFormattedTextFieldHexadecimal.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                NumberConverterView.this.keyReleasedHexadecimal(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelCustomBase, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonClear, GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelBinary).addComponent(this.jLabelDecimal).addComponent(this.jLabelOctal).addComponent(this.jLabelHexadecimal)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jFormattedTextFieldHexadecimal, -1, 310, Short.MAX_VALUE).addComponent(this.jFormattedTextFieldOctal, -1, 310, Short.MAX_VALUE).addComponent(this.jFormattedTextFieldDecimal, -1, 310, Short.MAX_VALUE).addComponent(this.jFormattedTextFieldBinary, -1, 310, Short.MAX_VALUE)))).addContainerGap()));
        layout.linkSize(0, this.jLabelBinary, this.jLabelDecimal, this.jLabelHexadecimal, this.jLabelOctal);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelBinary).addComponent(this.jFormattedTextFieldBinary, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelDecimal).addComponent(this.jFormattedTextFieldDecimal, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelOctal).addComponent(this.jFormattedTextFieldOctal, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelHexadecimal).addComponent(this.jFormattedTextFieldHexadecimal, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jPanelCustomBase, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jButtonClear).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(1, this.jFormattedTextFieldBinary, this.jFormattedTextFieldDecimal, this.jFormattedTextFieldHexadecimal, this.jFormattedTextFieldOctal, this.jLabelBinary, this.jLabelDecimal, this.jLabelHexadecimal, this.jLabelOctal);
        this.pack();
    }

    private void actionPerformedButtonClear(ActionEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleButtonClear();
        }
    }

    private void keyReleasedBinary(KeyEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleFormattedTextFieldChanged(0);
        }
    }

    private void keyReleasedDecimal(KeyEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleFormattedTextFieldChanged(1);
        }
    }

    private void keyReleasedOctal(KeyEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleFormattedTextFieldChanged(2);
        }
    }

    private void keyReleasedHexadecimal(KeyEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleFormattedTextFieldChanged(3);
        }
    }

    private void keyReleasedCustom(KeyEvent evt) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleFormattedTextFieldChanged(4);
        }
    }

    @Override
    public void stateChanged(ChangeEvent pa_tEvent) {
        if (null != this.m_tGuiConnector) {
            this.m_tGuiConnector.handleSliderChanged(pa_tEvent);
        }
    }
}

